const carouselTemplateCount = document.querySelectorAll('.iranavada-carousel-template');
carouselTemplateCount.forEach((carousel) => {

  var getDataResposive = JSON.parse(carousel.getAttribute('data-responsive'));
  var getAutoPlayDelay = carousel.getAttribute('data-autoplaytime');
  var getDataAutoPlayStatus = carousel.getAttribute('data-autoplay');
  var getDataRewind = carousel.getAttribute('data-rewind');

  // Rewind
  if( getDataRewind == 'false' ) {
    getDataRewind = true;
  }else if( getDataRewind == 'true' ) {
    getDataRewind = false;
  }

  if( getDataAutoPlayStatus == 'false' ) {
    var swiper = new Swiper(carousel, {
      autoplay: false,
      spaceBetween: 15,
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
      pagination: {
        el: ".swiper-pagination",
      },
      breakpoints: {
        0: {
          slidesPerView: getDataResposive.r_0,
        },
        480: {
          slidesPerView: getDataResposive.r_480,
        },
        720: {
          slidesPerView: getDataResposive.r_720,
        },
        960: {
          slidesPerView: getDataResposive.r_960,
        },
        1200: {
          slidesPerView: getDataResposive.r_1200,
        }
      }
    });
  }else if( getDataAutoPlayStatus == 'true' ) {
    var swiper = new Swiper(carousel, {
      autoplay: {
        delay: getAutoPlayDelay,
        centeredSlides: true,
        pauseOnMouseEnter: true,
        stopOnLastSlide: getDataRewind,
      },
      spaceBetween: 15,
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
      pagination: {
        el: ".swiper-pagination",
      },
      breakpoints: {
        0: {
          slidesPerView: getDataResposive.r_0,
        },
        480: {
          slidesPerView: getDataResposive.r_480,
        },
        720: {
          slidesPerView: getDataResposive.r_720,
        },
        960: {
          slidesPerView: getDataResposive.r_960,
        },
        1200: {
          slidesPerView: getDataResposive.r_1200,
        }
      }
    });
  }

});

(function($) {
  $(document).ready(function() {

    $(".js-counter[data-countdown]").each(function(i, x) {
        var countDownDate = new Date($(x).data("countdown")).getTime();
        var me = $(this);
        setInterval(function() {
            var now = new Date().getTime();
            var distance = countDownDate - now;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            days = days < 1 ? "" : (days < "10" ? `${days}:` : `${days}:`);
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            if (hours < "10") { hours = "0" + hours; }
            if (minutes < "10") { minutes = "0" + minutes; }
            if (seconds < "10") { seconds = "0" + seconds; }
            $(me).html(`${days}${hours}:${minutes}:${seconds}`);
            if (distance < 0) { clearInterval(x); $(me).html(`00:00:00`) }
        }, 1000);

    });

  });
})(jQuery);
