<?php
/**
 * @Author: Iranavada Team
 * @Date:   2020/10/10 13:19:49
 * @Email:  iranavada@gmail.com
 * @Last modified by:   Iranavada Team
 * @Last modified time: 2020/10/18 15:14:46
 * @License: GPLv2
 * @Copyright: Copyright © 2020 Iranavada Team, All rights reserved.
 */
 
global // Get All Global Variables Value
$woocommerce,		
$get_template_name,
$irava_display_title,
$irava_display_price,
$carousel_banner,
$responsive_min_0,
$responsive_min_480,
$responsive_min_720,
$responsive_min_960,
$responsive_min_1200,
$carousel_button_text,
$Carousel_button_link,
$category,
$shegeftangiz,
$discounted_products,
$Show_timer,
$timerColor,
$display_product_limit,
$irava_orderby,
$irava_product_type,
$irava_sortby,
$display_banner_button,
$id,
$enable_disable_addtocart_button,
$display_percentage_number_off,
$addtocart_button_icon,
$product_on_sale_to_final,
$auto_play_on_off,
$auto_play_time,
$rewind_carousel,
$stop_on_last_slide,
$special_carousel_cat_filter,
$cat_filter_default,
$cat_filter_title,
$view_all_btn_cat_filter,
$irava_display_last_slide,
$view_all_btn_text_ajax_cat_filter,
$active_cat_filter_items_color,
$active_carousel_filter_cat_background_color,
$view_all_cat_filter_btn_link,
$carousel_items_gap;

$cat_items = preg_split ("/\,/", $category);
$cat_filter_def = preg_split ("/\,/", $cat_filter_default);

if( $special_carousel_cat_filter == 'yes' && $cat_filter_def != '' ) {
  $load_category = $cat_filter_default;
}else {
  $load_category = $category;
}
if( $discounted_products == 'yes' ) {

  $query_args     = array( 
    'post_type'       => 'product', 
    'post_status'     => 'publish',
    'limit'           => $display_product_limit,
    'product_cat'     => $load_category,
    'orderby'         => $irava_orderby,
    'order'           => $irava_sortby,
    'type'            => array("simple","variable"),
    'stock_status'    => 'instock',
    'include'         => wc_get_product_ids_on_sale(),
  );

}elseif( $shegeftangiz == 'yes' ) {

  $query_args     = array( 
    'post_type'       => 'product', 
    'post_status'     => 'publish',
    'limit'           => $display_product_limit,
    'product_cat'     => $load_category,
    'orderby'         => $irava_orderby,
    'order'           => $irava_sortby,
    'type'            => array("simple","variable"),
    'stock_status'    => 'instock',
    '_iranavadasopc'  => 'yes',
  );

}else {

  $query_args     = array( 
    'post_type'       => 'product', 
    'post_status'     => 'publish',
    'limit'           => $display_product_limit,
    'product_cat'     => $load_category,
    'orderby'         => $irava_orderby,
    'order'           => $irava_sortby,
    'type'            => array("simple","variable"),
    'stock_status'    => 'instock',
  );

}

$iranavada_products = wc_get_products( $query_args );

$responsive = array(
  "r_0" => $responsive_min_0 + 0.2,
  "r_480" => $responsive_min_480 + 0.2,
  "r_720" => $responsive_min_720 + 0.2,
  "r_960" => $responsive_min_960 + 0.2,
  "r_1200" => $responsive_min_1200 + 0.2,
);
$responsive = esc_attr( esc_js( wp_json_encode( $responsive ) ) ) ;

  if( $special_carousel_cat_filter == 'yes' && $category != '' ) {

    ?>
    <div class="iravada-product-category-filter">
      <div class="iranavada-filter-items">
        <div class="iranavada-filter-title"><span><?= $cat_filter_title ? $cat_filter_title : 'محصولات ویژه' ?></span></div>
        <ul <?= FusionBuilder::attributes( 'iravada-swiper-filter' ) ?> data-gap-items="<?= $carousel_items_gap ?>" data-active-item-color="<?= $active_cat_filter_items_color ?>" data-active-item-background="<?= $active_carousel_filter_cat_background_color ?>" data-text-view-all-btn-ajax="<?= $view_all_btn_text_ajax_cat_filter ?>" data-read-more-btn-text="<?= $view_all_btn_cat_filter ?>" data-display-last-slide="<?= $irava_display_last_slide ?>" data-cat-filter-default="<?= $cat_filter_default ?>" data-cat-filter-status="<?= $special_carousel_cat_filter ?>" data-category="<?= $category ?>" data-border-radius-top-left="<?= fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) ?>" data-border-radius-top-right="<?= fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) ?>" data-border-radius-bottom-right="<?= fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) ?>" data-border-radius-bottom-left="<?= fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) ?>" data-border-color="<?= $this->args['special_offer_item_border_color'] ?>" data-border-style="<?= $this->args['special_offer_item_border_style'] ?>" data-border-top="<?= fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ) ?>" data-border-right="<?= fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ) ?>" data-border-bottom="<?= fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ) ?>" data-border-left="<?= fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ) ?>" data-timer-color="<?= $timerColor ?>" data-show-timer="<?= $Show_timer ?>" data-display-price="<?= $irava_display_price ?>" data-display-title="<?= $irava_display_title ?>" data-display-addtocart="<?= $enable_disable_addtocart_button ?>" data-addtocart-icon="<?= $addtocart_button_icon  ?>" data-addtocart-background="<?= $this->args['addtocart_background_color'] ?>" data-addtocart-icon-color="<?= $this->args['addtocart_icon_color'] ?>" data-off-type-number="<?= $display_percentage_number_off ?>" data-onsale-products="<?= $discounted_products ?>" data-shegeftangiz="<?= $shegeftangiz ?>" data-orderby="<?= $irava_orderby ?>" data-limit-product="<?= $display_product_limit ?>" data-sortby="<?= $irava_sortby ?>" data-target-remove="<?= $id ?>" data-carousel-banner="<?= $carousel_banner ?>" data-template-name="<?= $get_template_name ?>" data-display-banner-status="<?= $display_banner_button ?>" data-carousel-btn-link="<?= $Carousel_button_link ?>" data-carousel-btn-text="<?= $carousel_button_text ?>">
          <?php 

          foreach($cat_filter_def as $default_cat) {
            
            $default_category   = get_term_by( 'slug', $default_cat, 'product_cat' );
            
            if( !empty($default_category) ) {
                
                $cat_name   = $default_category->name;
                $cat_id     = $default_category->term_id;
                $cat_slug   = $default_category->slug;  
                $cat_link   = $default_category->term_link;
                
                ?><li <?= FusionBuilder::attributes( 'irava-cat-filter-first-item' ) ?> id="<?= $id ?>" data-template-name="carousel" data-term-link="<?= get_term_link( $cat_id, 'product_cat' ) ?>" data-term-id="<?= $cat_id ?>" data-term-slug="<?= $cat_slug ?>" data-term-name="<?= $cat_name ?>"><?= $cat_name ?></li><?php
                
            }

          }

          foreach($cat_items as $cat) {
  
              
            $category   = get_term_by( 'slug', $cat, 'product_cat' );
            
            if( !empty( $category ) ) {
            
                $cat_name   = $category->name;
                $cat_id     = $category->term_id;
                $cat_slug   = $category->slug;  
                $cat_link   = $category->term_link;
      
                ?><li <?= FusionBuilder::attributes( 'irava-filter-item' ) ?> id="<?= $id ?>" data-template-name="carousel" data-term-link="<?= get_term_link( $cat_id, 'product_cat' ) ?>" data-term-id="<?= $cat_id ?>" data-term-slug="<?= $cat_slug ?>" data-term-name="<?= $cat_name ?>"><?= $cat_name ?></li><?php
    
            }
            
          }
          
          ?>
        </ul>
        <div <?= FusionBuilder::attributes( 'iranavada-view-current-filter-line' ) ?> ></div>
        <div class="iranavada-view-current-filter-btn"><a class="product-filter-show-all <?= $id ?>" href="<?= $view_all_cat_filter_btn_link ? $view_all_cat_filter_btn_link : get_permalink( wc_get_page_id( 'shop' ) ) ?>" target="_blank"><span><?= $view_all_btn_cat_filter ? $view_all_btn_cat_filter : 'صفحه فروشگاه' ?> <i class="fa-angle-double-left fas"></i></span></a></div>
      </div>
    </div>
    <?php

  }
?>

<div class="swiper iranavada-carousel-template <?= $id ?>" data-stop-last="<?= $stop_on_last_slide ?>" data-responsive="<?= $responsive ?>" data-rewind="<?= $rewind_carousel ?>" data-autoplay="<?= $auto_play_on_off ?>" data-autoplaytime="<?= $auto_play_time ?>">

  <div class="iravada-ajax-load <?= $id ?>"></div>
  <div class="swiper-wrapper carousel <?= $id ?>" id="<?= $id ?>">
    <?php if( $carousel_banner != '' && $display_banner_button == 'yes' && $special_carousel_cat_filter == 'no' ) { ?>
      <div class="swiper-slide carousel" style="background: none;">
            <a href="<?=$Carousel_button_link;?>" class="hero-img-link <?= $id ?>" target="_blank">
                <div <?= FusionBuilder::attributes( 'irava-hero-img' ) ?> >
                    <div <?= FusionBuilder::attributes( 'hero-img' ) ?> ><img width="110" height="245" src="<?=$carousel_banner;?>" alt=""></div>
                    <span <?= FusionBuilder::attributes( 'show-more-product-text' ) ?>><?=$carousel_button_text;?></span>
                </div>
            </a>

      </div>
    <?php } // End If ?>

    <!-- Start Loop -->
    <?php

    foreach ($iranavada_products as $products) {

      $product = wc_get_product($products);
      $product_id = $product->get_id();
      // $product_name = strlen($product->get_name()) > 55 ? mb_substr($product->get_name(), 0, 55, "utf-8") . "&hellip;" : $product->get_name();
      // $product_title = strlen($product->get_title()) > 55 ? mb_substr($product->get_title(), 0, 55, "utf-8") . "&hellip;" : $product->get_title();
      $product_name = $product->get_name();
      $product_title = $product->get_title();
      $product_slug = $product->get_slug();
      $product_permalink = get_permalink($product->get_id());
      $product_price = $product->get_price();
      $product_price_html = $product->get_price_html();
      $product_sale_price = $product->is_type('variable') ? $product->get_variation_sale_price('min', true) : $product->get_sale_price();
      $product_regular_price = $product->is_type('variable') ? $product->get_variation_regular_price('min', true) : $product->get_regular_price();
      $product_is_on_sale = $product->is_on_sale();
      $product_is_in_stock = $product->is_in_stock();
      $product_stock_status = $product->get_stock_status();
      $product_on_sale_to = $product->get_date_on_sale_to();
      $product_stock_quantity = $product->get_stock_quantity();
      $product_image = $product->get_image();
      $product_image_id = $product->get_image_id();
      $product_image_url = wp_get_attachment_url($product_image_id);
      $product_image_url_optimized = get_the_post_thumbnail_url($product_id, 'irava-carousel-300-crop'); // large carousel image
      $product_image_url_optimized_full = get_the_post_thumbnail_url($product_id, 'irava-slider-75-crop');
      $product_gallery_image_ids = $product->get_gallery_image_ids();
      $product_sale_price = $product->is_type('variable') ? $product->get_variation_sale_price('min', true) : $product->get_sale_price();
      $percentage         = "";
      $price_off_number   = "";
      if ($product_is_in_stock && $product_is_on_sale) {
          if ($product_regular_price !== $product_sale_price ) { 
            $percentage         = round(( $product_regular_price - $product_sale_price ) / $product_regular_price * 100);
            $price_off_number   = $product_regular_price - $product_sale_price;
          }
      }
      $product_special_true = get_post_meta($product_id, '_iranavadasopc', true);
      $product_on_sale_to_2 = get_post_meta($product_id, '_iranavadasopc_date', true);
      $product_on_sale_to_final = null;
      if ($product->is_type('variable') && "yes" == $product_special_true && !empty($product_on_sale_to_2)) {
          $product_on_sale_to_final = (new DateTime($product_on_sale_to_2))->format('Y/m/d') . ' 23:59:59';
      }
      else{
          if ($product_is_in_stock && $product_on_sale_to != null) {
              $product_on_sale_to_final = $product_on_sale_to->date('Y/m/d') . ' 23:59:59';
          }
          elseif($product_is_in_stock) {
              $product_on_sale_to_final = null;
          }
      }

      if( $product_on_sale_to_final != null ) {
        if (date("Y/m/d H:i:s") > $product_on_sale_to_final ) {
          update_post_meta( $product_id, '_iranavadasopc', 'no' );
        }
      }

      ?>
      <div <?= FusionBuilder::attributes( 'carousel' ) ?>>
          <a href="<?=$product_permalink;?>" class="product-link"></a>
          <div class="product-img">
            <?php 

            if( $product_image_url_optimized ) {
                ?><img width="300" height="300" alt="<?=$product_name;?>" src="<?=$product_image_url_optimized;?>"><?php
            }else {
                ?><img width="300" height="300" alt="<?=$product_name;?>" src="<?=wc_placeholder_img_src();?>"><?php
            }
            
            ?>
          </div>
          <?php 
            if( $product_is_on_sale ) {
              if( $display_percentage_number_off == 'percentage' ) {
                ?><div class="price-discount percentage"><span><?= $percentage; ?>%</span></div><?php
              }

              if( $display_percentage_number_off == 'number' ) {
                ?><div class="price-discount number"><span><?= number_format($price_off_number).' '.get_woocommerce_currency_symbol(); ?></span></div><?php
              }
            }
          ?>
          <div class="swiper-product-details">
              
              <?php 
              
              if( $irava_display_title == 'yes' ) {
                  ?><h3 <?= FusionBuilder::attributes( 'product-title' ) ?>><?=$product_name;?></h3><?php
              }
              
              if( $irava_display_price == 'yes' ) {
                ?>
                <span class="product-price<?php if($product_is_on_sale) { echo ' discounted'; } ?>">
                  <?php echo $product_price_html; ?>
                </span>
                <?php
              }
              ?>

              <?php 
                  if( $enable_disable_addtocart_button == 'yes' ) : 
                      if( $irava_display_price == 'yes' ) :
                          ?>
                          
                          <span class="addtocart-icon">
                            <a href="<?php echo ( $product->is_type('simple') ) ? '?add-to-cart=' . $product_id : $product_permalink; ?>"
                              <?= FusionBuilder::attributes( 'special-carousel-add-to-cart' ) ?> 
                              target="_blank" 
                              data-quantity="1" 
                              data-product_id="<?= $product_id; ?>" 
                              data-product_sku=""
                              data-product_sku="<?= esc_attr( $product->get_sku() ); ?>"
                              aria-label="<?= $product_title; ?>" 
                              rel="nofollow">
                                <span class="tooltip-text">
                                    <?php echo $product->add_to_cart_text(); ?>
                                </span>
                                <i class="<?php echo $addtocart_button_icon; ?>" aria-hidden="true"></i>
                            </a>
                          </span>
                          
                          <?php 
                      endif;
                  endif; 
              ?>

              <div <?= FusionBuilder::attributes( 'product-off-timer' ) ?> data-countdown="<?=$product_on_sale_to_final;?>"></div>

          </div>

      </div>
      <?php

    }

    if( $irava_display_last_slide == 'yes' ) {

      ?>
      <div <?= FusionBuilder::attributes( 'carousel' ) ?>>
        <div class="show-more-section">
          <a href="<?=$Carousel_button_link;?>" class="show-more-products-irava <?= $id ?>" target="_blank">
            <div class="show-more-icon">
              <img width="300" height="300" src="<?php echo get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/template/carousel/img/last-item-carousel-ok.svg'; ?>" alt="show all" />
            </div>
            <div class="show-more-text" style="width: 100%;">
              <span><?=$carousel_button_text;?></span>
            </div>
          </a>
        </div>
      </div>
      <?php

    }
    ?>
    <!-- End Loop -->
    
  </div>
  <div class="swiper-button-next"></div>
  <div class="swiper-button-prev"></div>
</div>