<?php
/**
 * @Author: Iranavada Team
 * @Date:   2020/10/10 13:19:49
 * @Email:  iranavada@gmail.com
 * @Last modified by:   Iranavada Team
 * @Last modified time: 2020/10/18 15:14:46
 * @License: GPLv2
 * @Copyright: Copyright © 2020 Iranavada Team, All rights reserved.
 */

$svg = '<svg xmlns="http://www.w3.org/2000/svg" width="249" height="49" viewBox="0 0 249 49"><path class="svgbackcolor" d="M.191 0H0h249-.191a30 30 0 0 0-25.586 14.335l-12.446 20.33A30 30 0 0 1 185.19 49H63.81a30 30 0 0 1-25.586-14.335l-12.446-20.33A30 30 0 0 0 .19 0z"/></svg>';


global // Get All Global Variables Value
$woocommerce,		
$get_template_name,
$irava_display_title,
$irava_display_price,
$carousel_banner,
$responsive_min_0,
$responsive_min_480,
$responsive_min_720,
$responsive_min_960,
$responsive_min_1200,
$carousel_button_text,
$Carousel_button_link,
$Carousel_button_link_small,
$Carousel_button_link_medium,
$category,
$shegeftangiz,
$discounted_products,
$Show_timer,
$display_product_limit,
$irava_orderby,
$irava_product_type,
$irava_sortby,
$display_banner_button,
$id,
$enable_disable_addtocart_button,
$display_percentage_number_off,
$addtocart_button_icon,
$product_on_sale_to_final,
$auto_play_on_off,
$auto_play_time,
$rewind_carousel,
$stop_on_last_slide;

if( $discounted_products == 'yes' ) {

  $query_args     = array( 
    'post_type'       => 'product', 
    'post_status'     => 'publish',
    'limit'           => $display_product_limit,
    'product_cat'     => $category,
    'orderby'         => $irava_orderby,
    'order'           => $irava_sortby,
    'type'            => array("simple","variable"),
    'stock_status'    => 'instock',
    'include'         => wc_get_product_ids_on_sale(),
  );

}elseif( $shegeftangiz == 'yes' ) {

  $query_args     = array( 
    'post_type'       => 'product', 
    'post_status'     => 'publish',
    'limit'           => $display_product_limit,
    'product_cat'     => $category,
    'orderby'         => $irava_orderby,
    'order'           => $irava_sortby,
    'type'            => array("simple","variable"),
    'stock_status'    => 'instock',
    '_iranavadasopc'  => 'yes',
  );

}else {

  $query_args     = array( 
    'post_type'       => 'product', 
    'post_status'     => 'publish',
    'limit'           => $display_product_limit,
    'product_cat'     => $category,
    'orderby'         => $irava_orderby,
    'order'           => $irava_sortby,
    'type'            => array("simple","variable"),
    'stock_status'    => 'instock',
  );

}

$iranavada_products = wc_get_products( $query_args );

// Get Responsive In Global -> Slider Template
$responsive_min_0 		= '1';	
$responsive_min_480 	= '1';
$responsive_min_720 	= '1';	
$responsive_min_960 	= '1';
$responsive_min_1200 	= '1';

$responsive = array(
  "r_0"     => $responsive_min_0,
  "r_480"   => $responsive_min_480,
  "r_720"   => $responsive_min_720,
  "r_960"   => $responsive_min_960,
  "r_1200"  => $responsive_min_1200,
);
$responsive = esc_attr( esc_js( wp_json_encode( $responsive ) ) ) ;

?>

<div class="swiper iranavada-slider-template" id="<?= $id ?>" data-responsive="<?= $responsive ?>" data-autoplay="<?= $auto_play_on_off ?>" data-autoplaytime="<?= $auto_play_time ?>">

    <div class="slider-template-head">
        <div class="slider-svg-section iravada-col m7 iravada-center">
            <div class="iravada-left special-discount-slider-title">
                <?php
                    if( $slider_title_text_banner_image == 'text' ) {
                        if( $slider_heading_text != '' ) {
                            echo "<div class='slider-background-head'>$svg</div><div class='discount-text'>{$slider_heading_text}</div>";
                        }elseif( $slider_heading_text == '' ) {
                            echo "<div class='slider-background-head' style='opacity: 0;'>$svg</div>";
                        }
                    }else {
                        if( $slider_template_font_icon != '' && $slider_title_text_banner_image == 'banner' ) {
                            echo '<img src="' . esc_attr($slider_template_font_icon) . '" alt="' . esc_attr($slider_heading_text) . '"/>';
                        }
                    }
                ?>
            </div>
        </div>
        <div class="swiper-prev-next-btn iravada-col m5 iravada-center">
            <span class="slider-prev iravada-button"><?php echo __("Prev", 'royal');?> <i class="fa fa-angle-left"></i></span>
            <span class="swiper-number-cout" style="direction: ltr;">0/0</span>
            <span class="slider-next iravada-button"><i class="fa fa-angle-right"></i> <?php echo __("Next", 'royal');?></span>
        </div>
    </div>

    <div class="swiper-wrapper">

        <?php 
        foreach ($iranavada_products as $products) {
            $product = wc_get_product($products);
            $product_id = $product->get_id();
            $product_name = strlen($product->get_name()) > 70 ? mb_substr($product->get_name(), 0, 70, "utf-8") . "&hellip;" : $product->get_name();
            $product_title = strlen($product->get_title()) > 70 ? mb_substr($product->get_title(), 0, 70, "utf-8") . "&hellip;" : $product->get_title();
            $product_slug = $product->get_slug();
            $product_permalink = get_permalink($product->get_id());
            $product_price = $product->get_price();
            $product_price_html = $product->get_price_html();
            $product_sale_price = $product->get_sale_price();
            $product_regular_price = $product->get_regular_price();
            $product_is_on_sale = $product->is_on_sale();
            $product_is_in_stock = $product->is_in_stock();
            $product_stock_status = $product->get_stock_status();
            $product_on_sale_to = $product->get_date_on_sale_to();
            $product_stock_quantity = $product->get_stock_quantity();
            $product_image = $product->get_image();
            $product_image_id = $product->get_image_id();
            $product_image_url = wp_get_attachment_url($product_image_id);
            $product_image_url_optimized = get_the_post_thumbnail_url($product_id, 'irava-slider-400-crop');
            $product_image_url_optimized_full = get_the_post_thumbnail_url($product_id, 'irava-slider-75-crop');
            $product_gallery_image_ids = $product->get_gallery_image_ids();
            
            $product_special_true = get_post_meta($product_id, '_iranavadasopc', true);
            $product_on_sale_to_2 = get_post_meta($product_id, '_iranavadasopc_date', true);
            $product_on_sale_to_final = null;
            
            if ($product->is_type('variable') && "yes" == $product_special_true && !empty($product_on_sale_to_2)) {
                $product_on_sale_to_final = (new DateTime($product_on_sale_to_2))->format('Y/m/d') . ' 23:59:59';
            }
            else{
                if ($product_is_in_stock && $product_on_sale_to != null) {
                    $product_on_sale_to_final = $product_on_sale_to->date('Y/m/d') . ' 23:59:59';
                }
                elseif($product_is_in_stock) {
                    $product_on_sale_to_final = null;
                }
            }
      
            if( $product_on_sale_to_final != null ) {
              if (date("Y/m/d H:i:s") > $product_on_sale_to_final ) {
                update_post_meta( $product_id, '_iranavadasopc', 'no' );
              }
            }

            ?>
            
            <div class="swiper-slide">

                <div class="swiper-product-images iravada-col s9 m5 l5 iravada-center offer-image">
                    <div class="swiper-product-featured-img iravada-margin-top iravada-margin-bottom iravada-margin-left">
                        <?php 
                            if( $product_image_url_optimized ) {
                                ?><a href="<?=esc_attr( $product_permalink );?>"><img width="400" height="400" class="iravada-round" src="<?=esc_attr( $product_image_url_optimized )?>"></a><?php
                            }else {
                                ?><a href="<?=esc_attr( $product_permalink );?>"><img width="400" height="400" class="iravada-round" src="<?=wc_placeholder_img_src()?>"></a><?php
                            }
                        ?>
                    </div>
                </div>
                <div class="iravada-col s3 m2 l2 iravada-center offer_thumbnails">
                    <div class="iravada-margin-top iravada-margin-bottom">
                    <?php
                        $i = 0;
                        if (count($product_gallery_image_ids) > 0) {
                            foreach( $product_gallery_image_ids as $attachment_id ){
                                if (++$i == 5) { break; }
                                ?>
                                    <div class="swiper-gallery-img iravada-margin-bottom">
                                        <a href="<?=esc_attr( $product_permalink );?>">
                                            <?php 
                                                if( isset( wp_get_attachment_image_src($attachment_id, 'irava-slider-75-crop')[0] ) ) {
                                                    ?><img width="75" height="75" class="iravada-border iravada-round" src="<?=esc_attr( wp_get_attachment_image_src($attachment_id, 'irava-slider-75-crop')[0] );?>"><?php
                                                }else {
                                                    ?><img width="75" height="75" class="iravada-border iravada-round" src="<?= wc_placeholder_img_src() ?>"><?php
                                                }
                                            ?>
                                        </a>
                                    </div>
                                <?php
                            }
                        }
                        ?>
                    </div> 
                </div>
                <div class="swiper-product-details offer_text iravada-col m5 l5 iravada-center">
                    <div class="discount_text_content">
                        <div class="iravada-large offer-price">
                            <?php
                                if ($product_is_in_stock) {

                                    echo $product_price_html;
                                    if ($product_is_on_sale) {

                                        $regular_price = $product->is_type('variable') ? $product->get_variation_regular_price( 'min', true ) : $product->get_regular_price();
                                        $sale_price = $product->is_type('variable') ? $product->get_variation_sale_price( 'min', true ) : $product->get_sale_price();
                                        
                                        if ( $regular_price !== $sale_price ) {

                                            if( $display_percentage_number_off == 'percentage' ) {

                                                $percentage = floor( ( $regular_price - $sale_price ) / $regular_price * 100 );
                                                echo '<span class="iranavada-soc-onsale">';
                                                echo "<span class='discount-amount'>{$percentage}% </span>";
                                                echo "<small class='iranavada-soc-onsale-text'>".__("OFF",'royal')."</small>";
                                                echo '</span>';

                                            }

                                            if( $display_percentage_number_off == 'number' ) {

                                                $price_off_number = $regular_price - $sale_price;
                                                echo '<span class="iranavada-soc-onsale">';
                                                echo '<span class="discount-amount">'.number_format($price_off_number).' '.get_woocommerce_currency_symbol().' </span>';
                                                echo '<small class="iranavada-soc-onsale-text"> '.__('OFF','royal').'</small>';
                                                echo '</span>';
                                            
                                            }

                                        }

                                    }

                                }
                            ?>
                        </div>
                        <a class="iranavada-soc-title" href="<?=esc_attr( $product_permalink );?>" style="text-decoration: none">
                            <div class="iravada-large discount-title"><?=$product_title;?></div>
                        </a>
                        <?php

                            $mcg_group_title = get_post_meta($product_id, 'mcg_group_title', true);
                            $gpminvoice_group = get_post_meta($product_id, 'customdata_group', true);

                            if ($gpminvoice_group) {
                                echo '<section class="home_unique_attributes"><ul class="value_field">';
                                $i = 0;
                                foreach ( $gpminvoice_group as $field ) { $i++;
                                    if( $i <= 6 ) { echo '<li>'.esc_attr($field['TitleItem']).' <span class="irava-uniq-bold">'.esc_attr($field['AttrItem']).'</span></li>'; }
                                }
                                echo '</ul></section>';
                            }
                            else{
                                echo '<div id="onsel-height"></div>';
                            }

                        ?>
                    </div>
                    <div class="home_discount_timer_box" style="<?=("yes" == $Show_timer ? "":"display:none;");?>">
                        <?php

                            $product_on_sale_to_1 = get_post_meta( $product_id, '_iranavadasopc', true );
                            $product_on_sale_to_2 = get_post_meta( $product_id, '_iranavadasopc_date', true );

                            if ($product->is_type('variable') && "yes" == $product_on_sale_to_1 && !empty($product_on_sale_to_2)){
                                echo '<span class="remaining-time">'.__("Special Offer time left",'royal').'</span><div class="iranavada-sopcaw-countdown-raw coundown-large" data-options="spancolon|box|label"
                                data-date="' . esc_attr((new DateTime($product_on_sale_to_2))->format('Y/m/d')) . ' 23:59:59"></div>';
                            }
                            else {
                                if ($product_is_in_stock && $product_on_sale_to != null){
                                    if ($product_is_in_stock && $product_on_sale_to != null){
                                        $product_on_sale_to_final = $product_on_sale_to->date('Y/m/d H:i:s');
                                        echo '<span class="remaining-time">'.__("Special Offer time left",'royal').'</span><div class="iranavada-sopcaw-countdown-raw coundown-large" data-options="spancolon|box|label"
                                        data-date="' . esc_attr($product_on_sale_to->date('Y/m/d')) . ' 23:59:59"></div>';
                                    }
                                }

                            }

                        ?>
                    </div>
                </div>

            </div>
            
            <?php

        }
        ?>

    </div>

    <div class="swiper-pagination"></div>

</div>