<?php

if( !class_exists('Royal_Elements') ) {

    class Royal_Elements {
        
        protected $royal_elements_css_url = '';
        protected $royal_elements_dir = '';

        public function __construct() {

            $this->royal_elements_css_url = get_stylesheet_directory_uri() . '/includes/royal-elements/assets/css/';
            $this->royal_elements_dir     = get_stylesheet_directory() . '/includes/royal-elements/';

            // Enqueue Scripts Needed For Elements Admin Section
            add_action( 'admin_enqueue_scripts', array($this, 'iravada_load_css_royal_element_backend_style') );

			// Add new setting fields to Fusion Builder.
			add_filter( 'fusion_builder_fields', array( $this, 'royal_add_new_fields' ), 11 );

            // Run Elements Files
            $this->load_elements_php_files();

            // ست شدن رویال برند در زمان تکثیر یک محصول
            add_action( 'woocommerce_product_duplicate', array( $this, 'iranavada_copy_brand_on_product_duplicate' ), 10, 2 );
        }

        // --- شروع متد اضافه شده برای کپی کردن برند محصول ---
        /**
         * هنگام تکثیر محصول ووکامرس، برند (از تکسونومی iravada-royal-brands) را نیز کپی می‌کند.
         * این متد به هوک 'woocommerce_product_duplicate' متصل می‌شود.
         *
         * @param WC_Product $duplicate_product شیء محصول جدید (تکثیر شده).
         * @param WC_Product $original_product  شیء محصول اصلی.
         */
        public function iranavada_copy_brand_on_product_duplicate( $duplicate_product, $original_product ) {

            // نام تکسونومی رویال برند
            $taxonomy_slug = 'iravada-royal-brands';

            // اطمینان از اینکه هر دو آرگومان، اشیاء معتبر WC_Product هستند.
            if ( ! $duplicate_product instanceof WC_Product || ! $original_product instanceof WC_Product ) {
                // اگر اشیاء معتبر نباشند، برای جلوگیری از خطا از تابع خارج می‌شویم.
                return;
            }

            $original_product_id = $original_product->get_id();
            $new_product_id      = $duplicate_product->get_id();

            // دریافت شناسه‌های ترم‌های برند از محصول اصلی.
            $term_ids = wp_get_object_terms( $original_product_id, $taxonomy_slug, array( 'fields' => 'ids' ) );

            // اگر خطایی در دریافت ترم‌ها وجود نداشت و حداقل یک ترم یافت شد.
            if ( ! is_wp_error( $term_ids ) && ! empty( $term_ids ) ) {
                // اختصاص دادن ترم‌ها به محصول جدید (تکثیر شده).
                // پارامتر چهارم (false) به این معنی است که ترم‌های موجود (اگر باشند) با این ترم‌ها جایگزین می‌شوند.
                wp_set_object_terms( $new_product_id, $term_ids, $taxonomy_slug, false );
            }
        }

        // Add New Fields To Fusion Builder Option
        public function royal_add_new_fields( $fields ) {

			$fields[] = array( 'royal_mega_menu_tabs', $this->royal_elements_dir . 'elements-additional/fields/royal-mega-menu-library-columns.php' );
			$fields[] = array( 'royal_mega_menu_submenu', $this->royal_elements_dir . 'elements-additional/fields/royal-mega-menu-submenu.php' );

			return $fields;
            
        }

        // Load Scripts Needed For Elements On Admin
        public function iravada_load_css_royal_element_backend_style() {
            wp_enqueue_style('royal-element-frontend-css', $this->royal_elements_css_url . 'royal-element-admin-style.css', '', '2.4' );
        }

        // Load Elements Files
        public function load_elements_php_files() {

            // Check If Wishlist Active From Royal Options ==> Require Main File Needed
            if( empty( $get_royal_option_settings['wishlist_status'] ) ) {
                
                // Load Main Wishlist Files
                require_once( get_stylesheet_directory() . '/includes/royal-elements/includes/irava-product-wishlist/royal-wishlist.php' );
                
                // Include The Wishlist Element ==> Post Cart
                require_once( $this->royal_elements_dir . 'includes/irava-product-wishlist/inc/shortcodes/iravada-wishlist-product-post-card.php' );
                
                // Include The Wishlist Element ==> Wishlist Page
                require_once( $this->royal_elements_dir . 'includes/irava-product-wishlist/inc/shortcodes/iravada-product-wishlist-element.php' );
            }
            
            // Include The Subtitle Element
            require_once( $this->royal_elements_dir . 'includes/iravada-subtitle.php' );

            // Include The User Avatar Element
            require_once( $this->royal_elements_dir . 'includes/iravada-account-avatar.php' );

            // Include The Soon Product Element
            require_once( $this->royal_elements_dir . 'includes/iravada-soon-product.php' );

            // Include The Soon Product Lable Element
            require_once( $this->royal_elements_dir . 'includes/iravada-soon-product-shop-lable.php' );

            // Include The Uniq Attr Element
            require_once( $this->royal_elements_dir . 'includes/iravada-uniq-attr.php' );

            // Include The Product Video Element
            require_once( $this->royal_elements_dir . 'includes/iravada-product-video.php' );

            // INclude The Cart Display Message Element
            require_once( $this->royal_elements_dir . 'includes/iravada-free-shipping.php' );

            // Include The Offer Element
            require_once( $this->royal_elements_dir . 'includes/iravada-offer.php' );

            // Include The Register And Login Woo Element
            require_once( $this->royal_elements_dir . 'includes/iravada-register-login.php' );

            // Include The Single Product Icons Element
            require_once( $this->royal_elements_dir . 'includes/iravada-icons.php' );

            // Include The Single Product digikala rate Element
            require_once( $this->royal_elements_dir . 'includes/iravada-product-comment-rate.php' );

            // Include The Single Product digikala rate Element
            require_once( $this->royal_elements_dir . 'elements-additional/uniq-attr.php' );

            // Include The Royal Mega Menu
            require_once( $this->royal_elements_dir . 'includes/irava-royal-mega-menu/iravada-royal-mega-menu.php' );

            // Include The Royal Products ACF
            require_once( $this->royal_elements_dir . 'includes/iravada-royal-product-acf.php' );
            
            // Check Woocommerce Is Active - بهتر است قبل از فراخوانی متد استاتیک، وجود کلاس نیز بررسی شود.
            if( class_exists('Proshop_Royal') && Proshop_Royal::check_plugin_activated('woocommerce/woocommerce.php') == true ) {

                // Include The Royal Product Special Carousel
                require_once( $this->royal_elements_dir . 'includes/special-product-swiper/iravada-swiper-product-slider.php' );
                require_once( $this->royal_elements_dir . 'includes/iravada-product-compare-page.php' );
                require_once( $this->royal_elements_dir . 'includes/iravada-story-elements.php' );

            }
            
            // Include The Display Brand Element
            require_once( $this->royal_elements_dir . 'includes/iravada-brands-single.php' );
            require_once( $this->royal_elements_dir . 'includes/iravada-brands-list.php' );

            // Include The Compare Product Element
            require_once( $this->royal_elements_dir . 'includes/iravada-compare-product.php' );

            // Check Dokan Pro Is Active
            if( class_exists('Proshop_Royal') && Proshop_Royal::check_plugin_activated('dokan-pro/dokan-pro.php') == true ) {

                // Include The Store Name Element --> Dokan
                require_once( $this->royal_elements_dir . 'includes/iravada-dokan-display-store-name.php' );

                // Include The Sell This Product Button --> Dokan
                require_once( $this->royal_elements_dir . 'includes/iravada-dokan-sell-this-product-button.php' );

                // Include The Product Vendors --> Dokan
                require_once( $this->royal_elements_dir . 'includes/iravada-dokan-display-product-seller.php' );

            }

        }

    }
    new Royal_Elements(); // نمونه سازی کلاس 

}