<?php

if( !class_exists('Royal_Add_Attribute_To_Group_In_Add_New') ) {

    class Royal_Add_Attribute_To_Group_In_Add_New {

        public function __construct() {

            add_action('woocommerce_after_add_attribute_fields', [$this, 'add_royal_group_attribute_dropdown']);
            add_action('woocommerce_after_edit_attribute_fields', [$this, 'edit_royal_group_attribute_dropdown']);

            add_action('woocommerce_attribute_added', [$this, 'save_royal_group_attribute_dropdown']);
            add_action('woocommerce_attribute_updated', [$this, 'save_royal_group_attribute_dropdown'], 10, 3);

        }

        // Add dropdown before "Add Attribute" button
        public static function add_royal_group_attribute_dropdown() {
            $all_group = Royal_Display_Group_Attributes::GetAllGroupAttributes();
            echo '<div class="form-field"><label for="royal_group_attribute_select">'.__('Select for Group', 'royal').'</label><select id="royal_group_attribute_select" name="royal_group_attribute_select">';
            echo '<option value="">' . __('Select Royal Group Attribute', 'royal') . '</option>';
            foreach ($all_group as $group) {
                echo '<option value="' . esc_attr($group->post_id) . '">' . get_the_title($group->post_id) . '</option>';
            }
            echo '</select></div>';
        }

        // Add dropdown before "Add Attribute" button
        public static function edit_royal_group_attribute_dropdown() {

            if(isset($_GET['edit']) && $_GET['edit'] > 0){
                $id = intval($_GET['edit']);
            }else{
                $id = 0;
            }

            $all_group = Royal_Display_Group_Attributes::GetAllGroupAttributes();

            ?>
                <tr class="form-field form-required">
                    <th scope="row" valign="top">
                        <label for="royal_group_attribute_select"><?= __('Select for Group', 'royal') ?></label>
                    </th>
                    <td>
                        <select id="royal_group_attribute_select" name="royal_group_attribute_select">
                            <option value=""><?= __('Select Royal Group Attribute', 'royal') ?></option>
                            <?php 
                                foreach ($all_group as $group) {
                                    $checked = '';
                                    // بررسی متا و انجام صحیح سریالایز کردن
                                    $attributes = maybe_unserialize($group->meta_value);
                                    if (is_array($attributes) && in_array($id, $attributes)) {
                                        $checked = 'selected';
                                    }
                                    ?>
                                    <option value="<?= esc_attr($group->post_id) ?>" <?= $checked ?>><?= get_the_title($group->post_id) ?></option>
                                    <?php
                                }
                            ?>
                        </select>
                    </td>
                </tr>
            <?php

        }

        public function save_royal_group_attribute_dropdown($id) {

            if (is_admin() && !empty($_POST['royal_group_attribute_select'])) {

                $group_id       = intval($_POST['royal_group_attribute_select']); 
                $attribute_id   = strval($id);

                 // دریافت متای گروه
                $group_meta = get_post_meta($group_id, 'royal_group_attribute_selected_attributes', true);
                
                 // بررسی و باز کردن داده‌های سریالایز شده
                $attributes = maybe_unserialize($group_meta);

                 // اطمینان از اینکه $attributes آرایه است
                if (!is_array($attributes)) {
                    $attributes = [];
                }

                 // اضافه کردن آی‌دی جدید اگر وجود نداشته باشد
                if (!in_array($attribute_id, $attributes)) {
                    $attributes[] = $attribute_id;
                }

                 // ذخیره داده‌ها به صورت سریالایز شده (یک بار فقط)
                update_post_meta($group_id, 'royal_group_attribute_selected_attributes', $attributes); 

            }
        }
        

    } new Royal_Add_Attribute_To_Group_In_Add_New();

}
?>
