<?php

if( !class_exists('Royal_Display_Group_Attributes') ) {

    class Royal_Display_Group_Attributes {
        
        protected $template_path = '';
        protected $css_path = '';
        protected $js_path = '';
        
        public function __construct() {

            $this->template_path    = get_stylesheet_directory() . '/includes/royal-group-attribute/templates/';
            $this->css_path         = get_stylesheet_directory_uri() . '/includes/royal-group-attribute/assets/css/';
            $this->js_path          = get_stylesheet_directory_uri() . '/includes/royal-group-attribute/assets/js/';

            $this->removeDefaultAttributesDisplay();
            $this->addCustomAttributesDisplay();

            add_action( 'wp_enqueue_scripts', array($this, 'royal_product_additional_information_enqueue_scripts') );

        }

        // wp Enqueue Scripts/Styles
        public function royal_product_additional_information_enqueue_scripts() {

            $setting = Royal_Option_Functions::get_royal_option_settings();

            $GetStyleType = isset($setting['group_attributes_select_style']) ? $setting['group_attributes_select_style'] : 'title_side';

            if ( class_exists('WooCommerce') ) {
                
                if( is_product() ) {
    
                    switch($GetStyleType) {
                        case 'title_side':
                            wp_enqueue_style('royal-group-attr-styles', $this->css_path . 'template-1-side-title.css', '', '1.1' );
                            break;
                        case 'title_on_top':
                            wp_enqueue_style('royal-group-attr-styles', $this->css_path . 'template-2-top-title.css', '', '1.1' );
                            break;
                    }
                    
                    wp_enqueue_script( 'royal-group-attr-script', $this->js_path . 'front-end-group-attr-script.js', array('jquery'), '1.0', true );
                }
            }
        }
        
        // Remove Current Display Attributes
        private function removeDefaultAttributesDisplay() {
            remove_action('woocommerce_product_additional_information', 'wc_display_product_attributes', 10);
        }

        // Display Custom Group Attributes
        private function addCustomAttributesDisplay() {
            add_action('woocommerce_product_additional_information', [$this, 'royal_display_group_attributes'], 10);
        }

        public function royal_display_group_attributes() {

            global $product;

            $setting = Royal_Option_Functions::get_royal_option_settings();

            $GetStyleType = isset($setting['group_attributes_select_style']) ? $setting['group_attributes_select_style'] : 'title_side';

            $attributes = $product->get_attributes();
            $attribute_groups = $this->GetAllGroupAttributes();

            $grouped_attributes = [];
            $ungrouped_attributes = [];
            
            foreach ($attributes as $attribute) {
                $found = false;
                foreach ($attribute_groups as $key => $group) {
                    $attrs = unserialize($group->meta_value);
                    foreach ($attrs as $atr) {
                        if ($attribute->get_id() == $atr) {
                            $grouped_attributes[$key][] = $attribute;
                            $found = true;
                            break;
                        }
                    }
                }
                if ( !$found ) {
                    $ungrouped_attributes[] = $attribute;
                }
            }

            switch($GetStyleType) {
                case 'title_side':
                    require_once( $this->template_path . 'group-attribute-template-1-side-title.php' );
                    new Royal_Group_Attributes_Template_One($grouped_attributes, $ungrouped_attributes, $attribute_groups);
                    break;
                case 'title_on_top':
                    require_once( $this->template_path . 'group-attribute-template-2-top-title.php' );
                    new Royal_Group_Attributes_Template_Two($grouped_attributes, $ungrouped_attributes, $attribute_groups);
                    break;
            }
            

        }

        public static function GetAllGroupAttributes() {

            global $wpdb;

            $query = " SELECT * FROM {$wpdb->postmeta} WHERE meta_key = %s ";
            
            $sql = $wpdb->prepare($query, 'royal_group_attribute_selected_attributes');
            $results = $wpdb->get_results($sql);
            
            return $results;

        }
        
    }new Royal_Display_Group_Attributes();

}
