<?php 

// Add Royal Group Attribute Post Type
if( !class_exists( 'Royal_Group_Attribute_Post_Type' ) ) {

    class Royal_Group_Attribute_Post_Type {
        
        protected $js_path = '';
        protected $css_path = '';

        public function __construct() {

            $this->js_path   = get_stylesheet_directory_uri() . '/includes/royal-group-attribute/assets/js/';
            $this->css_path  = get_stylesheet_directory_uri() . '/includes/royal-group-attribute/assets/css/';

            add_action('init', [$this, 'create_group_attribute_post_type']);
            add_action('add_meta_boxes', [$this, 'royal_group_attr_meta_box']);
            add_action('admin_enqueue_scripts', [$this, 'load_edit_page_js_code']);

            add_action('save_post', [$this, 'save_royal_group_attributes_meta']);

             // اضافه کردن ستون جدید به لیست پست‌ها
            add_filter('manage_royal_group_attr_posts_columns', [$this, 'add_column_attributes_selected']);
            add_action('manage_royal_group_attr_posts_custom_column', [$this, 'display_attributes_selected'], 10, 2);

        }

        public function create_group_attribute_post_type() {

            $args = array(

                'labels' => array(
                    'name'                  => 'دسته بندی‌ ویژگی‌ها رویال',
                    'singular_name'         => 'دسته بندی ویژگی',
                    'menu_name'             => __('Royal Group Attribute', 'royal'),
                    'add_new'               => 'افزودن دسته بندی', // متن دکمه افزودن جدید
                    'add_new_item'          => 'افزودن دسته بندی', // عنوان صفحه افزودن پست جدید
                    'edit_item'             => 'ویرایش دسته بندی', // عنوان صفحه ویرایش پست
                    'new_item'              => 'دسته بندی جدید' , // عنوان پست جدید
                    'view_item'             => 'مشاهده دسته ویژگی', // عنوان دکمه مشاهده
                    'search_items'          => 'جستجو دسته بندی', // عنوان جستجو در پست‌های ویژگی جدید
                    'not_found'             => 'هیچ دسته‌ای پیدا نشد', // متن زمانی که هیچ نتیجه‌ای پیدا نمی‌شود
                    'not_found_in_trash'    => 'هیچ دسته‌ای در سطل زباله پیدا نشد', // زمانی که هیچ چیزی در سطل زباله نیست
                ),
                'public'            => false,
                'has_archive'       => false,
                'supports'          => array('title'),
                'show_in_rest'      => false, // فعال کردن پشتیبانی از گوتنبرگ
                'hierarchical'      => false,
                'rewrite'           => array('slug' => 'royal-group-attributes'),
                'show_ui'           => true,
                'show_in_menu'      => 'edit.php?post_type=product', // اینجا منوی محصولات را دقیقاً مشخص می‌کنیم
                'menu_position'     => 25, // تنظیم موقعیت منو در زیر منوی محصولات

            );
            register_post_type('royal_group_attr', $args);

        }

        // اضافه کردن ستون جدید بعد از عنوان
        public function add_column_attributes_selected($columns) {

            $new_columns = [];
            foreach ($columns as $key => $value) {
                $new_columns[$key] = $value; // کپی کردن ستون‌های موجود
                if ($key === 'title') {  // بعد از ستون عنوان
                    $new_columns['royal_group_attribute_column'] = 'ویژگی‌های انتخابی';  // نام ستون جدید
                }
            }
            return $new_columns;

        }

        // نمایش محتوای ستون جدید
        public function display_attributes_selected($column, $post_id) {

            if ($column === 'royal_group_attribute_column') {

                $prefix = 'royal_group_attribute_selected_';
                $selectedAttributes = get_post_meta($post_id, $prefix . 'attributes', true);
        
                if ($selectedAttributes) {
                    
                     // تبدیل آیدی‌ها به نام ویژگی‌ها
                    $possibleAttributes = wc_get_attribute_taxonomies(); // لیست ویژگی‌ها
                    $attributeNames = [];
        
                    foreach ($selectedAttributes as $attributeId) {
                        foreach ($possibleAttributes as $possibleAttribute) {
                            if ($possibleAttribute->attribute_id == $attributeId) {
                                $attributeNames[] = $possibleAttribute->attribute_label . "<strong> [ID:$attributeId] </strong><br>";
                            }
                        }
                    }
        
                     // نمایش لیستی از ویژگی‌های انتخاب شده
                    // echo implode(' , ', $attributeNames);
                    echo implode('', $attributeNames);

                } else {
                    echo 'هیچ ویژگی انتخاب نشده';
                }
            }

        }

        // Add Select Attribute MetaBox 
        public function royal_group_attr_meta_box() {

            add_meta_box(
                'royal_group_attr_meta',        // شناسه جعبه متا
                'انتخاب ویژگی',                  // عنوان جعبه متا
                [$this, 'royal_group_attr_meta_content'], // تابعی که محتوای جعبه متا را تولید می‌کند
                'royal_group_attr',             // پست تایپ هدف
                'normal',                       // موقعیت جعبه متا (normal یا side)
                'high'                          // اولویت جعبه متا (high یا low)
            );

        }

        // MetaBox Content For Select Attribute
        public function royal_group_attr_meta_content() {

            // متاباکس HTML
            global $post;
            
            // لیست ویژگی‌های موجود در ووکامرس
            $possibleAttributes     = wc_get_attribute_taxonomies();
            $prefix                 = 'royal_group_attribute_selected_';
            $selectedAttributes     = get_post_meta($post->ID, $prefix . 'attributes', true);  // ویژگی‌های انتخاب‌شده
            $selected_icon          = get_post_meta($post->ID, $prefix . 'icon', true); // دریافت آیکون ذخیره شده

            if( !$selected_icon ) {
                $selected_icon = 'noIcon';
            }
            // اطمینان از اینکه مقادیر ذخیره‌شده به عنوان آرایه خوانده می‌شوند
            $selectedAttributes = is_array($selectedAttributes) ? $selectedAttributes : [];
            ?>

            <div class="royal-select-attribute">

                <div class="select-attribute-section">

                    <!-- لیست ویژگی‌های موجود -->
                    <div class="royal-all-attributes">
                        <div class="royal-inner-attribute">
                            <h3>انتخاب ویژگی‌ها</h3>
                            <ul id="availableAttributesList">
                                <?php foreach ($possibleAttributes as $possibleAttribute): ?>
                                    <?php if (!in_array($possibleAttribute->attribute_id, $selectedAttributes)): ?>
                                        <li data-id="<?= $possibleAttribute->attribute_id; ?>">
                                            <?= $possibleAttribute->attribute_label; ?>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>

                    <!-- لیست ویژگی‌های انتخاب‌شده -->
                    <div class="royal-selected-attributes">
                        <h3>ویژگی‌های انتخاب شده</h3>
                        <ul id="selectedAttributesList">
                            <?php foreach ($selectedAttributes as $attributeId): ?>
                                <?php foreach ($possibleAttributes as $possibleAttribute): ?>
                                    <?php if ($possibleAttribute->attribute_id == $attributeId): ?>
                                        <li data-id="<?= $attributeId; ?>" draggable="true">
                                            <span class="attribute-text"><span class="drag-handle">⋮⋮</span><span class="attribute-label"><?= $possibleAttribute->attribute_label; ?></span></span>
                                            <button class="remove">حذف</button>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>

                </div>

                <!-- فیلد مخفی برای ذخیره مقادیر انتخاب‌شده -->
                <input type="hidden" name="royal_group_attribute_selected_attributes" id="selected_attributes_input" value="<?= implode(',', $selectedAttributes); ?>" />

            <div style="margin: 0 5px 10px 0;font-size: 15px;"><span style="color: #ff0000;"><strong>ترتیب نمایش ویژگی‌ها</strong></span> را از صفحه ویرایش محصول » بخش اطلاعات محصول » منوی ویژگی‌ها چیدمان کنید.</div>
            <?php

        }

        // Load JS Just In Edit Page For Royal Group Attribute Items
        public function load_edit_page_js_code($hook) {

            if (
                'post-new.php' === $hook && isset($_GET['post_type']) && $_GET['post_type'] === 'royal_group_attr' or 
                'post.php' === $hook && isset($_GET['post']) && get_post_type($_GET['post']) === 'royal_group_attr' 
            ) {
                wp_enqueue_script('royal-group-attr-edit-page-items', $this->js_path . 'admin-edit-page.js', array('jquery'), '', '1.2');
                wp_enqueue_style( 'royal-group-attr-edit-page-style', $this->css_path . 'admin-edit-page.css', '', '1.2' );
            }

        }

        // Save Selected Attributes
        public function save_royal_group_attributes_meta($post_id) {

            // بررسی دسترسی و نوع ذخیره‌سازی
            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
                return;
            }

            if (!current_user_can('edit_post', $post_id)) {
                return;
            }

             // دریافت مقادیر فیلد hidden
            if ( isset($_POST['royal_group_attribute_selected_attributes']) ) {

                $selected_attributes = $_POST['royal_group_attribute_selected_attributes'];
                $selected_attributes_array = array_filter(explode(',', $selected_attributes), 'is_numeric');
                update_post_meta($post_id, 'royal_group_attribute_selected_attributes', $selected_attributes_array);

            }else {
                delete_post_meta( $post_id, 'royal_group_attribute_selected_attributes' );
            }

        }

    }new Royal_Group_Attribute_Post_Type();

}