<?php

if( !class_exists('Royal_Group_Attribute_Edit_Product_Options') ) {

    class Royal_Group_Attribute_Edit_Product_Options {

        public function __construct() {

            add_action('woocommerce_product_options_attributes', [$this, 'royal_group_attribute_button']);
            add_action('wp_ajax_get_royal_group_attributes_inproduct', [$this, 'get_royal_group_attributes_inproduct']);

        }

        // Add button to the product edit page
        
        
        public function royal_group_attribute_button() {
    global $post;
    
    if($post->post_type == 'product') {

        $text = __( 'Save attributes', 'royal' );
        $expand_text = __( 'Expand', 'royal' );
        $collapse_text = __( 'Close', 'royal' );
        $load_text = __('Load Attribute', 'royal');

        ?>

        <div class="toolbar toolbar-buttons royal-group-attribute" style="display: block;">
            <span class="expand-close">
                <a href="#" class="expand_all"><?php echo esc_html( $expand_text ); ?></a> / <a href="#" class="close_all"><?php echo esc_html( $collapse_text ); ?></a>
            </span>
            <button type="button" class="button save_attributes button-primary"><?php echo esc_html( $text ); ?></button>
            <form action="javascript:;" method="post">
                <?php $all_group = Royal_Display_Group_Attributes::GetAllGroupAttributes() ?>
                <select name="royal-group-attribute-id" id="royal_group_attribute_id">
                    <?php foreach ($all_group as $group): ?>
                        <option value="<?php echo esc_attr($group->post_id); ?>"><?php echo get_the_title($group->post_id); ?></option>
                    <?php endforeach; ?>
                </select>
                <button type="button" id="load_royal_attributes" class="button load_attributes button-secondary"><?php echo esc_html($load_text); ?></button>
            </form>
        </div> 
        <style>
            .toolbar.toolbar-buttons {
                display: none;
            }
        </style>

        <script>
jQuery(function($) {
    $('#load_royal_attributes').on('click', function(e) {
        e.preventDefault();
        const $button = $(this);
        
        $button.prop('disabled', true)
               .html('در حال بارگذاری... <span class="spinner" style="visibility:visible; display:inline-block;"></span>');

        $.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: {
                action: 'get_royal_group_attributes_inproduct',
                group_id: $("#royal_group_attribute_id").val()
            },
            success: function(response) {
                if (response.success && response.data && response.data.length > 0) {
                    response.data.forEach(function(item) {
                        add_attribute_to_product(item);
                    });
                } else {
                    alert('هیچ ویژگی‌ای یافت نشد.');
                }
            },
            error: function(xhr, status, error) {
                console.error('خطا:', error);
                alert('خطا در بارگذاری ویژگی‌ها');
            },
            complete: function() {
                $button.prop('disabled', false)
                       .text('بارگذاری ویژگی');
            }
        });
    });

    function add_attribute_to_product(item) {
        if (!item.taxonomy || !item.values) return;

        $.ajax({
            url: ajaxurl,
            method: 'POST',
            data: {
                action: 'woocommerce_add_attribute',
                taxonomy: item.taxonomy.replace('pa_', ''),
                product_type: $('#product-type').val(),
                i: item.i,
                security: woocommerce_admin_meta_boxes.add_attribute_nonce
            },
            success: function(response) {
                const $newAttribute = $(response);
                $('.product_attributes.wc-metaboxes.ui-sortable').append($newAttribute);
                
                $newAttribute.removeClass('closed').addClass('open');
                $newAttribute.find('.woocommerce_attribute_data.wc-metabox-content.hidden')
                    .removeClass('hidden')
                    .css('display', 'block');

                // تنظیم Select برای ویژگی جدید
                const $attributeContainer = $newAttribute.find('.attribute_values');
                const $select = $attributeContainer.find('select');

                // پاک کردن مقادیر قبلی
                $select.empty();

                // اضافه کردن مقادیر جدید
                if (item.values && item.values.length > 0) {
                    item.values.forEach(function(term) {
                        $select.append(
                            $('<option>', {
                                value: term.id,
                                text: term.name,
                                selected: 'selected'
                            })
                        );
                    });
                }

                // اجرای متد استاندارد ووکامرس برای راه‌اندازی مجدد select2
                if (typeof woocommerce_admin_meta_boxes !== 'undefined') {
                    // اجرای مجدد متد select2
                    woocommerce_admin_meta_boxes.init_attribute_select2();
                    
                    // تلاش برای بازسازی select2
                    $select.select2('destroy').select2({
                        width: '100%',
                        placeholder: 'Select terms',
                        multiple: true,
                        allowClear: true
                    });
                }

                // تنظیم نوع ویژگی به عنوان انتخابی
                $newAttribute.find('.attribute_is_variation')
                    .prop('checked', true);
                $newAttribute.find('.enable_variation')
                    .prop('checked', true);

                // تحریک رویداد تغییر برای اطمینان از به‌روزرسانی
                $select.trigger('change');
            },
            error: function(xhr, status, error) {
                console.error('خطا در افزودن ویژگی:', error);
            }
        });
    }
});   
        </script>

        <?php 
    }
}

        
        
        
        

        /**
         * Add attributes to a product based on given attribute IDs.
         */
        public function get_royal_group_attributes_inproduct() {
        
            $group_id = $_POST['group_id'];
            $group_data = Royal_Display_Group_Attributes::GetAllGroupAttributes();
            
            $attributes = [];
            
            foreach ($group_data as $group) {
                if ($group_id == $group->post_id) {
                    $attrs = unserialize($group->meta_value);
                    
                    foreach ($attrs as $atr) {
                        $attribute = wc_get_attribute($atr);
                        
                        if (!$attribute) {
                            error_log("Attribute not found for ID: " . $atr);
                            continue;
                        }
        
                        $taxonomy = 'pa_' . $attribute->slug; // نام taxonomy ویژگی‌ها
        
                        // دریافت مقدارهای این ویژگی
                        $terms = get_terms([
                            'taxonomy'   => $taxonomy,
                            'hide_empty' => false
                        ]);
        
                        // لاگ گرفتن از مقدارهای ویژگی
                        error_log("Taxonomy: $taxonomy - Terms: " . print_r($terms, true));
        
                        // مقدارها را در آرایه قرار دهیم
                        $term_values = [];
                        if (!is_wp_error($terms) && !empty($terms)) {
                            foreach ($terms as $term) {
                                $term_values[] = [
                                    'id'   => $term->term_id,
                                    'name' => $term->name
                                ];
                            }
                        }
        
                        $attributes[] = [
                            'taxonomy'  => $taxonomy,
                            'i'         => $atr,
                            'values'    => $term_values // ارسال مقدارهای ویژگی به AJAX
                        ];
                    }
                }
            }
            
            wp_send_json_success($attributes);
            exit;
        }


    } new Royal_Group_Attribute_Edit_Product_Options();

}