<?php 

// Royal Group Attribute V 1.0
if( !class_exists( 'Royal_Group_Attribute' ) ) {

    class Royal_Group_Attribute {
        
        protected $assets_path = '';
        protected $classes_path = '';
        protected $js_path = '';
        protected $css_path = '';

        public function __construct() {

            $this->assets_path      = get_stylesheet_directory() . '/includes/royal-group-attribute/assets/';
            $this->classes_path     = get_stylesheet_directory() . '/includes/royal-group-attribute/classes/';
            $this->js_path          = get_stylesheet_directory_uri() . '/includes/royal-group-attribute/assets/js/';
            $this->css_path         = get_stylesheet_directory_uri() . '/includes/royal-group-attribute/assets/css/';

            // Load Requie Files For Royal Group Attribute
            $this->load_group_attributes_files();

        }

        // Load All Files Needed
        public function load_group_attributes_files() {

            require_once( $this->classes_path . 'class-royal-group-attribute-post-type.php' );
            require_once( $this->classes_path . 'class-royal-display-group-attribute.php' );
            require_once( $this->classes_path . 'class-royal-group-attribute-product-edit-option.php' );
            require_once( $this->classes_path . 'class-royal-add-attribute.php' );

        }
        
    }new Royal_Group_Attribute();
    
}