<?php

if( !class_exists('Royal_Group_Attributes_Template_One') ) {

    class Royal_Group_Attributes_Template_One {

        private $settings;

        public $royal_attgrp_status;
        public $royal_attgrp_display_weight;
        public $royal_attgrp_display_dimensions;
        public $royal_attgrp_other_text;
        public $royal_attgrp_select_style;
        public $royal_attgrp_more_setting;
        public $group_attributes_more_number;
        public $royal_attgrp_variable_display_style;
        public $royal_attgrp_category_title_text_color;
        public $royal_attgrp_category_title_icon_color;
        public $royal_attgrp_variable_title_text_color;
        public $royal_attgrp_variable_background_color;
        public $royal_attgrp_variable_text_color;

        public function __construct($grouped_attributes, $ungrouped_attributes, $attribute_groups) {

            $this->initializeSettings();

            $this->grouped_attributes   = $grouped_attributes;
            $this->ungrouped_attributes = $ungrouped_attributes;
            $this->attribute_groups     = $attribute_groups;

            $this->displayAttributes($this->grouped_attributes, $this->ungrouped_attributes, $this->attribute_groups);

        }

        private function initializeSettings() {

            $setting = Royal_Option_Functions::get_royal_option_settings();

            $this->royal_attgrp_status = isset($setting['group_attributes_status']) ? $setting['group_attributes_status'] : 'yes';
            $this->royal_attgrp_display_weight = isset($setting['group_attributes_display_weight']) ? $setting['group_attributes_display_weight'] : 'no';
            $this->royal_attgrp_display_dimensions = isset($setting['group_attributes_display_dimensions']) ? $setting['group_attributes_display_dimensions'] : 'no';
            $this->royal_attgrp_other_text = isset($setting['group_attributes_other_text']) ? $setting['group_attributes_other_text'] : 'سایر ویژگی‌ها';
            $this->royal_attgrp_more_setting = isset($setting['group_attributes_more_setting']) ? $setting['group_attributes_more_setting'] : 'yes';
            $this->group_attributes_more_number = isset($setting['group_attributes_more_number']) ? $setting['group_attributes_more_number'] : '5';
            $this->royal_attgrp_variable_display_style = isset($setting['group_attributes_variable_display_style']) ? $setting['group_attributes_variable_display_style'] : 'under';

            $this->royal_attgrp_category_title_text_color       = isset($setting['royal_group_attr_title_text_color_s_one']) ? $setting['royal_group_attr_title_text_color_s_one'] : '#333';
            $this->royal_attgrp_category_title_icon_color       = isset($setting['royal_group_attr_title_icon_color_s_one']) ? $setting['royal_group_attr_title_icon_color_s_one'] : '#21d392';
            $this->royal_group_attr_link_hover_text_color       = isset($setting['royal_group_attr_link_hover_text_color_s_one']) ? $setting['royal_group_attr_link_hover_text_color_s_one'] : '#00c095';
            $this->royal_attgrp_variable_title_text_color       = isset($setting['royal_group_attr_variable_title_text_color_s_one']) ? $setting['royal_group_attr_variable_title_text_color_s_one'] : '#81858b';
            $this->royal_attgrp_variable_text_color             = isset($setting['royal_group_attr_variable_text_color_s_one']) ? $setting['royal_group_attr_variable_text_color_s_one'] : '#333';
            $this->group_attribute_title_icon                   = isset($setting['group_attribute_title_icon_s_one']) ? $setting['group_attribute_title_icon_s_one'] : 'icon1';

            $this->group_attr_color_display                     = isset($setting['group_attr_color_display']) ? $setting['group_attr_color_display'] : 'circle_text';
            $this->group_attr_image_display                     = isset($setting['group_attr_image_display']) ? $setting['group_attr_image_display'] : 'img_text';

        }

        private function displayAttributes($grouped_attributes, $ungrouped_attributes, $attribute_groups) {

            // if (empty($grouped_attributes)) return;

            ?>
            
            <style>

                .royal-attribute-group-wrap span a {
                    color: <?= $this->royal_attgrp_variable_text_color ?> !important;
                }
                .royal-attribute-group-wrap span a:hover  {
                    color: <?= $this->royal_group_attr_link_hover_text_color ?> !important;
                }

            </style>
            <div class="royal-group-attribute product-specs royal-group-attribute-section-category-title-on-side">
                <?php 
                    
                    $count = 1;
                    foreach ($grouped_attributes as $group => $attrs) {
                            ?><div class="royal-group-attribute-category-title-on-side"><?php
                            $this->displayGroupAttributes($group, $attrs, $attribute_groups, $count);
                            ?></div><?php
                        }

                        if (!empty($ungrouped_attributes)) {
                            ?><div class="royal-group-attribute-category-title-on-side"><?php
                            $this->displayUngroupedAttributes($ungrouped_attributes, $count);
                            ?></div><?php
                        }else {
                            ?><div class="royal-group-attribute-category-title-on-side"><?php
                            $this->displayUngroupedAttributesWeightDim($count);
                            ?></div><?php
                        }
                        
                    ?>

                <?php 

                if ( $this->royal_attgrp_more_setting == 'yes' && $count - 1 > $this->group_attributes_more_number ) {

                    ?>
                        <span class="royal-group-attribute-toggle-open" onclick="showMoreAttr()">مشاهده بیشتر <svg width="17px" height="17px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style=""><path d="M16.2431 6.34317L14.8288 4.92896L7.75781 12L14.8289 19.0711L16.2431 17.6569L10.5862 12L16.2431 6.34317Z" fill="var(--primary_color)"></path></svg></span>
                        <span class="royal-group-attribute-toggle-close" onclick="showLessAttr()">بستن <svg width="17px" height="17px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style=""><path d="M16.2431 6.34317L14.8288 4.92896L7.75781 12L14.8289 19.0711L16.2431 17.6569L10.5862 12L16.2431 6.34317Z" fill="var(--primary_color)"></path></svg></span>
                    <?php

                }

                ?>

            </div>

            <?php

        }

        private function displayGroupAttributes($group, $attrs, $attribute_groups, &$count) {

            $GetCurrentGroupID  = $attribute_groups[$group]->post_id;

            ?>
                <div class="royal-attribute-title-group group-title">
                    <p class="royal-attribute-title-group-heading" style="color:<?= esc_attr($this->royal_attgrp_category_title_text_color) ?>;">
                        <?php 
                        
                        $Icon = '';
                        switch($this->group_attribute_title_icon) {
                            case 'icon1':
                                $Icon = '<svg width="15px" viewBox="-2.16 -2.16 28.32 28.32" fill="#1C274C" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                                break;
                            case 'icon2':
                                $Icon = '<svg width="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                                break;
                            case 'icon3':
                                $Icon = '<svg width="15px" viewBox="0 0 24 24" fill="#1C274C" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <circle cx="12" cy="12" r="10" fill="'. $this->royal_attgrp_category_title_icon_color .'"/> </g></svg>';
                                break;
                            case 'icon4':
                                $Icon = '<svg width="15px" viewBox="-2.16 -2.16 28.32 28.32" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M3.46447 3.46447C2 4.92893 2 7.28595 2 12C2 16.714 2 19.0711 3.46447 20.5355C4.92893 22 7.28595 22 12 22C16.714 22 19.0711 22 20.5355 20.5355C22 19.0711 22 16.714 22 12C22 7.28595 22 4.92893 20.5355 3.46447C19.0711 2 16.714 2 12 2C7.28595 2 4.92893 2 3.46447 3.46447ZM9.17157 15.5784C8.75736 15.5784 8.42157 15.2426 8.42157 14.8284L8.42157 10.5858C8.42157 10.1716 8.75736 9.83579 9.17157 9.83578C9.58579 9.83579 9.92157 10.1716 9.92157 10.5858L9.92157 13.0178L14.2981 8.64124C14.591 8.34835 15.0659 8.34835 15.3588 8.64124C15.6517 8.93414 15.6517 9.40901 15.3588 9.7019L10.9822 14.0784H13.4142C13.8284 14.0784 14.1642 14.4142 14.1642 14.8284C14.1642 15.2426 13.8284 15.5784 13.4142 15.5784L9.17157 15.5784Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                                break;
                            case 'icon5':
                                $Icon = '<svg width="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(270)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M21 13.5C21 18.4706 16.9706 22.5 12 22.5C7.02944 22.5 3 18.4706 3 13.5C3 10.796 4.40858 8.44449 5.97593 6.65272C7.55461 4.84799 9.3972 3.49253 10.4939 2.76287C11.411 2.15267 12.589 2.15267 13.5061 2.76287C14.6028 3.49253 16.4454 4.84799 18.0241 6.65272C19.5914 8.44449 21 10.796 21 13.5Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                                break;
                            case 'noIcon':
                                $Icon = '';
                                break;
                        }
    
                        ?>
                        <span class="royal-attribute-title-group-text" style="color:<?= esc_attr($this->royal_attgrp_category_title_text_color) ?>;"><?php echo $Icon . esc_html(get_the_title( $GetCurrentGroupID )) ?> </span>
                    </p>
                </div>
                <div class="royal-group-attributes-item">
                    <?php 
                        foreach ($attrs as $attr) {
                            $this->displayAttributeOptions($attr, $count);
                        }
                    ?>
                </div>
            <?php

        }

        private function displayUngroupedAttributes($ungrouped_attributes, &$count) {

            global $product;

            $Icon = '';
            switch($this->group_attribute_title_icon) {
                case 'icon1':
                    $Icon = '<svg width="15px" viewBox="-2.16 -2.16 28.32 28.32" fill="#1C274C" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                    break;
                case 'icon2':
                    $Icon = '<svg width="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                    break;
                case 'icon3':
                    $Icon = '<svg width="15px" viewBox="0 0 24 24" fill="#1C274C" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <circle cx="12" cy="12" r="10" fill="'. $this->royal_attgrp_category_title_icon_color .'"/> </g></svg>';
                    break;
                case 'icon4':
                    $Icon = '<svg width="15px" viewBox="-2.16 -2.16 28.32 28.32" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M3.46447 3.46447C2 4.92893 2 7.28595 2 12C2 16.714 2 19.0711 3.46447 20.5355C4.92893 22 7.28595 22 12 22C16.714 22 19.0711 22 20.5355 20.5355C22 19.0711 22 16.714 22 12C22 7.28595 22 4.92893 20.5355 3.46447C19.0711 2 16.714 2 12 2C7.28595 2 4.92893 2 3.46447 3.46447ZM9.17157 15.5784C8.75736 15.5784 8.42157 15.2426 8.42157 14.8284L8.42157 10.5858C8.42157 10.1716 8.75736 9.83579 9.17157 9.83578C9.58579 9.83579 9.92157 10.1716 9.92157 10.5858L9.92157 13.0178L14.2981 8.64124C14.591 8.34835 15.0659 8.34835 15.3588 8.64124C15.6517 8.93414 15.6517 9.40901 15.3588 9.7019L10.9822 14.0784H13.4142C13.8284 14.0784 14.1642 14.4142 14.1642 14.8284C14.1642 15.2426 13.8284 15.5784 13.4142 15.5784L9.17157 15.5784Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                    break;
                case 'icon5':
                    $Icon = '<svg width="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(270)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M21 13.5C21 18.4706 16.9706 22.5 12 22.5C7.02944 22.5 3 18.4706 3 13.5C3 10.796 4.40858 8.44449 5.97593 6.65272C7.55461 4.84799 9.3972 3.49253 10.4939 2.76287C11.411 2.15267 12.589 2.15267 13.5061 2.76287C14.6028 3.49253 16.4454 4.84799 18.0241 6.65272C19.5914 8.44449 21 10.796 21 13.5Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                    break;
                case 'noIcon':
                    $Icon = '';
                    break;
            }

            ?>
                <p class="royal-attribute-title-group-heading other-attributes group-title">
                    <span class="royal-attribute-title-group-text" style="color:<?= esc_attr($this->royal_attgrp_category_title_text_color) ?>;"><?= $Icon ?> <?= esc_html($this->royal_attgrp_other_text) ? esc_html($this->royal_attgrp_other_text) : 'سایر ویژگی‌ها' ?> </span>
                </p>
                <div class="royal-group-attributes-item">
                    <?php 
                        foreach ($ungrouped_attributes as $attr) {
                            $this->displayAttributeOptions($attr, $count);
                        }
                        $this->displaycustomAttributes($product, $count);
                        $this->displayWeightAndDimensions($product, $count);

                        
                    ?>
                </div>
            <?php

        }

        private function displayUngroupedAttributesWeightDim(&$count) {

            global $product;

            $weight = $product->get_weight();
            $dimensions = wc_format_dimensions($product->get_dimensions(false));

            if( !empty($dimensions) && !empty($weight) ) {
            
                $Icon = '';
                switch($this->group_attribute_title_icon) {
                    case 'icon1':
                        $Icon = '<svg width="15px" viewBox="-2.16 -2.16 28.32 28.32" fill="#1C274C" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                        break;
                    case 'icon2':
                        $Icon = '<svg width="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                        break;
                    case 'icon3':
                        $Icon = '<svg width="15px" viewBox="0 0 24 24" fill="#1C274C" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <circle cx="12" cy="12" r="10" fill="'. $this->royal_attgrp_category_title_icon_color .'"/> </g></svg>';
                        break;
                    case 'icon4':
                        $Icon = '<svg width="15px" viewBox="-2.16 -2.16 28.32 28.32" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M3.46447 3.46447C2 4.92893 2 7.28595 2 12C2 16.714 2 19.0711 3.46447 20.5355C4.92893 22 7.28595 22 12 22C16.714 22 19.0711 22 20.5355 20.5355C22 19.0711 22 16.714 22 12C22 7.28595 22 4.92893 20.5355 3.46447C19.0711 2 16.714 2 12 2C7.28595 2 4.92893 2 3.46447 3.46447ZM9.17157 15.5784C8.75736 15.5784 8.42157 15.2426 8.42157 14.8284L8.42157 10.5858C8.42157 10.1716 8.75736 9.83579 9.17157 9.83578C9.58579 9.83579 9.92157 10.1716 9.92157 10.5858L9.92157 13.0178L14.2981 8.64124C14.591 8.34835 15.0659 8.34835 15.3588 8.64124C15.6517 8.93414 15.6517 9.40901 15.3588 9.7019L10.9822 14.0784H13.4142C13.8284 14.0784 14.1642 14.4142 14.1642 14.8284C14.1642 15.2426 13.8284 15.5784 13.4142 15.5784L9.17157 15.5784Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                        break;
                    case 'icon5':
                        $Icon = '<svg width="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(270)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M21 13.5C21 18.4706 16.9706 22.5 12 22.5C7.02944 22.5 3 18.4706 3 13.5C3 10.796 4.40858 8.44449 5.97593 6.65272C7.55461 4.84799 9.3972 3.49253 10.4939 2.76287C11.411 2.15267 12.589 2.15267 13.5061 2.76287C14.6028 3.49253 16.4454 4.84799 18.0241 6.65272C19.5914 8.44449 21 10.796 21 13.5Z" fill="'.$this->royal_attgrp_category_title_icon_color.'"/> </g></svg>';
                        break;
                    case 'noIcon':
                        $Icon = '';
                        break;
                }
    
                ?>
                    <p class="royal-attribute-title-group-heading other-attributes group-title">
                        <span class="royal-attribute-title-group-text" style="color:<?= esc_attr($this->royal_attgrp_category_title_text_color) ?>;"><?= $Icon ?> <?= esc_html($this->royal_attgrp_other_text) ? esc_html($this->royal_attgrp_other_text) : 'سایر ویژگی‌ها' ?> </span>
                    </p>
                    <div class="royal-group-attributes-item">
                        <?php 
                            $this->displayWeightAndDimensions($product, $count);
                        ?>
                    </div>
                <?php
               
            }

        }

        private function displayAttributeOptions($attr, &$count) {

            global $wpdb;

            $options        = $attr->get_options();
            $attr_id        = $attr->get_id();

            $option_names   = [];
            $public_link    = true;

            $table_name_posts = $wpdb->prefix . 'woocommerce_attribute_taxonomies';
            $query = " SELECT * FROM $table_name_posts WHERE attribute_id = '$attr_id' ";
            $results = $wpdb->get_results($query);
            
            foreach ( $results as $attr_public ) {
                if( $attr_public->attribute_public == 0 ) {
                    $public_link = false;
                }
            }

            $style_color = $this->royal_attgrp_variable_text_color;
            $seperator = ($this->royal_attgrp_variable_display_style == 'next') ? 'attribute-inline' : 'attribute-below';
            $remove_style_color = ($seperator == 'attribute-inline') ? '' : $style_color;

            foreach ($options as $option) {

                $term = get_term_by('id', $option, $attr->get_taxonomy());
                if ($term) {
                    $attribute_type = get_term_meta($term->term_id, '_fusion', true);
                    $option_names[] = $this->getAttributesNamesHtml($public_link, $term, $attribute_type, $remove_style_color);
                }

            }

            $this->displayAttributeOptionNames($attr, $option_names, $seperator, $count); 
            
        }

        private function getAttributesNamesHtml($public_link, $term, $attribute_type, $style_color) {

            if( $public_link == true ) {

                $term_link = get_term_link($term);
                $html ='<span><a '. $style_color .' href="'. $term_link .'" target="_blank">' . esc_html($term->name) . '</a></span>';

            }else {

                $html = '<span>' . esc_html($term->name) . '</span>';

            }

            if (!empty($attribute_type)) {

                if (isset($attribute_type['attribute_color'])) {
                    return $this->getColorOptionHtml($term, $attribute_type['attribute_color'], $style_color);
                } elseif (isset($attribute_type['attribute_image'])) {
                    return $this->getImageOptionHtml($term, $attribute_type['attribute_image'], $style_color);
                } elseif (isset($attribute_type['attribute_button'])) {
                    return $this->getButtonOptionHtml($term, $attribute_type['attribute_button'], $style_color);
                }

            }

            return $html;

        }

        private function getColorOptionHtml($term, $color_value, $style_color) {

            $background_color_code = esc_attr($color_value);
            $Get_Term_Name = esc_html($term->name);
            
            if( $style_color != '' ) {
                $style_color_attr = "style='color:$style_color;'";
            }else {
                $style_color_attr = '';
            }
            
            switch ( $this->group_attr_color_display ) {
                case 'circle_text':
                    return "<span class='royal-attribute-group-style royal-attribute-color' $style_color_attr>
                                <span class='royal-color-column-preview' style='background-color: $background_color_code;width: 25px;height: 25px;border-radius: 20px; display: inline-block;'></span>
                                <span class='royal-color-attribute-name' style='margin-right: 5px;'> $Get_Term_Name </span>
                            </span>";
                break;
            
                case 'circle':
                    return "<span class='royal-attribute-group-style royal-attribute-color' $style_color_attr>
                                <span class='royal-color-column-preview' style='background-color: $background_color_code;width: 25px;height: 25px;border-radius: 20px; display: inline-block;'></span>
                            </span>";
                break;
            
                case 'text':
                    return "<span class='royal-attribute-group-style royal-attribute-color' $style_color_attr>
                                <span class='royal-color-attribute-name' style='margin-right: 5px;'> $Get_Term_Name </span>
                            </span>";
                break;

            }

        }

        private function getImageOptionHtml($term, $image_url, $style_color) {

            $ImageUrl = esc_url($image_url['url']);
            $TermName = esc_attr($term->name);

            switch ( $this->group_attr_image_display ) {
                case 'img_text':
                    return "<span class='royal-attribute-group-style royal-attribute-image' style='color:$style_color ;'>
                                <span class='royal-image-attribute' style='width: auto;max-height: 27px;height: 27px;display: flex;align-items: center;'>
                                    <img src='$ImageUrl' alt='$TermName' style='width: auto;height: 100%;display: block;'/>
                                    <span class='royal-color-attribute-name' style='margin-right: 5px;'> $TermName </span>
                                </span>
                            </span>";
                break;
            
                case 'img':
                    return "<span class='royal-attribute-group-style royal-attribute-image' style='color:$style_color ;'>
                                <span class='royal-image-attribute' style='width: auto;max-height: 27px;height: 27px;display: flex;align-items: center;'>
                                    <img src='$ImageUrl' alt='$TermName' style='width: auto;height: 100%;display: block;'/>
                                </span>
                            </span>";
                break;
            
                case 'text':
                    return "<span class='royal-attribute-group-style royal-attribute-image' style='color:$style_color ;'>
                                <span class='royal-image-attribute' style='width: auto;max-height: 27px;height: 27px;display: flex;align-items: center;'>
                                    <span class='royal-color-attribute-name'> $TermName </span>
                                </span>
                            </span>";
                break;

            }

        }

        private function getButtonOptionHtml($term, $button_text, $style_color) {

            $btn_text = esc_html($button_text);

            return "<span class='royal-attribute-group-style royal-attribute-button' style='color:$style_color ;'>
                        <span class='royal-button-attribute'><button>$btn_text</button></span>
                    </span>";
        }

        private function displayAttributeOptionNames($attr, $option_names, $seperator, &$count) {

            $style = "style='color:{$this->royal_attgrp_variable_text_color};' ";
            $wrap_style = ($seperator == 'attribute-inline') ? $style : '';
            $is_visible = '';

            $product_id = get_the_ID(); // آی‌دی محصول
            $product_attributes = get_post_meta($product_id, '_product_attributes', true);
            $attribute_slug = $attr->get_name(); // نام اسلاگ ویژگی
            
            if (!empty($product_attributes) && isset($product_attributes[$attribute_slug])) {
                $attribute_data = $product_attributes[$attribute_slug];
                if (!empty($attribute_data['is_visible'])) {
                    $is_visible = 1;
                } else {
                    $is_visible = 0;
                }
            }

            if( $is_visible == 1 ) {

                if ( $count > $this->group_attributes_more_number && $this->royal_attgrp_more_setting == 'yes' ) {

                    ?>
                        <div class="royal-group-attributes-wrap hidden-attribute">
                            <p class="royal-attribute-title-group">
                                <span class="royal-attribute-name" style="color:<?= esc_attr($this->royal_attgrp_variable_title_text_color) ?>;"><?= wc_attribute_label($attr->get_name()) ?> </span>
                            </p>
                            <div class="royal-attribute-group-wrap <?= esc_attr($seperator) ?>" <?= $wrap_style ?> ><?= implode('', $option_names) ?></div>
                        </div>
                    <?php
    
                } else {
                    ?>
                        <div class="royal-group-attributes-wrap">
                            <p class="royal-attribute-title-group">
                                <span class="royal-attribute-name" style="color:<?= esc_attr($this->royal_attgrp_variable_title_text_color) ?>;"><?= wc_attribute_label($attr->get_name()) ?> </span>
                            </p>
                            <div class="royal-attribute-group-wrap <?= esc_attr($seperator) ?>" <?= $wrap_style ?> ><?= implode('', $option_names) ?></div>
                        </div>
                    <?php
                }
                $count++;

            }

        }

        private function displaycustomAttributes($product, &$count) {

            $seperator = ($this->royal_attgrp_variable_display_style == 'next') ? 'attribute-inline' : 'attribute-below';
            $style = "style='color:{$this->royal_attgrp_variable_text_color};'";
            $wrap_style_parent = ($seperator == 'attribute-inline') ? $style : '';
            $wrap_style_span = ($seperator == 'attribute-inline') ? '' : $style;

            $attributes = $product->get_attributes();
            foreach ( $attributes as $attribute ) {

                if ( ! $attribute->is_taxonomy() ) {

                    $custom_attr = '<p class="royal-attribute-title-group">
                                        <span class="royal-attribute-name" style="color:' . esc_attr($this->royal_attgrp_variable_title_text_color) . ';">' . wc_attribute_label( $attribute->get_name() ) . '</span>
                                    </p>
                                    <div class="royal-attribute-group-wrap '.$seperator.'">
                                        <span style="color:' . esc_attr($this->royal_attgrp_variable_text_color) . ';">' . esc_html( implode( ', ', $attribute->get_options() ) ) . '</span>
                                    </div>';

                    if ( $count > $this->group_attributes_more_number && $this->royal_attgrp_more_setting == 'yes') {
                        echo '<div class="royal-group-attributes-wrap hidden-attribute">' . $custom_attr . '</div>';
                    } else {
                        echo '<div class="royal-group-attributes-wrap">' . $custom_attr . '</div>';
                    }
                    $count++;

                }

            }

        }

        private function displayWeightAndDimensions($product, &$count) {
        
            $weight = $product->get_weight();
            $dimensions = wc_format_dimensions($product->get_dimensions(false));

            $seperator = ($this->royal_attgrp_variable_display_style == 'next') ? 'attribute-inline' : 'attribute-below';
            $style = "style='color:{$this->royal_attgrp_variable_text_color};'";
            $wrap_style_parent = ($seperator == 'attribute-inline') ? $style : '';
            $wrap_style_span = ($seperator == 'attribute-inline') ? '' : $style;

            $attributes_html_weight     = '';
            $attributes_html_dimensions = '';
        
            // نمایش وزن اگر موجود باشد
            if ($this->royal_attgrp_display_weight == 'yes' && !empty($weight)) {
                $attributes_html_weight = '<p class="royal-attribute-title-group">
                                                <span class="royal-attribute-name" style="color:' . esc_attr($this->royal_attgrp_variable_title_text_color) . ';">' . __('Weight', 'royal') . '</span>
                                            </p>
                                            <div class="royal-attribute-group-wrap '.$seperator.'">
                                                <span style="color:' . esc_attr($this->royal_attgrp_variable_text_color) . ';">' . esc_html($weight) . ' ' . esc_html(get_option('woocommerce_weight_unit')) . '</span>
                                            </div>';
            }
        
            // بررسی اگر ابعاد واقعاً "NaN" یا مشابه آن باشند، ابعاد را نمایش ندهیم
            if ($this->royal_attgrp_display_dimensions == 'yes' && !empty($dimensions) && strpos($dimensions, 'نامعلوم') === false) {
                $attributes_html_dimensions = '<p class="royal-attribute-title-group">
                                                    <span class="royal-attribute-name" style="color:' . esc_attr($this->royal_attgrp_variable_title_text_color) . '; background-color:' . esc_attr($this->royal_attgrp_variable_background_color) . ';">' . __('Dimensions', 'royal') . '</span>
                                                </p>
                                                <div class="royal-attribute-group-wrap '.$seperator.'">
                                                    <span style="color:' . esc_attr($this->royal_attgrp_variable_text_color) . ';">' . esc_html($dimensions) . '</span>
                                                </div>';
            }
        
            // در صورتی که وزن یا ابعاد وجود داشته باشد، نمایش داده می‌شود
            if ( $attributes_html_weight or $attributes_html_dimensions ) {
                if ($count > $this->group_attributes_more_number && $this->royal_attgrp_more_setting == 'yes') {
                    echo '<div class="royal-group-attributes-wrap hidden-attribute">' . $attributes_html_weight . '</div>';
                    echo '<div class="royal-group-attributes-wrap hidden-attribute">' . $attributes_html_dimensions . '</div>';
                } else {
                    echo '<div class="royal-group-attributes-wrap">' . $attributes_html_weight . '</div>';
                    echo '<div class="royal-group-attributes-wrap">' . $attributes_html_dimensions . '</div>';
                }
                $count++;
            }
        }


    }

}