jQuery(document).ready(function ($) {
	
	$('#btn_royal_import_all').on('click', async function (e) {
		
		e.preventDefault();

		const searchIDs = $('input[name="checkbox_royal_import_all"]:checkbox:checked');

		if (searchIDs.length === 0) {
			alert("لطفاً حداقل یک مورد را انتخاب کنید.");
			return;
		}

		document.getElementById('wp-loading-overlay').style.display = 'block';
		document.getElementById('wacmModalBody').classList.remove('fade-out');

		$("#royal_notices").html('');
		

		const searchIDs2 = [];
        searchIDs2.unshift("step_01_royal_server_config");
         
        searchIDs.each(function () {
          const value = $(this).val();
          searchIDs2.push(value);
        });
    
        searchIDs2.push("step_16_royal_import_change_links");
        
        
		// تابع برای ارسال یک درخواست AJAX به صورت Promise
		function sendRequestAll(value) {
			return $.ajax({
				url: AllImportAjax.ajax_url,
				method: 'POST',
				dataType: 'json',
				data: {
					action: 'royal_all_ajax_handler',
					nonce: AllImportAjax.nonce,
					'royal_all_ajax_token': value
				}
			});
		}
		
		function sendRequestGetMedia() {
			return $.ajax({
				url: AllImportAjax.ajax_url,
				method: 'POST',
				dataType: 'json',
				data: {
					action: 'get_media_urls',
					nonce: AllImportAjax.nonce,
				}
			});
		}
		
		function sendRequestMediaImport(chunks) {
			return $.ajax({
				url: AllImportAjax.ajax_url,
				method: 'POST',
				dataType: 'json',
				data: {
					action: 'import_media_batch',
					nonce: AllImportAjax.nonce,
					images: chunks
				},
			});
		}

		// اجرای درخواست‌ها به صورت پشت سر هم
		for (const value of searchIDs2) {
			try {
				
				if('step_03_royal_import_media' == value) {
				
					const res = await sendRequestGetMedia();
				 
					if (res.success) {
						
						const allImages = res.data;
						 
						const size = 10
						for (let i = 0; i < allImages.length; i += size) {
							
							let chunks = allImages.slice(i, i + size);
							 
							const res = await sendRequestMediaImport(chunks);
					
							if (res.success) {
								$( "#royal_notices" ).append( '<div class="notice notice-success is-dismissible"><p>✔️ درون ریزی عکس ' + (i+1) + ' تا ' + (i+10) + ' موفق </p></div>' );
								console.log(`✔️ دسته ${i + 1} موفق`, res.data);
							} else {
								console.error(`❌ دسته ${i + 1} شکست خورد:`, res.data);
							}
						}
						
					} else {
						console.error("❌ دریافت URLها ناموفق:", res.data);
					}
					
				} else {
					
					const res = await sendRequestAll(value);
					
					if (res.success) {
						
						console.log(res.data);
						
						$("#royal_notices").append('<div class="notice notice-success is-dismissible"><p>' + res.data + '</p></div>');
						
					} else {
						console.error("❌ ارتباط با سرور ناموفق بود 123:", res.data);
					}
				}
				 
			} catch (xhr) {
				console.error("❌ ارتباط با سرور ناموفق بود 1234 :", xhr);
			}
		}

		document.querySelector('.wacm-box-warning-setting').style.display = 'block';
						
		document.getElementById('wp-loading-overlay').style.display = 'none';
		document.getElementById('royalModalOverlay').style.display = 'none';
	});
 
	$('#wacmMaintenanceModeToggle').on('click', async function (e) {
		 
		function MaintenanceModeToggle() {
			return $.ajax({
				url: AllImportAjax.ajax_url,
				method: 'POST',
				dataType: 'json',
				data: {
					action: 'royal_all_ajax_handler',
					nonce: AllImportAjax.nonce,
					'royal_all_ajax_token': 'maintenance_toggle'
				}
			});
		}
		
		const res = await MaintenanceModeToggle();
		
		if (res.success) {		 
			$("#wacmMaintenanceModeToggle input").prop("checked", !res.data);
		} else {
			console.error("❌ ارتباط با سرور ناموفق بود 12345:", res.data);
		}
	});

	$('#wacmCloseBtn').on('click', async function (e) {
		
		e.preventDefault();
		document.querySelector('.save_button_action_bottom').style.display = 'flex';  
		document.getElementById('royalModalOverlay').style.display = 'none';
	});
});
