<?php 

add_action('wp_ajax_royal_all_ajax_handler', 'royal_all_ajax_handler_call');
add_action('wp_ajax_nopriv_royal_all_ajax_handler', 'royal_all_ajax_handler_call');
function royal_all_ajax_handler_call() {
	
	$token = $_POST['royal_all_ajax_token'];

	switch ($token) {

		case 'step_01_royal_server_config':
			step_01_royal_server_config();
			break;
			
		case 'step_02_royal_remove_pages':
			step_02_royal_remove_pages();
			break;
			
		case 'step_04_royal_import_pages':
			step_04_royal_import_pages();
			break;
			
		case 'step_05_royal_import_theme_option':
			step_05_royal_import_theme_option();
			break;
			
		case 'step_06_royal_import_menus':
			step_06_royal_import_menus();
			break;
			
		case 'step_07_royal_import_library':
			step_07_royal_import_library();
			break;
			
		case 'step_08_royal_import_icons':
			step_08_royal_import_icons();
			break;
			
		case 'step_09_royal_import_forms':
			step_09_royal_import_forms();
			break;
			
		case 'step_10_royal_import_layouts':
			step_10_royal_import_layouts();
			break;
			
		case 'step_11_royal_import_sections':
			step_11_royal_import_sections();
			break;
			
		case 'step_12_royal_import_convas':
			step_12_royal_import_convas();
			break;
			
		case 'step_13_royal_import_product_filter':
			step_13_royal_import_product_filter();
			break;
			
		case 'step_14_royal_import_setting':
			step_14_royal_import_setting();
			break;
			
		case 'step_15_royal_import_woo_my_account':
			step_15_royal_import_woo_my_account();
			break;
			
		case 'step_16_royal_import_change_links':
			step_16_royal_import_change_links();
			break;
			
		case 'step_17_royal_import_product_subtitle':
			step_17_royal_import_product_subtitle();
			break;
			
		case 'step_20_royal_import_lang':
			step_20_royal_import_lang();
			break;
			
		case 'step_21_royal_install_plugins':
			step_21_royal_install_plugins();
			break;
			
		case 'maintenance_toggle':
			maintenance_toggle();
			break;
	}
}
 
function step_00_download_json($token) { //

	$url_pre = 'https://iranavada.com/wp-content/updater/royal-importer/demo-data/';
	
	$json_data['step_04_royal_import_pages']		= $url_pre . '004-royal-pages.xml';
	$json_data['step_05_royal_import_option']		= $url_pre . '005-royal-theme-option.json';
	$json_data['step_06_royal_import_menus']		= $url_pre . '006-royal-menus.xml';
	$json_data['step_07_royal_import_library']		= $url_pre . '007-royal-library.xml';
	$json_data['step_08_royal_import_icons']		= $url_pre . '008-royal-icons.xml';
	$json_data['step_09_royal_import_forms']		= $url_pre . '009-royal-forms.xml';
	$json_data['step_10_royal_import_layouts']		= $url_pre . '010-royal-builder-layout.xml';
	$json_data['step_11_royal_import_sections']		= $url_pre . '011-royal-builder-section.xml';
	$json_data['step_12_royal_import_convas']		= $url_pre . '012-royal-convas.xml';

	$json_data['step_14_royal_import_setting']		= $url_pre . '014-wp-rocket-settings.json';
// 	$json_data['step_15_royal_import_account']		= $url_pre . '015-royal-my-account-builder.xml';
	$json_data['step_15_royal_import_account']		= $url_pre . '015-royal-my-account.json';

	$json_data['step_13_royal_import_f_autoload']	= $url_pre . '013-prdctfltr_autoload.json';
	$json_data['step_13_royal_import_f_default']	= $url_pre . '013-prdctfltr_preset_default.json';
	$json_data['step_13_royal_import_f_mobile']		= $url_pre . '013-prdctfltr_preset_mobile-filter.json';
	$json_data['step_13_royal_import_f_side']		= $url_pre . '013-prdctfltr_preset_side-filter-round.json';
	$json_data['step_13_royal_import_f_top']		= $url_pre . '013-prdctfltr_preset_top-filter.json';
	
	$json_data['get_media_urls_from_xml']			= $url_pre . 'royal-media.xml';
 
	if(!empty($json_data['step_04_royal_import_pages'])) {
		
		return royal_download_and_save_file_from_url($json_data[$token]);
	}
	
	return '';
}
		
function step_01_royal_server_config() { // Royal Server Config
    
	// 1. Add rules to .htaccess if they don't exist
	$htaccess_file = ABSPATH . '.htaccess';
	$htaccess_rules = [
		'# Start IranAvada',
		'php_value max_input_vars 20000',
		'php_value max_input_time 800',
		'php_value post_max_size 500M',
		'php_value memory_limit 2048M',
		'php_value max_execution_time 1000',
		'# END IranAvada'
	];

	if (file_exists($htaccess_file)) {
		$htaccess_content = file_get_contents($htaccess_file);
		foreach ($htaccess_rules as $rule) {
			if (strpos($htaccess_content, $rule) === false) {
				// Add rule only if it doesn't already exist
				file_put_contents($htaccess_file, PHP_EOL . $rule, FILE_APPEND);
			}
		}
	} else {
		// If .htaccess doesn't exist, create it with the rules
		file_put_contents($htaccess_file, implode(PHP_EOL, $htaccess_rules) . PHP_EOL);
	}

	// 2. Add rules to .user.ini if they don't exist
	$user_ini_file = ABSPATH . '.user.ini';
	$user_ini_rules = [
		'; Start IranAvada',
		'max_input_vars = 20000',
		'max_input_time = 800',
		'post_max_size = 1G',
		'memory_limit = 2G',
		'max_execution_time = 1000',
		'upload_max_filesize = 500M',
		'output_buffering = on',
		'; END IranAvada'
	];

	if (file_exists($user_ini_file)) {
		$user_ini_content = file_get_contents($user_ini_file);
		foreach ($user_ini_rules as $rule) {
			if (strpos($user_ini_content, $rule) === false) {
				// Add rule only if it doesn't already exist
				file_put_contents($user_ini_file, PHP_EOL . $rule, FILE_APPEND);
			}
		}
	} else {
		// If .user.ini doesn't exist, create it with the rules
		file_put_contents($user_ini_file, implode(PHP_EOL, $user_ini_rules) . PHP_EOL);
	}

	// 3. Add @ini_set and set_time_limit to wp-config.php if they don't exist
	$wp_config_file = ABSPATH . 'wp-config.php';
	$wp_config_rules = [
		"// Start IranAvada",
		"@ini_set( 'max_input_vars', 20000 );",
		'set_time_limit(800);',
		"// END IranAvada"
	];
 
	if (file_exists($wp_config_file)) {
		$wp_config_content = file_get_contents($wp_config_file);
		foreach ($wp_config_rules as $rule) {
			if (strpos($wp_config_content, $rule) === false) {
				// Add rule only if it doesn't already exist
				file_put_contents($wp_config_file, PHP_EOL . $rule, FILE_APPEND);
			}
		}
	}
	
	wp_send_json_success('تنظیمات اولیه جهت درون ریزی ست شد.');
}

function step_02_royal_remove_pages() { // تابع برای حذف برگه‌های ووکامرس

	// شناسه برگه‌های ووکامرس
	$page_ids = array(
		get_option('woocommerce_cart_page_id'),
		get_option('woocommerce_checkout_page_id'),
		get_option('woocommerce_myaccount_page_id'),
		get_option('woocommerce_shop_page_id')
	);

	// حذف برگه‌ها
	foreach ($page_ids as $page_id) {
		if ($page_id) {
			wp_delete_post($page_id, true); // حذف برگه با force delete
		}
	}
	
	// wp_send_json_success('برگه‌های ووکامرس با موفقیت حذف شدند.');
}

function step_04_royal_import_pages() { // Include Royal Pages
   
	step_02_royal_remove_pages();
 
	include RMSPROGRESSFILES . '/004-royal-pages.php';
 
	$Royal_home_page = get_page_by_title( 'صفحه اصلی رویال جدید' );
	update_option( 'page_on_front', $Royal_home_page->ID );
	update_option( 'show_on_front', 'page' );

	$save_pages_imported = update_option( 'irava_royal_pages' , 'imported' );
	if( $save_pages_imported = true ) {
		wp_send_json_success('برگه‌ها با موفقیت درون ریزی شد.');
	}
	
	// wp_send_json_success('گام های قبلی بررسی شود');
}

function step_05_royal_import_theme_option() { // Royal Theme Option Section

	global $wpdb;
	
	include RMSPROGRESSFILES . '/005-royal-theme-option.php';

	// $royal_option_panel_setting = 'a:31:{s:24:"royal_mobile_theme_color";s:7:"#00c095";s:21:"show_more_cover_color";s:7:"#f0f5f8";s:33:"cart_calculate_price_display_text";s:7:"1000000";s:19:"variable_color_name";s:3:"yes";s:29:"product_single_ajax_addtocart";s:3:"yes";s:31:"royal_woo_cart_page_form_option";s:2:"no";s:32:"not_show_main_price_var_products";s:2:"no";s:22:"overlay_hover_megamenu";s:3:"yes";s:30:"product_attr_back_color_circle";s:3:"yes";s:28:"display_color_attribute_name";s:3:"yes";s:23:"display_image_attribute";s:3:"yes";s:28:"display_image_attribute_name";s:3:"yes";s:33:"iravada_royal_disable_compare_bar";s:3:"yes";s:25:"disable_woocommerce_admin";s:3:"yes";s:21:"disable_marketing_hub";s:3:"yes";s:33:"disconnect_request_to_woocommerce";s:3:"yes";s:38:"disable_load_woocommerce_style_scripts";s:3:"yes";s:34:"disable_woocommerce_status_metabox";s:3:"yes";s:31:"disable_marketplace_suggestions";s:3:"yes";s:30:"disable_woocommerce_addon_menu";s:3:"yes";s:25:"disable_password_Strength";s:3:"yes";s:22:"disable_cart_fragments";s:3:"yes";s:26:"disable_woocommerce_blocks";s:3:"yes";s:33:"royal_on_off_classic_widgets_area";s:3:"yes";s:15:"wishlist_status";s:3:"yes";s:13:"wishlist_page";s:2:"31";s:15:"readmore_status";s:3:"yes";s:18:"royal_brand_status";s:3:"yes";s:23:"royal_custom_brand_slug";s:0:"";s:20:"royal_compare_status";s:3:"yes";s:12:"compare_page";s:3:"916";}';
	// $royal_option_panel_setting_saved = update_option( 'royal_option_settings', $royal_option_panel_setting );
  
	$save_theme_option_imported = update_option( 'irava_royal_theme_option' , 'imported' );
	if( $save_theme_option_imported = true ) {
		wp_send_json_success('تنظیمات قالب با موفقیت درون ریزی شد.');
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}
 
function step_06_royal_import_menus() { // Import Menu Settings
 
	global $wpdb;
	
	include RMSPROGRESSFILES . '/006-royal-menu.php';
	
	$table_name = $wpdb->prefix . 'posts';  // Get Table Name
	$get_menu_item_id = $wpdb->get_results("SELECT * FROM $table_name WHERE post_type = 'nav_menu_item';");
	
	foreach( $get_menu_item_id as $id ) {

		$get_menu_item_id = $id->ID;
		$get_menu_title	  = $id->post_title;

		// Left Main Menu -> Royal Left Menus
		if( $get_menu_title == 'علاقمندی‌ها' ) {
			
			$wishlist_options    = unserialize('a:23:{s:5:"style";s:0:"";s:6:"select";s:1:"0";s:4:"icon";s:12:"fa-heart far";s:8:"icononly";s:8:"icononly";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:0:"";s:21:"highlight_label_color";s:0:"";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:0:"";s:21:"show_woo_cart_counter";s:0:"";s:27:"show_empty_woo_cart_counter";s:0:"";s:20:"cart_counter_display";s:0:"";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:13:"off_canvas_id";s:0:"";s:6:"status";s:0:"";s:5:"width";s:0:"";s:7:"columns";s:4:"auto";s:11:"columnwidth";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";s:16:"background_image";s:0:"";}');
			$update_menu_options = update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $wishlist_options );

		}
		if( $get_menu_title == 'تخفیف ویژه' ) {
													
			$offer_menu_options     = unserialize('a:23:{s:5:"style";s:0:"";s:4:"icon";s:36:"fusion-prefix-iravaadmicon-stopwatch";s:8:"icononly";s:0:"";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:0:"";s:21:"highlight_label_color";s:0:"";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:0:"";s:21:"show_woo_cart_counter";s:0:"";s:27:"show_empty_woo_cart_counter";s:0:"";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:6:"status";s:0:"";s:5:"width";s:0:"";s:7:"columns";s:4:"auto";s:11:"columnwidth";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";s:16:"background_image";s:0:"";s:20:"cart_counter_display";s:0:"";s:6:"select";s:1:"0";s:13:"off_canvas_id";s:0:"";}');
			$update_menu_options 	= update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $offer_menu_options );

		}

		// Header Cart Menu
		if( $get_menu_title == 'سبد هدر' ) {
													
			$mobile_cart_options    = unserialize('a:23:{s:5:"style";s:0:"";s:4:"icon";s:39:"fusion-prefix-iravaadmicon-royal-icon-b";s:8:"icononly";s:8:"icononly";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:17:"var(--awb-color1)";s:21:"highlight_label_color";s:7:"#ffffff";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:15:"fusion-woo-cart";s:21:"show_woo_cart_counter";s:3:"yes";s:27:"show_empty_woo_cart_counter";s:2:"no";s:22:"show_woo_cart_contents";s:2:"no";s:15:"searchform_mode";s:0:"";s:6:"status";s:0:"";s:5:"width";s:0:"";s:7:"columns";s:4:"auto";s:11:"columnwidth";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";s:16:"background_image";s:0:"";s:20:"cart_counter_display";s:6:"inline";s:13:"off_canvas_id";s:4:"4613";s:6:"select";s:1:"0";}');
			$update_menu_options 	= update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $mobile_cart_options );

		}

		// Footer Cart Menu
		if( $get_menu_title == 'سبد' ) {
													
			$header_cart_options    = unserialize('a:23:{s:5:"style";s:0:"";s:4:"icon";s:39:"fusion-prefix-iravaadmicon-royal-icon-b";s:8:"icononly";s:0:"";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:17:"var(--awb-color1)";s:21:"highlight_label_color";s:7:"#ffffff";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:15:"fusion-woo-cart";s:21:"show_woo_cart_counter";s:3:"yes";s:27:"show_empty_woo_cart_counter";s:3:"yes";s:20:"cart_counter_display";s:6:"inline";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:6:"status";s:0:"";s:5:"width";s:0:"";s:7:"columns";s:4:"auto";s:11:"columnwidth";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";s:16:"background_image";s:0:"";s:13:"off_canvas_id";s:4:"4613";s:6:"select";s:1:"0";}');
			$update_menu_options 	= update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $header_cart_options );

		}

		// Blog Menu
		if( $get_menu_title == 'بازگشت به فروشگاه' ) {
													
			$return_to_shop_menu_options    = unserialize('a:23:{s:5:"style";s:20:"fusion-button-medium";s:6:"select";s:1:"0";s:4:"icon";s:19:"fa-shopping-bag fas";s:8:"icononly";s:0:"";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:0:"";s:21:"highlight_label_color";s:0:"";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:0:"";s:21:"show_woo_cart_counter";s:0:"";s:27:"show_empty_woo_cart_counter";s:0:"";s:20:"cart_counter_display";s:0:"";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:13:"off_canvas_id";s:0:"";s:6:"status";s:0:"";s:5:"width";s:0:"";s:7:"columns";s:4:"auto";s:11:"columnwidth";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";s:16:"background_image";s:0:"";}');
			$update_menu_options			= update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $return_to_shop_menu_options );

		}
		if( $get_menu_title == 'آرشیو وبلاگ' ) {
													
			$blog_archive_menu_options    = unserialize('a:18:{s:5:"style";s:0:"";s:6:"select";s:4:"5064";s:4:"icon";s:11:"fa-bars fas";s:8:"icononly";s:0:"";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:0:"";s:21:"highlight_label_color";s:0:"";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:0:"";s:21:"show_woo_cart_counter";s:0:"";s:27:"show_empty_woo_cart_counter";s:0:"";s:20:"cart_counter_display";s:0:"";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:13:"off_canvas_id";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";}');
			$update_menu_options 		  = update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $blog_archive_menu_options );

		}
		if( $get_menu_title == 'پایگاه دانش رویال' ) {
													
			$blog_two_menu_options    = unserialize('a:18:{s:5:"style";s:0:"";s:6:"select";s:1:"0";s:4:"icon";s:0:"";s:8:"icononly";s:0:"";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:0:"";s:21:"highlight_label_color";s:0:"";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:0:"";s:21:"show_woo_cart_counter";s:0:"";s:27:"show_empty_woo_cart_counter";s:0:"";s:20:"cart_counter_display";s:0:"";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:13:"off_canvas_id";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";}');
			$update_menu_options 	  = update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $blog_two_menu_options );

		}
		if( $get_menu_title == 'جستجو' ) {
													
			$search_menu_options    = unserialize('a:23:{s:5:"style";s:0:"";s:4:"icon";s:13:"fa-search fas";s:8:"icononly";s:8:"icononly";s:5:"modal";s:16:"blogsearch_modal";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:0:"";s:21:"highlight_label_color";s:0:"";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:0:"";s:21:"show_woo_cart_counter";s:0:"";s:27:"show_empty_woo_cart_counter";s:0:"";s:20:"cart_counter_display";s:0:"";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:6:"status";s:0:"";s:5:"width";s:0:"";s:7:"columns";s:4:"auto";s:11:"columnwidth";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";s:16:"background_image";s:0:"";s:6:"select";s:1:"0";s:13:"off_canvas_id";s:0:"";}');
			$update_menu_options 	= update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $search_menu_options );

		}

		// Main Menu Setting -> Mega Menu Setting Import
		if( $get_menu_title == 'کالای دیجیتال' ) {
													
			$blog_archive_menu_options    = unserialize('a:23:{s:5:"style";s:0:"";s:6:"select";s:4:"5102";s:4:"icon";s:0:"";s:8:"icononly";s:0:"";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:0:"";s:21:"highlight_label_color";s:0:"";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:0:"";s:21:"show_woo_cart_counter";s:0:"";s:27:"show_empty_woo_cart_counter";s:0:"";s:20:"cart_counter_display";s:0:"";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:13:"off_canvas_id";s:0:"";s:6:"status";s:0:"";s:5:"width";s:0:"";s:7:"columns";s:4:"auto";s:11:"columnwidth";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";s:16:"background_image";s:0:"";}');
			$update_menu_options 		  = update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $blog_archive_menu_options );

		}
		if( $get_menu_title == 'مد و پوشاک' ) {
													
			$blog_two_menu_options    = unserialize('a:23:{s:5:"style";s:0:"";s:4:"icon";s:0:"";s:8:"icononly";s:0:"";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:0:"";s:21:"highlight_label_color";s:0:"";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:0:"";s:21:"show_woo_cart_counter";s:0:"";s:27:"show_empty_woo_cart_counter";s:0:"";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:6:"status";s:7:"enabled";s:5:"width";s:9:"fullwidth";s:7:"columns";s:4:"auto";s:11:"columnwidth";s:0:"";s:9:"thumbnail";s:0:"";s:12:"thumbnail_id";s:0:"";s:16:"background_image";s:0:"";s:20:"cart_counter_display";s:0:"";s:13:"off_canvas_id";s:0:"";s:6:"select";s:4:"4950";}');
			$update_menu_options 	  = update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $blog_two_menu_options );

		}
		if( $get_menu_title == 'دسته‌بندی کالاها' ) {
													
			$search_menu_options    = unserialize('a:16:{s:5:"style";s:0:"";s:6:"select";s:4:"5191";s:4:"icon";s:11:"fa-bars fas";s:8:"icononly";s:0:"";s:5:"modal";s:0:"";s:15:"highlight_label";s:0:"";s:26:"highlight_label_background";s:0:"";s:21:"highlight_label_color";s:0:"";s:28:"highlight_label_border_color";s:0:"";s:12:"special_link";s:0:"";s:21:"show_woo_cart_counter";s:0:"";s:27:"show_empty_woo_cart_counter";s:0:"";s:20:"cart_counter_display";s:0:"";s:22:"show_woo_cart_contents";s:0:"";s:15:"searchform_mode";s:0:"";s:13:"off_canvas_id";s:0:"";}');
			$update_menu_options 	= update_post_meta( $get_menu_item_id, '_menu_item_fusion_megamenu', $search_menu_options );

		}

	}// End Foreach

	$save_import_action =  update_option( 'irava_royal_menus' , 'imported' );
	if( $save_import_action = true and $update_menu_options = true ) {
		wp_send_json_success('منوها با موفقیت درون ریزی شد.');
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}

function step_07_royal_import_library() { // Load Royal Library
 
	include RMSPROGRESSFILES . '/007-royal-library.php';
 
	$save_library_imported = update_option( 'irava_royal_library' , 'imported' );
	if( $save_library_imported = true ) {
		wp_send_json_success('کتابخانه با موفقیت درون ریزی شد.');
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}

function step_08_royal_import_icons() { // Load Royal Icons
	
	include RMSPROGRESSFILES . '/008-royal-icons.php';

	$save_icon_imported = update_option( 'irava_royal_icons' , 'imported' );
	if( $save_icon_imported = true ) {
		wp_send_json_success('آیکون‌ها با موفقیت درون ریزی شد.');
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}

function step_09_royal_import_forms() { // Load Royal Forms

	include RMSPROGRESSFILES . '/009-royal-forms.php';

	$save_forms_imported = update_option( 'irava_royal_forms' , 'imported' );
	if( $save_forms_imported = true ) {
		wp_send_json_success('فرم‌ها با موفقیت درون ریزی شد.');
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}

function step_10_royal_import_layouts() { // Load Royal Layout
 
	include RMSPROGRESSFILES . '/010-royal-layout.php';
 
	$save_section_imported = update_option( 'irava_royal_layouts' , 'imported' );
	if( $save_section_imported = true ) {
		wp_send_json_success('قالب‌های طراحی شده با موفقیت درون ریزی شد.');
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}

function step_11_royal_import_sections() { // Load Royal Section

	include RMSPROGRESSFILES . '/011-royal-section.php';

	if( $run_import_layout = true ) {

		$save_layout_imported = update_option( 'irava_royal_section' , 'imported' );
		if( $save_layout_imported = true ) {
			wp_send_json_success('سکشن‌های قالب ساز و شرط‌ها با موفقیت درون ریزی شد.');
		}
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
} 

function step_12_royal_import_convas() { // Load Royal Canvas
 
	global $wpdb;
	
	include RMSPROGRESSFILES . '/012-royal-convas.php';
 
	$save_convas_imported =  update_option( 'irava_royal_canvas' , 'imported' );
	$table_name = $wpdb->prefix . 'posts';  // Get Table Name
	$get_canvas_uniq_id = $wpdb->get_results(" SELECT * FROM $table_name ");

	foreach( $get_canvas_uniq_id as $canvas_data ) {

		// Import Mobile Menu Setting ==> Canvas Mobile Menu
		if( $canvas_data->post_title == 'محتوای منوی موبایل' ) {

			$canvas_options_mobile_menu     = unserialize('a:72:{s:4:"type";s:11:"sliding-bar";s:16:"off_canvas_state";s:6:"closed";s:8:"position";s:5:"right";s:10:"transition";s:7:"overlap";s:5:"width";s:5:"300px";s:26:"horizontal_position_medium";s:6:"center";s:25:"horizontal_position_small";s:6:"center";s:19:"horizontal_position";s:10:"flex-start";s:24:"vertical_position_medium";s:6:"center";s:23:"vertical_position_small";s:6:"center";s:17:"vertical_position";s:10:"flex-start";s:14:"content_layout";s:6:"column";s:13:"align_content";s:10:"flex-start";s:14:"valign_content";s:10:"flex-start";s:12:"content_wrap";s:4:"wrap";s:9:"css_class";s:19:"royal-mobile-canvas";s:16:"background_color";s:7:"#ffffff";s:22:"background_custom_size";a:2:{s:5:"width";s:0:"";s:6:"height";s:0:"";}s:13:"border_radius";a:4:{s:8:"top_left";s:0:"";s:9:"top_right";s:0:"";s:12:"bottom_right";s:0:"";s:11:"bottom_left";s:0:"";}s:12:"border_width";a:4:{s:3:"top";s:0:"";s:5:"right";s:0:"";s:6:"bottom";s:0:"";s:4:"left";s:0:"";}s:6:"margin";a:4:{s:3:"top";s:0:"";s:5:"right";s:0:"";s:6:"bottom";s:0:"";s:4:"left";s:0:"";}s:7:"padding";a:4:{s:3:"top";s:2:"15";s:5:"right";s:0:"";s:6:"bottom";s:0:"";s:4:"left";s:0:"";}s:10:"box_shadow";s:2:"no";s:19:"box_shadow_position";a:2:{s:8:"vertical";s:0:"";s:10:"horizontal";s:0:"";}s:7:"overlay";s:3:"yes";s:22:"overlay_page_scrollbar";s:3:"yes";s:24:"overlay_background_color";s:15:"rgba(0,0,0,0.7)";s:30:"overlay_background_custom_size";a:2:{s:5:"width";s:0:"";s:6:"height";s:0:"";}s:22:"overlay_close_on_click";s:3:"yes";s:12:"close_on_esc";s:3:"yes";s:12:"close_button";s:3:"yes";s:21:"close_button_position";s:5:"right";s:19:"close_button_margin";a:4:{s:3:"top";s:2:"30";s:5:"right";s:4:"105%";s:6:"bottom";s:0:"";s:4:"left";s:0:"";}s:18:"close_button_color";s:7:"#e5e5e5";s:15:"close_icon_size";s:2:"26";s:24:"close_button_custom_icon";s:38:"fusion-prefix-iravaadmicon-cancel-thin";s:24:"sb_enter_animation_speed";s:3:"0.5";s:23:"sb_exit_animation_speed";s:3:"0.5";s:18:"conditions_enabled";s:3:"yes";s:12:"on_page_load";s:2:"no";s:12:"time_on_page";s:2:"no";s:9:"on_scroll";s:2:"no";s:16:"scroll_direction";s:2:"up";s:9:"scroll_to";s:8:"position";s:8:"on_click";s:2:"no";s:11:"exit_intent";s:2:"no";s:16:"after_inactivity";s:2:"no";s:14:"on_add_to_cart";s:2:"no";s:18:"after_x_page_views";s:2:"no";s:16:"after_x_sessions";s:2:"no";s:5:"users";s:3:"all";s:28:"dynamic_content_preview_type";s:7:"default";s:12:"preview_post";s:1:"0";s:12:"preview_page";s:1:"0";s:16:"preview_archives";s:4:"post";s:6:"height";s:4:"full";s:19:"background_position";s:8:"left top";s:17:"background_repeat";s:6:"repeat";s:15:"background_size";s:4:"auto";s:21:"background_blend_mode";s:4:"none";s:27:"overlay_background_position";s:8:"left top";s:25:"overlay_background_repeat";s:6:"repeat";s:23:"overlay_background_size";s:4:"auto";s:29:"overlay_background_blend_mode";s:4:"none";s:15:"enter_animation";s:0:"";s:25:"enter_animation_direction";s:6:"static";s:14:"exit_animation";s:0:"";s:24:"exit_animation_direction";s:6:"static";s:18:"sb_enter_animation";s:10:"slideShort";s:17:"sb_exit_animation";s:10:"slideShort";s:9:"frequency";s:7:"forever";s:6:"device";a:2:{i:0;s:6:"tablet";i:1;s:6:"mobile";}}');
			$update_canvas_options  		= update_post_meta( $canvas_data->ID, '_fusion', $canvas_options_mobile_menu );

		}
		
		// Import Mobile Menu Setting ==> Canvas MiniCart
		if( $canvas_data->post_title == 'افزودن به سبد MiniCart' ) {

			$canvas_options_mini_cart      	= unserialize('a:74:{s:4:"type";s:11:"sliding-bar";s:16:"off_canvas_state";s:6:"closed";s:8:"position";s:4:"left";s:10:"transition";s:7:"overlap";s:5:"width";s:5:"350px";s:26:"horizontal_position_medium";s:6:"center";s:25:"horizontal_position_small";s:6:"center";s:19:"horizontal_position";s:6:"center";s:24:"vertical_position_medium";s:6:"center";s:23:"vertical_position_small";s:6:"center";s:17:"vertical_position";s:6:"center";s:14:"content_layout";s:6:"column";s:13:"align_content";s:10:"flex-start";s:14:"valign_content";s:10:"flex-start";s:12:"content_wrap";s:4:"wrap";s:9:"css_class";s:21:"royal-canvas-minicart";s:22:"background_custom_size";a:2:{s:5:"width";s:0:"";s:6:"height";s:0:"";}s:12:"oc_scrollbar";s:6:"custom";s:25:"oc_scrollbar_handle_color";s:7:"#949ca3";s:13:"border_radius";a:4:{s:8:"top_left";s:0:"";s:9:"top_right";s:0:"";s:12:"bottom_right";s:0:"";s:11:"bottom_left";s:0:"";}s:12:"border_width";a:4:{s:3:"top";s:0:"";s:5:"right";s:3:"1px";s:6:"bottom";s:0:"";s:4:"left";s:0:"";}s:12:"border_color";s:7:"#e8e8e8";s:6:"margin";a:4:{s:3:"top";s:0:"";s:5:"right";s:0:"";s:6:"bottom";s:0:"";s:4:"left";s:0:"";}s:7:"padding";a:4:{s:3:"top";s:4:"60px";s:5:"right";s:0:"";s:6:"bottom";s:0:"";s:4:"left";s:0:"";}s:10:"box_shadow";s:3:"yes";s:19:"box_shadow_position";a:2:{s:8:"vertical";s:1:"0";s:10:"horizontal";s:2:"10";}s:15:"box_shadow_blur";s:1:"5";s:16:"box_shadow_color";s:16:"rgba(0,0,0,0.02)";s:7:"overlay";s:3:"yes";s:22:"overlay_page_scrollbar";s:3:"yes";s:24:"overlay_background_color";s:19:"rgba(255,255,255,0)";s:30:"overlay_background_custom_size";a:2:{s:5:"width";s:0:"";s:6:"height";s:0:"";}s:22:"overlay_close_on_click";s:3:"yes";s:12:"close_on_esc";s:3:"yes";s:12:"close_button";s:3:"yes";s:21:"close_button_position";s:5:"right";s:19:"close_button_margin";a:4:{s:3:"top";s:0:"";s:5:"right";s:0:"";s:6:"bottom";s:0:"";s:4:"left";s:0:"";}s:18:"close_button_color";s:7:"#000000";s:24:"close_button_color_hover";s:16:"rgba(0,0,0,0.71)";s:15:"close_icon_size";s:2:"18";s:18:"conditions_enabled";s:3:"yes";s:12:"on_page_load";s:2:"no";s:12:"time_on_page";s:2:"no";s:9:"on_scroll";s:2:"no";s:16:"scroll_direction";s:2:"up";s:9:"scroll_to";s:8:"position";s:8:"on_click";s:3:"yes";s:16:"on_click_element";s:55:".royal-cart-menu, .mobile-footer-menu .fusion-menu-cart";s:11:"exit_intent";s:2:"no";s:16:"after_inactivity";s:2:"no";s:14:"on_add_to_cart";s:3:"yes";s:18:"after_x_page_views";s:2:"no";s:16:"after_x_sessions";s:2:"no";s:5:"users";s:3:"all";s:28:"dynamic_content_preview_type";s:7:"default";s:12:"preview_post";s:1:"0";s:12:"preview_page";s:1:"0";s:16:"preview_archives";s:4:"post";s:6:"height";s:3:"fit";s:19:"background_position";s:8:"left top";s:17:"background_repeat";s:6:"repeat";s:15:"background_size";s:4:"auto";s:21:"background_blend_mode";s:4:"none";s:27:"overlay_background_position";s:8:"left top";s:25:"overlay_background_repeat";s:6:"repeat";s:23:"overlay_background_size";s:4:"auto";s:29:"overlay_background_blend_mode";s:4:"none";s:15:"enter_animation";s:0:"";s:25:"enter_animation_direction";s:6:"static";s:14:"exit_animation";s:0:"";s:24:"exit_animation_direction";s:6:"static";s:18:"sb_enter_animation";s:10:"slideShort";s:17:"sb_exit_animation";s:10:"slideShort";s:9:"frequency";s:7:"forever";}');
			$update_canvas_options  		= update_post_meta( $canvas_data->ID, '_fusion', $canvas_options_mini_cart );

		}

	}
	if( $save_convas_imported = true && $update_canvas_options = true ) {
		wp_send_json_success('کانواس/پاپ آپ با موفقیت درون ریزی شد.');
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}

function step_13_royal_import_product_filter() { // Royal Product Filter

	// Load Royal Product Filter
	include RMSPROGRESSFILES . '/013-royal-product-filter.php';

	if( $set_product_filter_options = true ) {

		$save_product_filter_imported =  update_option( 'irava_royal_product_filter' , 'imported' );
		if( $save_product_filter_imported = true ) {
			wp_send_json_success('تنظیمات فیلتر محصول با موفقیت درون ریزی شد.');
		}
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}

function step_14_royal_import_setting() { // Royal Rocket Setting

	// Load Royal Rocket
	include RMSPROGRESSFILES . '/014-rocket-setting.php';

	if( $save_rocket_settings_into_database = true ) {

		$save_rocket_imported =  update_option( 'irava_royal_rocket' , 'imported' );
		if( $save_rocket_imported = true ) {
			wp_send_json_success('تنظیمات افزونه راکت با موفقیت درون ریزی شد.');
		}
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}

function step_15_royal_import_woo_my_account() { // Load Royal My Acoount & Thank You
 
	include RMSPROGRESSFILES . '/015-royal-my-account.php';
	
	wp_send_json_success('قالب صفحه حساب کاربری با موفقیت درون ریزی شد.');
	
} 

function step_16_royal_import_change_links() { //

	global $wpdb;
	
	$site_url = site_url();
	
	$table_name_posts = $wpdb->prefix . 'posts';  // Get Table Name
	$table_name_postmeta = $wpdb->prefix . 'postmeta';  // Get Table Name

	$update_link_query_postmeta = $wpdb->query("UPDATE $table_name_postmeta SET meta_value = replace(meta_value, 'https://user.iranavada.ir/new-royal-export','$site_url');");
	$update_link_query_posts_guid = $wpdb->query("UPDATE $table_name_posts SET guid = replace(guid, 'https://user.iranavada.ir/new-royal-export','$site_url');");
	$update_link_query_posts = $wpdb->query("UPDATE $table_name_posts SET post_content = replace(post_content, 'https://user.iranavada.ir/new-royal-export', '$site_url');");

	update_option( 'irava_royal_change_links' , 'imported' );

	if( $update_link_query_posts = true ) {
		wp_send_json_success('آپدیت لینک ها با موفقیت انجام شد.');
	}
	
	wp_send_json_success('گام های قبلی بررسی شود');
}

function step_17_royal_import_product_subtitle() { //

	$pluginList = get_option( 'active_plugins' );
	$plugin = 'wc-product-subtitle/wc-product-subtitle.php'; 
	if ( in_array( $plugin , $pluginList ) ) {
		
		$post_meta_table_name = $wpdb->prefix . 'postmeta';  // Get Table Name
		$post_meta_run_update_query	= " UPDATE $post_meta_table_name SET `meta_key`='iravada_sec_title' WHERE `meta_key`='wc_ps_subtitle' ";

		$run_change_post_meta_query = $wpdb->query( $wpdb->prepare( $post_meta_run_update_query ) );

		if( $run_change_post_meta_query = true ) {

			$update_option_changed_subtitles = update_option( 'irava_royal_subtitle_changed', 'changed' );
			if( $update_option_changed_subtitles = true ) {
				wp_send_json_success('عناوین دوم با موفقیت به رویال انتقال یافت.');
			}
		}
	}
	
	wp_send_json_success('افزونه عنوان دوم غیر فعال است');
}
 
 
function step_20_royal_import_lang() { //
 
	if (!current_user_can('manage_options')) return;
    
    $lang_dir = WP_CONTENT_DIR . '/languages/plugins/';
    if (!file_exists($lang_dir)) {
        wp_mkdir_p($lang_dir);
    }
	
    $base_url = 'https://iranavada.com/wp-content/updater/royal-importer/plugins-languages/';
    $files = [
        'flexible-checkout-fields-fa_IR.mo',
        'flexible-checkout-fields-fa_IR.po',
        'prdctfltr-fa_IR.mo',
        'prdctfltr-fa_IR.po',
        'woocommerce-advbulkedit-fa_IR.mo',
        'woocommerce-advbulkedit-fa_IR.po',
		'woocommerce-fusion-builder-fa_IR.mo',
        'woocommerce-fusion-builder-fa_IR.po',
    ];

    $success = 0;
    foreach ($files as $file) {
        $remote_url = $base_url . $file;
        $response = wp_remote_get($remote_url);

        if (is_wp_error($response) || wp_remote_retrieve_response_code($response) != 200) {
            continue; // فایل پیدا نشد یا خطا داشت
        }

        $save_path = $lang_dir . $file;
        $contents = wp_remote_retrieve_body($response);
        file_put_contents($save_path, $contents);
        $success++;
    }

	if($success>0) {
		wp_send_json_success('فایل زبان با موفقیت کپی شد.');
	}
	
	wp_send_json_success('مشکلی در بروزرسانی فایل های زبان وجود دارد.');
}
  
function step_21_royal_install_plugins() { //
    
    if (!current_user_can('install_plugins')) wp_send_json_success('مشکلی در فرآیند نصب افزونه ها است.');
	if (get_transient('custom_plugins_report')) wp_send_json_success('مشکلی در فرآیند نصب افزونه ها است.');

    require_once ABSPATH . 'wp-admin/includes/file.php';
    require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    require_once ABSPATH . 'wp-admin/includes/plugin.php';

    $remote_base = 'https://iranavada.com/wp-content/updater/royal-importer/plugins/';
    
    // *** نقشه مسیردهی افزونه‌ها ***
    // در این نقشه، نام فایل zip را به مسیر فایل اصلی PHP آن متصل می‌کنیم.
    $plugin_map = [
        'prdctfltr.zip' => 'prdctfltr/prdctfltr.php',
        'WP-Rocket.zip' => 'wp-rocket/wp-rocket.php',
        'woocommerce-page-builder-for-avada.zip' => 'woocommerce-page-builder-for-avada/init.php',
    ];

    $zip_files = array_keys($plugin_map); // لیست فایل‌های zip از کلیدهای نقشه گرفته می‌شود.
    $installed = [];
    $errors    = [];

    foreach ($zip_files as $file_name) {
        $url = $remote_base . $file_name;
        $temp_file = download_url($url, 300);

        if (is_wp_error($temp_file)) {
            $errors[] = "$file_name - دانلود ناموفق بود: " . $temp_file->get_error_message();
            continue;
        }

        $upgrader = new Plugin_Upgrader(new Automatic_Upgrader_Skin());
        $result   = $upgrader->install($temp_file);
        @unlink($temp_file);

        if (is_wp_error($result)) {
            $errors[] = "$file_name - نصب ناموفق بود: " . $result->get_error_message();
            continue;
        }
        
        if ($result === null) {
             $errors[] = "$file_name - نصب انجام نشد. احتمالا افزونه از قبل نصب شده است.";
             continue;
        }

        // *** منطق جدید برای فعال‌سازی با استفاده از نقشه ***
        $plugin_to_activate = $plugin_map[$file_name]; // مسیر را مستقیماً از نقشه بخوان

        if (!is_plugin_active($plugin_to_activate)) {
            $activation = activate_plugin($plugin_to_activate);
            if (is_wp_error($activation)) {
                // این خطا حالا بسیار بعید است، مگر اینکه فایل PHP واقعا وجود نداشته باشد.
                $errors[] = "$file_name - فعال‌سازی ناموفق بود: " . $activation->get_error_message();
            } else {
                $installed[] = $file_name;
            }
        } else {
            $installed[] = $file_name;
        }
    }
 
    set_transient('custom_plugins_report', ['installed' => $installed, 'errors' => $errors], 60);
	
	if(empty($errors)) {
		
		wp_send_json_success('نصب افزونه‌ها موفقت آمیز بود.');
	}
	
	wp_send_json_success(implode('<br>', $errors));
	
    // wp_redirect(remove_query_arg(['import_custom_plugins', '_wpnonce']));
    // exit;
}
 
 
 
 
 
 
 
 
function maintenance_toggle() { // Maintenance Toggle Mode
 
	$is_maintenance_mode = get_option('maintenance_mode_enabled', false);

	if (!$is_maintenance_mode) {
		
		// فعال کردن حالت تعمیر
		update_option('maintenance_mode_enabled', true);
		wp_send_json_success(true);
	}
	
	delete_option('maintenance_mode_enabled');
	wp_send_json_success(false);
}
 
add_action('wp_ajax_get_media_urls', 'get_media_urls_from_xml');
add_action('wp_ajax_nopriv_get_media_urls', 'get_media_urls_from_xml');
function get_media_urls_from_xml() {
   
	check_ajax_referer('import_media_nonce', 'nonce');
 
	$import_data_demo_file = step_00_download_json('get_media_urls_from_xml');
	if(empty($import_data_demo_file)) {
		wp_send_json_error('فایل XML پیدا نشد.');
	}
 
	$xml = simplexml_load_file($import_data_demo_file);
	$namespaces = $xml->getNamespaces(true);
	$items = $xml->channel->item;
	$urls = [];

	foreach ($items as $item) {
		$wp = $item->children($namespaces['wp']);
		if ((string)$wp->post_type === 'attachment') {
			$attachment_url = (string)$wp->attachment_url;
			if ($attachment_url) {
				$urls[] = $attachment_url;
			}
		}
	}

	wp_send_json_success($urls);

}
add_action('wp_ajax_import_media_batch', 'handle_import_media_batch');
add_action('wp_ajax_nopriv_import_media_batch', 'handle_import_media_batch');

function handle_import_media_batch() {
    // امنیت:
    check_ajax_referer('import_media_nonce', 'nonce');

    if (!current_user_can('upload_files')) {
        wp_send_json_error('شما دسترسی ندارید.');
    }

    if (!isset($_POST['images']) || !is_array($_POST['images'])) {
        wp_send_json_error('لیست تصاویر ارسال نشده.');
    }

    require_once ABSPATH . 'wp-admin/includes/image.php';
    require_once ABSPATH . 'wp-admin/includes/file.php';
    require_once ABSPATH . 'wp-admin/includes/media.php';

    $results = [];

    foreach ($_POST['images'] as $url) {
        $tmp = download_url($url);

        if (is_wp_error($tmp)) {
            $results[] = ['url' => $url, 'error' => $tmp->get_error_message()];
            continue;
        }

        $file_array = [
            'name'     => basename($url),
            'tmp_name' => $tmp,
        ];

        // استخراج سال و ماه از URL
        if (preg_match('/\/(\d{4})\/(\d{2})\//', $url, $matches)) {
            $year = $matches[1];
            $month = $matches[2];

            // تعریف فیلتر سفارشی برای تعیین مسیر آپلود
            add_filter('upload_dir', function($dirs) use ($year, $month) {
                $subdir = "/$year/$month";
                $dirs['subdir'] = $subdir;
                $dirs['path'] = $dirs['basedir'] . $subdir;
                $dirs['url'] = $dirs['baseurl'] . $subdir;
                return $dirs;
            });
        }

        $id = media_handle_sideload($file_array, 0);

        // حذف فیلتر بعد از بارگذاری هر فایل
        remove_all_filters('upload_dir');

        if (is_wp_error($id)) {
            @unlink($tmp);
            $results[] = ['url' => $url, 'error' => $id->get_error_message()];
        } else {
            $results[] = ['url' => $url, 'id' => $id];
        }
    }

    update_option('irava_royal_media', 'imported');

    wp_send_json_success($results);
} 