<?php

function royal_download_and_save_file_from_url($url) {
   
    $upload_dir = wp_upload_dir();
    $base_dir = $upload_dir['basedir'] . '/royal-demo-data';
 
    if (!file_exists($base_dir)) {
        wp_mkdir_p($base_dir);
    }
 
    $filename = basename(parse_url($url, PHP_URL_PATH));
 
    $destination = $base_dir . '/' . $filename;
 
    $tmp_file = download_url($url);
 
    if (is_wp_error($tmp_file)) {
        return 'خطا در دانلود فایل: ' . $tmp_file->get_error_message();
    }
 
    $moved = rename($tmp_file, $destination);

    if (!$moved) {
        return 'خطا در انتقال فایل به پوشه royal-demo-data.';
    }

    return $destination;
}