<?php

// نمایش حالت تعمیر برای بازدیدکنندگان غیر مدیر
add_action('template_redirect', 'apply_maintenance_mode');
function apply_maintenance_mode() {
    // بررسی اگر حالت تعمیر فعال است و کاربر مدیر نیست
    if (get_option('maintenance_mode_enabled') && !current_user_can('manage_options')) {
        // ارسال هدر HTTP با کد 503 (Service Unavailable)
        header('HTTP/1.1 503 Service Unavailable');
        header('Retry-After: 3600'); // مدت زمان تا دوباره در دسترس بودن سایت (1 ساعت)

        // پیام تعمیر
        $message = '<h1>سایت در حال بروزرسانی است</h1>';
        $message .= '<h3>بزودی برمی‌گردیم...</h3>';
        $message .= '<p>' . get_bloginfo('description') . '</p>';

        // متوقف کردن نمایش سایر محتواها
        wp_die($message, 'Maintenance Mode', array('response' => 503));
    }
}
