function showToast(message) {
    const toast = document.getElementById("royal_toast");
    toast.querySelector('span').innerText = message;
    toast.className = "show";
    setTimeout(() => {
      toast.className = toast.className.replace("show", "");
    }, 3000);
}

// دریافت لیست صفحات ووکامرس از Localized Data
function loadWooCommercePages(menuID) {
    if (typeof admin_localized_data.myAccountMenus === "undefined") {
        console.error("داده‌های صفحات ووکامرس یافت نشد!");
        return;
    }

    let optionsHtml = "";
    admin_localized_data.myAccountMenus.forEach(page => {
        optionsHtml += `<option value="${page.slug}">${page.label}</option>`;
    });

    // اضافه کردن گزینه‌ها به دراپ‌دان
    jQuery(`#woocommerce_account_page_${menuID}`).html(optionsHtml);

    // مقدار اولیه را تنظیم کن
    let firstSlug = admin_localized_data.myAccountMenus[0].slug;
    jQuery(`#woocommerce_page_slug_${menuID}`).val(firstSlug);
}

jQuery(document).ready(function($) {

    // Set All Color Picker
    $('.royal-myaccount-color-picker').wpColorPicker();

    $(".royal-myaccount-menu:first").addClass("active");

    var firstMenuID = $(".royal-myaccount-menu:first").data("id");
    $(".royal-myaccount-menu-settings[data-id='" + firstMenuID + "']").show();

    $(".add-new-myaccount-menu").click(function () {
        $(".add-menu-section").fadeIn();
        $(".add-new-myaccount-menu").fadeOut();
        $("#new-menu-name").focus();
    });

    // کلیک روی دکمه "افزودن منو"
    $('#submit-new-menu').on('click', function () {

        let menuName = $("#new-menu-name").val().trim();

        if (menuName === "") {
            alert("لطفاً نام منو را وارد کنید!");
            return;
        }
        
        $.ajax({
            url: admin_localized_data.ajax_url,
            type: 'POST',
            data: {
                action: 'insert_menu',
                menuName: menuName,
            },
            beforeSend: function(result) {
                $('.submit-menu-btn').addClass('saving');
            },
            success: function (response) {
                if (response.success && response.data.menuID) {
                    
                    $('.submit-menu-btn').removeClass('saving');
                    
                    var menuID = response.data.menuID;
                    
                    // اضافه کردن منوی جدید به لیست
                    var MenuHtml = `
                    <li class="royal-myaccount-menu" data-id="${menuID}">
                    <span class="menu-title-icon">${response.data.menuName}</span>
                    <button class="delete-menu" data-id="${menuID}"><span style="font-size: 17px;" class="dashicons dashicons-trash"></span> </button>
                    </li>`;
                    
                    $('.royal-myaccount-menus').append(MenuHtml);

                    // حذف پیام از لیست منوها و تنظیمات
                    if ($('#NoMenuDetected').length > 0) {
                        $('#NoMenuDetected').remove(); 
                    }
                    if ($(".royal-setting-content:contains('هیچ منویی یافت نشد')").length > 0) {
                        $(".royal-setting-content:contains('هیچ منویی یافت نشد')").remove();
                    }
                    
                    // مخفی کردن فیلد پس از ارسال موفق
                    $(".add-menu-section").fadeOut();
                    $(".add-new-myaccount-menu").fadeIn();
                    $("#new-menu-name").val("");

                    // حذف کلاس active از تمام منوها و فعال کردن منوی جدید
                    $(".royal-myaccount-menu").removeClass("active");
                    $('.royal-myaccount-menu[data-id="' + menuID + '"]').addClass("active");
                    
                    var selectedIcon = 'dashicons-admin-generic'; // مقدار پیش‌فرض
                
                    loadWooCommercePages(menuID);

                    // اضافه کردن به تنظیمات منوی جدید
                    var menuSettingsHtml = `<span style="padding:15px 10px;">در حال افزودن منو...</span>`;

                    // اول HTML تنظیمات رو اضافه کن
                    $("#save-menu-settings").before(menuSettingsHtml);
                    
                    // بعد، لود صفحات ووکامرس برای select اضافه شده
                    loadWooCommercePages(menuID);
                    
                    // و بعد هم اجرا کردن رویداد change برای ست شدن input readonly
                    setTimeout(() => {
                        $(`#woocommerce_account_page_${menuID}`).trigger("change");
                    }, 100); // زمان کم کافیه
                    
                     // بستن تنظیمات سایر منوها و نمایش تنظیمات منوی جدید
                     $(".royal-myaccount-menu-settings").hide();
                     $(".royal-myaccount-menu-settings[data-id='" + menuID + "']").fadeIn();
                     
                    } else {
                        showToast(response.data.message || 'خطایی رخ داده است!');
                }
                
                window.location.reload();

            },
            error: function () {
                alert('خطای سرور! لطفا دوباره تلاش کنید.');
            }
        });

    });

     // تغییر نام منو در زمان تایپ در بخش تنظیمات و اعمال روی li
    $(document).on('input', 'input[id^="RoyalMyaccountMenuName"]', function () {

        var menuID = $(this).attr('id').replace('RoyalMyaccountMenuName', '');
        var newMenuName = $(this).val();
        
        // فقط متن را تغییر می‌دهیم و آیکون را نگه می‌داریم
        $('.royal-myaccount-menu[data-id="' + menuID + '"] .menu-title-icon').contents().last().replaceWith(` ${newMenuName}`);

    });

    // کلیک روی هر منو برای نمایش تنظیمات آن
    $(document).on('click', '.royal-myaccount-menu', function () {
        $(".royal-myaccount-menu").removeClass("active");
        $(this).addClass("active");

        var menuID = $(this).data("id");
        $(".royal-myaccount-menu-settings").hide();
        $(".royal-myaccount-menu-settings[data-id='" + menuID + "']").fadeIn();
    });

    $(document).on('click', '.delete-menu', function (e) {
    e.stopPropagation();

    var menuID = $(this).data('id');

    $("#confirm-modal").fadeIn();

    $("#confirm-no").off().on('click', function () {
        $("#confirm-modal").fadeOut();
    });

    $("#confirm-yes").off().on('click', function () {
        var $btn = $(this);
        $btn.prop('disabled', true);
        $btn.find('.btn-text').text('در حال حذف...');
        $btn.find('.btn-spinner').show();

        $.ajax({
        url: admin_localized_data.ajax_url,
        type: 'POST',
        data: {
            action: 'delete_menu',
            menuID: menuID
        },
        success: function (response) {
            if (response.success) {
            $('li[data-id="' + menuID + '"]').remove();
            $('.royal-myaccount-menu-settings[data-id="' + menuID + '"]').remove();

            if ($('.royal-myaccount-menu').length === 0) {
                $('.royal-myaccount-menus').append('<li id="NoMenuDetected">هیچ منویی یافت نشد</li>');
                $(".royal-myaccount-menu-settings").hide();
            } else {
                var firstMenuID = $('.royal-myaccount-menu:first').data("id");
                $('.royal-myaccount-menu:first').addClass("active");
                $(".royal-myaccount-menu-settings[data-id='" + firstMenuID + "']").fadeIn();
            }

            $("#confirm-modal").fadeOut();
                showToast('منو با موفقیت حذف شد!');
            } else {
                showToast(response.data.message || 'خطایی رخ داده است!');
            }
        },
        error: function () {
            showToast('خطای سرور! لطفا دوباره تلاش کنید.');
        },
        complete: function () {
            $btn.prop('disabled', false);
            $btn.find('.btn-text').text('حذف');
            $btn.find('.btn-spinner').hide();
        }
        });
    });
    });

    // نمایش تنظیمات هر منو
    $(".royal-myaccount-menu").on("click", function () {
        var menuID = $(this).data("id");

        // مخفی کردن همه محتواها
        $(".royal-myaccount-menu-settings").hide();

        // نمایش محتوای مربوط به منوی انتخاب‌شده
        $(".royal-myaccount-menu-settings[data-id='" + menuID + "']").show();
    });

     // ذخیره تنظیمات در دیتابیس
    $('.myaccount-save-setting-btn').on('click', function () {

        var menuSettings = {};
        var menuName = {};
        var menuSlug = {};
        var menuContent = {};
        var orderAwaitingReview = '';
        var orderCompleted = '';
        var orderAwaitingPayment = '';
        var orderCancelled = '';

        $('.royal-myaccount-menu-settings').each(function () {

            var menuID = $(this).data('id');
        
            var processingStatuses = $('#custom_multiselect_processing_' + menuID).find('.selected-values').val();
            var completedStatuses  = $('#custom_multiselect_completed_'  + menuID).find('.selected-values').val();
            var refundedStatuses   = $('#custom_multiselect_refunded_'   + menuID).find('.selected-values').val();
            var cancelledStatuses  = $('#custom_multiselect_cancelled_'  + menuID).find('.selected-values').val();

            // Get Tab Setting
            var RoyalActiveProccessingTab       = $('#royal_active_processing_tab_'  + menuID);
            var RoyalActiveComplatedTab         = $('#royal_active_complated_tab_'  + menuID);
            var RoyalActiveRefundedTab          = $('#royal_active_refunded_tab_'  + menuID);
            var RoyalActiveCancelledTab         = $('#royal_active_cancelled_tab_'  + menuID);

            if( RoyalActiveProccessingTab.prop('checked') ) {
                var ProccessingTabStatus = 'no';
            }else {
                var ProccessingTabStatus = 'yes';
            }

            if( RoyalActiveComplatedTab.prop('checked') ) {
                var ComplatedTabStatus = 'no';
            }else {
                var ComplatedTabStatus = 'yes';
            }

            if( RoyalActiveRefundedTab.prop('checked') ) {
                var RefundedTabStatus = 'no';
            }else {
                var RefundedTabStatus = 'yes';
            }

            if( RoyalActiveCancelledTab.prop('checked') ) {
                var CancelledTabStatus = 'no';
            }else {
                var CancelledTabStatus = 'yes';
            }

            menuSettings[menuID] = {
                royal_myaccount_menu_type               : $('input[name="royal_myaccount_menu_type_' + menuID + '"]:checked').val(),
                royal_myaccount_menu_icon_type          : $('input[name="royal_myaccount_icon_type_' + menuID + '"]:checked').val(),
                royal_myaccount_menu_image_url          : $('input[name="banner_image_' + menuID + '"]').val(),
                royal_myaccount_menu_item_image_icon    : $('#banner_icon_image_' + menuID).val(),
                royal_myaccount_menu_icon               : $('input[name="royal_myaccount_menu_icon_' + menuID + '"]').val(),
                royal_myaccount_menu_icon_color         : $('#royal_myaccount_menu_icon_color_' + menuID).val(),
                royal_myaccount_banner_link             : $('#banner_link_' + menuID).val(),
                order_awaiting_review_statuses          : processingStatuses,
                order_completed_statuses                : completedStatuses,
                order_refunded_statuses                 : refundedStatuses,
                order_cancelled_statuses                : cancelledStatuses,

                // Multi Selector Tab Settings
                royal_proccessing_tab_status            : ProccessingTabStatus,
                royal_proccessing_tab_name              : $('#royal_myaccount_proccessing_tab_name_' + menuID).val(),
                royal_complated_tab_status              : ComplatedTabStatus,
                royal_complated_tab_name                : $('#royal_myaccount_complated_tab_name_' + menuID).val(),
                royal_refunded_tab_status               : RefundedTabStatus,
                royal_refunded_tab_name                 : $('#royal_myaccount_refunded_tab_name_' + menuID).val(),
                royal_cancelled_tab_status              : CancelledTabStatus,
                royal_cancelled_tab_name                : $('#royal_myaccount_cancelled_tab_name_' + menuID).val(),

                // Dashboard Custom Shortcode
                RoyalMyaccountCustomDashboardShortcode : $('#RoyalMyaccountCustomDashboardShortcode' + menuID).val(),

            };
            
            menuName[menuID] = $('#RoyalMyaccountMenuName' + menuID).val();
            menuSlug[menuID] = $('#woocommerce_account_page_' + menuID).val();
            
            if( menuSlug[menuID].length <= 0 ) {
                alert('khali');
            }
            
            if (menuSlug[menuID] == 'custom') {
                menuSlug[menuID] = $('#woocommerce_page_slug_' + menuID).val();
                menuContent[menuID] = $('#RoyalMyaccountCustomShortcode' + menuID).val();
            } else {
                menuSlug[menuID] = $('#woocommerce_account_page_' + menuID).val();
                menuContent[menuID] = $('#woocommerce_account_page_' + menuID).val();
            }

        });
        
        $.ajax({
            url: admin_localized_data.ajax_url,
            type: 'POST',
            data: {
                action: 'save_menu_settings',
                settings: menuSettings,
                menusName: menuName,
                menusSlug: menuSlug,
                menusContent: menuContent,
            },
            beforeSend: function(result) {
            
                $('.myaccount-save-setting-btn').addClass('saving');
    
            },
            success: function (response) {
                $('.myaccount-save-setting-btn').removeClass('saving');
                if (response.success) {
                    showToast('تنظیمات با موفقیت ذخیره شد!');
                } else {
                    showToast('خطا در ذخیره تنظیمات!');
                }
            },
            error: function () {
                showToast('خطای سرور! لطفا دوباره تلاش کنید.');
            }
        });
    });

    // Upload Wordpress Media For Menu Banner
    $(document).on('click', '.upload-banner-button', function(e) {
        e.preventDefault();
    
        var button = $(this);
        var menuID = button.data('menu-id');
        var preview = $('#banner-preview-' + menuID);
        var inputField = $('#banner-image-' + menuID);
        var removeButton = $('.remove-banner-button[data-menu-id="' + menuID + '"]');
    
        var file_frame = wp.media({
            title: 'Select or Upload Image',
            button: { text: 'Use this image' },
            library: {
                type: 'image'
            },
            multiple: false
        });
    
        file_frame.on('select', function() {
            var selection = file_frame.state().get('selection').first();
    
            if (!selection) {
                console.warn('No file selected');
                return;
            }
    
            var attachment = selection.toJSON();
            console.log('Selected image:', attachment);
    
            if (attachment.url) {
                // اینجاست که کدت رو اینجا استفاده می‌کنی 👇
                preview.attr('src', ''); // خالی کن برای اطمینان
                preview.off('load').on('load', function () {
                    $(this).fadeIn(); // یا show()
                });
                preview.attr('src', attachment.url);
                inputField.val(attachment.url);
                removeButton.show();
            } else {
                console.error('attachment.url is missing');
            }
        });
    
        file_frame.open();
    });

    $(document).on('click', '.upload-menu-icon-img-button', function(e) {
        e.preventDefault();
    
        var button = $(this);
        var menuID = button.data('menu-id');
        var preview = $('#banner-preview-icon-' + menuID);
        var inputField = $('#banner_icon_image_' + menuID);
        var removeButton = $('.remove-icon-img-button[data-menu-id="' + menuID + '"]');
    
        var file_frame = wp.media({
            title: 'Select or Upload Image',
            button: { text: 'Use this image' },
            library: {
                type: 'image'
            },
            multiple: false
        });
    
        file_frame.on('select', function() {
            var selection = file_frame.state().get('selection').first();
    
            if (!selection) {
                console.warn('No file selected');
                return;
            }
    
            var attachment = selection.toJSON();
            console.log('Selected image:', attachment);
    
            if (attachment.url) {
                // اینجاست که کدت رو اینجا استفاده می‌کنی 👇
                preview.attr('src', ''); // خالی کن برای اطمینان
                preview.off('load').on('load', function () {
                    $(this).fadeIn(); // یا show()
                });
                preview.attr('src', attachment.url);
                inputField.val(attachment.url);
                removeButton.show();
            } else {
                console.error('attachment.url is missing');
            }
        });
    
        file_frame.open();
    });
    
    // حذف عکس
    $(document).on('click', '.remove-banner-button', function(e) {
        e.preventDefault();
        var button = $(this);
        var menuID = button.data('menu-id');
        $('#banner-preview-' + menuID).attr('src', '').hide();
        $('#banner-image-' + menuID).val('');
        button.hide();
    });
    $(document).on('click', '.remove-icon-img-button', function(e) {
        e.preventDefault();
        var button = $(this);
        var menuID = button.data('menu-id');
        $('#banner-preview-icon-' + menuID).attr('src', '').hide();
        $('#banner-icon-image-' + menuID).val('');
        button.hide();
    });


    // Upload Wordpress Media For Menu Icon Image
    // $(document).on('click', '.upload-menu-icon-button', function(e) {
    //     e.preventDefault();
    //     var button = $(this);
    //     var menuID = button.data('menu-id');
    //     var preview = $('#menu_icon_preview_' + menuID);
    //     var inputField = $('#menu_icon_image_' + menuID);

    //     var file_frame = wp.media({ // متغیر را اینجا تعریف می‌کنیم تا مستقل باشد
    //         title: 'Select or Upload Image',
    //         button: {
    //             text: 'Use this image'
    //         },
    //         multiple: false
    //     });

    //     file_frame.on('select', function() {
    //         var attachment = file_frame.state().get('selection').first().toJSON();
    //         preview.attr('src', attachment.url).show();
    //         preview.css('display', 'block');
    //         inputField.val(attachment.url);
    //     });

    //     file_frame.open();
    // });
    
     // انتخاب آیکون و تغییر مقدار input hidden
    $(document).on("click", ".icon-option", function() {
        var selectedIcon = $(this).data("icon");
        var menuID = $(this).closest('.royal-myaccount-menu-settings').data("id");

         // حذف کلاس selected از تمام آیکون‌ها و اضافه کردن به آیکون انتخاب شده
        $(this).closest(".dashicons-grid").find(".icon-option").removeClass("selected");
        $(this).addClass("selected");

         // مقدار input hidden مربوطه را تغییر دهیم
        $("input[name='royal_myaccount_menu_icon_" + menuID + "']").val(selectedIcon);
    });

    // زمانی که تب جاری فعال/غیرفعال میشود
    $(document).on('change', 'input[type="checkbox"][name^="royal_myaccount_proccessing_tab_status_"]', function() {

        var nameAttr = $(this).attr('name');
        var menuID = nameAttr.replace("royal_myaccount_proccessing_tab_status_", "");

        var GetProccessingTabOptions    = $('.proccessing-tab[data-menu-id="' + menuID + '"]');

        if( $(this).prop('checked') ) {
            GetProccessingTabOptions.hide();
        }else {
            GetProccessingTabOptions.show();
        }

    });

    // زمانی که تب تکمیل شده فعال/غیرفعال میشود
    $(document).on('change', 'input[type="checkbox"][name^="royal_myaccount_complated_tab_status_"]', function() {

        var nameAttr = $(this).attr('name');
        var menuID = nameAttr.replace("royal_myaccount_complated_tab_status_", "");

        var GetComplatedTabOptions    = $('.complated-tab[data-menu-id="' + menuID + '"]');

        if( $(this).prop('checked') ) {
            GetComplatedTabOptions.hide();
        }else {
            GetComplatedTabOptions.show();
        }

    });

    // زمانی که تب مرجوع شده فعال/غیرفعال میشود
    $(document).on('change', 'input[type="checkbox"][name^="royal_myaccount_refunded_tab_status_"]', function() {

        var nameAttr = $(this).attr('name');
        var menuID = nameAttr.replace("royal_myaccount_refunded_tab_status_", "");

        var GetComplatedTabOptions    = $('.refunded-tab[data-menu-id="' + menuID + '"]');

        if( $(this).prop('checked') ) {
            GetComplatedTabOptions.hide();
        }else {
            GetComplatedTabOptions.show();
        }

    });

    // زمانی که تب لغو شده فعال/غیرفعال میشود
    $(document).on('change', 'input[type="checkbox"][name^="royal_myaccount_cancelled_tab_status_"]', function() {

        var nameAttr = $(this).attr('name');
        var menuID = nameAttr.replace("royal_myaccount_cancelled_tab_status_", "");

        var GetComplatedTabOptions    = $('.cancelled-tab[data-menu-id="' + menuID + '"]');

        if( $(this).prop('checked') ) {
            GetComplatedTabOptions.hide();
        }else {
            GetComplatedTabOptions.show();
        }

    });

    // تغییر در گزینه‌های رادیو (برای آیتم‌های جدید و موجود)
    $(document).on('change', 'input[type="radio"][name^="royal_myaccount_menu_type_"]', function() {

        var nameAttr = $(this).attr('name');
        var menuID = nameAttr.replace("royal_myaccount_menu_type_", "");

        // پیدا کردن بخش مربوط به همین منو
        var imageRow            = $('.image-upload-row[data-menu-id="' + menuID + '"]');
        var imageLink           = $('.banner_link_field[data-menu-id="' + menuID + '"]');
        var menuIconRow         = $('.menu-icon-row[data-menu-id="' + menuID + '"]');
        var menuIconColorRow    = $('.menu-icon-color-row[data-menu-id="' + menuID + '"]');
        var MenuCustomContent   = $('.menu-custom-content[data-menu-id="' + menuID + '"]');
        var royalMenuContent    = $('.royal-myaccount-select-menu-content[data-menu-id="' + menuID + '"]');
        var iconTypeRow         = $('.menu-icon-type-row[data-menu-id="' + menuID + '"]');
        
        var UploadIcon          = $('.menu-icon-image-upload-row[data-menu-id="' + menuID + '"]');
        var proccessingTab      = $('.menu-orders-status-tabs.proccessing-tab[data-menu-id="' + menuID + '"]');
        var complatedTab        = $('.menu-orders-status-tabs.complated-tab[data-menu-id="' + menuID + '"]');
        var refundedTab         = $('.menu-orders-status-tabs.refunded-tab[data-menu-id="' + menuID + '"]');
        var cancelledTab        = $('.menu-orders-status-tabs.cancelled-tab[data-menu-id="' + menuID + '"]');
        
        var RoyalDashboardCustomShortcode = $('.royal-dashboard-custom-shortcode[data-menu-id="' + menuID + '"]');
        
        var orderStatusTabs     = $('.menu-orders-status-tabs[data-menu-id="' + menuID + '"]');
        
        var MenuCustomContent   = $('.menu-custom-content[data-menu-id="' + menuID + '"]');
        var SelectOption        = $('#woocommerce_account_page_' + menuID).val();
        
        var IconType            = $('input[name="royal_myaccount_icon_type_' + menuID + '"]:checked').val();

        if ($(this).val() === 'banner') {
            imageRow.css("display", "table-row");
            imageLink.css("display", "table-row");
            menuIconRow.css("display", "none");
            menuIconColorRow.css("display", "none");
            MenuCustomContent.css("display", "none");
            royalMenuContent.css("display", "none");
            iconTypeRow.css("display", "none");
            UploadIcon.css("display", "none");
            proccessingTab.css("display", "none");
            complatedTab.css("display", "none");
            refundedTab.css("display", "none");
            cancelledTab.css("display", "none");
            orderStatusTabs.css("display", "none");
            MenuCustomContent.css("display", "none");
            RoyalDashboardCustomShortcode.css("display", "none");
        } else {
            imageRow.css("display", "none");
            imageLink.css("display", "none");
            menuIconRow.css("display", "table-row");
            MenuCustomContent.css("display", "table-row");
            royalMenuContent.css("display", "table-row");
            UploadIcon.css("display", "table-row");   
            
            if( IconType == 'icon' ) {
                iconTypeRow.css("display", "table-row");
                menuIconColorRow.css("display", "table-row");
            }
            
            if( SelectOption == 'orders' ) {
                proccessingTab.css("display", "table-row");
                complatedTab.css("display", "table-row");
                refundedTab.css("display", "table-row");
                cancelledTab.css("display", "table-row");
                orderStatusTabs.css("display", "table-row");   
            }
            
            if( SelectOption == 'custom' ) {
                MenuCustomContent.css("display", "table-row");
            }else {
                MenuCustomContent.css("display", "none");
            }
            
            if( SelectOption == 'dashboard' ) {
                RoyalDashboardCustomShortcode.css("display", "table-row");
            }
            
        }
        
    });

    // Change Menu Icon/Image Type On Change Radio Btn
    $(document).on('change', 'input[type="radio"][name^="royal_myaccount_icon_type_"]', function() {

        var nameAttr = $(this).attr('name');
        var menuID = nameAttr.replace("royal_myaccount_icon_type_", "");

        // Find Menu Icon Section
        var IconOption = $('.menu-icon-type-row[data-menu-id="' + menuID + '"]');
        var UploadIcon = $('.menu-icon-image-upload-row[data-menu-id="' + menuID + '"]');
        var IconColor  = $('.menu-icon-color-row[data-menu-id="' + menuID + '"]');
        
        if ($(this).val() === 'icon') {
            IconOption.css("display", "table-row");
            UploadIcon.css("display", "none");
            IconColor.css("display", "table-row");
        } else {
            IconOption.css("display", "none");
            UploadIcon.css("display", "table-row");
            IconColor.css("display", "none");
        }
        
    });

    $(".royal-myaccount-menus").sortable({
        placeholder: "sortable-placeholder",
        cursor: "move",
        opacity: 0.7,
        update: function (event, ui) {
            let sortedIDs = $(this).sortable("toArray", { attribute: "data-id" });
            
            $.ajax({
                url: admin_localized_data.ajax_url,
                type: 'POST',
                data: {
                    action: 'update_menu_order',
                    sortedIDs: sortedIDs
                },
                success: function (response) {
                    if (response.success) {
                        console.log("ترتیب منوها ذخیره شد!");
                    } else {
                        console.log("خطا در ذخیره ترتیب منوها!");
                    }
                },
                error: function () {
                    console.log("خطای سرور در ذخیره ترتیب منوها!");
                }
            });
        }
    });
    $(".royal-myaccount-menus").disableSelection();

});

jQuery(document).on('change', 'select[name^="woocommerce_account_page_"]', function () {

    var nameAttr = jQuery(this).attr('name'); // مثال: woocommerce_account_page_12
    var menuID = nameAttr.replace("woocommerce_account_page_", "");
    
    var selectedSlug = jQuery(this).val(); // مقدار option انتخاب‌شده واقعی

    // let selectedSlug = jQuery("#woocommerce_account_page_" + menuID).val();
    let slugInput = jQuery("#woocommerce_page_slug_" + menuID);
    let MenuCustomContent = jQuery('.menu-custom-content[data-menu-id="' + menuID + '"]');
    let MenuOrdersTab = jQuery('.menu-orders-status-tabs[data-menu-id="' + menuID + '"]');
    let RoyalDashboardCustomShortcode = jQuery('.royal-dashboard-custom-shortcode');

    console.log("🔄 تغییر مقدار در menuID:", menuID, "Selected Slug:", selectedSlug);

    if (selectedSlug === "custom") {
        slugInput.prop("readonly", false).val("");
        MenuCustomContent.css('display', 'table-row');
    } else {
        slugInput.prop("readonly", true).val(selectedSlug);
        MenuCustomContent.css('display', 'none');
    }

    if (selectedSlug === 'orders') {
        MenuOrdersTab.show();
    } else {
        MenuOrdersTab.hide();
    }
    
    if (selectedSlug === 'dashboard') {
        RoyalDashboardCustomShortcode.show();
    } else {
        RoyalDashboardCustomShortcode.hide();
    }

});

// Multi Select JS ==> Start
jQuery(document).ready(function ($) {

    // باز و بسته کردن دراپ‌داون
    $(document).on('click', '.custom-multiselect', function (e) {
        e.stopPropagation();
        $('.dropdown').not($(this).find('.dropdown')).hide();
        $(this).find('.dropdown').toggle();
    });

    // انتخاب آیتم از دراپ‌داون
    $(document).on('click', '.custom-multiselect .option', function (e) {
        e.stopPropagation();
        var $option = $(this);

        if ($option.hasClass('disabled')) return;

        var value = $option.data('value');
        var text = $option.text();

        var $multiselect = $option.closest('.custom-multiselect');
        var $selectedItems = $multiselect.find('.selected-items');
        var $dropdown = $multiselect.find('.dropdown');

        if ($selectedItems.find('[data-value="' + value + '"]').length) return;

        // اضافه کردن آیتم
        var $item = $('<span class="selected-item selected" data-value="' + value + '">' + text + ' <span class="remove">×</span></span>');
        $selectedItems.append($item);

        // بستن دراپ‌داون
        $dropdown.hide();

        // به‌روزرسانی input مخفی
        updateHiddenInput($multiselect);
    });

    // بستن دراپ‌داون در کلیک خارج
    $(document).on('click', function (e) {
        $('.dropdown').hide();
    });

    // تابع به‌روزرسانی مقدار input مخفی
    function updateHiddenInput($multiselect) {
        var selectedValues = [];
        $multiselect.find('.selected-item').each(function () {
            selectedValues.push($(this).data('value'));
        });
        var joinedValues = selectedValues.join(',');
        $multiselect.find('input[type="hidden"]').val(joinedValues);
    }

    // بخش غیرفعال کردن آیتم انتخاب شده در بقیه باکس ها
    var selectedStatuses = [];

    function refreshOptions() {
      $('.custom-multiselect').each(function(){
        var $box = $(this);
        $box.find('.option').each(function(){
          var val = $(this).data('value');
          if (selectedStatuses.includes(val)) {
            $(this).addClass('disabled');
          }
        });
      });
    }
  
    $('.custom-multiselect .option').on('click', function(){
      var $option = $(this);
      if ($option.hasClass('disabled')) return;
  
      var val = $option.data('value');
      var text = $option.text();
      var $box = $option.closest('.custom-multiselect');
  
      // چک کن وضعیت از قبل انتخاب نشده باشه
      if ($box.find('.selected-items .item[data-value="'+val+'"]').length) return;
  
      // به آرایه اضافه کن
      selectedStatuses.push(val);
  
      // به لیست انتخابی اضافه کن
      $box.find('.selected-items').append('<div class="item" data-value="'+val+'">'+text+' <span class="remove">×</span></div>');
  
      // مقدار hidden input رو بروزرسانی کن
      var selected = [];
      $box.find('.selected-items .item').each(function(){
        selected.push($(this).data('value'));
      });
      $box.find('.selected-values').val(selected.join(','));
  
      refreshOptions();
    });
  
    $(document).on('click', '.custom-multiselect .remove', function(){
        var $item = $(this).closest('.item');
        var val = $item.data('value');
        var $box = $item.closest('.custom-multiselect');
      
        // از آرایه کلی حذف کن
        selectedStatuses = selectedStatuses.filter(function(v){
          return v !== val;
        });
      
        // از UI حذف کن
        $item.remove();
      
        // input hidden رو آپدیت کن
        var selected = [];
        $box.find('.selected-items .item').each(function(){
          selected.push($(this).data('value'));
        });
        $box.find('.selected-values').val(selected.join(','));
      
        // تو همه مولتی سلکت‌ها گزینه مربوطه رو فعال کن
        $('.custom-multiselect .dropdown .option[data-value="' + val + '"]').removeClass('disabled');
      
        refreshOptions();
    });
      
});
// Multi Select JS ==> End
