<?php

if( !class_exists('Royal_MyAccount_Admin_Content') ) {

    class Royal_MyAccount_Admin_Content {
        
        protected $RoyalMyAccount_Css_Url = '';
        protected $RoyalMyAccount_Js_Url = '';

        public function __construct() {

            $this->RoyalMyAccount_Css_Url       = get_stylesheet_directory_uri() . '/includes/royal-myaccount/assets/css';
            $this->RoyalMyAccount_Js_Url        = get_stylesheet_directory_uri() . '/includes/royal-myaccount/assets/js';

            add_action( 'admin_menu', [$this, 'RoyalMyAccountAdmin'], 13 );
            add_action( 'admin_enqueue_scripts', [$this, 'LoadAdminScripts'] );

            // Start All Ajax Requests

                // Save Menu Ajax
                add_action( 'wp_ajax_insert_menu', [$this, 'Royal_Myaccount_SaveMenu'] );
                add_action( 'wp_ajax_nopriv_insert_menu', [$this, 'Royal_Myaccount_SaveMenu'] );

                // delete Menu Ajax
                add_action( 'wp_ajax_delete_menu', [$this, 'delete_menu_callback'] );
                add_action( 'wp_ajax_nopriv_delete_menu', [$this, 'delete_menu_callback'] );

                // Save Menu Setting With Ajax
                add_action( 'wp_ajax_save_menu_settings', [$this, 'save_menu_settings'] );
                add_action( 'wp_ajax_nopriv_save_menu_settings', [$this, 'save_menu_settings'] );

                // Save Menu Sort On Database
                add_action( 'wp_ajax_update_menu_order', [$this, 'update_menu_order_callback'] );
                add_action( 'wp_ajax_nopriv_update_menu_order', [$this, 'update_menu_order_callback'] );

            // End All Ajax Requests
        }

        // Save Menu Ajax Handle
        public function Royal_Myaccount_SaveMenu() {
            if (!isset($_POST['menuName']) || empty($_POST['menuName'])) {
                wp_send_json_error(['message' => 'نام منو الزامی است!']);
            }
            
            $menuName = sanitize_text_field($_POST['menuName']);
            $menuID = Royal_MyAccount_Querys::insertMenu($menuName);
            
            if ($menuID) {
                delete_transient('royal_myaccount_all_menus_cache');
                wp_send_json_success([
                    'message'  => 'منو با موفقیت ذخیره شد!',
                    'menuName'  => $menuName,
                    'menuID'   => $menuID,
                    'menuSort' => $menuSort
                ]);
            } else {
                wp_send_json_error(['message' => 'خطا در ذخیره منو!']);
            }
        }
        
        // Delete menu
        public function delete_menu_callback() {
            
            // چک کردن ورودی‌ها
            if (isset($_POST['menuID'])) {
                $menuID = intval($_POST['menuID']);
                
                // حذف منو از دیتابیس
                $result = Royal_MyAccount_Querys::deleteMenu($menuID);
                
                if ($result) {
                    delete_transient('royal_myaccount_all_menus_cache');
                    wp_send_json_success(); // ارسال پاسخ موفق
                } else {
                    wp_send_json_error(['message' => 'منو حذف نشد!']);
                }
            } else {
                wp_send_json_error(['message' => 'خطا در ورودی‌ها']);
            }
            
            wp_die(); // لازم است برای پایان دادن به درخواست AJAX
        }

        // Save Menu Settings
        public function save_menu_settings() {
            
            global $wpdb;
            
            if( isset( $_POST['menusName'] ) ) {
                
                $menuName = $_POST['menusName'];
                foreach ($menuName as $menuID => $menuNames) {
                    
                    $result = Royal_MyAccount_Querys::updateMenuName(
                        $menuID,
                        'menuName', 
                        $menuNames 
                    );
                }
            }
            
            if( isset( $_POST['menusSlug'] ) ) {
                
                $menuSlug = $_POST['menusSlug'];
                foreach ($menuSlug as $menuID => $menuSlugs) {
                    
                    $result = Royal_MyAccount_Querys::updateMenuName(
                        $menuID,
                        'menuSlug', 
                        $menuSlugs 
                    );
                }
            }
            
            if( isset( $_POST['menusContent'] ) ) {
                
                $menusContent = $_POST['menusContent'];
                foreach ($menusContent as $menuID => $menusContent) {
                    
                    $result = Royal_MyAccount_Querys::updateMenuName(
                        $menuID,
                        'menuContent', 
                        $menusContent 
                    );
                }
            }
            
            if( isset( $_POST['settings'] ) ) {
                
                $settings = $_POST['settings'];
                foreach ($settings as $menuID => $menuSettings) {
                    
                    $serialized_settings = maybe_serialize($menuSettings);
                    
                    $result = Royal_MyAccount_Querys::updateMenuName(
                        $menuID, 
                        'menusSettingData', 
                        $serialized_settings 
                    );
                }
            }
            
            delete_transient('royal_myaccount_all_menus_cache');
            wp_send_json_success(['message' => 'تنظیمات ذخیره شد!']);
            wp_die();
        }

        public function royal_show_status_items($statuses, $order_statuses) {
            foreach ($statuses as $status) {
                $name = isset($order_statuses[$status]) ? $order_statuses[$status] : $status;
                echo '<div class="item" data-value="' . esc_attr($status) . '">'
                        . esc_html($name)
                        . '<span class="remove">×</span>'
                    . '</div>';
            }
        }
        
        public function update_menu_order_callback() {
            
            global $wpdb;
            $table_name = $wpdb->prefix . 'royal_myaccount';
            
            if (!isset($_POST['sortedIDs']) || !is_array($_POST['sortedIDs'])) {
                wp_send_json_error(['message' => 'داده‌های نامعتبر ارسال شده است!']);
            }
            
            $sortedIDs = array_map('intval', $_POST['sortedIDs']); // تبدیل مقادیر به عدد صحیح
            
            if (empty($sortedIDs)) {
                wp_send_json_error(['message' => "هیچ menuID معتبری دریافت نشد!"]);
            }
            
            error_log("دریافت‌شده: " . print_r($sortedIDs, true)); // لاگ مقدار menuID‌ها
            
            foreach ($sortedIDs as $menuID) {
                $menu_exists = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE menuID = %d", $menuID));
                
                if (!$menu_exists) {
                    wp_send_json_error(['message' => "menuID $menuID در دیتابیس وجود ندارد!"]);
                }
            }
            
            // بروزرسانی ترتیب در دیتابیس
            foreach ($sortedIDs as $index => $menuID) {
                $result = $wpdb->update(
                    $table_name,
                    ['menuSort' => $index + 1],
                    ['menuID' => $menuID], // تغییر از 'id' به 'menuID'
                    ['%d'],
                    ['%d']
                );
                
                if ($result === false) {
                    wp_send_json_error(['message' => "خطای دیتابیس: " . $wpdb->last_error]);
                }
            }
            delete_transient('royal_myaccount_all_menus_cache');
            wp_send_json_success(['message' => 'ترتیب منوها با موفقیت ذخیره شد!']);
        }

        public function RoyalMyAccountAdmin() {
            add_submenu_page( 
                'iranavada', 
                __('Royal MyAccount', 'royal'), 
                __('Royal MyAccount', 'royal'), 
                'administrator', 
                'royal_my_account', 
                [$this, 'RoyalAdminMyAccountContent']
            );
        }
        
        public function RoyalAdminMyAccountContent() {
            
            /* wp_enqueue_style('royal-setting-style'); */
            
            ?>
            <div class="iranavada-dashboard">
                <?php
                if( !class_exists('IRAVADA_ADMIN_HEADER') ) {
                    require_once( get_stylesheet_directory() . '/includes/admin-screens/admin-contents/iravada-admins-header.php' );
                }
                IRAVADA_ADMIN_HEADER::iravada_dashboard_header_design('royal_my_account');
                ?>                
            </div>

            <div id="royal_toast"><span></span></div>
            <div id="confirm-modal" class="modal">
                <div class="modal-content">
                    <h3>آیا مطمئن هستید؟</h3>
                    <p>آیا می‌خواهید این منو حذف شود؟ این عملیات غیرقابل بازگشت است.</p>
                    <div class="modal-actions">
                        <button id="confirm-yes" class="yes-btn">
                            <span class="btn-text">حذف</span>
                            <span class="btn-spinner"></span>
                        </button>
                        <button id="confirm-no" class="no-btn">انصراف</button>
                    </div>
                </div>
            </div>
            
            <div class="wrap">  
                <div class="royal-myaccount-admin-content iranavada-dashboard">
                    <div class="royal-myaccount-menus-section">
                        <ul class="royal-myaccount-menus">
                            <?php 
                            $menus = Royal_MyAccount_Querys::getAllMenus();
                            if (!empty($menus)) :
                                $first = true; // برای نمایش اولین منو
                                foreach ($menus as $menu) : ?>
                                    <li class="royal-myaccount-menu" data-id="<?php echo esc_attr($menu['menuID']); ?>">
                                        <span class="menu-mover dashicons dashicons-move"></span>
                                        <span class="menu-title-icon"><?php echo esc_html($menu['menuName']); ?></span>
                                        <button class="delete-menu" data-id="<?php echo esc_attr($menu['menuID']); ?>"><span class="delete-menu-icon dashicons dashicons-no-alt"></span></button>
                                    </li>
                                <?php 
                                $first = false;
                                endforeach;

                            else :
                                echo "<li id='NoMenuDetected'>هیچ منویی یافت نشد</li>";
                            endif;
                            ?>
                        </ul>
                        <div class="add-menu-section" style="display: none;">
                            <div class="add-menu-container" style="display: flex;flex-direction: column;gap: 10px;">
                                <input type="text" style="width: 100%;height: 40px;border: 1px solid #ccc;border-radius: 5px;outline: none;color: #2c3338;box-shadow: 0 0 3px #ebebeb;" id="new-menu-name" class="new-menu-input" placeholder="نام منوی جدید را وارد کنید" style="display: none;">
                                <button id="submit-new-menu" class="submit-menu-btn" style="background: #00c095;padding: 12px 30px;color: #fff;border-radius: 5px;cursor: pointer;border: none;">ثبت</button>
                            </div>
                        </div>
                        <span class="add-new-myaccount-menu">افزودن منو</span>

                    </div>

                    <div class="royal-myaccount-menus-settings">
                        <?php if (!empty($menus)) : ?>
                            <?php 
                                foreach ($menus as $menu) : 

                                    $menusSettingData = maybe_unserialize($menu['menusSettingData']);
                                    
                                    // وضعیت‌های داینامیک ووکامرس
                                    $order_statuses = wc_get_order_statuses();

                                    $order_awaiting_review_statuses     = isset( $menusSettingData['order_awaiting_review_statuses'] ) ? $menusSettingData['order_awaiting_review_statuses'] : '';
                                    $order_completed_statuses           = isset( $menusSettingData['order_completed_statuses'] ) ? $menusSettingData['order_completed_statuses'] : '';
                                    $order_refunded_statuses            = isset( $menusSettingData['order_refunded_statuses'] ) ? $menusSettingData['order_refunded_statuses'] : '';
                                    $order_cancelled_statuses           = isset( $menusSettingData['order_cancelled_statuses'] ) ? $menusSettingData['order_cancelled_statuses'] : '';

                                    // لیست وضعیت‌ها از دیتابیس
                                    $awaiting_review_statuses = array_filter(explode(',', $order_awaiting_review_statuses));
                                    $completed_statuses       = array_filter(explode(',', $order_completed_statuses));
                                    $refunded_statuses        = array_filter(explode(',', $order_refunded_statuses));
                                    $cancelled_statuses       = array_filter(explode(',', $order_cancelled_statuses));

                                    // Check Menu Type
                                    if( isset( $menusSettingData['royal_myaccount_menu_type'] ) && $menusSettingData['royal_myaccount_menu_type'] == 'banner' ) {
                                        $MyAccountMenuType = 'banner';
                                    }else {
                                        $MyAccountMenuType = 'text';
                                    }

                                    if( isset( $menusSettingData['royal_myaccount_menu_icon_type'] ) ) {
                                        $MyAccountMenuIconType = $menusSettingData['royal_myaccount_menu_type'];
                                    }else {
                                        $MyAccountMenuIconType = 'icon';
                                    }

                                    // Check Processing Tab Status
                                    $MyAccountProccessingTabStatus  = isset( $menusSettingData['royal_proccessing_tab_status'] ) ? $menusSettingData['royal_proccessing_tab_status'] : 'yes';
                                    $MyAccountComplatedTabStatus    = isset( $menusSettingData['royal_complated_tab_status'] ) ? $menusSettingData['royal_complated_tab_status'] : 'yes';
                                    $MyAccountRefundedTabStatus     = isset( $menusSettingData['royal_refunded_tab_status'] ) ? $menusSettingData['royal_refunded_tab_status'] : 'yes';
                                    $MyAccountCancelledTabStatus    = isset( $menusSettingData['royal_cancelled_tab_status'] ) ? $menusSettingData['royal_cancelled_tab_status'] : 'yes';

                                    // Get Menu Links
                                    if( isset( $menusSettingData['royal_myaccount_banner_link'] ) ) {
                                        $MyAccountBannerLink = $menusSettingData['royal_myaccount_banner_link'];
                                    }else {
                                        $MyAccountBannerLink = '';
                                    }

                                    if( isset( $menusSettingData['royal_myaccount_menu_icon_color'] ) ) {
                                        $MyAccountIconColor = $menusSettingData['royal_myaccount_menu_icon_color'];
                                    }else {
                                        $MyAccountIconColor = '#3f4064';
                                    }

                                    // Check Menu Type
                                    $icon_type = $menusSettingData['royal_myaccount_menu_icon_type'];
                                    if( isset( $menusSettingData['royal_myaccount_menu_icon_type'] ) ) {
                                        $MyAccountMenuIconType = $menusSettingData['royal_myaccount_menu_icon_type'];

                                        if( $icon_type == 'image' ) {
                                            $displayNoneIconSelector = 'display:none;';
                                        }

                                    }else {
                                        $MyAccountMenuIconType = 'icon';

                                        if( $icon_type == 'icon' ) {
                                            $displayNoneIconSelector = 'display:table-row;';
                                        }
                                    }
                                    
                                    // Check Menu Icon Type For Display Upload Menu Image Icon
                                    if( $MyAccountMenuIconType == 'icon' ) {
                                        $DisplayOptionStatusMenuIcon = 'display:table-row;';
                                        $DisplayOptionStatusMenuUploadIcon = 'display:none;';
                                    }else {
                                        $DisplayOptionStatusMenuIcon = 'display:none;';
                                        $DisplayOptionStatusMenuUploadIcon = 'display:table-row;';
                                    }
                                    
                                    // Check Menu Type For Display Upload Menu Image
                                    if( $MyAccountMenuType == 'banner' ) {
                                        $DisplayOptionStatus = 'display:table-row;';
                                        $DisplayNotNeedOptions = 'display:none;';
                                        $displayNoneIconSelector = 'display:none;';
                                        $DisplayOptionStatusMenuUploadIcon = 'display:none;';
                                        $Custom_dashboard_Shortcode_Display_Status = 'display: none;';
                                    }else {
                                        $DisplayOptionStatus = 'display:none;';
                                        $DisplayNotNeedOptions = 'display:table-row;';
                                        if( $icon_type == 'icon' ) {
                                            $displayNoneIconSelector = 'display:table-row;';
                                        }else {
                                            $displayNoneIconSelector = 'display:none;';
                                        }
                                        
                                        // Check MenuContent is Dashboard
                                        if( $menu['menuSlug'] == 'dashboard' ) {
                                            $Custom_dashboard_Shortcode_Display_Status = 'display: table-row;';
                                        }else {
                                            $Custom_dashboard_Shortcode_Display_Status = 'display: none;';
                                        }
                                        
                                    }

                                    // Menu Banner
                                    if( isset( $menusSettingData['royal_myaccount_menu_image_url'] ) ) {
                                        $banner_url = $menusSettingData['royal_myaccount_menu_image_url'];
                                        $img_preview_display_status = 'display:block;';
                                    }else {
                                        $banner_url = '';
                                        $img_preview_display_status = 'display:none;';
                                    }

                                    // Menu Items Icon
                                    if( isset( $menusSettingData['royal_myaccount_menu_item_image_icon'] ) ) {
                                        $meun_icons_image = $menusSettingData['royal_myaccount_menu_item_image_icon'];
                                    }else {
                                        $meun_icons_image = '';
                                    }

                                    // Check Menu Slug ReadOnly Status
                                    $selected_pages = [
                                        'dashboard'       => 'داشبورد',
                                        'orders'          => 'سفارش‌ها',
                                        'downloads'       => 'دانلودها',
                                        'edit-address'    => 'آدرس‌',
                                        'edit-account'    => 'ویرایش حساب',
                                        'customer-logout' => 'خروج از سیستم'
                                    ];
                                    
                                    // بررسی اینکه مقدار انتخاب‌شده کاستوم هست یا نه
                                    $is_custom = !array_key_exists($menu['menuSlug'], $selected_pages);

                                    if( $is_custom ) {
                                        $option_is_custom = 'yes';
                                    }else {
                                        $option_is_custom = 'no';
                                    }

                                    $Custom_Shortcode_Display_Status = 'display: none;';
                                    $Display_set_menu_content = 'display: none;';
                                    
                                    if( $MyAccountMenuType == 'text' ) {
                                        
                                        $Display_set_menu_content = 'display: table-row;';
                                        
                                        if( $option_is_custom == 'no' ) {
                                            $Custom_Shortcode_Display_Status = 'display: none;';
                                        }else {
                                            $Custom_Shortcode_Display_Status = 'display: table-row;';
                                        }   
                                    }

                                    if( isset( $menu['menuSlug'] ) && !empty($menu['menuSlug']) && $menu['menuSlug'] == 'orders'  ) {
                                        $Orders_Tabs_Display_Status = 'display: table-row;';
                                        
                                        if( $MyAccountProccessingTabStatus == 'yes' ) {
                                            $DisplayProccessingTab = 'display:table-row;';
                                        }

                                        if( $MyAccountComplatedTabStatus == 'yes' ) {
                                            $DisplayComplatedTab = 'display:table-row;';
                                        }

                                        if( $MyAccountRefundedTabStatus == 'yes' ) {
                                            $DisplayRefundedTab = 'display:table-row;';
                                        }

                                        if( $MyAccountCancelledTabStatus == 'yes' ) {
                                            $DisplayCancelledTab = 'display:table-row;';
                                        }

                                    }else {
                                        $Orders_Tabs_Display_Status     = 'display: none;';
                                        $DisplayProccessingTab          = 'display:none;';
                                        $DisplayComplatedTab            = 'display:none;';
                                        $DisplayRefundedTab             = 'display:none;';
                                        $DisplayCancelledTab            = 'display:none;';
                                    }
                                ?>
                                <div class="royal-setting-content royal-myaccount-menu-settings" data-id="<?php echo esc_attr($menu['menuID']); ?>" style="display: none;">
                                    <div class="menu-title-area">
                                        <span class="dashicons dashicons-admin-settings"></span>
                                        <h3 class="menu-title"><?php echo esc_html($menu['menuName']); ?></h3>
                                    </div>
                                    <table class="form-table no-border">
                                        <tr>
                                            <th scope="row">
                                                <lable for="RoyalMyaccountMenuName<?= esc_attr($menu['menuID']) ?>"><?php _e( 'Menu Name' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td> 
                                                <input type="text" class="royal-myaccount-input-option" value="<?php echo esc_html($menu['menuName']) ?>" id="RoyalMyaccountMenuName<?= esc_attr($menu['menuID']) ?>" name="RoyalMyaccountMenuName<?= esc_attr($menu['menuID']) ?>" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">
                                                <lable><?php _e( 'Menu Type' , 'royal' ); ?>
                                                    <p class="description"><?php _e( 'Select the menu type according to your needs. Content: Creates the content inside the menus. Banner inside the menu bar: Loads an image/banner inside the menu bar.' , 'royal' ); ?></p>
                                                </lable>
                                            </th>
                                            <td> 
                                                <div class="radio-group">
                                                    <input type="radio" id="text_<?= esc_attr($menu['menuID']); ?>" name="royal_myaccount_menu_type_<?= esc_attr($menu['menuID']); ?>" value="text" <?php checked( 'text' , $MyAccountMenuType ); ?> >
                                                    <label style="border-radius: 0px 5px 5px 0px;" for="text_<?= esc_attr($menu['menuID']); ?>"><?php _e('Content', 'royal'); ?></label>
                                                    <input type="radio" id="banner_<?= esc_attr($menu['menuID']); ?>" name="royal_myaccount_menu_type_<?= esc_attr($menu['menuID']); ?>" value="banner" <?php checked( 'banner' , $MyAccountMenuType ); ?> >
                                                    <label style="border-radius: 5px 0px 0px 5px;" for="banner_<?= esc_attr($menu['menuID']); ?>"><?php _e('Banner inside the menu column', 'royal'); ?></label>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="royal-myaccount-select-menu-content" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $Display_set_menu_content ?>">
                                            <th scope="row">
                                                <label for="woocommerce_account_page"><?php _e( 'Select Menu Content' , 'royal' ); ?></label>
                                            </th>
                                            <td>
                                                <?php
                                                $selected_pages = [
                                                    'dashboard'       => 'داشبورد',
                                                    'orders'          => 'سفارش‌ها',
                                                    'downloads'       => 'دانلودها',
                                                    'edit-address'    => 'آدرس‌',
                                                    'edit-account'    => 'ویرایش حساب',
                                                    'customer-logout' => 'خروج از سیستم'
                                                ];
                                                
                                                // اگر menuSlug در کلیدهای selected_pages نبود، custom باید selected بشه
                                                $is_custom = !array_key_exists($menu['menuSlug'], $selected_pages);
                                                ?>
                                                
                                                <select class="royal-myaccount-input-option woocommerce-page-dropdown"
                                                        name="woocommerce_account_page_<?= esc_attr($menu['menuID']); ?>"
                                                        id="woocommerce_account_page_<?= esc_attr($menu['menuID']); ?>">
                                                
                                                    <option value="custom" <?= $is_custom ? 'selected' : '' ?>>
                                                        <?php _e('Custom Content', 'royal') ?>
                                                    </option>
                                                
                                                    <?php
                                                    foreach ($selected_pages as $slug => $label) {
                                                        $selected = ($menu['menuSlug'] === $slug) ? 'selected' : '';
                                                        echo "<option value='" . esc_attr($slug) . "' $selected>" . esc_html($label) . "</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr class="menu-custom-content" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $Custom_Shortcode_Display_Status ?>">
                                            <th scope="row">
                                                <lable for="RoyalMyaccountCustomShortcode<?= esc_attr($menu['menuID']); ?>"><?php _e( 'Custom Content Menu Slug' , 'royal' ); ?>
                                                <p class="description"><?php _e( 'Enter a URL for the custom menu.' , 'royal' ); ?></p>
                                                </lable>
                                            </th>
                                            <td> 
                                                <input class="royal-myaccount-input-option" type="text" placeholder="اسلاگ سفارشی" id="woocommerce_page_slug_<?= esc_attr($menu['menuID']); ?>" name="woocommerce_page_slug_<?= esc_attr($menu['menuID']); ?>" value="<?= isset($menu['menuSlug']) ? $menu['menuSlug'] : '' ?>" />
                                                <p style="color:red" class="description"><?php _e( 'Required. Entering a link for the custom menu is required.' , 'royal' ); ?></p>
                                            </td>
                                        </tr>
                                        
                                        <tr class="menu-custom-content" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $Custom_Shortcode_Display_Status ?>">
                                            <th scope="row">
                                                <lable for="RoyalMyaccountCustomShortcode<?= esc_attr($menu['menuID']); ?>"><?php _e( 'Custom Content Menu Shortcode' , 'royal' ); ?>
                                                <p class="description"><?php _e( 'Enter your custom shortcode. You can create custom content from the Avada library, save it globally, and use its shortcode.' , 'royal' ); ?><a href="<?php echo admin_url( 'admin.php?page=avada-library' ) ?>" target="_blank"> <?php _e( 'Avada Library' , 'royal' ); ?></a></p>
                                                </lable>
                                            </th>

                                            <td> 
                                                <input type="text" class="royal-myaccount-input-option" placeholder="شورتکد سفارشی" value="<?php echo preg_replace('/\\\\+/', '', esc_html($menu['menuContent'])) ?>" id="RoyalMyaccountCustomShortcode<?= esc_attr($menu['menuID']) ?>" name="RoyalMyaccountCustomShortcode<?= esc_attr($menu['menuID']) ?>" />
                                                <p class="description">شورتکد جهت نمایش خروجی افزونه هایی مثل پیگیری سفارشات یا افزونه تیکت یا کتابخانه آوادا و غیره </p>
                                            </td>
                                        </tr>
                                        
                                        <tr class="royal-dashboard-custom-shortcode" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $Custom_dashboard_Shortcode_Display_Status ?>">
                                            <th scope="row">
                                                <lable for="RoyalMyaccountCustomDashboardShortcode<?= esc_attr($menu['menuID']); ?>"><?php _e( 'Custom dashboard Menu Shortcode' , 'royal' ); ?>
                                                <p class="description"><?php _e( 'If left blank, the default WooCommerce dashboard will be displayed. For a custom design, create custom content from the Avada library, save it globally, and place its shortcode here.' , 'royal' ); ?><a href="<?php echo admin_url( 'admin.php?page=avada-library' ) ?>" target="_blank"> <?php _e( 'Avada Library' , 'royal' ); ?></a></p>
                                                </lable>
                                            </th>

                                            <td> 
                                                <input type="text" class="royal-myaccount-input-option" placeholder="شورتکد سفارشی داشبورد" value="<?= preg_replace('/\\\\+/', '', esc_html($menusSettingData['RoyalMyaccountCustomDashboardShortcode'])) ?>" id="RoyalMyaccountCustomDashboardShortcode<?= esc_attr($menu['menuID']) ?>" name="RoyalMyaccountCustomDashboardShortcode<?= esc_attr($menu['menuID']) ?>" />
                                            </td>
                                        </tr>
                                        
                                        <tr class="image-upload-row" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $DisplayOptionStatus ?>">
                                            <th scope="row">
                                                <label for="banner-image-<?php echo esc_attr($menu['menuID']); ?>"><?php _e('Upload Banner Image', 'royal'); ?></label>
                                            </th>
                                            <td>
                                                <img class="royal-myaccount-menu-image" 
                                                     id="banner-preview-<?php echo esc_attr($menu['menuID']); ?>" 
                                                     src="<?= esc_url($banner_url); ?>" 
                                                     style="max-width: 200px; max-height: 100px; <?= $img_preview_display_status ?>" />
                                            
                                                <button type="button" 
                                                        class="remove-banner-button" 
                                                        data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" 
                                                        style="<?= empty($banner_url) ? 'display: none;' : '' ?>">
                                                    &times;
                                                </button>
                                            
                                                <input type="hidden" 
                                                       id="banner-image-<?php echo esc_attr($menu['menuID']); ?>" 
                                                       name="banner_image_<?php echo esc_attr($menu['menuID']); ?>" 
                                                       value="<?= esc_attr($banner_url); ?>">
                                            
                                                <button type="button" 
                                                        class="button upload-banner-button" 
                                                        data-menu-id="<?php echo esc_attr($menu['menuID']); ?>">
                                                    <?php _e('Upload Image', 'royal'); ?>
                                                </button>
                                            </td>
                                        </tr>
                                        
                                        <tr class="banner_link_field" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $DisplayOptionStatus ?>">
                                            <th scope="row">
                                                <label for="banner_link_<?php echo esc_attr($menu['menuID']); ?>"><?php _e('Banner Link', 'royal'); ?></label>
                                            </th>
                                            <td>
                                                <input type="text" class="royal-myaccount-input-option" id="banner_link_<?php echo esc_attr($menu['menuID']); ?>" name="banner_link_<?php echo esc_attr($menu['menuID']); ?>" placeholder="لینک عکس را وارد کنید" value="<?= $MyAccountBannerLink ?>" />
                                                <p class="description">لینک بنر را وارد کنید. اگر خالی رها شود، به صورت پیش‌فرض به صفحه فروشگاه لینک داده خواهد شد.</p>
                                            </td>
                                        </tr>
                                        
                                        <tr class="menu-icon-row" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $DisplayNotNeedOptions ?>">
                                            <th scope="row">
                                                <lable><?php _e( 'Menu Icon/Image' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td> 
                                                <div class="radio-group">
                                                    <input type="radio" id="icon_<?= esc_attr($menu['menuID']); ?>" name="royal_myaccount_icon_type_<?= esc_attr($menu['menuID']); ?>" value="icon" <?php checked( 'icon' , $MyAccountMenuIconType ); ?> >
                                                    <label style="border-radius: 0px 5px 5px 0px;" for="icon_<?= esc_attr($menu['menuID']); ?>"><?php _e('Icon', 'royal'); ?></label>

                                                    <input type="radio" id="image_<?= esc_attr($menu['menuID']); ?>" name="royal_myaccount_icon_type_<?= esc_attr($menu['menuID']); ?>" value="image" <?php checked( 'image' , $MyAccountMenuIconType ); ?> >
                                                    <label style="border-radius: 5px 0px 0px 5px;" for="image_<?= esc_attr($menu['menuID']); ?>"><?php _e('Image', 'royal'); ?></label>
                                                </div>
                                            </td>
                                        </tr>
                                        
                                        <tr class="menu-icon-image-upload-row" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $DisplayOptionStatusMenuUploadIcon ?>">
                                            <th scope="row">
                                                <label for="menu_icon_preview_<?php echo esc_attr($menu['menuID']); ?>"><?php _e('Upload Icon Image', 'royal'); ?></label>
                                            </th>
                                            <td>
                                                <img class="royal-myaccount-menu-image" 
                                                     id="banner-preview-icon-<?php echo esc_attr($menu['menuID']); ?>" 
                                                     src="<?= esc_url($meun_icons_image); ?>" 
                                                     style="max-width: 200px; max-height: 100px; <?= $img_preview_display_status ?>" />
                                            
                                                <button type="button" 
                                                        class="remove-icon-img-button" 
                                                        data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" 
                                                        style="<?= empty($meun_icons_image) ? 'display: none;' : '' ?>">
                                                    &times;
                                                </button>
                                            
                                                <input type="hidden" 
                                                       id="banner_icon_image_<?php echo esc_attr($menu['menuID']); ?>" 
                                                       name="banner_icon_image_<?php echo esc_attr($menu['menuID']); ?>" 
                                                       value="<?= esc_attr($meun_icons_image); ?>">
                                            
                                                <button type="button" 
                                                        class="button upload-menu-icon-img-button" 
                                                        data-menu-id="<?php echo esc_attr($menu['menuID']); ?>">
                                                    <?php _e('Upload Image', 'royal'); ?>
                                                </button>
                                            </td>
                                        </tr>
                                        
                                        <tr class="menu-icon-color-row" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $displayNoneIconSelector ?>">
                                            <th scope="row">
                                                <lable for="royal_myaccount_menu_icon_color_<?php echo esc_attr($menu['menuID']); ?>"><?php _e( 'Menu Icon Color' , 'royal' ); ?>
                                                </lable>
                                            </th>

                                            <td> 
                                                <input type="text" class="royal-myaccount-color-picker" data-default-color="#3f4064" value="<?= $MyAccountIconColor ?>" id="royal_myaccount_menu_icon_color_<?php echo esc_attr($menu['menuID']); ?>" name="royal_myaccount_menu_icon_color_<?php echo esc_attr($menu['menuID']); ?>" />
                                            </td>
                                        </tr>
                                        
                                        <tr class="menu-icon-type-row" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $displayNoneIconSelector ?>">
                                            <th scope="row">
                                                <label for="royal_myaccount_menu_icon_<?php echo esc_attr($menu['menuID']); ?>"><?php _e('Select Menu Icon', 'royal'); ?></label>
                                            </th>
                                            <td>
                                                <div class="dashicons-grid">
                                                    <?php
                                                    $dashicons = [
                                                        'dashicons-menu',
                                                        'dashicons-admin-site',
                                                        'dashicons-dashboard',
                                                        'dashicons-admin-media',
                                                        'dashicons-admin-page',
                                                        'dashicons-admin-comments',
                                                        'dashicons-admin-appearance',
                                                        'dashicons-admin-plugins',
                                                        'dashicons-admin-users',
                                                        'dashicons-admin-tools',
                                                        'dashicons-admin-settings',
                                                        'dashicons-admin-network',
                                                        'dashicons-admin-generic',
                                                        'dashicons-admin-home',
                                                        'dashicons-admin-collapse',
                                                        'dashicons-filter',
                                                        'dashicons-admin-customizer',
                                                        'dashicons-admin-multisite',
                                                        'dashicons-welcome-write-blog',
                                                        'dashicons-welcome-add-page',
                                                        'dashicons-welcome-view-site',
                                                        'dashicons-welcome-widgets-menus',
                                                        'dashicons-welcome-comments',
                                                        'dashicons-welcome-learn-more',
                                                        'dashicons-format-aside',
                                                        'dashicons-format-image',
                                                        'dashicons-format-gallery',
                                                        'dashicons-format-video',
                                                        'dashicons-format-status',
                                                        'dashicons-format-quote',
                                                        'dashicons-format-chat',
                                                        'dashicons-format-audio',
                                                        'dashicons-camera',
                                                        'dashicons-images-alt',
                                                        'dashicons-images-alt2',
                                                        'dashicons-video-alt',
                                                        'dashicons-video-alt2',
                                                        'dashicons-video-alt3',
                                                        'dashicons-shield',
                                                        'dashicons-shield-alt',
                                                        'dashicons-sos',
                                                        'dashicons-search',
                                                        'dashicons-analytics',
                                                        'dashicons-chart-pie',
                                                        'dashicons-chart-bar',
                                                        'dashicons-chart-line',
                                                        'dashicons-chart-area',
                                                        'dashicons-groups',
                                                        'dashicons-businessman',
                                                        'dashicons-id',
                                                        'dashicons-id-alt',
                                                        'dashicons-products',
                                                        'dashicons-awards',
                                                        'dashicons-forms',
                                                        'dashicons-testimonial',
                                                        'dashicons-portfolio',
                                                        'dashicons-book',
                                                        'dashicons-book-alt',
                                                        'dashicons-download',
                                                        'dashicons-upload',
                                                        'dashicons-migrate',
                                                        'dashicons-backup',
                                                        'dashicons-clock',
                                                        'dashicons-lightbulb',
                                                        'dashicons-microphone',
                                                        'dashicons-desktop',
                                                        'dashicons-laptop',
                                                        'dashicons-tablet',
                                                        'dashicons-smartphone',
                                                        'dashicons-phone',
                                                        'dashicons-index-card',
                                                        'dashicons-carrot',
                                                        'dashicons-building',
                                                        'dashicons-store',
                                                        'dashicons-cart',
                                                        'dashicons-album',
                                                        'dashicons-palmtree',
                                                        'dashicons-tickets-alt',
                                                        'dashicons-bank',
                                                        'dashicons-smiley',
                                                        'dashicons-thumbs-up',
                                                        'dashicons-thumbs-down',
                                                        'dashicons-layout',
                                                        'dashicons-paperclip',
                                                        'dashicons-email',
                                                        'dashicons-email-alt',
                                                        'dashicons-networking',
                                                        'dashicons-location',
                                                        'dashicons-location-alt',
                                                        'dashicons-calendar',
                                                        'dashicons-calendar-alt',
                                                        'dashicons-visibility',
                                                        'dashicons-hidden',
                                                        'dashicons-post-status',
                                                        'dashicons-edit',
                                                        'dashicons-trash',
                                                        'dashicons-sticky',
                                                        'dashicons-external',
                                                        'dashicons-lock',
                                                        'dashicons-unlock',
                                                        'dashicons-randomize',
                                                        'dashicons-list-view',
                                                        'dashicons-excerpt-view',
                                                        'dashicons-grid-view',
                                                        'dashicons-no',
                                                        'dashicons-plus',
                                                        'dashicons-plus-alt',
                                                        'dashicons-plus-alt2',
                                                        'dashicons-minus',
                                                        'dashicons-dismiss',
                                                        'dashicons-marker',
                                                        'dashicons-info',
                                                        'dashicons-warning',
                                                        'dashicons-share',
                                                        'dashicons-share-alt',
                                                        'dashicons-share-alt2',
                                                        'dashicons-networking',
                                                        'dashicons-hammer',
                                                        'dashicons-art',
                                                        'dashicons-performance',
                                                        'dashicons-universal-access',
                                                        'dashicons-universal-access-alt',
                                                        'dashicons-tickets',
                                                        'dashicons-nametag',
                                                        'dashicons-clipboard',
                                                        'dashicons-heart',
                                                        'dashicons-megaphone',
                                                        'dashicons-schedule',
                                                        'dashicons-tide',
                                                        'dashicons-exit',
                                                        'dashicons-rest-api',
                                                        'dashicons-editor-bold',
                                                        'dashicons-editor-italic',
                                                        'dashicons-editor-ul',
                                                        'dashicons-editor-ol-rtl',
                                                        'dashicons-editor-quote',
                                                        'dashicons-editor-alignleft',
                                                        'dashicons-editor-aligncenter',
                                                        'dashicons-editor-alignright',
                                                        'dashicons-editor-insertmore',
                                                        'dashicons-editor-spellcheck',
                                                        'dashicons-editor-expand',
                                                        'dashicons-editor-contract',
                                                        'dashicons-editor-kitchensink',
                                                        'dashicons-editor-underline',
                                                        'dashicons-editor-justify',
                                                        'dashicons-editor-textcolor',
                                                        'dashicons-editor-paste-word',
                                                        'dashicons-editor-paste-text',
                                                        'dashicons-editor-video',
                                                        'dashicons-editor-customchar',
                                                        'dashicons-editor-outdent',
                                                        'dashicons-editor-indent',
                                                        'dashicons-editor-help',
                                                        'dashicons-editor-unlink',
                                                        'dashicons-editor-rtl',
                                                        'dashicons-editor-break',
                                                        'dashicons-editor-code',
                                                        'dashicons-editor-paragraph',
                                                        'dashicons-align-left',
                                                        'dashicons-align-right',
                                                        'dashicons-align-center',
                                                        'dashicons-align-none',
                                                        'dashicons-lock',
                                                        'dashicons-unlock',
                                                        'dashicons-calendar-alt',
                                                        'dashicons-controls-play',
                                                        'dashicons-controls-pause',
                                                        'dashicons-controls-forward',
                                                        'dashicons-controls-skipforward',
                                                        'dashicons-controls-back',
                                                        'dashicons-controls-skipback',
                                                        'dashicons-controls-repeat',
                                                        'dashicons-controls-volumeon',
                                                        'dashicons-controls-volumeoff',
                                                        'dashicons-image-crop',
                                                        'dashicons-image-rotate',
                                                        'dashicons-image-rotate-left',
                                                        'dashicons-image-rotate-right',
                                                        'dashicons-image-flip-vertical',
                                                        'dashicons-image-flip-horizontal',
                                                        'dashicons-image-filter',
                                                        'dashicons-undo',
                                                        'dashicons-redo',
                                                        'dashicons-edit-large',
                                                        'dashicons-translation',
                                                        'dashicons-cloud',
                                                        'dashicons-cloud-upload',
                                                        'dashicons-flag',
                                                        'dashicons-chart-pie',
                                                        'dashicons-star-filled',
                                                        'dashicons-star-half',
                                                        'dashicons-star-empty',
                                                        'dashicons-ellipsis',
                                                        'dashicons-arrow-left-alt',
                                                        'dashicons-arrow-down-alt',
                                                        'dashicons-arrow-up-alt',
                                                        'dashicons-arrow-right-alt',
                                                        'dashicons-instagram',
                                                        'dashicons-pinterest',
                                                        'dashicons-linkedin',
                                                        'dashicons-youtube',
                                                        'dashicons-whatsapp',
                                                        'dashicons-twitter',
                                                        'dashicons-rss',
                                                        'dashicons-facebook',
                                                        'dashicons-facebook-alt',
                                                        'dashicons-googleplus',
                                                    ];

                                                    $selected_icon = isset($menusSettingData['royal_myaccount_menu_icon']) ? $menusSettingData['royal_myaccount_menu_icon'] : 'dashicons-admin-generic';

                                                    foreach ($dashicons as $icon) {
                                                        echo '<span class="dashicons ' . esc_attr($icon) . ' icon-option ' . ($selected_icon == $icon ? 'selected' : '') . '" data-icon="' . esc_attr($icon) . '"></span>';
                                                    }
                                                    ?>
                                                </div>
                                                <input type="hidden" name="royal_myaccount_menu_icon_<?php echo esc_attr($menu['menuID']); ?>" id="royal_myaccount_menu_icon_<?php echo esc_attr($menu['menuID']); ?>" class="selected-icon-input" value="<?php echo esc_attr($selected_icon); ?>">
                                            </td>
                                        </tr>
                                        
                                        <tr class="menu-orders-status-tabs order-top-menus" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $Orders_Tabs_Display_Status ?>">
                                            <th scope="row">
                                            <lable for="iravada_royal_myaccount_status"><?php _e( 'Active / Deactive Processing menu' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td>
                                                <div class="can-toggle">
                                                    <input type="checkbox" name="royal_myaccount_proccessing_tab_status_<?= esc_attr($menu['menuID']) ?>" id="royal_active_processing_tab_<?= esc_attr($menu['menuID']) ?>" <?php checked( 'no' , $MyAccountProccessingTabStatus ); ?> >
                                                    <label for="royal_active_processing_tab_<?= esc_attr($menu['menuID']) ?>">
                                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                                    </label>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs proccessing-tab" data-menu-id="<?= esc_attr($menu['menuID']); ?>" style="<?= $DisplayProccessingTab ?>">
                                            <th scope="row">
                                            <lable for="iravada_royal_myaccount_status"><?php _e( 'Processing menu Name' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td> 
                                                <input type="text" class="royal-myaccount-input-option" placeholder="<?php _e( 'Processing' , 'royal' ); ?>" value="<?= isset( $menusSettingData['royal_proccessing_tab_name'] ) ? $menusSettingData['royal_proccessing_tab_name'] : ''; ?>" id="royal_myaccount_proccessing_tab_name_<?= esc_attr($menu['menuID']); ?>" name="royal_myaccount[royal_myaccount_proccessing_tab_name]" />
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs proccessing-tab" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $DisplayProccessingTab ?>">
                                            <th scope="row">
                                                <lable for="order_awaiting_review_<?= esc_attr($menu['menuID']); ?>"><?php _e( 'Processing menu states' , 'royal' ); ?>
                                                    <p class="description"><?php _e( 'Select WooCommerce order statuses for the Processing menu.' , 'royal' ); ?></p>
                                                </lable>
                                            </th>
                                            <td> 
                                                <div class="custom-multiselect" id="custom_multiselect_processing_<?php echo esc_attr($menu['menuID']); ?>">
                                                    <input type="hidden" name="woo_order_status_multiselect_processing_<?php echo esc_attr($menu['menuID']); ?>" class="selected-values" value="<?= isset( $menusSettingData['order_awaiting_review_statuses'] ) ? $menusSettingData['order_awaiting_review_statuses'] : '' ?>">
                                                    <div class="selected-items" id="selected_items_<?php echo esc_attr($menu['menuID']); ?>"><?= $this->royal_show_status_items($awaiting_review_statuses, $order_statuses); ?></div>
                                                    <div class="dropdown" id="dropdown_<?php echo esc_attr($menu['menuID']); ?>">
                                                        <?php
                                                            $statuses = wc_get_order_statuses(); // همه وضعیت‌ها
                                                            $selected_statuses = array_merge(
                                                                $awaiting_review_statuses,
                                                                $completed_statuses,
                                                                $refunded_statuses,
                                                                $cancelled_statuses
                                                            );
                                                            foreach ($statuses as $status_key => $status_label) {
                                                                // بررسی می‌کنیم وضعیت انتخاب شده است یا نه
                                                                $is_selected = in_array($status_key, $selected_statuses);
                                                                ?>
                                                                <div class="option <?php echo $is_selected ? 'disabled' : 'enabled'; ?>" data-value="<?php echo esc_attr($status_key); ?>">
                                                                    <?php echo esc_html($status_label); ?>
                                                                </div>
                                                                <?php
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                                <p style="color:red" class="description">الزامی. حتما وضعیت های مورد نیاز را انتخاب کنید.</p>
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs order-top-menus" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $Orders_Tabs_Display_Status ?>">
                                            <th scope="row">
                                            <lable for="iravada_royal_myaccount_status"><?php _e( 'Active / Deactive Completed Menu' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td> 
                                                <div class="can-toggle">
                                                    <input type="checkbox" name="royal_myaccount_complated_tab_status_<?= esc_attr($menu['menuID']) ?>" id="royal_active_complated_tab_<?= esc_attr($menu['menuID']) ?>" <?php checked( 'no' , $MyAccountComplatedTabStatus ); ?> >
                                                    <label for="royal_active_complated_tab_<?= esc_attr($menu['menuID']) ?>">
                                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                                    </label>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs complated-tab" data-menu-id="<?= esc_attr($menu['menuID']); ?>" style="<?= $DisplayComplatedTab ?>">
                                            <th scope="row">
                                            <lable for="iravada_royal_myaccount_status"><?php _e( 'Completed Menu Name' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td> 
                                                <input type="text" class="royal-myaccount-input-option" placeholder="<?php _e( 'Completed' , 'royal' ); ?>" value="<?= isset( $menusSettingData['royal_complated_tab_name'] ) ? $menusSettingData['royal_complated_tab_name'] : ''; ?>" id="royal_myaccount_complated_tab_name_<?= esc_attr($menu['menuID']); ?>" name="royal_myaccount[royal_myaccount_complated_tab_name]" />
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs complated-tab" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $DisplayComplatedTab ?>">
                                            <th scope="row">
                                                <lable for="order_awaiting_review_<?= esc_attr($menu['menuID']); ?>"><?php _e( 'Completed menu states' , 'royal' ); ?>
                                                    <p class="description"><?php _e( 'Selecting WooCommerce order statuses for the completed menu.' , 'royal' ); ?></p>
                                                </lable>
                                            </th>
                                            <td> 
                                                <div class="custom-multiselect" id="custom_multiselect_completed_<?php echo esc_attr($menu['menuID']); ?>">
                                                    <input type="hidden" name="woo_order_status_multiselect_completed_<?php echo esc_attr($menu['menuID']); ?>" class="selected-values" value="<?= isset( $menusSettingData['order_completed_statuses'] ) ? $menusSettingData['order_completed_statuses'] : '' ?>">
                                                    <div class="selected-items" id="selected_items_<?php echo esc_attr($menu['menuID']); ?>"><?= $this->royal_show_status_items($completed_statuses, $order_statuses); ?></div>
                                                    <div class="dropdown" id="dropdown_<?php echo esc_attr($menu['menuID']); ?>">
                                                        <?php
                                                            $statuses = wc_get_order_statuses(); // همه وضعیت‌ها
                                                            $selected_statuses = array_merge(
                                                                $awaiting_review_statuses,
                                                                $completed_statuses,
                                                                $refunded_statuses,
                                                                $cancelled_statuses
                                                            );
                                                            foreach ($statuses as $status_key => $status_label) {
                                                                // بررسی می‌کنیم وضعیت انتخاب شده است یا نه
                                                                $is_selected = in_array($status_key, $selected_statuses);
                                                                ?>
                                                                <div class="option <?php echo $is_selected ? 'disabled' : 'enabled'; ?>" data-value="<?php echo esc_attr($status_key); ?>">
                                                                    <?php echo esc_html($status_label); ?>
                                                                </div>
                                                                <?php
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                                <p style="color:red" class="description">الزامی. حتما وضعیت های مورد نیاز را انتخاب کنید.</p>
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs order-top-menus" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $Orders_Tabs_Display_Status ?>">
                                            <th scope="row">
                                            <lable for="iravada_royal_myaccount_status"><?php _e( 'Active / Deactive Refunded Menu' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td> 
                                                <div class="can-toggle">
                                                    <input type="checkbox" name="royal_myaccount_refunded_tab_status_<?= esc_attr($menu['menuID']) ?>" id="royal_active_refunded_tab_<?= esc_attr($menu['menuID']) ?>" <?php checked( 'no' , $MyAccountRefundedTabStatus ); ?> >
                                                    <label for="royal_active_refunded_tab_<?= esc_attr($menu['menuID']) ?>">
                                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                                    </label>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs refunded-tab" data-menu-id="<?= esc_attr($menu['menuID']); ?>" style="<?= $DisplayRefundedTab ?>">
                                            <th scope="row">
                                                <lable for="iravada_royal_myaccount_status"><?php _e( 'Refunded Menu Name' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td> 
                                                <input type="text" class="royal-myaccount-input-option" placeholder="<?php _e( 'Refunded' , 'royal' ); ?>" value="<?= isset( $menusSettingData['royal_refunded_tab_name'] ) ? $menusSettingData['royal_refunded_tab_name'] : ''; ?>" id="royal_myaccount_refunded_tab_name_<?= esc_attr($menu['menuID']); ?>" name="royal_myaccount[royal_myaccount_complated_tab_name]" />
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs refunded-tab" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $DisplayRefundedTab ?>">
                                            <th scope="row">
                                                <lable for="order_awaiting_review_<?= esc_attr($menu['menuID']); ?>"><?php _e( 'Refunded menu states' , 'royal' ); ?>
                                                    <p class="description"><?php _e( 'Selecting WooCommerce order statuses for the Refunded menu.' , 'royal' ); ?></p>
                                                </lable>
                                            </th>
                                            <td> 
                                                <div class="custom-multiselect" id="custom_multiselect_refunded_<?php echo esc_attr($menu['menuID']); ?>">
                                                    <input type="hidden" name="woo_order_status_multiselect_refunded_<?php echo esc_attr($menu['menuID']); ?>" class="selected-values" value="<?= isset( $menusSettingData['order_refunded_statuses'] ) ? $menusSettingData['order_refunded_statuses'] : '' ?>">
                                                    <div class="selected-items" id="selected_items_<?php echo esc_attr($menu['menuID']); ?>"><?= $this->royal_show_status_items($refunded_statuses, $order_statuses); ?></div>
                                                    <div class="dropdown" id="dropdown_<?php echo esc_attr($menu['menuID']); ?>">
                                                        <?php
                                                            $statuses = wc_get_order_statuses(); // همه وضعیت‌ها
                                                            $selected_statuses = array_merge(
                                                                $awaiting_review_statuses,
                                                                $completed_statuses,
                                                                $refunded_statuses,
                                                                $cancelled_statuses
                                                            );
                                                            foreach ($statuses as $status_key => $status_label) {
                                                                // بررسی می‌کنیم وضعیت انتخاب شده است یا نه
                                                                $is_selected = in_array($status_key, $selected_statuses);
                                                                ?>
                                                                <div class="option <?php echo $is_selected ? 'disabled' : 'enabled'; ?>" data-value="<?php echo esc_attr($status_key); ?>">
                                                                    <?php echo esc_html($status_label); ?>
                                                                </div>
                                                                <?php
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                                <p style="color:red" class="description">الزامی. حتما وضعیت های مورد نیاز را انتخاب کنید.</p>
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs order-top-menus" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $Orders_Tabs_Display_Status ?>">
                                            <th scope="row">
                                            <lable for="iravada_royal_myaccount_status"><?php _e( 'Active / Deactive Canceled Menu' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td> 
                                                <div class="can-toggle">
                                                    <input type="checkbox" name="royal_myaccount_cancelled_tab_status_<?= esc_attr($menu['menuID']) ?>" id="royal_active_cancelled_tab_<?= esc_attr($menu['menuID']) ?>" <?php checked( 'no' , $MyAccountCancelledTabStatus ); ?> >
                                                    <label for="royal_active_cancelled_tab_<?= esc_attr($menu['menuID']) ?>">
                                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                                    </label>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs cancelled-tab" data-menu-id="<?= esc_attr($menu['menuID']); ?>" style="<?= $DisplayCancelledTab ?>">
                                            <th scope="row">
                                                <lable for="iravada_royal_myaccount_status"><?php _e( 'Canceled Menu Name' , 'royal' ); ?>
                                                </lable>
                                            </th>
                                            <td> 
                                                <input type="text" class="royal-myaccount-input-option" placeholder="<?php _e( 'Canceled' , 'royal' ); ?>" value="<?= isset( $menusSettingData['royal_cancelled_tab_name'] ) ? $menusSettingData['royal_cancelled_tab_name'] : ''; ?>" id="royal_myaccount_cancelled_tab_name_<?= esc_attr($menu['menuID']); ?>" name="royal_myaccount[royal_myaccount_complated_tab_name]" />
                                            </td>
                                        </tr>
                                        <tr class="menu-orders-status-tabs cancelled-tab" data-menu-id="<?php echo esc_attr($menu['menuID']); ?>" style="<?= $DisplayCancelledTab ?>">
                                            <th scope="row">
                                                <lable for="order_awaiting_review_<?= esc_attr($menu['menuID']); ?>"><?php _e( 'Canceled Menu states' , 'royal' ); ?>
                                                    <p class="description"><?php _e( 'Select WooCommerce order statuses for the canceled menu.' , 'royal' ); ?></p>
                                                </lable>
                                            </th>
                                            <td> 
                                                <div class="custom-multiselect" id="custom_multiselect_cancelled_<?php echo esc_attr($menu['menuID']); ?>">
                                                    <input type="hidden" name="woo_order_status_multiselect_cancelled_<?php echo esc_attr($menu['menuID']); ?>" class="selected-values" value="<?= isset( $menusSettingData['order_cancelled_statuses'] ) ? $menusSettingData['order_cancelled_statuses'] : '' ?>">
                                                    <div class="selected-items" id="selected_items_<?php echo esc_attr($menu['menuID']); ?>"><?= $this->royal_show_status_items($cancelled_statuses, $order_statuses); ?></div>
                                                    <div class="dropdown" id="dropdown_<?php echo esc_attr($menu['menuID']); ?>">
                                                        <?php
                                                            $statuses = wc_get_order_statuses(); // همه وضعیت‌ها
                                                            $selected_statuses = array_merge(
                                                                $awaiting_review_statuses,
                                                                $completed_statuses,
                                                                $refunded_statuses,
                                                                $cancelled_statuses
                                                            );
                                                            foreach ($statuses as $status_key => $status_label) {
                                                                // بررسی می‌کنیم وضعیت انتخاب شده است یا نه
                                                                $is_selected = in_array($status_key, $selected_statuses);
                                                                ?>
                                                                <div class="option <?php echo $is_selected ? 'disabled' : 'enabled'; ?>" data-value="<?php echo esc_attr($status_key); ?>">
                                                                    <?php echo esc_html($status_label); ?>
                                                                </div>
                                                                <?php
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                                <p style="color:red" class="description">الزامی. حتما وضعیت های مورد نیاز را انتخاب کنید.</p>
                                            </td>
                                        </tr>
                                    </table>

                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        
                        <div class="save-menu">
                            <button id="save-menu-settings" class="button-primary myaccount-save-setting-btn" style="width: max-content;" class="button-primary">ذخیره تنظیمات</button>
                        </div>
                    </div>

                </div>
                <?php
        
            ?></div><?php

        }

        public function LoadAdminScripts() {

            if( isset($_GET['page']) && $_GET['page'] == 'royal_my_account' ) {

                wp_enqueue_style('wp-jquery-ui-dialog');
                wp_enqueue_style('editor-buttons');
            
                wp_enqueue_script(
                    'royal-myaccount-admin-script',
                    $this->RoyalMyAccount_Js_Url . '/royal-myaccount-admin-script.js',
                    array('jquery', 'wp-color-picker', 'wpdialogs'),
                    '1.0',
                    true
                );
            
                wp_enqueue_style(
                    'royal-myaccount-admin-style',
                    $this->RoyalMyAccount_Css_Url . '/royal-myaccount-admin-style.css',
                    '',
                    '1.0'
                );

                if (!function_exists('WC')) return; // اگر ووکامرس فعال نیست، خروج کن

                $selected_pages = [
                    'dashboard'       => 'داشبورد',
                    'orders'          => 'سفارش‌ها',
                    'downloads'       => 'دانلودها',
                    'edit-address'    => 'آدرس‌',
                    'edit-account'    => 'ویرایش حساب',
                    'customer-logout' => 'خروج از سیستم'
                ];
            
                $pages_with_slugs = [];
                $pages_with_slugs[] = ['slug' => 'custom', 'label' => 'صفحه سفارشی'];
                
                /*foreach ($selected_pages as $slug => $label) {
                    $woo_slug = get_option("woocommerce_{$slug}_endpoint", $slug);
                    $pages_with_slugs[] = ['slug' => $woo_slug, 'label' => $label];
                }*/
                foreach ($selected_pages as $slug => $label) {
                    $pages_with_slugs[] = ['slug' => $slug, 'label' => $label]; // همیشه کلید ثابت ($slug) را ارسال کن
                }
            
                // افزودن گزینه "صفحه سفارشی"
                
                // Localize Data For royal-myaccount-admin-script
                wp_localize_script( 'royal-myaccount-admin-script', 'admin_localized_data', array(
                    'ajax_url' => admin_url('admin-ajax.php'),
                    'myAccountMenus' => $pages_with_slugs
                ) );

                wp_enqueue_style('wp-block-library'); // استایل‌های پیش‌فرض وردپرس
                wp_enqueue_style('editor-buttons'); // دکمه‌های ویرایشگر
            }

        }

    }new Royal_MyAccount_Admin_Content();

}
