<?php 

if( !class_exists('Royal_MyAccount_Querys') ) {

    class Royal_MyAccount_Querys {
        
        public function __construct() {
            $this->CreateRoyalMyAccountDataBase();
        }  
		
		// ایجاد دیتابیس
        public function CreateRoyalMyAccountDataBase() {
            
            global $wpdb;
            $table_name         = $wpdb->prefix . "royal_myaccount"; 
            $charset_collate    = $wpdb->get_charset_collate();
        
            $sql = "CREATE TABLE $table_name (
                id INT(10) NOT NULL AUTO_INCREMENT,
                menuID INT(10) NOT NULL,
                menuName VARCHAR(150) NOT NULL,
                menusSettingData TEXT NOT NULL,
                menuContent TEXT NOT NULL,
                menuSlug VARCHAR(90) NOT NULL,
                menuSort INT NOT NULL,
                PRIMARY KEY  (id)
            ) $charset_collate;";
                
            require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
            dbDelta( $sql );
        }		
		
         // دریافت محتوای منو بر اساس menuSlug
        public static function getMenuContentBySlug($slug) {

            global $wpdb;
            $table_name = $wpdb->prefix . "royal_myaccount";
            
            // دریافت محتوا بر اساس menuSlug
            $menuContent = $wpdb->get_var($wpdb->prepare("SELECT menuContent FROM $table_name WHERE menuSlug = %s", $slug));
            
            // در صورتی که محتوایی وجود داشته باشد، آن را برمی‌گرداند
            return $menuContent ? $menuContent : null;            
        }

         // درج داده در دیتابیس و بازگردانی menuID
        public static function insertMenu($menuName) {

            global $wpdb;
            $table_name = $wpdb->prefix . 'royal_myaccount';
        
            // دریافت آخرین مقدار menuSort
            $last_sort = $wpdb->get_var("SELECT MAX(menuSort) FROM $table_name");
            $new_sort = ($last_sort !== null) ? $last_sort + 1 : 1; // اگر مقدار null بود، مقدار 1 بده
        
             // دریافت آخرین مقدار menuID
            $last_menuID = $wpdb->get_var("SELECT MAX(CAST(menuID AS UNSIGNED)) FROM $table_name");
            $new_menuID = $last_menuID ? $last_menuID + 1 : 1;
            
            $menuDefaultSetting = 'a:19:{s:25:"royal_myaccount_menu_type";s:4:"text";s:30:"royal_myaccount_menu_icon_type";s:4:"icon";s:30:"royal_myaccount_menu_image_url";s:0:"";s:36:"royal_myaccount_menu_item_image_icon";s:0:"";s:25:"royal_myaccount_menu_icon";s:23:"dashicons-admin-generic";s:31:"royal_myaccount_menu_icon_color";s:7:"#3f4064";s:27:"royal_myaccount_banner_link";s:0:"";s:30:"order_awaiting_review_statuses";s:0:"";s:24:"order_completed_statuses";s:0:"";s:23:"order_refunded_statuses";s:0:"";s:24:"order_cancelled_statuses";s:0:"";s:28:"royal_proccessing_tab_status";s:3:"yes";s:26:"royal_proccessing_tab_name";s:0:"";s:26:"royal_complated_tab_status";s:3:"yes";s:24:"royal_complated_tab_name";s:0:"";s:25:"royal_refunded_tab_status";s:3:"yes";s:23:"royal_refunded_tab_name";s:0:"";s:26:"royal_cancelled_tab_status";s:3:"yes";s:24:"royal_cancelled_tab_name";s:0:"";}';

            // وارد کردن منوی جدید با مقدار menuSort
            $wpdb->insert(
                $table_name,
                [
                    'menuName'  => $menuName,
                    'menuID'      => $new_menuID,
                    'menusSettingData' => $menuDefaultSetting,
                    'menuSort'  => $new_sort, // مقدار جدید menuSort
                ],
                ['%s', '%d', '%s', '%d']
            );
        
            return $new_menuID; // برگرداندن ID منوی جدید
        }

         // دریافت تمام داده‌ها
        /*public static function getAllMenus() {
            global $wpdb;
            $table_name = $wpdb->prefix . "royal_myaccount";
            
            $results = $wpdb->get_results("SELECT * FROM $table_name ORDER BY menuSort ASC", ARRAY_A); // اضافه کردن آرگومان ARRAY_A برای دریافت به صورت آرایه‌ها
            
            if (!$results) {
                return []; // اگر دیتابیس خالی است، یک آرایه خالی برگردان
            }
            
            return $results;
        }*/
        
        public static function getAllMenus() {
            // ابتدا بررسی کن آیا نتیجه در حافظه موقت (کش) وجود دارد یا خیر
            $cached_menus = get_transient('royal_myaccount_all_menus_cache');
            if (false !== $cached_menus) {
                return $cached_menus;
            }
        
            // اگر در کش نبود، کوئری را اجرا کن
            global $wpdb;
            $table_name = $wpdb->prefix . "royal_myaccount";
            
            $results = $wpdb->get_results("SELECT * FROM $table_name ORDER BY menuSort ASC", ARRAY_A);
            
            if (!$results) {
                $results = []; // همیشه یک آرایه برگردان
            }
        
            // نتیجه را در حافظه موقت برای 12 ساعت ذخیره کن
            set_transient('royal_myaccount_all_menus_cache', $results, 24 * HOUR_IN_SECONDS);
            
            return $results;
        }

         // دریافت یک منو بر اساس ID
        public static function getMenuById($id) {
            global $wpdb;
            $table_name = $wpdb->prefix . "royal_myaccount";
            return $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id));
        }

         // به‌روزرسانی یک منو
        public static function updateMenuName($menuID, $colName, $menuName) {
            global $wpdb;
            $table_name = $wpdb->prefix . "royal_myaccount";
        
            $updated = $wpdb->update(
                $table_name,
                [
                    $colName => $menuName
                ],
                ['menuID' => (int) $menuID],
                '%s',
                '%d'
            );
        
            return $updated;
        }

         // حذف یک منو بر اساس ID
        public static function deleteMenu($id) {
            global $wpdb;
            $table_name = $wpdb->prefix . "royal_myaccount";
            return $wpdb->delete($table_name, ['menuID' => $id], ['%d']);
        }
    }

    new Royal_MyAccount_Querys();
}
