<?php
if( !class_exists('Royal_Woo_MyAccount') ) {

    class Royal_Woo_MyAccount {
        
        protected $RoyalMyAccount_Css_Url = '';
        protected $RoyalMyAccount_Js_Url = '';
        protected $RoyalMyAccount_Inc = '';
        protected $RoyalMyAccount_Assets = '';
        
        public function __construct() {
            
            $this->RoyalMyAccount_Css_Url       = get_stylesheet_directory_uri() . '/includes/royal-myaccount/assets/css';
            $this->RoyalMyAccount_Js_Url        = get_stylesheet_directory_uri() . '/includes/royal-myaccount/assets/js';
            $this->RoyalMyAccount_Inc           = get_stylesheet_directory() . '/includes/royal-myaccount/inc';
            $this->RoyalMyAccount_Assets        = get_stylesheet_directory_uri() . '/includes/royal-myaccount/Assets';
            
            $GetMyAccountStyles = Royal_Option_Functions::get_royal_option_settings();
            
            add_action('wp_enqueue_scripts', [$this, 'royal_myaccount_front_script']);
            
            add_action('init', [$this, 'add_custom_myaccount_endpoints']);
            add_filter('woocommerce_get_query_vars', [$this, 'add_myaccount_query_vars']);
            
            if( is_array($GetMyAccountStyles) && isset($GetMyAccountStyles['royal_myaccount_status']) && $GetMyAccountStyles['royal_myaccount_status'] == 'yes' ) {
                add_filter( 'woocommerce_locate_template', [$this, 'custom_woocommerce_template'], 10, 3 );
            }
            
            $this->LoadAllFilesNeeded();
        }
        
        public function custom_woocommerce_template( $template, $template_name, $template_path ) {
            $custom_path = get_stylesheet_directory() . '/includes/royal-myaccount/woocommerce/' . $template_name;
            if ( file_exists( $custom_path ) ) {
                return $custom_path;
            }
            return $template;
        }
        
        /*public function add_custom_myaccount_endpoints() {
            
            $GetAllMenus = Royal_MyAccount_Querys::getAllMenus();
            
            foreach ($GetAllMenus as $MyAccountMenus) {
                if (!empty($MyAccountMenus['menuSlug'])) {
                    add_rewrite_endpoint($MyAccountMenus['menuSlug'], EP_ROOT | EP_PAGES);
                }
            }
            
            // فقط یکبار rewrite flush اجرا شود
            if (!get_option('custom_endpoints_flushed')) {
                flush_rewrite_rules();
                update_option('custom_endpoints_flushed', true);
            }
        }*/
        
        
        
        public function add_custom_myaccount_endpoints() {
            
            $GetAllMenus = Royal_MyAccount_Querys::getAllMenus();
        
            // لیست اندپوینت‌های پیش‌فرض ووکامرس که نباید توسط ما ثبت شوند
            $default_wc_endpoints = [
                'orders',
                'view-order',
                'downloads',
                'edit-account',
                'edit-address',
                'payment-methods',
                'customer-logout',
            ];
            
            foreach ($GetAllMenus as $MyAccountMenus) {
                // فقط اگر اسلاگ خالی نبود و جزو اندپوینت‌های پیش‌فرض ووکامرس هم نبود، آن را ثبت کن
                if ( !empty($MyAccountMenus['menuSlug']) && !in_array($MyAccountMenus['menuSlug'], $default_wc_endpoints) ) {
                    add_rewrite_endpoint($MyAccountMenus['menuSlug'], EP_ROOT | EP_PAGES);
                }
            }
            
            // فقط یکبار rewrite flush اجرا شود
            if (!get_option('custom_endpoints_flushed')) {
                flush_rewrite_rules();
                update_option('custom_endpoints_flushed', true);
            }
        }
        
        
        /*public function add_myaccount_query_vars($vars) {
            
            $GetAllMenus = Royal_MyAccount_Querys::getAllMenus();
            
            foreach ($GetAllMenus as $MyAccountMenus) {
                if (!empty($MyAccountMenus['menuSlug'])) {
                    $vars[$MyAccountMenus['menuSlug']] = $MyAccountMenus['menuSlug'];
                }
            }
            return $vars;
        }*/
        
        
        public function add_myaccount_query_vars($vars) {
    
            $GetAllMenus = Royal_MyAccount_Querys::getAllMenus();
        
            // لیست کلیدهای پیش‌فرض ووکامرس که نباید توسط ما دوباره اضافه شوند
            $default_wc_endpoints = [
                'orders',
                'view-order',
                'downloads',
                'edit-account',
                'edit-address',
                'payment-methods',
                'customer-logout',
            ];
            
            foreach ($GetAllMenus as $MyAccountMenus) {
                // فقط اگر اسلاگ خالی نبود و جزو اندپوینت‌های پیش‌فرض ووکامرس هم نبود، آن را به عنوان query var اضافه کن
                if ( !empty($MyAccountMenus['menuSlug']) && !in_array($MyAccountMenus['menuSlug'], $default_wc_endpoints) ) {
                    $vars[$MyAccountMenus['menuSlug']] = $MyAccountMenus['menuSlug'];
                }
            }
            return $vars;
        }


        
        // Load All Files
        public function LoadAllFilesNeeded() {
            
            require_once( $this->RoyalMyAccount_Inc . '/royal-myaccount-query.php' );
            require_once( $this->RoyalMyAccount_Inc . '/royal-myaccount-admin.php' );
            
        }
        
        public function royal_myaccount_front_script() {
            
            if (function_exists('is_account_page') && is_account_page()) {
                wp_enqueue_style('dashicons');
                wp_enqueue_script( 'royal-myaccount-front-script', $this->RoyalMyAccount_Js_Url . '/royal-myaccount-front-script.js', array('jquery'), '1.0', true );
                wp_enqueue_style( 'royal-myaccount-front-style', $this->RoyalMyAccount_Css_Url . '/royal-myaccount-front-style.css', '', '1.5' );
            }
        }
        
    }new Royal_Woo_MyAccount();
}
