<?php
// ver 1.0

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$current_user = wp_get_current_user();

if ( class_exists( 'Royal_MyAccount_Querys' ) && method_exists( 'Royal_MyAccount_Querys', 'getAllMenus' ) ) {

    $menus = Royal_MyAccount_Querys::getAllMenus();

    if ( ! empty( $menus ) && is_array( $menus ) ) {
        foreach ( $menus as $menu ) {

            if ( isset($menu['menusSettingData'], $menu['menuSlug']) ) {

                $menusSettingData = maybe_unserialize( $menu['menusSettingData'] );
                $value = isset( $menusSettingData['RoyalMyaccountCustomDashboardShortcode'] ) ? $menusSettingData['RoyalMyaccountCustomDashboardShortcode'] : '';

                if ( $menu['menuSlug'] === 'dashboard' ) {

                    if ( ! empty( $value ) ) {
                        echo do_shortcode( stripslashes($value) );
                    } else {
                        ?>
                        <div class="custom-dashboard-content">
                            <h2 class="avada-woocommerce-myaccount-heading fusion-responsive-typography-calculated" data-fontsize="21" style="--fontSize:21; line-height: 1.8; --minFontSize:21;" data-lineheight="37.8px">داشبورد</h2>
                            <h2>🎉 خوش آمدی <?php echo esc_html( $current_user->display_name ); ?></h2>
                            <p>از اینجا می‌تونی سفارش‌هات رو ببینی، آدرس‌هات رو مدیریت کنی، و اطلاعات حساب‌تو به‌روزرسانی کنی.</p>

                            <ul style="list-style: disc; padding-right: 20px;">
                                <li><a href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>">سفارش‌ها</a></li>
                                <li><a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-address' ) ); ?>">مدیریت آدرس‌ها</a></li>
                                <li><a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-account' ) ); ?>">ویرایش اطلاعات حساب</a></li>
                                <li><a href="<?php echo esc_url( wp_logout_url( get_permalink( wc_get_page_id( 'myaccount' ) ) ) ); ?>">خروج</a></li>
                            </ul>
                        </div>
                        <?php
                    }
                }
            }
        }
    }
}
