<?php 
// ver 1.0

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$current_user = wp_get_current_user();
$current_endpoint = WC()->query->get_current_endpoint();

if( !class_exists('Royal_Woo_MyAccount') ) {
    require_once( get_stylesheet_directory() . '/includes/royal-myaccount/royal-myaccount.php' );
}

$get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

?>

<div class="royal-myaccount-container">
    <a class="mobile-menu-trigger fusion-one-page-text-link" href="#mobile-menu-trigger-target"><i class="fa-bars fas" aria-hidden="true"></i></a>
    <div class="royal-myaccount-layout">
        <div id="mobile-menu-trigger-target" class="royal-myaccount-menu-section">
            <div class="user-data-profile">
                <div class="royal-myaccount-profile-name-edit">
                    <span class="royal-myaccount-display-name">
                        <?php 
                            if ($current_user->exists()) {
                                echo esc_html($current_user->display_name); // نمایش نام کاربر
                            }
                        ?>
                    </span>
                    <span class="royal-myaccount-edit-profile"><a href="<?= wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) ) ?>"><span class="dashicons dashicons-edit icon-option " data-icon="dashicons-edit"></span></a></span>
                </div>
                <div class="royal-myaccount-phone-number">
                    <span class="royal-myaccount-display-phone-number">
                        <?php 

                            // کلید ذخیره‌شده برای شماره موبایل (از usermeta یا option)
                            $selected_meta_key = isset( $get_royal_option_settings['royal_myaccount_mobile_meta_key'] ) ? $get_royal_option_settings['royal_myaccount_mobile_meta_key'] : '';
                            $current_user_id = get_current_user_id();

                            // اگر کلید خالی نباشد
                            if ( $selected_meta_key ) {

                                // مقدار شماره موبایل کاربر را بخوانید
                                $user_phone = get_user_meta( $current_user_id, $selected_meta_key, true );

                                if ( $user_phone ) {
                                    echo esc_html( $user_phone );
                                }

                            }
                            
                        ?>
                    </span>
                </div>
            </div>

            <div class="royal-myaccount-menu-items">
                <ul>
                    <?php 

                        $GetAllMenus = Royal_MyAccount_Querys::getAllMenus();
                    
                        foreach( $GetAllMenus as $MyAccountMenus ) {

                            $menusSettingData = maybe_unserialize($MyAccountMenus['menusSettingData']);
                            $isActive   = '';

                            /*if( $menusSettingData['royal_myaccount_menu_type'] == 'text' ) {

                                if( $MyAccountMenus['menuSlug'] == 'dashboard' && !$current_endpoint ) {
                                    $isActive = 'active';
                                }else {
                                    $isActive = ($current_endpoint === $MyAccountMenus['menuSlug']) ? 'active' : '';
                                }

                                if( $MyAccountMenus['menuSlug'] == 'dashboard' ) {
                                    $MyAccountMenusUrl = wc_get_page_permalink('myaccount'); 
                                }else {
                                    $MyAccountMenusUrl = wc_get_page_permalink('myaccount') . $MyAccountMenus['menuSlug']; 
                                }
                                
                                $ImgStyle = '';

                            }elseif( $menusSettingData['royal_myaccount_menu_type'] == 'banner' ) { */
                            
                            
                            
                            
                            if( $menusSettingData['royal_myaccount_menu_type'] == 'text' ) {

                                // 'dashboard' دوباره به این آرایه اضافه می‌شود تا مانند یک صفحه عادی با آن رفتار شود
                                $standard_wc_pages = [
                                    'orders',
                                    'view-order',
                                    'downloads',
                                    'edit-account',
                                    'edit-address',
                                    'payment-methods',
                                    'customer-logout',
                                    'dashboard'
                                ];
                            
                                // منطق بهینه شده برای تشخیص منوی فعال
                                $isActive = '';
                                // اگر اندپوینت خالی بود و منوی فعلی داشبورد بود، آن را فعال کن
                                if ( ( empty($current_endpoint) && $MyAccountMenus['menuSlug'] == 'dashboard' ) 
                                    // یا اگر اندپوینت فعلی با اسلاگ منو یکی بود، آن را فعال کن
                                    || ( $current_endpoint == $MyAccountMenus['menuSlug'] ) ) {
                                    $isActive = 'active';
                                }
                            
                                // --- منطق بهینه شده برای ساخت URL ---
                                // برای داشبورد و سایر صفحات استاندارد، از یک منطق واحد استفاده می‌کنیم
                                if ( in_array( $MyAccountMenus['menuSlug'], $standard_wc_pages ) ) {
                                    $MyAccountMenusUrl = wc_get_endpoint_url( $MyAccountMenus['menuSlug'], '', wc_get_page_permalink( 'myaccount' ) );
                                } 
                                // برای منوهای کاملا سفارشی
                                else {
                                    $MyAccountMenusUrl = wc_get_endpoint_url( $MyAccountMenus['menuSlug'], '', wc_get_page_permalink('myaccount') );
                                }
                                
                                $ImgStyle = '';
                            
                            }elseif( $menusSettingData['royal_myaccount_menu_type'] == 'banner' ) {
                                
    
                                $ImgStyle = 'style="padding: 0;"';
                            
                                // منطق جدید برای تعیین لینک بنر
                                $banner_link_from_settings = $menusSettingData['royal_myaccount_banner_link'] ?? '';
                            
                                if ( ! empty( trim( $banner_link_from_settings ) ) ) {
                                    // اگر کاربر لینکی وارد کرده بود، از همان استفاده کن
                                    $MyAccountMenusUrl = $banner_link_from_settings;
                                } else {
                                    // در غیر این صورت، از لینک صفحه فروشگاه ووکامرس استفاده کن
                                    $MyAccountMenusUrl = get_permalink( wc_get_page_id( 'shop' ) );
                                }
                            }
                            
                            if( $MyAccountMenus['menuSlug'] == 'customer-logout' ) {
                                $MyAccountMenusUrl = wc_logout_url(home_url('/'));
                            }

                            $GetMyAccountStyles = Royal_Option_Functions::get_royal_option_settings();

                            $GetMenuTextColor = isset($GetMyAccountStyles['royal_myaccount_menu_text_color']) ? $GetMyAccountStyles['royal_myaccount_menu_text_color'] : '#3f4064';
                            $GetMenuTextSize  = isset($GetMyAccountStyles['royal_myaccount_menu_font_size']) ? $GetMyAccountStyles['royal_myaccount_menu_font_size'] : '15px';
                            $GetMenuIconSize  = isset($GetMyAccountStyles['royal_myaccount_menu_icon_size']) ? $GetMyAccountStyles['royal_myaccount_menu_icon_size'] : '20px';

                            if( $menusSettingData['royal_myaccount_menu_type'] == 'banner' ) {
                                $menuisbanner = 'royal-menu-banner';
                            }else {
                                $menuisbanner = '';
                            }
                            
                            if( !empty($MyAccountMenus['menuSlug']) ) {
                               $menuslugclass = 'royal-'.$MyAccountMenus['menuSlug']; 
                            }else {
                                $menuslugclass = '';
                            }
                            
                            // START: کد جدید برای باز شدن لینک در تب جدید
                            $link_target = ''; // برای هر آیتم متغیر را خالی می‌کنیم
                            if( isset($menusSettingData['royal_myaccount_menu_type']) && $menusSettingData['royal_myaccount_menu_type'] == 'banner' ) {
                                $link_target = 'target="_blank" rel="noopener noreferrer"';
                            }
                            // END: کد جدید

                            ?>
                            <li data-id="<?php echo esc_attr($MyAccountMenus['menuID']); ?>" class="royal-myaccount-menu <?= $isActive.' ' ?><?= $menuslugclass.' ' ?><?= $menuisbanner ?>">
                                <a href="<?= $MyAccountMenusUrl ?>" <?= $ImgStyle ?> <?= $link_target ?> >
                                    <div class="royal-myaccount-menu-item" <?= $ImgStyle ?>>
                                        <?php 
                                            if( $menusSettingData['royal_myaccount_menu_type'] == 'text' ) {
                                                ?>
                                                    <div class="royal-myaccount-menu-icon <?= $menusSettingData['royal_myaccount_menu_icon_type'] ?>">
                                                        <?php 
                                                            if( $menusSettingData['royal_myaccount_menu_icon_type'] == 'image' ) {
                                                                ?><img style="width: 100%;" src="<?= $menusSettingData['royal_myaccount_menu_item_image_icon'] ?>" alt=""><?php
                                                            }else {
                                                                ?><span class="dashicons <?= $menusSettingData['royal_myaccount_menu_icon'] ?>" style="font-size:<?= $GetMenuIconSize ?>;color:<?= $menusSettingData['royal_myaccount_menu_icon_color'] ?>;"  data-icon="dashicons-edit"></span><?php
                                                            }
                                                        ?>
                                                    </div>
                                                    <div class="royal-myaccount-menu-text">
                                                        <span class="royal-myaccount-menu-name" style="font-size:<?= $GetMenuTextSize ?>;color:<?= $GetMenuTextColor ?>;" ><?= esc_html($MyAccountMenus['menuName']) ?></span>
                                                    </div>
                                                <?php
                                            }else {
                                                ?>
                                                    <div class="royal-myaccount-menu-banner">
                                                        <img src="<?= $menusSettingData['royal_myaccount_menu_image_url'] ?>" alt="">
                                                    </div>
                                                <?php
                                            }
                                        ?>

                                    </div>
                                </a>
                            </li>
                            <?php
                            
                        }

                    ?>
                </ul>
            </div>
        </div>
        <div class="royal-myaccount-menu-content-section">
            <div class="royal-myaccount-content">
                <?php
                $current_endpoint = WC()->query->get_current_endpoint();
                
                // اگر اندپوینتی در URL نبود، به صورت دستی آن را روی 'dashboard' تنظیم می‌کنیم
                if (empty($current_endpoint)) {
                    $current_endpoint = 'dashboard';
                }
                
                // آرایه صفحات پیش‌فرض که در سوال به آن اشاره کردید
                $selected_pages = [
                    'dashboard'       => 'داشبورد',
                    'orders'          => 'سفارش‌ها',
                    'downloads'       => 'دانلودها',
                    'edit-address'    => 'آدرس‌',
                    'edit-account'    => 'ویرایش حساب',
                ];
                
                // دریافت تمام منوها
                $GetAllMenus = Royal_MyAccount_Querys::getAllMenus();
                $menuFound = false; // بررسی اینکه منو پیدا شده یا نه
                
                foreach ($GetAllMenus as $MyAccountMenus) {
                    if ($current_endpoint == $MyAccountMenus['menuSlug']) {
                        $menuFound = true;
                        $menuContent = $MyAccountMenus['menuContent']; // محتوای منو

                        // چک کردن اینکه آیا اسلاگ در آرایه صفحات پیش‌فرض نیست
                        if (!empty($MyAccountMenus['menuSlug']) && !array_key_exists($MyAccountMenus['menuSlug'], $selected_pages) ) {
                            $menuContent = preg_replace('/\\\\+/', '', $MyAccountMenus['menuContent']);
                            echo do_shortcode($menuContent);
                        } else {
                            // اگر منو یکی از صفحات پیش‌فرض است، سوئیچ به حالت قبلی
                            switch ($current_endpoint) {
                                case 'downloads':
                                    wc_get_template('myaccount/downloads.php');
                                    break;
                                case 'orders':
                                    wc_get_template('myaccount/orders.php');
                                    break;
                                case 'edit-address':
                                    $load_address = get_query_var('edit-address') ? wc_edit_address_i18n(wc_clean(wp_unslash(get_query_var('edit-address')))) : false;
                                
                                    if (!$load_address) {
                                        wc_get_template('myaccount/my-address.php');
                                    } else {
                                        if ('billing' === $load_address) {
                                            $address = apply_filters(
                                                'woocommerce_billing_fields',
                                                WC()->countries->get_address_fields(WC()->customer->get_billing_country(), 'billing_'),
                                                WC()->customer->get_billing_country(),
                                                'billing_'
                                            );
                                        } else {
                                            $address = apply_filters(
                                                'woocommerce_shipping_fields',
                                                WC()->countries->get_address_fields(WC()->customer->get_shipping_country(), 'shipping_'),
                                                WC()->customer->get_shipping_country(),
                                                'shipping_'
                                            );
                                        }
                                
                                        foreach ($address as $key => $field) {
                                            if (empty($field['type'])) {
                                                $field['type'] = 'text';
                                            }
                                            if (empty($field['name'])) {
                                                $field['name'] = $key;
                                            }
                                            if (empty($field['id'])) {
                                                $field['id'] = $key;
                                            }
                                            if (!isset($field['priority'])) {
                                                $field['priority'] = 10;  // مقدار پیش فرض مناسب بذار
                                            }
                                        
                                            $method_name = "get_$key";
                                            if (method_exists(WC()->customer, $method_name)) {
                                                $field['value'] = WC()->customer->$method_name();
                                            } else {
                                                $field['value'] = WC()->customer->get_meta($key);
                                            }
                                        
                                            if (empty($field['label'])) {
                                                $clean_key = preg_replace('/^(billing_|shipping_)/', '', $key);
                                                $field['label'] = ucwords(str_replace('_', ' ', $clean_key));
                                            }
                                        
                                            $address[$key] = $field;
                                        }
                                        
                                        
                                        wc_get_template(
                                            'myaccount/form-edit-address.php',
                                            array(
                                                'load_address' => $load_address,
                                                'address'      => $address,
                                            )
                                        );
                                        
                                    }
                                
                                    break;                 
                                case 'edit-account':
                                    wc_get_template('myaccount/edit-account.php');
                                    break;
                                case 'dashboard': 
                                default:
                                    wc_get_template('myaccount/dashboard.php'); // لود قالب داشبورد در صورت نبودن endpoint
                                    break;
                            }
                        }

                        break;
                    }
                }

                // اگر هیچ منویی یافت نشد، داشبورد پیش‌فرض را نمایش بده
                if (!$menuFound) {

                    // اگر یکی از endpointهای ووکامرس مثل view-order بود، اجازه بده ووکامرس خودش هندل کنه
                    global $wp;
                    $current_wc_endpoint = $wp->query_vars;
                
                    if (isset($current_wc_endpoint['view-order'])) {

                        if (isset($current_wc_endpoint['view-order'])) {

                            $order_id = absint($current_wc_endpoint['view-order']);
                            $order = wc_get_order($order_id);
                        
                            if ($order) {
                                // ارسال متغیر $order به فایل قالب به صورت global
                                global $order_id;
                                wc_get_template('myaccount/view-order.php', ['order' => $order, 'order_id' => $order_id]);
                            } else {
                                echo '<p>سفارش مورد نظر پیدا نشد.</p>';
                            }
                            
                        }                        

                    } else {
                        echo '<div class="royal-myaccount-menu-content">';
                                wc_get_template('myaccount/dashboard.php');
                        echo '</div>';
                    }
                }
                
                ?>
            </div>
        </div>
    </div>
</div>