<?php
// ver 1.0

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$current_user_id = get_current_user_id();

$addresses = array(
    'billing'  => array(
        'title' => 'آدرس صورتحساب',
        'icon'  => '💳',
    ),
    'shipping' => array(
        'title' => 'آدرس گیرنده / ارسال بار',
        'icon'  => '📦',
    ),
);
?>

<div class="woocommerce-addresses-list">
    <?php foreach ( $addresses as $type => $info ) :
        $first_name = get_user_meta( $current_user_id, $type . '_first_name', true );
        $last_name  = get_user_meta( $current_user_id, $type . '_last_name', true );
        $address_1  = get_user_meta( $current_user_id, $type . '_address_1', true );
        $postcode   = get_user_meta( $current_user_id, $type . '_postcode', true );
        $phone      = get_user_meta( $current_user_id, $type . '_phone', true );

        $full_name = trim( $first_name . ' ' . $last_name );
        $has_address = $first_name || $last_name || $address_1 || $postcode || $phone;
        ?>
        
        <div class="royal-edit-address-box">
            <h2><?= esc_html( $info['icon'] . ' ' . $info['title'] ); ?></h2>
            
            <?php if ( $has_address ) : ?>
            
                <p><?= esc_html( $address_1 ); ?></p>
                <p>کد پستی: <?= esc_html( $postcode ); ?></p>
                <p>نام: <?= esc_html( $full_name ); ?></p>
                <p>شماره موبایل: <?= esc_html( $phone ); ?></p>
                
            <?php else : ?>
                <div>هیچ آدرسی برای <?= $type === 'billing' ? 'صورتحساب' : 'ارسال بار'; ?> وارد نشده است.</div>
            <?php endif; ?>
            
            <a href="<?= esc_url( wc_get_endpoint_url( 'edit-address', $type ) ); ?>" class="royal-edit-address-button">ویرایش</a>
        </div>

    <?php endforeach; ?>
</div>
