<?php
// ver 2.0

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="royal-myaccount-orders">
    <div class="search-box">
        <h2 class="royal-orders-title">تاریخچه سفارشات</h2>
    </div>
    
    <div class="tab-header">
        
        <?php 
        
        $current_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
        $user_id = get_current_user_id();
        
        $menusSettingData = '';

        $GetAllMenus = Royal_MyAccount_Querys::getAllMenus();

        foreach( $GetAllMenus as $menu_items ) {

            if( $menu_items['menuSlug'] == 'orders' ) {
                $menusSettingData = maybe_unserialize($menu_items['menusSettingData']);

                if( isset($menusSettingData['order_cancelled_statuses']) && !empty($menusSettingData['order_cancelled_statuses']) ) {
                    $order_cancelled_statuses = array_map('trim', explode(',', $menusSettingData['order_cancelled_statuses']));
                }else {
                    $order_cancelled_statuses = '';
                }
                if( isset($menusSettingData['order_refunded_statuses']) && !empty($menusSettingData['order_refunded_statuses']) ) {
                    $order_refunded_statuses = array_map('trim', explode(',', $menusSettingData['order_refunded_statuses']));
                }else {
                    $order_refunded_statuses = '';
                }
                if( isset($menusSettingData['order_completed_statuses']) && !empty($menusSettingData['order_completed_statuses']) ) {
                    $order_completed_statuses = array_map('trim', explode(',', $menusSettingData['order_completed_statuses']));
                }else {
                    $order_completed_statuses = '';
                }
                if( isset($menusSettingData['order_awaiting_review_statuses']) && !empty($menusSettingData['order_awaiting_review_statuses']) ) {
                    $order_awaiting_review_statuses = array_map('trim', explode(',', $menusSettingData['order_awaiting_review_statuses']));
                }else {
                    $order_awaiting_review_statuses = '';
                }
            }
        }

        $statuses = [];

        if (isset($menusSettingData['royal_proccessing_tab_status']) && $menusSettingData['royal_proccessing_tab_status'] === 'yes') {
            $statuses['processing'] = $menusSettingData['royal_proccessing_tab_name'] ? $menusSettingData['royal_proccessing_tab_name'] : 'جاری';
        }
        
        if (isset($menusSettingData['royal_complated_tab_status']) && $menusSettingData['royal_complated_tab_status'] === 'yes') {
            $statuses['completed'] = $menusSettingData['royal_complated_tab_name'] ? $menusSettingData['royal_complated_tab_name'] : 'تحویل شده';
        }
        
        if (isset($menusSettingData['royal_refunded_tab_status']) && $menusSettingData['royal_refunded_tab_status'] === 'yes') {
            $statuses['refunded'] = $menusSettingData['royal_refunded_tab_name'] ? $menusSettingData['royal_refunded_tab_name'] : 'مرجوع شده';
        }
        
        if (isset($menusSettingData['royal_cancelled_tab_status']) && $menusSettingData['royal_cancelled_tab_status'] === 'yes') {
            $statuses['cancelled'] = $menusSettingData['royal_cancelled_tab_name'] ? $menusSettingData['royal_cancelled_tab_name'] : 'لغو شده';
        }
        
        $current_status = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : 'processing';
        
        foreach ( $statuses as $status_key => $status_label ) {

            if ( $status_key === 'processing' ) {

                if ( ! empty($order_awaiting_review_statuses) ) {
                    $orders = wc_get_orders( [
                        'customer_id' => $user_id,
                        'status'      => $order_awaiting_review_statuses,
                        'return'      => 'ids',
                        'limit'       => -1,
                    ] );
                    $count = count( $orders );
                } else {
                    $orders = [];
                    $count = 0;
                }
                $url = $current_url;

            } elseif($status_key === 'completed') {

                if ( ! empty($order_completed_statuses) ) {
                    $orders = wc_get_orders( [
                        'customer_id' => $user_id,
                        'status'      => $order_completed_statuses,
                        'return'      => 'ids',
                        'limit'       => -1,
                    ] );
                    $count = count( $orders );
                } else {
                    $orders = [];
                    $count = 0;
                }
                $url = add_query_arg( 'status', $status_key, $current_url );

            }elseif($status_key === 'refunded') {

                if ( ! empty($order_refunded_statuses) ) {
                    $orders = wc_get_orders( [
                        'customer_id' => $user_id,
                        'status'      => $order_refunded_statuses,
                        'return'      => 'ids',
                        'limit'       => -1,
                    ] );
                    $count = count( $orders );
                } else {
                    $orders = [];
                    $count = 0;
                }
                $url = add_query_arg( 'status', $status_key, $current_url );

            }elseif($status_key === 'cancelled') {

                if ( ! empty($order_cancelled_statuses) ) {
                    $orders = wc_get_orders( [
                        'customer_id' => $user_id,
                        'status'      => $order_cancelled_statuses,
                        'return'      => 'ids',
                        'limit'       => -1,
                    ] );
                    $count = count( $orders );
                } else {
                    $orders = [];
                    $count = 0;
                }
                $url = add_query_arg( 'status', $status_key, $current_url );
            }
        
            $is_active = ( $current_status === $status_key ) ? 'active' : '';
        
            echo '<div class="tab ' . $is_active . '">
                <a href="' . esc_url( $url ) . '">' .
                    esc_html( $status_label ) .
                    ' <span class="order-status status-' . esc_attr( $status_key ) . '">' . esc_html( $count ) . '</span>
                </a>
            </div>';
        }        
        ?>

    </div>

    <div class="royal-myaccount-order-list">
        <?php

            $svg_icon = '';

            if( isset($_GET['status']) && $_GET['status'] == 'completed' ) {

                $svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 64 64"><circle cx="32" cy="32" r="30" fill="#4CAF50"/><polyline points="20,34 28,42 44,24"fill="none"stroke="#FFFFFF"stroke-width="4"stroke-linecap="round"stroke-linejoin="round"/></svg>';

                if( !empty($order_completed_statuses) ) {
                    $orders = wc_get_orders([
                        'customer_id' => $user_id,
                        'status'      => $order_completed_statuses,
                        'limit'       => -1,
                    ]);
                }else {
                    $orders = [];
                }

            }elseif( isset($_GET['status']) && $_GET['status'] == 'refunded' ) {
                $svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 64 64"><circle cx="32" cy="32" r="30" fill="#555555"/><line x1="22" y1="22" x2="42" y2="42" stroke="#FFFFFF" stroke-width="4" stroke-linecap="round"/><line x1="42" y1="22" x2="22" y2="42" stroke="#FFFFFF" stroke-width="4" stroke-linecap="round"/></svg>';
                
                if( !empty($order_refunded_statuses) ) {
                    $orders = wc_get_orders([
                        'customer_id' => $user_id,
                        'status'      => $order_refunded_statuses,
                        'limit'       => -1,
                    ]);
                }else {
                    $orders = [];
                }

            }elseif( isset($_GET['status']) && $_GET['status'] == 'cancelled' ) {

                $svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 64 64"><circle cx="32" cy="32" r="30" fill="#F44336"/><line x1="20" y1="20" x2="44" y2="44"stroke="#FFFFFF"stroke-width="4"stroke-linecap="round"/><line x1="44" y1="20" x2="20" y2="44"stroke="#FFFFFF"stroke-width="4"stroke-linecap="round"/></svg>';

                if( !empty($order_cancelled_statuses) ) {
                    $orders = wc_get_orders([
                        'customer_id' => $user_id,
                        'status'      => $order_cancelled_statuses,
                        'limit'       => -1,
                    ]);
                }else {
                    $orders = [];
                }

            }elseif( !isset($_GET['status']) ) {

                $svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 64 64"><circle cx="32" cy="32" r="30" fill="#555555"/><line x1="22" y1="22" x2="42" y2="42" stroke="#FFFFFF" stroke-width="4" stroke-linecap="round"/><line x1="42" y1="22" x2="22" y2="42" stroke="#FFFFFF" stroke-width="4" stroke-linecap="round"/></svg>';

                if( !empty($order_awaiting_review_statuses) ) {
                    $orders = wc_get_orders([
                        'customer_id' => $user_id,
                        'status'      => $order_awaiting_review_statuses,
                        'limit'       => -1,
                    ]);
                }else {
                    $orders = [];
                }
            }
            
            if ( empty($orders) ) {
                ?>
                <div class="empty-orders">
                    <svg width="180" height="135" viewBox="0 0 180 135" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g filter="url(#filter0_f)">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M40.5 122.4L41.1767 123.3H98.6944H127.8L98.6944 122.4H40.5Z" fill="url(#paint0_linear)"/>
                    </g>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M61.2 14.4V105.3H123.732C129.458 105.3 134.1 100.658 134.1 94.932V14.4H61.2Z" fill="url(#paint1_linear)"/>
                    <rect width="38.88" height="3.888" transform="matrix(-1 0 0 1 113.58 26.1)" fill="url(#paint2_linear)"/>
                    <rect width="3.88802" height="3.888" transform="matrix(-1 0 0 1 121.356 26.1)" fill="#A1A3A8"/>
                    <rect width="38.88" height="3.888" transform="matrix(-1 0 0 1 113.58 35.172)" fill="url(#paint3_linear)"/>
                    <rect width="3.88802" height="3.888" transform="matrix(-1 0 0 1 121.356 35.172)" fill="#A1A3A8"/>
                    <rect width="38.88" height="3.888" transform="matrix(-1 0 0 1 113.58 44.244)" fill="url(#paint4_linear)"/>
                    <rect width="3.88802" height="3.888" transform="matrix(-1 0 0 1 121.356 44.244)" fill="#A1A3A8"/>
                    <rect width="38.88" height="3.888" transform="matrix(-1 0 0 1 113.58 53.316)" fill="url(#paint5_linear)"/>
                    <rect width="3.88802" height="3.888" transform="matrix(-1 0 0 1 121.356 53.316)" fill="#A1A3A8"/>
                    <rect width="38.88" height="3.888" transform="matrix(-1 0 0 1 113.58 62.388)" fill="url(#paint6_linear)"/>
                    <rect width="3.88802" height="3.888" transform="matrix(-1 0 0 1 121.356 62.388)" fill="#A1A3A8"/>
                    <rect width="38.88" height="3.88801" transform="matrix(-1 0 0 1 113.58 71.46)" fill="url(#paint7_linear)"/>
                    <rect width="3.88802" height="3.88801" transform="matrix(-1 0 0 1 121.356 71.46)" fill="#A1A3A8"/>
                    <rect width="38.88" height="3.88801" transform="matrix(-1 0 0 1 113.58 80.532)" fill="url(#paint8_linear)"/>
                    <rect width="3.88802" height="3.88801" transform="matrix(-1 0 0 1 121.356 80.532)" fill="#A1A3A8"/>
                    <rect width="38.88" height="3.888" transform="matrix(-1 0 0 1 113.58 89.604)" fill="url(#paint9_linear)"/>
                    <rect width="3.88802" height="3.888" transform="matrix(-1 0 0 1 121.356 89.604)" fill="#A1A3A8"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M112.95 91.8H40.5V93.8919C40.5 99.6953 45.2046 104.4 51.0081 104.4H123.3C117.584 104.4 112.95 99.7661 112.95 94.05V91.8Z" fill="url(#paint10_linear)"/>
                    <defs>
                    <filter id="filter0_f" x="37.7817" y="119.682" width="92.7366" height="6.33657" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                    <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                    <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                    <feGaussianBlur stdDeviation="1.35914" result="effect1_foregroundBlur"/>
                    </filter>
                    <linearGradient id="paint0_linear" x1="90.7341" y1="122.139" x2="90.7499" y2="123.679" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#A1A3A8"/>
                    <stop offset="1" stop-color="#C1C3C7"/>
                    </linearGradient>
                    <linearGradient id="paint1_linear" x1="148.663" y1="14.4" x2="148.663" y2="105.3" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#EEEEEE"/>
                    <stop offset="0.894686" stop-color="#DDDDDD"/>
                    <stop offset="1" stop-color="#EDEDED"/>
                    </linearGradient>
                    <linearGradient id="paint2_linear" x1="38.88" y1="1.944" x2="0" y2="1.944" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#C0C2C5"/>
                    <stop offset="1" stop-color="#A1A3A8"/>
                    </linearGradient>
                    <linearGradient id="paint3_linear" x1="38.88" y1="1.944" x2="0" y2="1.944" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#C0C2C5"/>
                    <stop offset="1" stop-color="#A1A3A8"/>
                    </linearGradient>
                    <linearGradient id="paint4_linear" x1="38.88" y1="1.944" x2="0" y2="1.944" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#C0C2C5"/>
                    <stop offset="1" stop-color="#A1A3A8"/>
                    </linearGradient>
                    <linearGradient id="paint5_linear" x1="38.88" y1="1.944" x2="0" y2="1.944" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#C0C2C5"/>
                    <stop offset="1" stop-color="#A1A3A8"/>
                    </linearGradient>
                    <linearGradient id="paint6_linear" x1="38.88" y1="1.944" x2="0" y2="1.944" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#C0C2C5"/>
                    <stop offset="1" stop-color="#A1A3A8"/>
                    </linearGradient>
                    <linearGradient id="paint7_linear" x1="38.88" y1="1.944" x2="0" y2="1.944" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#C0C2C5"/>
                    <stop offset="1" stop-color="#A1A3A8"/>
                    </linearGradient>
                    <linearGradient id="paint8_linear" x1="38.88" y1="1.944" x2="0" y2="1.944" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#C0C2C5"/>
                    <stop offset="1" stop-color="#A1A3A8"/>
                    </linearGradient>
                    <linearGradient id="paint9_linear" x1="38.88" y1="1.944" x2="0" y2="1.944" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#C0C2C5"/>
                    <stop offset="1" stop-color="#A1A3A8"/>
                    </linearGradient>
                    <linearGradient id="paint10_linear" x1="139.841" y1="91.8" x2="139.841" y2="104.4" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#F0F0F1"/>
                    <stop offset="0.678311" stop-color="#E0E0E2"/>
                    <stop offset="1" stop-color="#C0C2C5"/>
                    </linearGradient>
                    </defs>
                    </svg>
                    <p>هنوز هیچ سفارشی ندارید</p>
                </div>
                <?php
                
            } else {

                foreach ( $orders as $order ) {

                    $product_image = '';
                    
                    // اگه مقدار ID هست، آبجکتش رو بگیر
                    if ( is_numeric( $order ) ) {
                        $order = wc_get_order( $order );
                    }
                
                    // اگه هنوز آبجکت معتبر نیست، رد شو
                    if ( ! $order || ! is_a( $order, 'WC_Order' ) ) {
                        continue;
                    }

                    $status = $order->get_status();

                    // تبدیل وضعیت به لیبل قابل نمایش
                    $labels = wc_get_order_statuses();
                    
                    if (isset($labels['wc-' . $status])) {
                        $label = $labels['wc-' . $status]; // مثلا "تکمیل شده"
                    } else {
                        $label = $status; // اگر لیبل وجود نداشت، خود وضعیت خام نمایش داده می‌شود
                    }
                    
                    // شرط وجود سفارش و از نوع ووکامرس
                    if ( $order && is_a( $order, 'WC_Order' ) ) {
                        foreach ( $order->get_items() as $item ) {
                            
                            $product = $item->get_product(); // شیء محصول
                            
                            
                            // بررسی اینکه یک محصول وجود داره یا قبلا وجود داشته و الان حذف شده
                            if ( $product && is_a( $product, 'WC_Product' ) ) {
                                $product_id   = $product->get_id();
                                $product_name = $product->get_name();
                            } else {
                                $product_id   = 0;
                                $product_name = 'محصول ناموجود';
                            }
                            
                            $quantity = $item->get_quantity(); // تعداد خریداری‌شده
                            $total = $item->get_total(); // قیمت کل این آیتم
                            $product_image = $product ? $product->get_image(array(100, 100)) : wc_placeholder_img(array(150, 150));
                        }
                    }
                    
                    
                    // محاسبه مجموع مبلغ اصلی همه محصولات (قبل از تخفیف)
                    $total_regular_price = 0;
                    $total_discounted_price = 0;
                    
                    // شرط وجود سفارش و از نوع ووکامرس
                    if ( $order && is_a( $order, 'WC_Order' ) ) {
                        foreach ( $order->get_items() as $item ) {
                            $product = $item->get_product();
                            if ( ! $product ) continue;
                        
                            $quantity = $item->get_quantity();
                            
                            // $regular_price = $product->get_regular_price(); // قیمت اصلی محصول
                            if ( $product && is_a( $product, 'WC_Product' ) ) {
                                $regular_price = $product->get_regular_price(); // قیمت اصلی محصول درصورت وجود
                            } else {
                                $regular_price = 0;
                            }
                            
                            $line_total = $item->get_total(); // مبلغ واقعی پرداخت‌شده برای این آیتم
                        
                            if ( $regular_price ) {
                                $total_regular_price += $regular_price * $quantity;
                                $total_discounted_price += $line_total;
                            }
                        }
                    }
                    
                    $real_discount = $total_regular_price - $total_discounted_price;
                    $savings = $real_discount > 0 ? wc_price($real_discount) : '';
                    // اتمام تخفیف                    
                    
					$order_date = wp_date( 'j F Y', wc_string_to_timestamp( $order->get_date_created() ) );
                    
                    ?>
                    <div class="<?= $current_status ?>-orders-item">
                        <div class="order-<?= $current_status ?>">
                            <div class="<?= $current_status ?>-status-badge">
                                <span class="badge-icon" style="display: flex;"><?= $svg_icon ?></span>
                                <span class="badge-text"><?= $label ?></span>
                            </div>
                        </div>
                        
                        <div class="order-<?= $current_status ?>-details">
                            <span class="order-number"><span class="order-details-text">شماره سفارش </span><span class="order-details-value"><?= esc_html( $order->get_order_number() ) ?></span></span>
                            <span class="order-date"><span class="order-details-text">تاریخ ثبت سفارش </span><span class="order-details-value"><?= $order_date ?></span></span>
							<span class="discount"><span class="order-details-text">مبلغ </span><span class="order-details-value"><?= wc_price($order->get_total()) ?></span></span>
                            <?php 
                            
                             if ($savings): 
                             ?>
                                <div class="royal-summary-box">
                                    <span class="order-details-text">سود شما از خرید</span>
                                    <span class="royal-summary-value saving-price"><?php echo $savings; ?></span>
                                </div>
                            <?php endif; ?>
                            
                        </div>
                        
                        <div class="order-<?= $current_status ?>-products">
                            <?php 
                                foreach ($order->get_items() as $item_id => $item) : 
                                    $product = $item->get_product();
                                    $product_name = $item->get_name();
                                    $quantity = $item->get_quantity();
                                    $total = wc_price($item->get_total());

                                    // بررسی اینکه اگر محصول وجود داشت و حذف نشده بود و قیمت هم داشت
                                    if ( $product && is_a( $product, 'WC_Product' ) ) {
                                        $product_url   = get_permalink( $product->get_id() );
                                        $product_image = $product->get_image( array(150, 150) );
                                        $is_available  = $product->is_in_stock() && $product->is_purchasable();
                                    } else {
                                        $product_url   = '#';
                                        $product_image = wc_placeholder_img( array(150, 150) );
                                        $is_available  = false;
                                    }
                                    
                                    $add_to_cart_url = $is_available ? esc_url(wc_get_cart_url() . '?add-to-cart=' . $item->get_product_id()) : '#';
                            ?>
                                    <div class="royal-order-card">
                                        <div class="royal-product-image">
                                            <?php echo $product_image; ?>
                                            <span class="royal-product-quantity"><?php echo esc_html($quantity); ?></span>
                                        </div>
                                        <div class="royal-product-details">
                                            <div class="royal-product-name">
                                                <a href="<?php echo esc_url($product_url); ?>"><?php echo esc_html($product_name); ?></a>
                                            </div>
                                            <div class="royal-product-total"><?php echo $total; ?></div>
                                        </div>
                                    </div>
                            <?php 
                                endforeach; 
                            ?>
                        </div>
                        
                        <?php
						// گرفتن تمام دکمه‌های صفحه سفارشها از جمله دکمه‌های اضافه شده با افزونه هایی مثل فاکتور
                        $actions = wc_get_account_orders_actions( $order );
                        
                        if ( ! empty( $actions ) ) {
                        
                            // ترتیب دلخواه دکمه‌ها
                            $order_keys = ['view', 'cancel', 'pay'];
                        
                            // دکمه‌های مرتب شده
                            $sorted_actions = [];
                        
                            // ابتدا دکمه‌های مشخص شده را اضافه کن
                            foreach ( $order_keys as $key ) {
                                if ( isset( $actions[$key] ) ) {
                                    $sorted_actions[$key] = $actions[$key];
                                    unset( $actions[$key] );
                                }
                            }
                        
                            // بقیه دکمه‌ها را در انتها اضافه کن
                            $sorted_actions = array_merge( $sorted_actions, $actions );
                        
                            echo '<div class="order-' . esc_attr( $current_status ) . '-actions order-actions">';
                            echo '<div class="action-buttons-wrapper">';
                        
                            foreach ( $sorted_actions as $key => $action ) {
                        
                                $classes = 'my-order-action woocommerce-button button ' . esc_attr( $key );
                        
                                switch ( $key ) {
									
                                    case 'view':
                                        $label = '<span>جزئیات سفارش</span>';
                                        $icon  = '<span class="order-icon"><svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M21 8v13H3V8M1 3h22v5H1z M10 12h4"/></svg></span>';
                                        break;
										
                                    case 'cancel':
                                        $label = '<span>لغو سفارش</span>';
                                        $icon  = '<span class="order-icon"><svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line> <line x1="6" y1="6" x2="18" y2="18"></line></svg></span>';
                                        break;
										
                                    case 'pay':
                                        $label = '<span>پرداخت</span>';
                                        $icon  = '<span class="order-icon"><svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect><line x1="1" y1="10" x2="23" y2="10"></line></svg></span>';
                                        break;
										
                                    default:
                                        $label = '<span>' . $action['name'] . '</span>';
                                        $icon  = '<span class="order-icon other-icons"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><circle cx="6" cy="9" r="5.5" fill="currentColor"/></svg></span>';
                                        break;
                                }
                        
                                printf(
                                    '<a href="%s" class="%s">%s %s</a>',
                                    esc_url( $action['url'] ),
                                    $classes,
                                    $icon,
                                    $label
                                );
                            }
                        
                            echo '</div>';
                            echo '</div>';
                        }
                        ?>
                        
                    </div>
                    <?php
                }
            }
        ?>
    </div>
    
    <div class="royal_myaccount_orders_hook">
        <?php
            // هوک سفارشی رویال جهت اتصال توسعه دهندگان به صفحه سفارشات 
            do_action('royal_myaccount_orders_hook', $order);
        ?>
    </div>
    
</div>