<?php
// ver 2.0

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Order Info
$order_id = $order->get_id();
$order_date = wp_date( 'j F Y', wc_string_to_timestamp( $order->get_date_created() ) );
$order_status = wc_get_order_status_name($order->get_status());

// Financial Info
$subtotal = wc_price($order->get_subtotal());
$payment_method = $order->get_payment_method_title();
$shipping_method = $order->get_shipping_method() ?: 'رایگان';


// محاسبه مجموع مبلغ اصلی همه محصولات (قبل از تخفیف)
$total_regular_price = 0;
$total_discounted_price = 0;

foreach ( $order->get_items() as $item ) {
    $product = $item->get_product();
    if ( ! $product ) continue;

    $quantity = $item->get_quantity();
    $regular_price = $product->get_regular_price(); // قیمت اصلی محصول
    $line_total = $item->get_total(); // مبلغ واقعی پرداخت‌شده برای این آیتم

    if ( $regular_price ) {
        $total_regular_price += $regular_price * $quantity;
        $total_discounted_price += $line_total;
    }
}

$real_discount = $total_regular_price - $total_discounted_price;
$savings = $real_discount > 0 ? wc_price($real_discount) : '';
// اتمام تخفیف


// گرفتن اطلاعات دریافت کننده
// نام صورتحساب
$recipient_name = $order->get_billing_first_name() . ' ' . $order->get_billing_last_name();

// شماره صورتحساب
$recipient_phone = $order->get_billing_phone();


// آدرس صورتحساب (billing)
$billing_address_parts = array_filter([
    $order->get_billing_address_1(),
    $order->get_billing_address_2(),
]);
$billing_address = implode('، ', $billing_address_parts);
$billing_postcode = $order->get_billing_postcode();


// آدرس ارسال (shipping)
$shipping_address_parts = array_filter([
    $order->get_shipping_address_1(),
    $order->get_shipping_address_2(),
]);
$shipping_address = implode('، ', $shipping_address_parts);
$shipping_postcode = $order->get_shipping_postcode();

$billing_compare = trim($billing_address);
$shipping_compare = trim($shipping_address);
// پایان گرفتن اطلاعات دریافت کننده

?>
<div class="royal-order-summary">

    <div class="royal-summary-section">
        <div class="royal-summary-boxs">
            <div class="royal-summary-box royal-view-order-title">
                
                <?php
                // ایجاد لینک داینامیک برای بازگشت به صفحه سفارش‌ها
                $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
                ?>
                <a href="<?php echo esc_url( $orders_url ); ?>" class="royal-back-to-orders-link" title="بازگشت به لیست سفارش‌ها">
                    <span class="dashicons dashicons-arrow-right-alt"></span>
                </a>
                <h3>جزئیات سفارش</h3>
                
            </div>
        </div>
    </div>

    <!-- Order Info Section -->
    <div class="royal-summary-section">
        <div class="royal-summary-boxs">
            <div class="royal-summary-box">
                <span class="royal-summary-label">شماره سفارش</span>
                <span class="royal-summary-value"><?php echo esc_html($order_id); ?></span>
            </div>
            <div class="royal-summary-box">
                <span class="royal-summary-label">تاریخ ثبت سفارش</span>
                <span class="royal-summary-value"><?php echo esc_html($order_date); ?></span>
            </div>
            <div class="royal-summary-box">
                <span class="royal-summary-label">وضعیت</span>
                <span class="royal-summary-value"><?php echo esc_html($order_status); ?></span>
            </div>
        </div>
    </div>

    <!-- Recipient Info Section -->
    <div class="royal-summary-section">
        <div class="royal-summary-boxs">
            
            <div class="royal-summary-box">
                <span class="royal-summary-label">نام گیرنده</span>
                <span class="royal-summary-value"><?php echo esc_html($recipient_name); ?></span>
            </div>
            <div class="royal-summary-box">
                <span class="royal-summary-label">شماره تلفن</span>
                <span class="royal-summary-value"><?php echo esc_html($recipient_phone); ?></span>
            </div>
            
            <div class="royal-address-postcode">
                <div class="royal-summary-box royal-info-address">
                    <span class="royal-summary-label">آدرس </span>
                    <span class="royal-summary-value"><?php echo esc_html($billing_address); ?></span>
                </div>
                
                <?php if ( ! empty($billing_postcode) ) : ?>
                    <div class="royal-summary-box royal-info-postcode">
                        <span class="royal-summary-label">کد پستی</span>
                        <span class="royal-summary-value"><?php echo esc_html($billing_postcode); ?></span>
                    </div>
                <?php endif; ?>
            </div>
            
            <?php if ( ! empty($shipping_compare) && $shipping_compare !== $billing_compare ) : ?>
                <div class="royal-address-postcode">
                    
                    <div class="royal-summary-box royal-info-address">
                        <span class="royal-summary-label">آدرس ارسال</span>
                        <span class="royal-summary-value"><?php echo esc_html($shipping_address); ?></span>
                    </div>
                    
                    <?php if ( ! empty($shipping_postcode) ) : ?>
                        <div class="royal-summary-box royal-info-postcode">
                            <span class="royal-summary-label">کد پستی ارسال</span>
                            <span class="royal-summary-value"><?php echo esc_html($shipping_postcode); ?></span>
                        </div>
                    <?php endif; ?>
                    
                </div>
            <?php endif; ?>
            
        </div>
    </div>
</div>

<div class="royal_myaccount_view_order_hook">
    <?php
    // هوک سفارشی رویال جهت اتصال توسعه دهندگان به صفحه جزئیات سفارش
    do_action('royal_myaccount_view_order_hook', $order);
    ?>
</div>

<?php
/** لیست هوک های صفحه جزئیات سفارش 
 // قبل از شروع جدول جزئیات سفارش
do_action( 'woocommerce_order_details_before_order_table', $order );

// جدول اصلی سفارش
// بعد از بسته شدن تگ </table> اما همچنان داخل section
do_action( 'woocommerce_order_details_after_order_table', $order );

// بعد از کل بخش order-details (خارج از section)
do_action( 'woocommerce_after_order_details', $order );

// اگر افزونه‌ها روی ایتم‌های داخل جدول هم Hook می‌زنند، در هر <tr> مربوطه این خط را اضافه کن:
do_action( 'woocommerce_order_details_after_order_table_item', $item_id, $item, $order );
*/
?>

<?php
// نمایش یادداشت‌های خریدار در صفحه جزئیات سفارش
if ( ! isset( $order ) ) {
    return; // اگر سفارش تعریف نشده، کاری نکن
}

$notes = wc_get_order_notes( array(
    'order_id' => $order->get_id(),
    'type'     => 'customer', // فقط یادداشت‌هایی که برای خریدار ثبت شده‌اند
    'approve'  => true,  // فقط یادداشت‌های تایید شده
) );

if ( ! empty( $notes ) ) {
    ?>
    
    <section class="royal-order-notes">
        <h2 style="font-size: 16px;">یادداشت‌های سفارش</h2>
        <ul class="royal-order-notes__list">
        
        <?php foreach ( $notes as $note ) { ?>  
            
            <li class="royal-order-notes__item">
                <div class="royal-order-notes__item-date royal-summary-label">
                    <?php echo sprintf( __( '%s', 'woocommerce' ), wc_format_datetime( $note->date_created, 'j F Y - H:i' ) ) ?>
                </div>
                <div class="royal-order-notes__item-content royal-summary-value">
                    <?php echo wpautop( wptexturize( $note->content ) ) ?>
                </div>
            </li>
            
        <?php } ?>
            
        </ul>
    </section>
<?php 
}
?>


<!-- Financial and Methods Section -->
<div class="royal-summary-boxs order-details">
    <div class="royal-summary-box">
        <span class="royal-summary-label">مبلغ سفارش</span>
        <span class="royal-summary-value"><?php echo $subtotal; ?></span>
    </div>
    <?php if ($savings) : ?>
        <div class="royal-summary-box">
            <span class="royal-summary-label">سود شما از خرید</span>
            <span class="royal-summary-value saving-price"><?php echo $savings; ?></span>
        </div>
    <?php endif; ?>
    <div class="royal-summary-box">
        <span class="royal-summary-label">پرداخت</span>
        <span class="royal-summary-value"><?php echo esc_html($payment_method); ?></span>
    </div>
    <?php if( $order->get_status() == 'completed' ) : ?>
        <div class="royal-summary-box">
            <span class="royal-summary-label">روش ارسال</span>
            <span class="royal-summary-value"><?php echo esc_html($shipping_method); ?></span>
        </div>
    <?php endif; ?>
</div>
<div class="generals-information">

    <?php
    $payment_status = $order->is_paid() ? 'پرداخت موفق' : 'پرداخت ناموفق';

    if( $payment_status == 'پرداخت موفق' ) {
        
        $svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 64 64"><circle cx="32" cy="32" r="30" fill="#4CAF50"/><polyline points="20,34 28,42 44,24"fill="none"stroke="#FFFFFF"stroke-width="4"stroke-linecap="round"stroke-linejoin="round"/></svg>';
        ?>
        <div class="royal-order-information successful-payment">
            <span class="royal-information-label"><?= $svg_icon ?> مبلغ سفارش - <?= $payment_status ?></span>
            <div class="royal-information-date-price">
                <span class="royal-order-date"><?= $order_date ?></span>
                <span class="royal-order-price"><?= $subtotal ?></span>
            </div>
        </div>
        <?php
    }elseif( $payment_status == 'پرداخت ناموفق' ) {
    
        $svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 64 64"><circle cx="32" cy="32" r="30" fill="#F44336"/><line x1="20" y1="20" x2="44" y2="44"stroke="#FFFFFF"stroke-width="4"stroke-linecap="round"/><line x1="44" y1="20" x2="20" y2="44"stroke="#FFFFFF"stroke-width="4"stroke-linecap="round"/></svg>';
        
        ?>
        <div class="royal-order-information payment-failed">
            <span class="royal-information-label"><?= $svg_icon ?> مبلغ سفارش - <?= $payment_status ?></span>
            <div class="royal-information-date-price">
                <span class="royal-order-date"><?= $order_date ?></span>
                <span class="royal-order-price"><?= $subtotal ?></span>
            </div>
        </div>
        <?php
    } ?>
    
</div>


<div class="royal-order-products royal-order-detail">
    <?php foreach ($order->get_items() as $item_id => $item) : 
        $product = $item->get_product();
        $product_name = $item->get_name();
        $quantity = $item->get_quantity();
        $total = wc_price($item->get_total());
        
		// خطا داشتیم با هوش اصلاح شد
        //$regular_price = $product ? $product->get_regular_price() : 0;
        //$line_total    = $item->get_total();
		$regular_price = (float) ($product ? $product->get_regular_price() : 0);
		$line_total    = (float) $item->get_total();
        
		// خطا داشتیم که با هوش اصلاح شد نوع رشته و عدد در هم ضرب شده بود
		// $discount_amount = ($regular_price * $quantity) - $line_total;
		$discount_amount = ((float) $regular_price * (int) $quantity) - (float) $line_total;
        $discount_html = $discount_amount > 0 ? '<div class="product-discount">' . wc_price($discount_amount) . ' تخفیف </div>' : '';

        $product_url = $product ? get_permalink($product->get_id()) : '#';
        $product_image = $product ? $product->get_image(array(150, 150)) : wc_placeholder_img(array(150, 150));
        $is_available = $product && $product->is_in_stock() && $product->is_purchasable();
        $add_to_cart_url = $is_available ? esc_url(wc_get_cart_url() . '?add-to-cart=' . $item->get_product_id()) : '#';


        $meta_data = $item->get_formatted_meta_data('_', true);
        
        $shipping_total     = $order->get_shipping_total();
        $shipping_methods   = $order->get_shipping_methods();

        if ( ! empty($shipping_methods) ) {
            foreach ( $shipping_methods as $shipping_method ) {
                $shipping_method_value = esc_html( $shipping_method->get_name() );
            }
        } else {
            $shipping_method_value = 'هزینه ارسال: رایگان یا یافت نشد';
        }

        if( $shipping_total <= 0 ) {
            $shipping_value = 'رایگان';
        }else {
            $shipping_value = wc_price( $order->get_shipping_total() );
        }
    ?>
        
    <div class="royal-product-card">
    
        <div class="order-product-detail">
            <div class="royal-product-image">
                <?php echo $product_image; ?>
                <span class="royal-product-quantity"><?php echo esc_html($quantity); ?></span>
            </div>
            <div class="royal-product-details">

                <span class="royal-product-name">
                    <a href="<?php echo esc_url($product_url); ?>"><?php echo esc_html($product_name); ?></a> 
                </span>
                <span class="royal-order-variable">
                    <?php 
                        if (!empty($meta_data)) {
                            echo '<ul class="royal-product-attributes">';
                            foreach ($meta_data as $meta) {
                                $value = wp_strip_all_tags($meta->display_value);
                                echo '<li><span class="royal-summary-label">' . esc_html($meta->display_key) . ':</span> ' . esc_html($value) . '</li>';
                            }
                            echo '</ul>';
                        }
                    ?>
                </span>
                <span class="royal-product-total"><?php echo $total; ?></span>
                <?php echo $discount_html; ?>
                
                <?php
                /*
                // دکمه «سفارش دوباره» با استفاده از پارامتر order_again
                $order_again_url = wp_nonce_url(
                    add_query_arg(
                        'order_again',
                        $order->get_id(),
                        wc_get_cart_url()
                    ),
                    'woocommerce-order_again'
                );
                ?>
                
                <div class="order-again-wrapper">
                    <a href="<?php echo esc_url( $order_again_url ); ?>" class="button alt order-again">
                        <?php esc_html_e( 'سفارش دوباره', 'woocommerce' ); ?>
                    </a>
                </div>
                
                <?php
                // سفارش دوباره محصول End 
                */ 
                ?>
                    
            </div>
        </div>
        
    </div>
    <?php endforeach; ?>
</div>

