<?php 

// Start Get Data From Studio API

// Get Transient
$get_royal_studio_transient = get_transient( 'royal_studio' );

// Check Transient Exists
if( $get_royal_studio_transient ) {
    $studios = json_decode( $get_royal_studio_transient );
}

// If there are posts.
if ( ! empty( $studios ) ) {

    // For each post.
    foreach ( $studios as $studio ) {
        
        if( !empty($studio->studio_template_layout->ptb) && $studio->studio_template_layout->ptb == 'active' && $studio->sutdio_unic_item_key == ItemUnicIDN) { 

            ?>
        
            <article class="rs-items" pid="<?php echo $studio->id; ?>">
                <div class="rs-preview-banner">
                    <img src="<?php echo $studio->studio_template_banner; ?>" alt="<?php echo $studio->title->rendered; ?>">
                </div>
                <div class="rs-save-bar">
                    <div class="rs-item-title"><span class="rs-title"><?php echo $studio->title->rendered .' '. $studio->id; ?></span></div>
                    <div class="rs-actions-item">
                        <span class="rs-action"><a href="#" data-id="<?php echo $studio->id; ?>" id="show-popup-<?php echo $studio->id; ?>" class="rs-save-btn"><i class="fusiona-plus"></i></a></span>
                        <span class="rs-action"><a href="#" data-url="<?php echo $studio->studio_import_files->studio->live->url; ?>" data-id="<?php echo $studio->id; ?>" id="show-live-preview-<?php echo $studio->id; ?>" class="rs-show-live-preview"><span class="dashicons dashicons-visibility"></span></a></span>
                    </div>
                </div>
            </article>

            <!-- Start Studio Import Modal -->
            <div class="rs-modal-import-notice" id="modal-<?= $studio->id; ?>">
                <div class="rs-modal-inner">
                    <div class="rs-modal-content">
                        <h2 class="rs-modal-title">
                            <i class="fusiona-info-circle"></i> <span>درون ریزی قالب</span>
                        </h2>
                        <p>محتوای این بخش در قالبساز درون ریزی می‌شود. جهت دسترسی، منوی آوادا » قالبساز.</br> جهت import محتوا، دکمه درون ریزی را کلیک کنید.</p>
                    </div>
                    <div class="rs-import-status-bar" id="status-bar-<?= $studio->id; ?>">
                        <?php 
                            // data-template ===> POST_TYPE
                            // data-tax      ===> Items Taxonomy
                         ?>
                        <a href="#" class="rs-import-button" data-tax="fusion_tb_category" data-template="fusion_tb_section" data-type="page_title_bar" data-id="<?= $studio->id; ?>" id="import-id-<?= $studio->id; ?>"><div class="rs-status-bar-label" id="rs-status-bar-id-<?= $studio->id; ?>">درون ریزی</div></a>
                        <div class="rs-progress-bar"></div>
                    </div>
                </div>
                <a href="#" class="rs-admin-modal-corner-close"><span class="dashicons dashicons-no-alt"></span></a>
            </div>
            <!-- ENd Studio Import Modal -->

            <!-- Start Studio Live Preview -->
            <div class="rs-modal-live-preview" id="live-preview-<?= $studio->id; ?>">
                <div class="rs-live-preview-loader"><span class="rs-live-popup-loader" id="rs-live-loader-<?= $studio->id; ?>"></span></div>
                <div class="rs-modal-live-preview-inner">
                    <iframe class="rs-live-preview-section" id="rs-live-preview-<?= $studio->id; ?>" frameborder="0"></iframe>
                </div>
                <a href="#" class="rs-admin-modal-corner-close live-preview"><span class="dashicons dashicons-no-alt"></span></a>
            </div>
            <!-- End Studio Live Preview -->

            <div class="rs-modal-overlay" id="modal-overlay-id-<?= $studio->id; ?>"></div>
            <?php   

        }

    } // End Foreach

}

// End Get Data From Studio API