function openStudio(evt, studiotabs) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("rs-output-layouts");
    for (i = 0; i < tabcontent.length; i++) {
      tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
      tablinks[i].className = tablinks[i].className.replace(" active", "");
    }
    document.getElementById(studiotabs).style.display = "block";
    evt.currentTarget.className += " active";
}

jQuery(document).ready(function($) {

  $('.rs-modal-import-notice').hide();
  $('.rs-modal-live-preview').hide();

  // Open Import Modal Action
  $('.rs-save-btn').click(function(a) { 
    a.preventDefault();
    let id = $(this).attr('data-id');
    $('#modal-'+id+'').show();
    $('#modal-overlay-id-'+id+'').show();
  });

  // Open Live Preview Modal Action
  $('.rs-show-live-preview').click(function(a) { 
    a.preventDefault();

    let id = $(this).attr('data-id');
    let liveurl = $(this).attr('data-url');

    $('#live-preview-'+id+'').show();
    $('#modal-overlay-id-'+id+'').show();
    $('#rs-live-preview-'+id+'').attr("src", liveurl);

    $('.rs-live-popup-loader').addClass('display-loader');

    $('#rs-live-preview-'+id+'').on('load', function(){
      $('.rs-live-popup-loader').removeClass('display-loader');
    });
  });

  // Close Live Preview Modal Action
  $('.rs-admin-modal-corner-close.live-preview').click(function(b) { 
    b.preventDefault();
    $('.rs-modal-live-preview').hide();
    $('.rs-modal-overlay').hide();
    $(".rs-live-preview-section").attr("src", "");
  });

  // Close Import Modal Action
  $('.rs-admin-modal-corner-close').click(function(b) { 
    b.preventDefault();
    $('.rs-modal-import-notice').hide();
    $('.rs-modal-overlay').hide();
  });

  // Import Data With Ajax
  $('.rs-import-button').click(function(c) { 
    c.preventDefault();
    let ImportBTN_Id  = $(this).attr('data-id');
    let data_template = $(this).attr('data-template');
    let data_type     = $(this).attr('data-type');
    let data_tax      = $(this).attr('data-tax');
    
    jQuery.ajax({
            
      url: rs_ajax_url.ajax_url,
      data:{
          action: "rs_import_data",
          id: ImportBTN_Id,
          post_type: data_template,
          data_type: data_type,
          data_tax: data_tax,
      },
      type: "POST",
      beforeSend: function(result){
        $('#rs-status-bar-id-'+ImportBTN_Id+'').html('در حال درون ریزی');
      },
      success: function(result){
        $('#rs-status-bar-id-'+ImportBTN_Id+'').html('درون ریزی کامل شد');
        $( '#status-bar-'+ImportBTN_Id+'' ).css( 'background' , '#05b24d' );
      },
      complete: function (result){
        // $('.rs-modal-import-notice').hide();
        // $('.rs-modal-overlay').hide();
      }
    });
  });

  // Click Action For Get New Studio Data
  $('.update-rs-button').click(function (e) { 
    e.preventDefault();

    $('.sync-data').addClass('progress');
    $('.sync-data').addClass('disabled');

    jQuery.ajax({
            
      url: rs_ajax_url.ajax_url,
      data:{
          action: "iravada_studio_update_data",
      },
      type: "POST"
    })
    .done (function(result) {

      $('.sync-data').removeClass('progress');
      $('.sync-data').removeClass('disabled');

      $('.sync-data').addClass( 'success' );
      setTimeout( function() {
        $('.sync-data').removeClass( 'success' );
        $('.sync-data').html('در حال بارگذاری مجدد');
        location.reload();
      }, 1000 );

    })
    .fail (function() {

      $('.sync-data').removeClass('progress');
      $('.sync-data').removeClass('disabled');

      $('.sync-data').addClass( 'error' );
      setTimeout( function() {
        $('.sync-data').removeClass( 'success' );
      }, 2000 );
    })
  });
});

