<?php 

if( !class_exists('Royal_Option_save_Action') ) {

    class Royal_Option_save_Action {

        public function __construct() {

            // Add Ajax For Save Data
            add_action( 'wp_ajax_iravada_save_royal_options', array($this, 'royal_save_options_setting_ajax_handle') );
            add_action( 'wp_ajax_nopriv_iravada_save_royal_options', array($this, 'royal_save_options_setting_ajax_handle') );

            // Add Ajax For Reset Data
            add_action( 'wp_ajax_iravada_reset_royal_options', array($this, 'royal_reset_options_setting_ajax_handle') );
            add_action( 'wp_ajax_nopriv_iravada_reset_royal_options', array($this, 'royal_reset_options_setting_ajax_handle') );

            // Add Ajax For Import Avada Options ==> Royal Template
            add_action( 'wp_ajax_import_avada_option_royal', array($this, 'royal_insert_avada_setting_ajax_handle') );
            add_action( 'wp_ajax_nopriv_import_avada_option_royal', array($this, 'royal_insert_avada_setting_ajax_handle') );

            // Add Ajax For Import Royal Product Filter Setting ==> Royal Template
            add_action( 'wp_ajax_import_royal_product_filter_setting', array($this, 'royal_insert_product_filter_setting_ajax_handle') );
            add_action( 'wp_ajax_nopriv_import_royal_product_filter_setting', array($this, 'royal_insert_product_filter_setting_ajax_handle') );

            // Add Ajax Import Royal Setting
            add_action('wp_ajax_import_royal_settings_manual', array($this, 'import_royal_setting_manual_request'));
            add_action('wp_ajax_nopriv_import_royal_settings_manual', array($this, 'import_royal_setting_manual_request'));

            // Add Ajax For Import Royal Brands
            add_action('wp_ajax_import_royal_brands_plugin', array($this, 'import_royal_brand_from_plugins'));
            add_action('wp_ajax_nopriv_import_royal_brands_plugin', array($this, 'import_royal_brand_from_plugins'));
            
            // Add Ajax For Import Royal Brands
            add_action('wp_ajax_import_royal_group_attribute', array($this, 'import_royal_group_attribute_function'));
            add_action('wp_ajax_nopriv_import_royal_group_attribute', array($this, 'import_royal_group_attribute_function'));
            
            // Export MyAccount
            add_action( 'wp_ajax_export_royal_myaccount', [$this, 'export_royal_myaccount_ajax'] );
            add_action( 'wp_ajax_nopriv_export_royal_myaccount', [$this, 'export_royal_myaccount_ajax'] );
            
            // Import MyAccount
            add_action( 'wp_ajax_import_royal_myaccount', [$this, 'import_royal_myaccount_ajax'] );
            add_action( 'wp_ajax_nopriv_import_royal_myaccount', [$this, 'import_royal_myaccount_ajax'] );

            // Check Frist Time Child Theme Active
            $this->royal_check_setting_exist();
        }

        // Export MyAccount
        public function export_royal_myaccount_ajax() {

            global $wpdb;
            $table_name = $wpdb->prefix . "royal_myaccount";
            $results = $wpdb->get_results("SELECT * FROM $table_name", ARRAY_A);
        
            // خروجی JSON
            $json = json_encode($results);
        
            // Header برای Ajax معمولی نمی‌فرستیم چون قراره جواب رو JS بگیره
            wp_send_json_success($json);
        
            wp_die();
            
        }

        // Import MyAccount
        public function import_royal_myaccount_ajax() {

            // امنیت
            if (!current_user_can('manage_options')) {
                wp_send_json_error('دسترسی ندارید!');
                wp_die();
            }
        
            if (empty($_FILES['file'])) {
                wp_send_json_error('فایل ارسال نشده.');
                wp_die();
            }
        
            $file = $_FILES['file'];
        
            if ($file['error'] !== UPLOAD_ERR_OK) {
                wp_send_json_error('خطا در آپلود فایل.');
                wp_die();
            }
        
            $jsonData = file_get_contents($file['tmp_name']);
            $dataArray = json_decode($jsonData, true);
        
            if ($dataArray === null) {
                wp_send_json_error('فایل JSON معتبر نیست.');
                wp_die();
            }
        
            global $wpdb;
            $table_name = $wpdb->prefix . "royal_myaccount";
        
            // پاک کردن جدول برای وارد کردن مجدد
            $wpdb->query("TRUNCATE TABLE $table_name");
        
            foreach ($dataArray as $row) {
                unset($row['id']); // چون AUTO_INCREMENT داریم
                $wpdb->insert($table_name, $row);
            }
        
            wp_send_json_success('ایمپورت با موفقیت انجام شد!');
            wp_die();

        }

        // Check Frist Time Child Theme Active
        public function royal_check_setting_exist() {
    
            if( !get_option('royal_option_settings') ) {

                $royal_default_option_setting_file_path = get_stylesheet_directory() . '/assets/options/royal-theme-options.txt';
                $royal_default_option_setting = file_get_contents( $royal_default_option_setting_file_path );
                update_option( 'royal_option_settings', $royal_default_option_setting );

            }
        
        }
        
        // Save Royal Options Setting By Ajax
        public function royal_save_options_setting_ajax_handle() {

            $royal_setting_save = update_option( 'royal_option_settings', serialize($_POST['settingdata']) );
           
            if( $royal_setting_save = true ) {
                echo 'SaveOptionsSuccessfuly';
            }

            exit;

        }

        // Reset Royal Settings To Default
        public function royal_reset_options_setting_ajax_handle() {

            $royal_default_option_setting_file_path = get_stylesheet_directory() . '/assets/options/royal-theme-options.txt';
            $royal_default_option_setting = file_get_contents( $royal_default_option_setting_file_path );
            $royal_option_panel_setting_saved = update_option( 'royal_option_settings', $royal_default_option_setting );

            if( $royal_option_panel_setting_saved = true ) {
                echo 'ResetOptionsSuccessfuly';
            }

            exit;

        }

        // Add Ajax For Import Avada Options ==> Royal Template
        public function royal_insert_avada_setting_ajax_handle() {

            // Get Demo Option Json File
            $theme_options_file = get_stylesheet_directory() . '/assets/options/avada-theme-options.json';

            // Get Json File Content
            $theme_options_json = file_get_contents( $theme_options_file );

            // Start Json Decoded
            $theme_options = json_decode( $theme_options_json, true );

            // Set Retina Logo
            $theme_options['logo_retina'] = '';

            // Get Avada Theme Option DB Name
            $theme_options_db_name = Avada::get_original_option_name();

            // Update Royal Theme Options
            $set_theme_option = update_option( $theme_options_db_name, $theme_options );

            if ( $set_theme_option = true ) {
                echo 'AvadaImportSettingSuccessfuly';
            }

            exit;

        }

        public function royal_insert_product_filter_setting_ajax_handle() {

            // Start Get Json Files

            $prdctfltr_preset_default     = get_stylesheet_directory() . '/assets/options/product-filter-settings/_prdctfltr_preset_default.json';
            $prdctfltr_preset_top_filter  = get_stylesheet_directory() . '/assets/options/product-filter-settings/_prdctfltr_preset_top-filter.json';
            $prdctfltr_preset_mob_filter  = get_stylesheet_directory() . '/assets/options/product-filter-settings/_prdctfltr_preset_mobile-filter.json';
            $prdctfltr_autoload 		  = get_stylesheet_directory() . '/assets/options/product-filter-settings/_prdctfltr_autoload.json';
            $prdctfltr_preset_side_filter = get_stylesheet_directory() . '/assets/options/product-filter-settings/_prdctfltr_preset_side-filter-round.json';

            // End Get Json Files

            // Start Get All File Content

            // Get Json File Content ** Preset Default
            $product_filter_setting_preset_default_content = file_get_contents( $prdctfltr_preset_default );

            // Get Json File Content ** Preset Top Filter
            $product_filter_setting_preset_top_filter_content = file_get_contents( $prdctfltr_preset_top_filter );

            // Get Json File Content ** Preset Mobile Filter
            $product_filter_setting_preset_mob_filter_content = file_get_contents( $prdctfltr_preset_mob_filter );

            // Get Json File Content ** Auto Load
            $product_filter_setting_autoload_content = file_get_contents( $prdctfltr_autoload );
            
            // Get Json File Content ** Side Content
            $prdctfltr_preset_side_filter_content = file_get_contents( $prdctfltr_preset_side_filter );

            // End Get All File Content

            // Start Json Decoded

            $product_filter_setting_preset_default      = json_decode( $product_filter_setting_preset_default_content, true );
            $product_filter_setting_preset_top_filter   = json_decode( $product_filter_setting_preset_top_filter_content, true );
            $product_filter_setting_preset_mob_filter   = json_decode( $product_filter_setting_preset_mob_filter_content, true );
            $product_filter_setting_autoload            = json_decode( $product_filter_setting_autoload_content, true );
            $product_filter_setting_side_content        = json_decode( $prdctfltr_preset_side_filter_content, true );

            // End Json Decoded

            // Start Update Product FIlter Options

            // Update Product Filter DB Option -> Preset Default
            $set_product_filter_options = update_option( '_prdctfltr_preset_default' , $product_filter_setting_preset_default );

            // Update Product Filter DB Option -> Top Filter
            $set_product_filter_options = update_option( '_prdctfltr_preset_top-filter' , $product_filter_setting_preset_top_filter );

            // Update Product Filter DB Option -> Mobile Filter
            $set_product_filter_options = update_option( '_prdctfltr_preset_mobile-filter' , $product_filter_setting_preset_mob_filter );

            // Update Product Filter DB Option -> Auto Load
            $set_product_filter_options = update_option( '_prdctfltr_autoload' , $product_filter_setting_autoload );
            
            // Update Product Filter DB Option -> Side Filter
            $set_product_filter_options = update_option( '_prdctfltr_preset_side-filter-round' , $product_filter_setting_side_content );

            // End Update Product FIlter Options      

            if( $set_product_filter_options = true ) {
                echo 'ImportProductFilterSettingSuccessfuly';
            }

            exit;

        }

        // Import Royal Setting Manual
        public function import_royal_setting_manual_request() {
            
            $_POST          = array_map( 'stripslashes_deep', $_POST );
            $_GET           = array_map( 'stripslashes_deep', $_GET );
            $_COOKIE        = array_map( 'stripslashes_deep', $_COOKIE );
            $_REQUEST       = array_map( 'stripslashes_deep', $_REQUEST );

            $Imported_royal_data = $_POST['RoyalSetting'];

            $royal_setting_imported = update_option( 'royal_option_settings', $Imported_royal_data);
           
            if( $royal_setting_imported = true ) {
                echo 'ImportSettingSuccessfully';
            }

            exit;

        }

        // Import Royal Brands From Plugin
        public function import_royal_brand_from_plugins() {

            global $wpdb;
            
            if( $_POST['selected_plugin'] == 'perfect-brand' ) {
                
                $terms_pwb = $wpdb->get_col( 'SELECT term_id FROM ' . $wpdb->prefix . 'term_taxonomy WHERE taxonomy LIKE "pwb-brand"' );
                if( !empty( $terms_pwb ) ) {

                    foreach ( $terms_pwb as $term_id ) {
                        /**
                         * Change taxonomy
                         */
                        $import_brands = $wpdb->update(
                            $wpdb->prefix . 'term_taxonomy',
                            array(
                                'taxonomy' => 'iravada-royal-brands',
                            ),
                            array(
                                'term_id' => $term_id,
                            )
                        );
                        /**
                         * Add the logo id
                         */
                        $thumb_id = get_woocommerce_term_meta( $term_id, 'pwb_brand_image', true );
                        if ( $thumb_id ) {
                            add_term_meta( $term_id, 'royal_brands_logo', $thumb_id );
                        }
        
                    }
        
                    if( $import_brands == true ) {
                        echo 'RoyalBrandImportSuccessfuly';
                    }

                }else {
                    echo 'NotBrandFoundToImport';
                }

            }elseif( $_POST['selected_plugin'] == 'woocommerce-brands' ) {

                $terms_woo_brand = $wpdb->get_col( 'SELECT term_id FROM ' . $wpdb->prefix . 'term_taxonomy WHERE taxonomy LIKE "product_brand"' );
                if( !empty( $terms_woo_brand ) ) {

                    foreach ( $terms_woo_brand as $term_id ) {
                        /**
                         * Change taxonomy
                         */
                        $import_brands = $wpdb->update(
                            $wpdb->prefix . 'term_taxonomy',
                            array(
                                'taxonomy' => 'iravada-royal-brands',
                            ),
                            array(
                                'term_id' => $term_id,
                            )
                        );
                        /**
                         * Add the logo id
                         */
                        $thumb_id = get_woocommerce_term_meta( $term_id, 'thumbnail_id', true );
                        if ( $thumb_id ) {
                            add_term_meta( $term_id, 'royal_brands_logo', $thumb_id );
                        }
        
                    }
        
                    if( $import_brands == true ) {
                        echo 'RoyalBrandImportSuccessfuly';
                    }

                }else {
                    echo 'NotBrandFoundToImport';
                }

            }

            exit;

        }

        public function import_royal_group_attribute_function() {

            global $wpdb;

            $Royal_Group_Attribute_Post_Type = 'royal_group_attr';
            $Royal_Group_Attribute_Post_Meta = 'royal_group_attribute_selected_attributes';

            $Get_All_Posts      = $wpdb->get_results( 'SELECT * FROM ' . $wpdb->prefix . 'posts WHERE post_type LIKE "attribute_group"' );
            $Get_All_Post_Meta  = $wpdb->get_results( 'SELECT * FROM ' . $wpdb->prefix . 'postmeta WHERE meta_key LIKE "woocommerce_group_attributes_attributes"' );

            if( !empty( $Get_All_Posts ) ) {

                foreach ( $Get_All_Posts as $GroupAttrPosts ) {

                    $Import_Groups_Attribute = $wpdb->update(
                        $wpdb->prefix . 'posts',
                        array(
                            'post_type' => $Royal_Group_Attribute_Post_Type,
                        ),
                        array(
                            'ID' => $GroupAttrPosts->ID,
                        )
                    );

                }

                foreach( $Get_All_Post_Meta as $PostMeta ) {

                    $Import_Groups_Attribute = $wpdb->update(
                        $wpdb->prefix . 'postmeta',
                        array(
                            'meta_key' => $Royal_Group_Attribute_Post_Meta,
                        ),
                        array(
                            'meta_key' => 'woocommerce_group_attributes_attributes',
                        )
                    );

                }

                echo 'AllGroupAttributeImported';

            }else {
                echo 'NotGroupAttributeFoundToImport';
            }

            exit;

        }

    }new Royal_Option_save_Action();

}