<?php 

if( !class_exists('Royal_Ajax_Add_To_Cart') ) {

    class Royal_Ajax_Add_To_Cart {
        
        protected $ajax_js_url = '';

        public function __construct() {

            $get_royal_ajax_option_settings = Royal_Option_Functions::get_royal_option_settings();

            $this->ajax_js_url = get_stylesheet_directory_uri() . '/includes/royal-screen/pages/royal-setting/inc/general-settings/add-to-cart-event/assets/js/';

            if( $get_royal_ajax_option_settings['product_single_ajax_addtocart'] == 'yes' ) {

                // Ajax Js Files Enqueue On FrontEnd
                add_action('wp_enqueue_scripts', array($this, 'iravada_add_to_cart_ajax_event'));

                // Render Ajax Add To Cart Request
                add_action('wp_ajax_woocommerce_ajax_add_to_cart', array($this, 'woocommerce_ajax_add_to_cart'));
                add_action('wp_ajax_nopriv_woocommerce_ajax_add_to_cart', array($this, 'woocommerce_ajax_add_to_cart'));

            }

        }

        // Load Ajax Scripts Needed On Frontend
        public function iravada_add_to_cart_ajax_event() {
            
            if( is_product() ) {
                wp_enqueue_script( 'add-to-cart-event', $this->ajax_js_url . 'add-to-cart-ajax-event.js', array('jquery'), '1.2', true );
            }
            
        }

        // Render Ajax Add To Cart Request Function
        public function woocommerce_ajax_add_to_cart() {

            $product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
            $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
            $variation_id = absint($_POST['variation_id']);
            $passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
            $product_status = get_post_status($product_id);
    
            if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) {
    
                do_action('woocommerce_ajax_added_to_cart', $product_id);
    
                if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
                    wc_add_to_cart_message(array($product_id => $quantity), true);
                }
    
                WC_AJAX :: get_refreshed_fragments();
            } else {
    
                $data = array(
                    'error' => true,
                    'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id));
                    echo wp_send_json($data);
                }
        }

    }new Royal_Ajax_Add_To_Cart();

}