jQuery(document).ready(function($){

    /* global wc_add_to_cart_params */
    if ( typeof wc_add_to_cart_params === 'undefined' ) {
		return false;
    }

    $(document).on('submit', 'form.cart', function(e){
        
        var form = $(this),
            button = form.find('.single_add_to_cart_button');
        
        var formFields = form.find('input:not([name="product_id"]), select, button, textarea');

        // create the form data array
        var formData = [];
        formFields.each(function(i, field){

            // store them so you don't override the actual field's data
            var fieldName = field.name,
                fieldValue = field.value;

            if(fieldName && fieldValue){

                // set the correct product/variation id for single or variable products
                if(fieldName == 'add-to-cart'){
                    fieldName = 'product_id';
                    fieldValue = form.find('input[name=variation_id]').val() || fieldValue;
                }

                // if the fiels is a checkbox/radio and is not checked, skip it
                if((field.type == 'checkbox' || field.type == 'radio') && field.checked == false){
                    return;
                }

                // add the data to the array
                formData.push({
                    name: fieldName,
                    value: fieldValue
                });                
            }
        });

        if(!formData.length){
            return;
        }
        
        e.preventDefault();
        
        form.block({ 
            message: null, 
            overlayCSS: {
                background: "#ffffff",
                opacity: 0.6 
            }
        });

        $(document.body).trigger('adding_to_cart', [button, formData]);
  
        $.ajax({
            type: 'POST',
            url: woocommerce_params.wc_ajax_url.toString().replace('%%endpoint%%', 'add_to_cart'),
            data: formData,
            beforeSend: function(response) {
                $("body").addClass("addtocart-loading");
                // $(".single_add_to_cart_button").text('درحال افزودن');
            },
            success: function(response){
                
                /*
                $({ myScrollTop: window.pageYOffset }).animate({ myScrollTop: 0 }, {
                    duration: 1000,
                    easing: 'swing',
                    step: function(val) {
                        window.scrollTo(0, val);
                    }
                });
                */

                if(!response){
                    return;
                }

                if(response.error & response.product_url){
                    window.location = response.product_url;
                    return;
                }
                
                $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, button]);
                
                /*
                $(".submenu-mode-flyout").addClass("flyout-submenu-expanded");
                $(".submenu-mode-flyout .fusion-menu-cart").addClass("expanded");
                setTimeout(function(){
                    $(".submenu-mode-flyout").removeClass("flyout-submenu-expanded");
                    $(".submenu-mode-flyout .fusion-menu-cart").removeClass("expanded");
                }, 4000);
                
                $(".submenu-mode-dropdown ul.fusion-menu-cart-items").addClass("headercart-submenu-expanded");
                setTimeout(function(){
                    $(".submenu-mode-dropdown ul.fusion-menu-cart-items").removeClass("headercart-submenu-expanded");
                }, 4000);
                */
            },
            complete: function(){
                $("body").removeClass('addtocart-loading');
                form.unblock();
            }
            
        });
  
      return false;
  
    });
});


