<?php

function get_royal_option_settings() {

	$get_serialized_option  = get_option('royal_option_settings');

	if( !empty($get_serialized_option) ) {
		$unserialized_options   = unserialize($get_serialized_option);
		return $unserialized_options;
	}
}
$get_site_performance_options = get_royal_option_settings();

if(!function_exists('is_plugin_active'))
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
	
	/* Start Disable WooCommerce Admin, Analytics tab, Notification bar */
	/***********************************************************************/

	if( $get_site_performance_options['disable_woocommerce_admin'] == 'yes' ) {

	add_filter( 'woocommerce_admin_disabled', '__return_true' );
	// fix for WooCoommerce Status Meta Box not showing
	if(!empty(get_option('woocommerce_task_list_hidden', 'yes' ))) {
	update_option( 'woocommerce_task_list_hidden', 'yes' );
	}
	if(!empty(get_option('woocommerce_task_list_complete', 'yes' ))) {
	update_option( 'woocommerce_task_list_complete', 'yes' );
	}
	// end fix

	if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		if ( defined( 'WC_VERSION' ) && ( WC_VERSION !== null ) && ( version_compare( WC_VERSION, '5.5', '>' ) ) ) {
			// Old version code

			// fix for wc_admin_url in WooCommerce 5.0
			if ( ! function_exists( 'wc_admin_url') ) {
				function wc_admin_url( $path ) {
					return '#';
				}
				class WC_Notes_Run_Db_Update {}

				// 	fix for AutomateWoo

				function wc_admin_connect_page() {
					return;
				}

				function wc_admin_register_page() {
					return;
				}

				function wc_admin_is_registered_page() {
					return;
				}
			}
		}
	}
	
	}

	// Fix for Woo 6.2.0
	// multisite support:
	if ( in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins'))) ||	is_array(apply_filters('active_plugins', get_site_option('active_sitewide_plugins'))) && array_key_exists('woocommerce/woocommerce.php', apply_filters('active_plugins', get_site_option('active_sitewide_plugins'))))  {
	// the same if construct but without support for multisite:
	// if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, '6.2.0', '>=' ) ) {
			// Old version code
		} else {
        // New version code
			class WC_Admin_Dashboard_Setup {
				public function should_display_widget( $path ) {
					return '#';
				}
	}
	    // commented out due to problems reported here https://wordpress.org/support/topic/not-working-properly-after-update-2/
	    //		return new WC_Admin_Dashboard_Setup();
		}
	}
    // End of fix for Woo 6.2.0


	/***********************************************************************/
	/* End Disable WooCommerce Admin, Analytics tab, Notification bar */

	/* Start Disable Marketing Hub */
	/***********************************************************************/

		if( $get_site_performance_options['disable_marketing_hub'] == 'yes' ) {

			add_filter( 'woocommerce_marketing_menu_items', '__return_empty_array' );
		}

	/***********************************************************************/
	/* End Disable Marketing Hub */

	/* Start Disable Connect your store to WooCommerce.com */
	/***********************************************************************/

		if( $get_site_performance_options['disconnect_request_to_woocommerce'] == 'yes' ) {

			add_filter( 'woocommerce_helper_suppress_admin_notices', '__return_true' );
		}

	/***********************************************************************/
	/* End Disable Connect your store to WooCommerce.com */

	/* Start Disable WooCommerce Scripts & Styles */
	/***********************************************************************/

		if( $get_site_performance_options['disable_load_woocommerce_style_scripts'] == 'yes' ) {

			add_action('wp_enqueue_scripts', 'iravada_disable_woocommerce_scripts', 99);
			// add_action( 'init', 'iravada_disable_wc_blocks', 100 );
		}

		function iravada_disable_woocommerce_scripts() {

			if(function_exists('is_woocommerce')) {

				if(!is_woocommerce() && !is_cart() && !is_checkout() && !is_account_page() && !is_product() && !is_product_category() && !is_shop()) {
					
					//Dequeue WooCommerce Styles
					wp_dequeue_style('woocommerce-general');
					wp_dequeue_style('woocommerce-layout');
					wp_dequeue_style('woocommerce-smallscreen');
					wp_dequeue_style('woocommerce_frontend_styles');
					wp_dequeue_style('woocommerce_fancybox_styles');
					wp_dequeue_style('woocommerce_chosen_styles');
					wp_dequeue_style('woocommerce_prettyPhoto_css');

					//Dequeue WooCommerce Scripts
					wp_dequeue_script('wc_price_slider');
					wp_dequeue_script('wc-single-product');
					wp_dequeue_script('wc-add-to-cart');
					wp_dequeue_script('wc-checkout');
					wp_dequeue_script('wc-add-to-cart-variation');
					wp_dequeue_script('wc-single-product');
					wp_dequeue_script('wc-cart');
					wp_dequeue_script('wc-chosen');
					wp_dequeue_script('woocommerce');
					wp_dequeue_script('prettyPhoto');
					wp_dequeue_script('prettyPhoto-init');
					wp_dequeue_script('jquery-blockui');
					wp_dequeue_script('jquery-placeholder');
					wp_dequeue_script('fancybox');
					wp_dequeue_script('jqueryui');
				}
			}
		}
		
		
		// new for woocommerce 8
		/*
		if(function_exists('is_woocommerce')) {
		    
            function iravada_disable_wc_blocks() {
                $swp_dis_styles = array(
                    'wc-all-blocks-style-rtl',
                    'wc-blocks-vendors-style',
                    'wp-block-library',
                    'wc-blocks-style',
                    'wc-blocks-style-active-filters',
                    'wc-blocks-style-add-to-cart-form',
                    'wc-blocks-packages-style',
                    'wc-blocks-style-all-products',
                    'wc-blocks-style-all-reviews',
                    'wc-blocks-style-attribute-filter',
                    'wc-blocks-style-breadcrumbs',
                    'wc-blocks-style-catalog-sorting',
                    'wc-blocks-style-customer-account',
                    'wc-blocks-style-featured-category',
                    'wc-blocks-style-featured-product',
                    'wc-blocks-style-mini-cart',
                    'wc-blocks-style-price-filter',
                    'wc-blocks-style-product-add-to-cart',
                    'wc-blocks-style-product-button',
                    'wc-blocks-style-product-categories',
                    'wc-blocks-style-product-image',
                    'wc-blocks-style-product-image-gallery',
                    'wc-blocks-style-product-query',
                    'wc-blocks-style-product-results-count',
                    'wc-blocks-style-product-reviews',
                    'wc-blocks-style-product-sale-badge',
                    'wc-blocks-style-product-search',
                    'wc-blocks-style-product-sku',
                    'wc-blocks-style-product-stock-indicator',
                    'wc-blocks-style-product-summary',
                    'wc-blocks-style-product-title',
                    'wc-blocks-style-rating-filter',
                    'wc-blocks-style-reviews-by-category',
                    'wc-blocks-style-reviews-by-product',
                    'wc-blocks-style-product-details',
                    'wc-blocks-style-single-product',
                    'wc-blocks-style-stock-filter',
                    'wc-blocks-style-cart',
                    'wc-blocks-style-checkout',
                    'wc-blocks-style-mini-cart-contents',
                    'classic-theme-styles-inline'
                );
            
                foreach ( $swp_dis_styles as $irava_style ) {
                    wp_deregister_style( $irava_style );
                }
            
                $swp_dis_scripts = array(
                    'wc-blocks-middleware',
                    'wc-blocks-data-store'
                );
            
                foreach ( $swp_dis_scripts as $irava_script ) {
                    wp_deregister_script( $irava_script );  
                }
            }
		}
		*/
	
	
	/***********************************************************************/
	/* End Disable WooCommerce Scripts & Styles */

	/* Start Disable WooCommerce Status Meta Box */
	/***********************************************************************/

		if( $get_site_performance_options['disable_woocommerce_status_metabox'] == 'yes' ) {

			add_action('wp_dashboard_setup', 'iravada_disable_woocommerce_status');
		}

		function iravada_disable_woocommerce_status() {

			remove_meta_box('woocommerce_dashboard_status', 'dashboard', 'normal');
		}

	/***********************************************************************/
	/* End Disable WooCommerce Status Meta Box */

	/* Strat Disable WooCommerce Marketplace Suggestions */
	/***********************************************************************/

		if( $get_site_performance_options['disable_marketplace_suggestions'] == 'yes' ) {

			add_filter( 'woocommerce_allow_marketplace_suggestions', '__return_false', 999 );
		}

	/* End Disable WooCommerce Marketplace Suggestions */
	/***********************************************************************/

	/* Start Disable Extensions & addons submenu */
	/***********************************************************************/

		if( $get_site_performance_options['disable_woocommerce_addon_menu'] == 'yes' ) {

			add_action( 'admin_menu', 'iravada_remove_admin_addon_submenu', 999 );
			function iravada_remove_admin_addon_submenu() {

				remove_submenu_page( 'woocommerce', 'wc-addons');
				remove_submenu_page( 'woocommerce', 'wc-addons&section=helper');
			}
		}

	/* End Disable Extensions & addons submenu */
	/***********************************************************************/

	/* Start Disable Password Strength Meter */
	/***********************************************************************/

		if( $get_site_performance_options['disable_password_Strength'] == 'yes' ) {

			add_action('wp_print_scripts', 'iravada_disable_password_strength_meter', 100);
		}

		function iravada_disable_password_strength_meter() {

			global $wp;

			$wp_check = isset($wp->query_vars['lost-password']) || (isset($_GET['action']) && $_GET['action'] === 'lostpassword') || is_page('lost_password');

			$wc_check = (class_exists('WooCommerce') && (is_account_page() || is_checkout()));

			if(!$wp_check && !$wc_check) {
				if(wp_script_is('zxcvbn-async', 'enqueued')) {
					wp_dequeue_script('zxcvbn-async');
				}

				if(wp_script_is('password-strength-meter', 'enqueued')) {
					wp_dequeue_script('password-strength-meter');
				}

				if(wp_script_is('wc-password-strength-meter', 'enqueued')) {
					wp_dequeue_script('wc-password-strength-meter');
				}
			}
		}

	/***********************************************************************/
	/* End Disable Password Strength Meter */

	/* Start Disable WooCommerce Cart Fragments */
	/***********************************************************************/

		if( $get_site_performance_options['disable_cart_fragments'] == 'yes' ) {

			add_action('wp_enqueue_scripts', 'iravada_disable_woocommerce_cart_fragments', 99);
		}

		function iravada_disable_woocommerce_cart_fragments() {

			if(function_exists('is_woocommerce')) {

				wp_dequeue_script('wc-cart-fragments');
			}
		}

	/***********************************************************************/
	/* End Disable WooCommerce Cart Fragments */

	/* Start Disable Woocommerce Gutenberg Blocks Editor */
	/***********************************************************************/

		if( $get_site_performance_options['disable_woocommerce_blocks'] == 'yes' ) {

			function iravada_disable_woocommerce_block_editor_styles() {
				wp_deregister_style( 'wc-block-editor' );
				wp_deregister_style( 'wc-blocks-style' );
			}
			add_action( 'enqueue_block_assets', 'iravada_disable_woocommerce_block_editor_styles', 1, 1 );
		}

	/***********************************************************************/
	/* Start Disable Woocommerce Gutenberg Blocks Editor */

	/* Start Disable wordpress Gutenberg Widgets */
	/***********************************************************************/

	if( $get_site_performance_options['royal_on_off_classic_widgets_area'] == 'yes' ) {

		// Disables the block editor from managing widgets in the Gutenberg plugin.
		add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );

		// Disables the block editor from managing widgets.
		add_filter( 'use_widgets_block_editor', '__return_false' );
	}

	/***********************************************************************/
	/* End Disable wordpress Gutenberg Widgets */
}
