<?php

if( !class_exists('Royal_Option_Functions') ) {

    class Royal_Option_Functions {
        
        protected $royal_option_css_uri = '';
        protected $royal_option_js_uri = '';

        public function __construct() {

            // Set all Path/Url
            $this->royal_option_css_uri = get_stylesheet_directory_uri() . '/includes/royal-screen/pages/royal-setting/assets/css/';
            $this->royal_option_js_uri  = get_stylesheet_directory_uri() . '/includes/royal-screen/pages/royal-setting/assets/js/';

            // Load All Style/Script Needed For Royal Option Setting
            add_action( 'admin_enqueue_scripts', array($this, 'royal_option_setting_scripts') );

            // Add Royal Option Setting Menu
            add_action( 'admin_menu', array($this, 'royal_option_setting_menu'),11 );

        }

        // Add Tab Menu With Params For Royal option Setting
        public static function royal_add_option_menu( $menu_title, $menu_icon_class, $css_class, $css_id, $onclick_id ) {
            ?><li class="tablinks <?= $css_class ?>" onclick="openTab(event, '<?= $onclick_id ?>')" id="<?= $css_id ?>"><?= $menu_title ?><span class="dashicons <?= $menu_icon_class ?> custom-icon"></span></li><?php
        }

        // Add Tab Menu Content With Params For Royal Option Setting
        public static function royal_add_option_menu_content( $content_title, $header_icon, $onclick_id_tab_content, $css_class, $setting_table ) {

            ?>
            
            <div id="<?= $onclick_id_tab_content ?>" class="tabcontent <?= $css_class ?>">
                <h3 class="iravada-tab-heading"><span class="dashicons <?= $header_icon ?>"></span> <?= $content_title ?></h3>
                <?= call_user_func( $setting_table ); ?>
            </div>
            
            <?php

        }
        
        // Get Data Unserialized From Data Base
        // تنظیمات رویال را بصورت آرایه و بصورت آن سریالایز برمیگرداند
        public static function get_royal_option_settings() {

            $get_serialized_option  = get_option('royal_option_settings');

            if( !empty($get_serialized_option) ) {
                $unserialized_options   = unserialize($get_serialized_option);
                return $unserialized_options;
            }
        }

        // Load All Script Needed For Option Panel
        public function royal_option_setting_scripts() {

            $get_royal_setting = $this->get_royal_option_settings();

            // Get Unserialize Setting Data
            $get_unserialized_option  = get_option('royal_option_settings');

            // Check Data Base Data
            if( isset( $get_royal_setting['group_attributes_status'] ) ) {
                $group_attributes_status = $get_royal_setting['group_attributes_status'];
            }else {
                $group_attributes_status = 'yes';
            }

            $group_attributes_select_style = isset($get_royal_setting['group_attributes_select_style']) ? $get_royal_setting['group_attributes_select_style'] : 'title_side';

            wp_register_style( 'royal-setting-style', $this->royal_option_css_uri . 'setting-style.css', '', '10.6' );
            wp_register_script( 'royal-setting-javascript', $this->royal_option_js_uri . 'setting-script.js', array('jquery','wp-color-picker'), '10.7', true );
            
            wp_localize_script( 'royal-setting-javascript', 'royal_save_options_setting', 
                array( 
                    'ajax_url' => admin_url('admin-ajax.php'),
                    'home_url' => home_url(),
                    'myaccount_url' => admin_url( 'admin.php?page=royal_my_account' ),
                    'setting_for_export'  => $get_unserialized_option,
                    'read_more_status'  => $get_royal_setting['readmore_status'],
                    'royal_group_attribute'  => $group_attributes_status,
                    'group_attributes_select_style'  => $group_attributes_select_style,
                ) 
            );

        }

        // Get Child Theme Version
        public function get_child_theme_ver() {
            $child = wp_get_theme('IranAvada-Child');
            echo esc_html( $child->get('Version') );
        }

        // Add SubMenu 
        public function royal_option_setting_menu() {

            global $submenu;

            /* Add Menu Page Start */
            $proshop_royal_setting_panel = add_submenu_page(
                'iranavada', 
                __( 'Royal Setting Panel' , 'royal' ),
                __( 'Setting' , 'royal' ),
                'administrator',
                'proshop_royal_admin_panel',
                array($this, 'royal_setting_option_fields')
            );

            $submenu['iranavada'][0][0] = __('Dashboard', 'royal');

        }

        // Royal SubMenu Option Setting Content
        public function royal_setting_option_fields() {

            wp_enqueue_style('royal-setting-style');
            wp_enqueue_script('royal-setting-javascript');
            wp_enqueue_style('wp-color-picker');

            ?><div class="iranavada-dashboard"><?php

                do_action('pr_options_save_messages');

                if( !class_exists('IRAVADA_ADMIN_HEADER') ) {
                    require_once( get_stylesheet_directory() . '/includes/admin-screens/admin-contents/iravada-admins-header.php' );
                }
                IRAVADA_ADMIN_HEADER::iravada_dashboard_header_design('royal-setting');

                ?>
                
                <!-- Start HTML Option Panel -->

                <!-- Tab links -->
                <div class="setting-columns">
                    <div class="tab" id="tab-menus">
                        <div class="iravada-option-panel-logo-section">
                            <img src="<?php echo get_stylesheet_directory_uri() . '/includes/royal-screen/assets/img/Royal-favicon.svg' ?>" alt="" class="royal-favicon">
                            <span class="iravada-royal-heading-option"><?php _e( 'Proshop Royal' , 'royal' ); ?> <span class="iravada-royal-option-panel-ver"><?php _e( 'version ' , 'royal' ) . $this->get_child_theme_ver(); ?></span></span><br>
                        </div>
                        <ul>
                            <?php do_action('royal_options_tab_menu'); ?>
                        </ul>
                    </div>
    
                    <!-- Tab content -->
                    <form id="royal_option_saved_data_form">
                        <div class="tabs-content">
    
                            <?php do_action('royal_options_tab_content'); ?>
    
                            <div class="royal-option-save-notice-bar"></div>
                            <div class="save_button_action_bottom iravada-save-option-button">
                                <button type="submit" class="royal_option_save_btn royal-setting-button" name="option_Panel_save_data"><?php _e( 'Save Settings' , 'royal' ); ?></button>
                                <button type="submit" class="royal_option_reset_btn royal-reset-btn" name="option_Panel_reset_data"><?php _e( 'Reset Settings' , 'royal' ); ?></button>
                            </div>
    
                        </div>
                    </form>
                </div>
                <!-- End HTML Option Panel -->
                <?php

                if( !class_exists('IRAVADA_ADMIN_FOOTER') ) {
                    require_once( get_stylesheet_directory() . '/includes/admin-screens/admin-contents/iravada-admins-footer.php' );
                }
                IRAVADA_ADMIN_FOOTER::iravada_dashboard_footer_design();
            
            ?></div><?php

        }

    }new Royal_Option_Functions();

}