<?php 

if( !class_exists('Royal_Theme_Option_Setting') ) {

    class Royal_Theme_Option_Setting {
        
        protected $royal_option_setting_path = '';

        public function __construct() {

            // Royal Option Setting Path
            $this->royal_option_setting_path = get_stylesheet_directory() . '/includes/royal-screen/pages/royal-setting/';

            // Add Class To Body For Compare Close btn
            add_filter( 'body_class', array($this, 'royal_compare_close_btn') );
			
			// Load Scripts Needed On Footer
			add_action( 'wp_footer', array($this, 'irava_load_script_needed_on_footer') );

            // Run Load All Files
            $this->require_php_files_needed();

        }
        
        // Load All PHP Files Needed
        public function require_php_files_needed() {

            // Load Royal Option Main Functions 
            require_once( $this->royal_option_setting_path . 'inc/setting-functions.php' );

            // Load Royal Option Ajax Save Actions
            require_once( $this->royal_option_setting_path . 'inc/ajax-save-setting.php' );

            // Load Royal Setting Content
            require_once( $this->royal_option_setting_path . 'setting-content/general-setting.php' );
            require_once( $this->royal_option_setting_path . 'setting-content/performance-setting.php' );
            require_once( $this->royal_option_setting_path . 'setting-content/royal-myaccount.php' );
            require_once( $this->royal_option_setting_path . 'setting-content/royal-compare.php' );
            require_once( $this->royal_option_setting_path . 'setting-content/royal-group-attribute-settings.php' );
            require_once( $this->royal_option_setting_path . 'setting-content/royal-brands.php' );
            require_once( $this->royal_option_setting_path . 'setting-content/wishlist-setting.php' );
            require_once( $this->royal_option_setting_path . 'setting-content/default-setting.php' );
            require_once( $this->royal_option_setting_path . 'setting-content/royal-tutorials.php' );
            require_once( $this->royal_option_setting_path . 'setting-content/about-royal-theme.php' );

            
            // Check Woocommerce is Activated And Require PHP Worked With Woocommerce
            if( Proshop_Royal::check_plugin_activated('woocommerce/woocommerce.php') == true ) {
                
                require_once( get_stylesheet_directory() . '/includes/royal-screen/pages/royal-setting/inc/general-settings/add-to-cart-event/add-to-cart-trigger.php' ); 
                
                // load site performance panel
                require_once( get_stylesheet_directory() . '/includes/royal-screen/pages/royal-setting/inc/performance/site-performance.php' );
            }
        }

        // Add Class To Body For Compare Close btn
        public function royal_compare_close_btn($classes) {

            $get_royal_sliding_panel_option_settings = Royal_Option_Functions::get_royal_option_settings();

            // Remove Proshop Royal Attributes Price
            if( $get_royal_sliding_panel_option_settings['not_show_main_price_var_products'] == 'yes' ) {
                $classes[] = 'royal-remove-attribute-price';
            }
            
            // Remove Proshop Royal Attributes Price
            if( $get_royal_sliding_panel_option_settings['royal_woo_cart_page_form_option'] == 'yes' ) {
                if( Proshop_Royal::check_plugin_activated('woocommerce/woocommerce.php') == true ) {
                    if( is_cart() ) {
                        $classes[] = 'royal-woo-cart-page-form';
                    }   
                }
            }
            
            return $classes;
        }

        // Load Scripts In Footer
        public function irava_load_script_needed_on_footer() {
            
            $get_royal_sliding_panel_option_settings = Royal_Option_Functions::get_royal_option_settings();

            if ( $get_royal_sliding_panel_option_settings['overlay_hover_megamenu'] == 'yes' ) {

                // Load overlay-shadow.js In Frontend Page If Not Trun On Option In Option Panel
                ?>
                <script>
                    /* Royal - Overlay Shadow for Hover Menu */
                    jQuery(document).ready(function($) {
                        $('header nav.awb-menu').hover(function() {
                            $('#main').addClass('nav-focus');
                        },
                        function() {
                            $('#main').removeClass('nav-focus');
                        });
                    });
                </script>
                <?php
            }
            
            if( is_single() ) {

                if( $get_royal_sliding_panel_option_settings['variable_color_name'] == 'yes' ) {
                    
                    // Load Variable Color Name
                    ?>
                    <script>
                        /* Royal - add variable name on add to cart button */
                        jQuery(document).ready(function($) {
                            $('.avada-select-wrapper[data-type="color"]').parent().parent().each(function() {
                                jQuery(this).addClass('royal-color-variations-name');
                            });
                        });
                    </script>
                    <?php
                }
                
                ?>
                <script>
                    //* margin bottom if upsell product is on */
                    jQuery(document).ready(function($) {
                        $('.up-sells').parent().parent().parent().each(function() {
                            jQuery(this).css('margin-bottom', '10px');
                        });
                    });
                </script>
                <?php
            }
        }

    }new Royal_Theme_Option_Setting();

}