<?php 

if( !class_exists('Royal_About_Theme') ) {

    class Royal_About_Theme {

        public function __construct() {

            // Add Tutorial Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_about_theme_menu_handle') );

            // Add Tutorial Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_about_theme_content_handle') );

        }

        // Add Tutorial Tab Menu
        public function royal_about_theme_menu_handle() {

            // Add Tutorial Tab Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'About Royal Theme' , 'royal' ), 
                'dashicons-format-aside', 
                '', 
                '', 
                'about_theme' 
            );

        }

        // Add Tutorial Tab Menu Content
        public function royal_about_theme_content_handle() {

            // Add Tutorial Setting Tab Menu Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'About Royal Theme' , 'royal' ), 
                'dashicons-format-aside', 
                'about_theme',
                '', 
                array($this, 'royal_about_theme_section_content')
            );

        }

        // Handle About Royal Theme Content
        public function royal_about_theme_section_content() {

            ?>
            <div class="royal-tab-content">
                <div style="text-align: center;"><p><?php _e( 'The most advanced template available in Iran, all parts of which can be edited by the user without coding.' , 'royal' ); ?></p></div>
                <div style="text-align: center;"><p><?php _e( 'This template is only available on the <a href="https://iranavada.com/" target="_blank"> iranavada.com </a> website.' , 'royal' ); ?></p></div>
            </div>
            <?php

        }

    }new Royal_About_Theme();

}