<?php 

if( !class_exists('Royal_Default_Options') ) {

    class Royal_Default_Options {

        public function __construct() {

            // Add Default Option Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_default_setting_menu_handle') );

            // Add Default Option Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_default_setting_content_handle') );

        }

        // Add Default Option Tab Menu
        public function royal_default_setting_menu_handle() {

            // Add Default Option Tab Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'Default Option' , 'royal' ), 
                'dashicons-admin-settings', 
                '', 
                '', 
                'royal_default_option' 
            );

        }

        // Add Default Option Tab Menu Content
        public function royal_default_setting_content_handle() {

            // Add General Setting Tab Menu Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'Default Option' , 'royal' ), 
                'dashicons-admin-settings', 
                'royal_default_option',
                '', 
                array($this, 'royal_default_setting_content')
            );

        }

        // Handle Default Option Content
        public function royal_default_setting_content() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            ?>
            <div class="royal-tab-content">
                <table class="form-table no-border">
    
                    <tr class="iravada-bottom-border">
    
                        <th scope="row">
                            <lable for="iravada_royal_avada_option_setting"><?php _e( 'Royal Option' , 'royal' ); ?>
                                <p class="description"><?php _e( 'When the settings of the template are messed up or reset by mistake, you can use the button in front of you to enter the default royal settings and fix the problems.' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td> 
                            <div class="option-input-margin-right">
                                <button type="submit" name="import_avada_royal_option_setting" class="royal-setting-button royal-avada-options-btn-import"><?php _e( 'Import Settings' , 'royal' ); ?></button>
                            </div>
                        </td>
    
                    </tr>
    
                    <tr class="iravada-bottom-border">
    
                        <th scope="row">
                            <lable for="iravada_royal_mobile_theme_color"><?php _e( 'Product Filter Option' , 'royal' ); ?>
                                <p class="description"><?php _e( 'By using the opposite button, you can restore the default filter settings of Royal products' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td> 
                            <div class="option-input-margin-right">
                                <button type="submit" name="import_royal_product_filter_setting" class="royal-setting-button royal-product-filter-setting"><?php _e( 'Import Settings' , 'royal' ); ?></button>
                            </div>
                        </td>
    
                    </tr>
                    
                    <!-- zarei -->	
                    <tr>
                        <th scope="row">
                            <lable for="iravada_royal_mobile_theme_color"><?php _e( 'Complete installation of ProShopRoyal' , 'royal' ); ?>
                                <p class="description"><?php _e( 'Full ProShop Royal import imports all media, pages, template settings, menus, library, icons, forms, designed templates, sections and conditions, canvas/pop-ups, etc. at once. With a full ProShop Royal import, all settings and appearance of your site will be similar to the ProShop Royal demo. This import is more suitable for a comprehensive and overall change from another template to the ProShop Royal template.' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td>
							<div class="option-input-margin-right">
								<span id="wacmOpenModalBtn"><?php _e( 'ProshopRoyal Full Install' , 'royal' ); ?></span>
							</div>	
							<?php
								require_once(get_stylesheet_directory() . '/includes/royal-manual-setup/display/section004-import.php' );
							?>
                        </td>    
                    </tr>
					
					<tr class="iravada-bottom-border">
                        <td colspan="2">
							<div id="royal_notices"></div>
							<?php require_once(get_stylesheet_directory() . '/includes/royal-manual-setup/display/warning-after.php' ); ?>
                        </td>
                    </tr>
     
					<?php if(current_user_can('manage_options')) { ?>
                    <tr>
                        <th scope="row">
                            <lable for="iravada_royal_mobile_theme_color"><?php _e( 'Maintenance Mode' , 'royal' ); ?>
                                <p class="description"><?php _e( 'Maintenance Mode Description' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td>
							<div class="option-input-margin-right">
								<?php $is_maintenance_mode = get_option('maintenance_mode_enabled', false); ?>
								<div id="wacmMaintenanceModeToggle" class="can-toggle">
									<?php if(false==$is_maintenance_mode) { ?>
										<input type="checkbox" checked>
									<?php } else { ?>
										<input type="checkbox">
									<?php } ?>
									<label for="iravada_group_attributes_more_setting">
										<div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
									</label>
								</div>
							</div>
                        </td>    
                    </tr>
					<?php } ?>
					<!-- zarei -->
					
    
                </table>

                <!-- Start Section For Export Royal Setting -->
                <div class="royal-setting-export-import-parent">
                    <div class="export-import-section-head">
                        <h2 style="font-size: 15px;"><?php _e( 'Royal Setting Import/Export' , 'royal' ); ?></h2>
                    </div>
                    <div class="export-import-section-description">
                        <p class="description"><?php _e( 'Here you can copy Proshop Royal settings. Keep these settings in a safe place. You can use the following two buttons to import/export the settings, <strong> Note that the settings are directly output from the database, after applying the new settings, save the settings once and exit the settings after refreshing.</strong>' , 'royal' ); ?></p>
                    </div>
                    <div class="export-import-section-buttons-boxes">
                        <div class="royal-export-import-button">
                            <a href="#" class="royal-export-button"><?php _e( 'Export' , 'royal' ); ?></a>
                            <a href="#" class="royal-import-button"><?php _e( 'Import' , 'royal' ); ?></a>
                        </div>
                        <div class="royal-export-import-boxes"></div>
                    </div>
                </div>
                <!-- End Section For Export Royal Setting -->
            </div>
            <?php

        }

    }new Royal_Default_Options();

}