<?php

if( !class_exists('Royal_General_Setting') ) {

    class Royal_General_Setting {

        public function __construct() {

            // Add General Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_general_setting_menu_handle') );

            // Add General Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_general_setting_content_handle') );

        }

        // Add General Tab Menu
        public function royal_general_setting_menu_handle() {

            // Add General Setting Tab Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'General Setting' , 'royal' ), 
                'dashicons-admin-generic', 
                '', 
                'defaultOpen', 
                'general' 
            );

        }

        // Add General Tab Menu Content
        public function royal_general_setting_content_handle() {

            // Add General Setting Tab Menu Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'General Setting' , 'royal' ),  
                'dashicons-admin-generic', 
                'general',
                '', 
                array($this, 'royal_general_setting_content')
            );

        }

        // Handle General Setting Content
        public function royal_general_setting_content() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            if( Proshop_Royal::check_plugin_activated('woocommerce/woocommerce.php') == true ) {
                $woo_symbol = get_woocommerce_currency_symbol();
            }else {
                $woo_symbol = '';
            }

            ?>
            <div class="royal-tab-content">
                <table class="form-table no-border">
    
                    <tr class="iravada-bottom-border">
    
                        <th scope="row">
                            <lable for="iravada_royal_mobile_theme_color"><?php _e( 'Mobile theme tolor' , 'royal' ); ?>
                                <p class="description"><?php _e( 'sets the main template color of mobile. to view, open the site by mobile. Default color: <strong> #48cab2 </strong>' , 'royal' ); ?></p>
                            </lable>
                        </th>
    
                        <td> 
                            <div class="option-input-margin-right">
                                <input type="text" data-default-color="#00c095" value="<?php echo $get_royal_option_settings['royal_mobile_theme_color'] ? $get_royal_option_settings['royal_mobile_theme_color'] : '#00c095' ?>" id="iravada_royal_mobile_theme_color" name="royal_option[royal_mobile_theme_color]" />
                            </div>
                        </td>
    
                    </tr>
    
                    <tr class="iravada-bottom-border">
    
                        <th scope="row">
                        <lable for="iravada_royal_woo_cart_calculate_free_shipping"><?php _e( 'Set Free Shipping Limit Price' , 'royal' ); ?>
                            <p class="description"><?php _e( 'Set Price Limit For Calculate Cart Total With This Option And Show Message On Cart Page Set Price With Your Currency.' , 'royal' ); ?></p>
                        </lable>
                        </th>
                        <td> 
                            <div class="option-input-margin-right">
                                <div class="cart-calculate-curreny-input-parent">
                                    <input type="text" class="royal-text-field-style" name="royal_option[royal_woo_cart_calculate_free_shipping]" id="iravada_royal_woo_cart_calculate_free_shipping" 
                                    value="<?php echo isset($get_royal_option_settings['cart_calculate_price_display_text']) ? esc_attr($get_royal_option_settings['cart_calculate_price_display_text']) : '1000000'; ?>" 
                                    > <?= $woo_symbol ?>
                                </div>
                            </div>
                        </td>
    
                    </tr>

                    <tr class="iravada-bottom-border">
    
                        <th scope="row">
                        <lable for="iravada_variable_color_name"><?php _e( 'Displays the color names of variables' , 'royal' ); ?>
                                <p class="description"><?php _e( 'Displays the name of the color variable at the top of the color on the product page.' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td> 
                            <div class="can-toggle option-input-margin-right">
                                <input type="checkbox" name="royal_option[variable_color_name]" id="iravada_variable_color_name" value="no" <?php checked( 'no' , $get_royal_option_settings['variable_color_name'] ); ?> >
                                <label for="iravada_variable_color_name">
                                    <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                </label>
                            </div>
                        </td>
    
                    </tr>
    
                    <tr class="iravada-bottom-border">
    
                        <th scope="row">
                            <lable><?php _e( 'Beautiful Ajax Add to cart' , 'royal' ); ?>
                                <p class="description"><?php _e( 'Do the process of adding the product to the cart with Ajax.' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td> 
                            <div class="can-toggle option-input-margin-right">
                                <input type="checkbox" name="royal_option[product_single_ajax_addtocart]" id="iravada_add_product_to_cart_ajax_action" value="no" <?php checked( 'no' , $get_royal_option_settings['product_single_ajax_addtocart'] ); ?> >
                                <label for="iravada_add_product_to_cart_ajax_action">
                                    <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                </label>
                            </div>
                        </td>
    
                    </tr>
    
                    <tr class="iravada-bottom-border">
    
                        <th scope="row">
                        <lable for="iravada_royal_woo_cart_page_form_option"><?php _e( 'Displays Cart Items In Table Mode' , 'royal' ); ?>
                                <p class="description"><?php _e( 'By activating this option, the shopping cart will be displayed in table mode in the mobile version.' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td> 
                            <div class="can-toggle option-input-margin-right">
                                <input type="checkbox" name="royal_option[royal_woo_cart_page_form_option]" id="iravada_royal_woo_cart_page_form_option" value="no" <?php checked( 'no' , $get_royal_option_settings['royal_woo_cart_page_form_option'] ); ?> >
                                <label for="iravada_royal_woo_cart_page_form_option">
                                    <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                </label>
                            </div>
                        </td>
    
                    </tr>
    
                    <tr class="iravada-bottom-border">
    
                        <th scope="row">
                            <lable><?php _e( 'Failure to display initial prices on variable products' , 'royal' ); ?>
                                <p class="description"><?php _e( 'By activating this option, the initial price of the product will not be displayed in variable products.' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td> 
                            <div class="can-toggle option-input-margin-right">
                                <input type="checkbox" name="royal_option[not_show_main_price_var_products]" id="iravada_not_display_main_price_variable_products" value="no" <?php checked( 'no' , $get_royal_option_settings['not_show_main_price_var_products'] ); ?> >
                                <label for="iravada_not_display_main_price_variable_products">
                                    <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                </label>
                            </div>
                        </td>
    
                    </tr>
    
                    <tr class="iravada-bottom-border">
    
                        <th scope="row">
                            <lable><?php _e( 'Dark page cover with hover menus' , 'royal' ); ?>
                                <p class="description"><?php _e( 'By activating this option, when you place the mouse on the main menus. The background color darkens.' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td> 
                            <div class="can-toggle option-input-margin-right">
                                <input type="checkbox" name="royal_option[overlay_hover_megamenu]" id="iravada_turn_on_off_overlay_hover_megamenu" value="no" <?php checked( 'no' , $get_royal_option_settings['overlay_hover_megamenu'] ); ?> >
                                <label for="iravada_turn_on_off_overlay_hover_megamenu">
                                    <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                </label>
                            </div>
                        </td>
    
                    </tr>

                    <tr class="iravada-bottom-border royal-read-more-section">
                        <th scope="row">
                            <lable><?php _e( 'Active/Deactive Read More' , 'royal' ); ?>
                                <p class="description"><?php _e( 'Disabling this option disables Read More in Royal, if you dont need Read More, disable them.' , 'royal' ); ?></p>
                            </lable>
                        </th>
                        <td> 
                            <div class="can-toggle option-input-margin-right">
                                <input type="checkbox" name="royal_option[readmore_status]" id="iravada_read_more_status" value="no" <?php checked( 'no' , $get_royal_option_settings['readmore_status'] ); ?> >
                                <label for="iravada_read_more_status">
                                    <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                </label>
                            </div>
                        </td>
                    </tr>
                    <tr class="royal-read-more-custom-class iravada-bottom-border">
                        <th scope="row">
                            <lable for="iravada_wishlist_page"><?php _e( 'Enter Custom Class' , 'royal' ); ?>
                                <p class="description"><?php _e( 'This class is used to display the show more button, enter your custom class, note that this class is used in Avada page builder container and column.' , 'royal' ); ?></p>
                            </lable>
                        </th>
    
                        <td> 
                            <div class="option-input-margin-right">
                                <input type="text" style="font-weight: bold;" class="proshop-royal-input-style" value="royal-show-hide" disabled>
                            </div>
                        </td>
                    </tr>
                    <tr class="royal-read-more-custom-class">
                        <th scope="row">
                            <lable for="iravada_show_more_cover_color"><?php _e( 'Overlay color show more/less' , 'royal' ); ?>
                                <p class="description"><?php _e( 'Select the overlay color to show more/less. Default: #f0f5f8' , 'royal' ); ?></p>
                            </lable>
                        </th>
    
                        <td> 
                            <div class="option-input-margin-right">
                                <input type="text" data-default-color="#f0f5f8" value="<?php echo $get_royal_option_settings['show_more_cover_color'] ? $get_royal_option_settings['show_more_cover_color'] : '#f0f5f8' ?>" id="iravada_show_more_cover_color" class="iravada_show_more_cover_color" name="royal_option[show_more_cover_color]" />
                            </div>
                        </td>
                    </tr>
    
                </table>
            </div>
            <?php

        }

    }new Royal_General_Setting();

}