<?php

if( !class_exists('Royal_Performance_Setting') ) {

    class Royal_Performance_Setting {

        public function __construct() {

            // Add Performance Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_performance_setting_menu_handle') );

            // Add Performance Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_performance_setting_content_handle') );

        }

        // Add Performance Tab Menu
        public function royal_performance_setting_menu_handle() {

            // Add Performance Setting Tab Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'Site Performance' , 'royal' ),
                'dashicons-star-filled', 
                '', 
                '', 
                'royal_optimize' 
            );

        }

        // Add Performance Tab Menu Content
        public function royal_performance_setting_content_handle() {

            // Add Performance Setting Tab Menu Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'Site Performance' , 'royal' ),
                'dashicons-star-filled', 
                'royal_optimize',
                '', 
                array($this, 'royal_performance_setting_content')
            );
        
        }

        // Handle Performance Setting Content
        public function royal_performance_setting_content() {

            do_action( 'performance_tab' ); 

            $get_royal_performance_option_settings = Royal_Option_Functions::get_royal_option_settings();
            
            ?>
            <!--<div class="tab-performance">-->
            <!--    <ul>-->
            <!--        <li class="tablinks_performance active" onclick="new_tab_content_per(event, 'newtab_performance')"><span><?php //_e( 'Site Performance' , 'royal' ); ?></span></li>-->
            <!--    </ul>-->
            <!--</div>-->


            <!-- Start Tab content Performance -->

                <!-- style="display:block;" id="newtab_performance" -->
                <div class="tabcontent_performance royal-tab-content">

                    <table class="form-table no-border">

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable additional WooCommerce messages' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enabling this option disables the message bar, the Analytics tab, the WooCommerce home submenu, and speeds up management. Be sure to disable it.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disable_woocommerce_admin]" id="iravada_disable_woocommerce_admin" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disable_woocommerce_admin'] ); ?> >
                                    <label for="iravada_disable_woocommerce_admin">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable WooCommerce marketing' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enabling this option disables the non-functional WooCommerce marketing section and speeds up management. The marketing menu is removed and the coupons are placed under the WooCommerce menu.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disable_marketing_hub]" id="iravada_disable_marketing_hub" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disable_marketing_hub'] ); ?> >
                                    <label for="iravada_disable_marketing_hub">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable connection with WooCommerce.com' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enabling this option will disconnect your site from woocommerce.com and speed up WordPress management. Be sure to disable it.' ,'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disconnect_request_to_woocommerce]" id="iravada_disconnect_request_to_woocommerce" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disconnect_request_to_woocommerce'] ); ?> >
                                    <label for="iravada_disconnect_request_to_woocommerce">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable additional WooCommerce CSS and JS loads' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'By activating this option, WooCommerce scripts and styles will be removed from all pages and posts on the site and will be loaded only on the required pages. Be sure to disable it.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disable_load_woocommerce_style_scripts]" id="iravada_disable_load_woocommerce_style_scripts" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disable_load_woocommerce_style_scripts'] ); ?> >
                                    <label for="iravada_disable_load_woocommerce_style_scripts">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable WooCommerce status in the counter menu' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enabling this option disables the WooCommerce status box, sales report and orders in the WordPress counter, making the counter faster.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disable_woocommerce_status_metabox]" id="iravada_disable_woocommerce_status_metabox" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disable_woocommerce_status_metabox'] ); ?> >
                                    <label for="iravada_disable_woocommerce_status_metabox">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable Marketplace Offers' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enabling this option disables WooCommerce Marketplace offers and speeds up management. Be sure to disable it.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disable_marketplace_suggestions]" id="iravada_disable_marketplace_suggestions" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disable_marketplace_suggestions'] ); ?> >
                                    <label for="iravada_disable_marketplace_suggestions">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable the menu and the Add-ons section' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enabling this option will disable the WooCommerce Add-ons menu and page in the WooCommerce submenu.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disable_woocommerce_addon_menu]" id="iravada_disable_woocommerce_addon_menu" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disable_woocommerce_addon_menu'] ); ?> >
                                    <label for="iravada_disable_woocommerce_addon_menu">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable password power script' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enabling this option removes the password authentication script from the pages that are not needed and only loads in the "<strong> Registration </strong>" and "<strong> Password Recovery </strong>" pages.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disable_password_Strength]" id="iravada_disable_password_Strength" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disable_password_Strength'] ); ?> >
                                    <label for="iravada_disable_password_Strength">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable Fragments Shopping Cart' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'The fragments feature is used to update the entire shopping cart without reloading the page. Disabling it will speed up the site, but may lead to miscalculation in the small portfolio. If you select active, fragments will be removed from the pages. Use with caution.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disable_cart_fragments]" id="iravada_disable_cart_fragments" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disable_cart_fragments'] ); ?> >
                                    <label for="iravada_disable_cart_fragments">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr class="iravada-bottom-border">

                            <th scope="row">
                                <lable><?php _e( 'Disable Gutenberg WooCommerce blocks' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enabling this option removes Gutenberg WooCommerce editor styles that are virtually useless from the pages and speeds up the site.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[disable_woocommerce_blocks]" id="iravada_disable_woocommerce_blocks" value="no" <?php checked( 'no', $get_royal_performance_option_settings['disable_woocommerce_blocks'] ); ?> >
                                    <label for="iravada_disable_woocommerce_blocks">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                        <tr>

                            <th scope="row">
                                <lable><?php _e( 'Disable Gutenberg widgets' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enabling this option disables Gutenberg new gadgets and enables classic gadgets.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[royal_on_off_classic_widgets_area]" id="iravada_royal_on_off_classic_widgets_area" value="no" <?php checked( 'no', $get_royal_performance_option_settings['royal_on_off_classic_widgets_area'] ); ?> >
                                    <label for="iravada_royal_on_off_classic_widgets_area">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>

                        </tr>

                    </table>

                </div>

            <!-- End Tab content Performance -->

            <?php

        }

    }new Royal_Performance_Setting();

}