<?php

if( !class_exists('Royal_Brands_Setting') ) {

    class Royal_Brands_Setting {

        public function __construct() {

            // Add Brands Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_brands_setting_menu_handle') );

            // Add Brands Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_brands_setting_content_handle') );
        }

        // Add Brands Tab Menu
        public function royal_brands_setting_menu_handle() {

            // Add Brands Setting Tab Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'Royal Brands' , 'royal' ), 
                'dashicons-awards', 
                '', 
                '', 
                'brands' 
            );
        }
        
        // Add Brands Tab Menu Content
        public function royal_brands_setting_content_handle() {
            
            // Add Brands Setting Tab Menu Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'Royal Brands' , 'royal' ),  
                'dashicons-awards', 
                'brands',
                '', 
                array($this, 'royal_brand_setting_content')
            );
        }

        // Handle Brands Setting Content
        public function royal_brand_setting_content() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
			
			$Woocommerce_Brands_Status = isset( $get_royal_option_settings['woocommerce_brand_status'] ) ? $get_royal_option_settings['woocommerce_brand_status'] : 'no';

            if( IPL_CLIENT_UPDATE_THEME::update() ) {
                
                ?>
                <div class="royal-tab-content">
                    
                    <table class="form-table no-border">
    
                        <tr class="iravada-bottom-border">
        
                            <th scope="row">
                            <lable for="iravada_royal_brand_status"><?php _e( 'Active / Deactive Royal Brand' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Set Royal Brand Status.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    
                                    <?php 
                                    $royal_brand_status = isset($get_royal_option_settings['royal_brand_status']) 
                                        ? $get_royal_option_settings['royal_brand_status'] 
                                        : 'yes'; // پیش‌فرض فعال
                                    ?>
                                    <input type="checkbox" 
                                           name="royal_option[royal_brand_status]" 
                                           id="iravada_royal_brand_status" 
                                           value="no" 
                                           <?php checked('no', $royal_brand_status); ?> >
                                    
                                    <label for="iravada_royal_brand_status">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>
        
                        </tr>
						
						<tr class="iravada-bottom-border">
        
                            <th scope="row">
                            <lable for="iravada_woocommerce_brand_status"><?php _e( 'Active / Deactive Woocommerce Brand' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Set Woocommerce Plugin Brand Status.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[woocommerce_brand_status]" id="iravada_woocommerce_brand_status" value="no" <?php checked( 'no' , $Woocommerce_Brands_Status ); ?> >
                                    <label for="iravada_woocommerce_brand_status">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>
        
                        </tr>
    
                        <tr class="iravada-bottom-border">
        
                            <th scope="row">
                            <lable for="iravada_royal_brand_custom_slug"><?php _e( 'Set Royal Brands Custom Slug' , 'royal' ); ?>
                                <p class="description"><?php _e( 'If You Need Custom Slug Put Own Slug In Front Field.' , 'royal' ); ?></p>
                            </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <?php $royal_custom_brand_slug = isset($get_royal_option_settings['royal_custom_brand_slug']) ? $get_royal_option_settings['royal_custom_brand_slug'] : 'brand'; ?>
                                    <input type="text" class="royal-text-field-style" name="royal_option[royal_custom_brand_slug]" id="iravada_royal_brand_custom_slug" placeholder="brand" value="<?php echo esc_attr($royal_custom_brand_slug); ?>" >
                                </div>
                            </td>
        
                        </tr>
    
                        <?php 
    
                        if( Proshop_Royal::check_plugin_activated('perfect-woocommerce-brands/perfect-woocommerce-brands.php') == true ) {
    
                            ?>
                            <tr class="iravada-bottom-border">
            
                                <th scope="row">
                                    <lable for="iravada_royal_brand_import_pwb"><?php _e( 'Import Royal Brand From plugins PWB' , 'royal'); ?>
                                        <p class="description"><?php _e( 'If You Use PWB Brands Plugin. You Can Import All Brands From Plugin To Royal Brand.' , 'royal' ); ?></p>
                                    </lable>
                                </th>
                                <td> 
                                    <div class="option-input-margin-right">
                                        <button type="submit" name="iravada_royal_brand_import_pwb" data-brand-plugin="perfect-brand" class="royal-setting-button iravada-royal-brand-import-btn"><?php _e( 'Import Brands' , 'royal' ); ?></button>
                                    </div>
                                </td>
    
                            </tr>
                            <?php
    
                        }
                        if( Proshop_Royal::check_plugin_activated('woocommerce-brands/woocommerce-brands.php') == true ) {
    
                            ?>
                            <tr class="iravada-bottom-border">
            
                                <th scope="row">
                                    <lable for="iravada_royal_brand_import_woo_brand"><?php _e( 'Import from woocommerce-brands plugin' , 'royal'); ?>
                                        <p class="description"><?php _e( 'Importing the brands of the woocommerce-brands plugin, which is created by woocommerce.com.' , 'royal' ); ?></p>
                                    </lable>
                                </th>
                                <td> 
                                    <div class="option-input-margin-right">
                                        <button type="submit" name="iravada_royal_brand_import_woo_brand" data-brand-plugin="woocommerce-brands" class="royal-setting-button iravada-royal-brand-import-btn"><?php _e( 'Import Brands' , 'royal' ); ?></button>
                                    </div>
                                </td>
    
                            </tr>
                            <?php
                        }
                        
                        ?>
                    </table>
                </div>
                <?php

            }else {
                ?><span style="display: block;width: 100%;padding: 10px 0;text-align: center;background: #d32f2f36;color: #d32f2f;border-radius: 5px;border: 1px solid #d32f2f57;">لطفا برای فعالسازی این بخش لایسنس خود را ثبت/تمدید نمایید</span><?php   
            }
        }

    }new Royal_Brands_Setting();
}
