<?php

if( !class_exists('Royal_Compare_Setting') ) {

    class Royal_Compare_Setting {

        public function __construct() {

            // Add Compare Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_compare_setting_menu_handle') );

            // Add Compare Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_compare_setting_content_handle') );

        }

        // Add Compare Tab Menu
        public function royal_compare_setting_menu_handle() {

            // Add Compare Setting Tab Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'Royal Compare' , 'royal' ), 
                'dashicons-grid-view', 
                '', 
                '', 
                'royal_compare' 
            );

        }

        // Add Compare Tab Menu Content
        public function royal_compare_setting_content_handle() {

            // Add Compare Setting Tab Menu Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'Royal Compare' , 'royal' ),  
                'dashicons-grid-view', 
                'royal_compare',
                '', 
                array($this, 'royal_compare_setting_content')
            );

        }

        // Handle Compare Setting Content
        public function royal_compare_setting_content() {
            
            
            /*
            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            $get_royal_compare_status = '';
            $get_royal_compare_page = '';

            if( isset( $get_royal_option_settings['royal_compare_status'] ) ) {
                $get_royal_compare_status = $get_royal_option_settings['royal_compare_status'];
            }

            if( isset( $get_royal_option_settings['royal_compare_status'] ) ) {
                $get_royal_compare_page = $get_royal_option_settings['compare_page'];
            }
            */
            
            
            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            // مقداردهی امن
            $get_royal_compare_status = isset( $get_royal_option_settings['royal_compare_status'] ) 
                ? $get_royal_option_settings['royal_compare_status'] 
                : 'yes'; // پیشفرض فعال
            
            $get_royal_compare_page = isset( $get_royal_option_settings['compare_page'] ) 
                ? intval( $get_royal_option_settings['compare_page'] ) 
                : 0; // پیشفرض بدون صفحه
                

            if( IPL_CLIENT_UPDATE_THEME::update() ) {

                ?>
                <div class="royal-tab-content">
                    <table class="form-table no-border">
    
                        <tr class="iravada-bottom-border">
        
                            <th scope="row">
                            <lable for="iravada_royal_compare_status"><?php _e( 'Active / Deactive Royal Compare' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Set Royal Compare Status.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[royal_compare_status]" id="iravada_royal_compare_status" value="no" <?php checked( 'no' , $get_royal_compare_status ); ?> >
                                    <label for="iravada_royal_compare_status">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>
        
                        </tr>
                        <tr>
                            <th scope="row">
                                <lable for="iravada_compare_page"><?php _e( 'Select Compare Page' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Select The Compare Page.' , 'royal' ); ?></p>
                                </lable>
                            </th>
        
                            <td> 
                                <div class="option-input-margin-right">
                                    <select id="compare_page" class="iravada_select_style" name="royal_option[compare_page]">
                                        <option value="NAN" <?php selected( $get_royal_compare_page, 'NAN' ); ?>>یک صفحه را انتخاب کنید</option>
                                        <?php 
                                            $get_wordpress_pages_query = new WP_Query();
                                            $all_wp_pages = $get_wordpress_pages_query->query( array(
                                                'post_type' => 'page',
                                                'posts_per_page' => -1
                                            ));
        
                                            foreach ($all_wp_pages as $value){
        
                                                $post       = get_page($value);
                                                $title      = $post->post_title;
                                                $id         = $post->ID;
        
                                                ?><option value="<?= $id ?>" <?php selected( $get_royal_compare_page, $id ); ?>><?= $title ?></option><?php
                                            }; 
                                        ?>
                                    </select>
                                    <p style="font-size: 11px;">برای ویرایش و طراحی صفحه مقایسه محصولات 
                                        <a href="<?php echo $get_royal_compare_page ? esc_url( get_edit_post_link($get_royal_compare_page) ) : '#'; ?>" 
                                       class="royal-edit-compare-page" 
                                       style="font-weight: bold;" 
                                       data-id="<?php echo esc_attr($get_royal_compare_page); ?>" 
                                       target="_blank">اینجا</a>

                                            کلیک کنید.</p>
                                </div>
                            </td>
                        </tr>
        
                    </table>
                </div>
                <?php

            }else {
                ?><span style="display: block;width: 100%;padding: 10px 0;text-align: center;background: #d32f2f36;color: #d32f2f;border-radius: 5px;border: 1px solid #d32f2f57;">لطفا برای فعالسازی این بخش لایسنس خود را ثبت/تمدید نمایید</span><?php   
            }

        }

    }new Royal_Compare_Setting();

}