<?php

if( !class_exists('Royal_Group_Attribute_Settings') ) {

    class Royal_Group_Attribute_Settings {

        public function __construct() {

            // Add Default Option Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_group_attribute_menu_handle') );

            // Add Default Option Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_group_attribute_content_handle') );

        }

        // Add Group Attribute Menu
        public function royal_group_attribute_menu_handle() {

            // Add Group Attribute Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'Royal Group Attribute' , 'royal' ), 
                'dashicons-editor-table', 
                '', 
                '', 
                'royal_group_attr_settings' 
            );

        }

        // Add Group Attribute Content
        public function royal_group_attribute_content_handle() {

            // Add Group Attribute Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'Royal Group Attribute' , 'royal' ), 
                'dashicons-editor-table', 
                'royal_group_attr_settings',
                '', 
                array($this, 'royal_group_attribute_setting_content')
            );

        }

        // Load All Settings Needed For Royal Group Attribute
        public function royal_group_attribute_setting_content() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            // Check ISSET group_attributes_status
            if( isset( $get_royal_option_settings['group_attributes_status'] ) ) {
                $group_attributes_status = $get_royal_option_settings['group_attributes_status'];
            }else {
                $group_attributes_status = '';
            }

            // Check ISSET group_attributes_display_weight
            if( isset( $get_royal_option_settings['group_attributes_display_weight'] ) ) {
                $group_attributes_display_weight = $get_royal_option_settings['group_attributes_display_weight'];
            }else {
                $group_attributes_display_weight = '';
            }
                        
            // Check ISSET group_attributes_display_dimensions
            if( isset( $get_royal_option_settings['group_attributes_display_dimensions'] ) ) {
                $group_attributes_display_dimensions = $get_royal_option_settings['group_attributes_display_dimensions'];
            }else {
                $group_attributes_display_dimensions = '';
            }

            // Check ISSET group_attributes_other_text
            if( isset( $get_royal_option_settings['group_attributes_other_text'] ) ) {
                $group_attributes_other_text = $get_royal_option_settings['group_attributes_other_text'];
            }else {
                $group_attributes_other_text = '';
            }

            // Check ISSET group_attributes_select_style
            if( isset( $get_royal_option_settings['group_attributes_select_style'] ) ) {
                $group_attributes_select_style = $get_royal_option_settings['group_attributes_select_style'];
            }else {
                $group_attributes_select_style = 'title_side';
            }

            // Check ISSET group_attributes_more_setting
            if( isset( $get_royal_option_settings['group_attributes_more_setting'] ) ) {
                $group_attributes_more_setting = $get_royal_option_settings['group_attributes_more_setting'];
            }else {
                $group_attributes_more_setting = '';
            }

            // Check ISSET group_attributes_variable_display_style
            if( isset( $get_royal_option_settings['group_attributes_variable_display_style'] ) ) {
                $group_attributes_variable_display_style = $get_royal_option_settings['group_attributes_variable_display_style'];
            }else {
                $group_attributes_variable_display_style = 'under';
            }
            
            // Start Get Options For Style > Title On Side ==> Start

                // Check ISSET royal_group_attr_title_text_color_s_one
                if( isset( $get_royal_option_settings['royal_group_attr_title_text_color_s_one'] ) ) {
                    $royal_group_attr_title_text_color_s_one = $get_royal_option_settings['royal_group_attr_title_text_color_s_one'];
                }else {
                    $royal_group_attr_title_text_color_s_one = '#333333';
                }

                // Check ISSET group_attribute_title_icon_s_one
                if( isset( $get_royal_option_settings['group_attribute_title_icon_s_one'] ) ) {
                    $group_attribute_title_icon_s_one = $get_royal_option_settings['group_attribute_title_icon_s_one'];
                }else {
                    $group_attribute_title_icon_s_one = 'icon1';
                }

                // Check ISSET royal_group_attr_title_icon_color_s_one
                if( isset( $get_royal_option_settings['royal_group_attr_title_icon_color_s_one'] ) ) {
                    $royal_group_attr_title_icon_color_s_one = $get_royal_option_settings['royal_group_attr_title_icon_color_s_one'];
                }else {
                    $royal_group_attr_title_icon_color_s_one = '#21d392';
                }
        
                // Check ISSET royal_group_attr_variable_title_text_color_s_one
                if( isset( $get_royal_option_settings['royal_group_attr_variable_title_text_color_s_one'] ) ) {
                    $royal_group_attr_variable_title_text_color_s_one = $get_royal_option_settings['royal_group_attr_variable_title_text_color_s_one'];
                }else {
                    $royal_group_attr_variable_title_text_color_s_one = '#81858b';
                }
    
                // Check ISSET royal_group_attr_variable_text_color_s_one
                if( isset( $get_royal_option_settings['royal_group_attr_variable_text_color_s_one'] ) ) {
                    $royal_group_attr_variable_text_color_s_one = $get_royal_option_settings['royal_group_attr_variable_text_color_s_one'];
                }else {
                    $royal_group_attr_variable_text_color_s_one = '#333';
                }

                // Check ISSET royal_group_attr_link_hover_text_color_s_one
                if( isset( $get_royal_option_settings['royal_group_attr_link_hover_text_color_s_one'] ) ) {
                    $royal_group_attr_link_hover_text_color_s_one = $get_royal_option_settings['royal_group_attr_link_hover_text_color_s_one'];
                }else {
                    $royal_group_attr_link_hover_text_color_s_one = '#00c095';
                }

            // Start Get Options For Style > Title On Side ==> End

            // Start Get Options For Style > Title On Top ==> Start

                // Check ISSET royal_group_attr_title_text_color_s_two
                if( isset( $get_royal_option_settings['royal_group_attr_title_text_color_s_two'] ) ) {
                    $royal_group_attr_title_text_color_s_two = $get_royal_option_settings['royal_group_attr_title_text_color_s_two'];
                }else {
                    $royal_group_attr_title_text_color_s_two = '#333333';
                }

                // Check ISSET group_attribute_title_icon_s_two
                if( isset( $get_royal_option_settings['group_attribute_title_icon_s_two'] ) ) {
                    $group_attribute_title_icon_s_two = $get_royal_option_settings['group_attribute_title_icon_s_two'];
                }else {
                    $group_attribute_title_icon_s_two = 'icon1';
                }

                // Check ISSET royal_group_attr_title_icon_color_s_two
                if( isset( $get_royal_option_settings['royal_group_attr_title_icon_color_s_two'] ) ) {
                    $royal_group_attr_title_icon_color_s_two = $get_royal_option_settings['royal_group_attr_title_icon_color_s_two'];
                }else {
                    $royal_group_attr_title_icon_color_s_two = '#21d392';
                }
        
                // Check ISSET royal_group_attr_variable_title_text_color_s_two
                if( isset( $get_royal_option_settings['royal_group_attr_variable_title_text_color_s_two'] ) ) {
                    $royal_group_attr_variable_title_text_color_s_two = $get_royal_option_settings['royal_group_attr_variable_title_text_color_s_two'];
                }else {
                    $royal_group_attr_variable_title_text_color_s_two = '#333333';
                }
    
                // Check ISSET royal_group_attr_variable_background_color_s_two
                if( isset( $get_royal_option_settings['royal_group_attr_variable_background_color_s_two'] ) ) {
                    $royal_group_attr_variable_background_color_s_two = $get_royal_option_settings['royal_group_attr_variable_background_color_s_two'];
                }else {
                    $royal_group_attr_variable_background_color_s_two = '#fafafa';
                }
    
                // Check ISSET royal_group_attr_variable_text_color_s_two
                if( isset( $get_royal_option_settings['royal_group_attr_variable_text_color_s_two'] ) ) {
                    $royal_group_attr_variable_text_color_s_two = $get_royal_option_settings['royal_group_attr_variable_text_color_s_two'];
                }else {
                    $royal_group_attr_variable_text_color_s_two = '#333333';
                }
    
                // Check ISSET royal_group_attr_variable_text_background_color_s_two
                if( isset( $get_royal_option_settings['royal_group_attr_variable_text_background_color_s_two'] ) ) {
                    $royal_group_attr_variable_text_background_color_s_two = $get_royal_option_settings['royal_group_attr_variable_text_background_color_s_two'];
                }else {
                    $royal_group_attr_variable_text_background_color_s_two = '#fafafa';
                }

                // Check ISSET royal_group_attr_link_hover_text_color_s_two
                if( isset( $get_royal_option_settings['royal_group_attr_link_hover_text_color_s_two'] ) ) {
                    $royal_group_attr_link_hover_text_color_s_two = $get_royal_option_settings['royal_group_attr_link_hover_text_color_s_two'];
                }else {
                    $royal_group_attr_link_hover_text_color_s_two = '#00c095';
                }

            // Start Get Options For Style > Title On Top ==> End

            // Check ISSET group_attr_color_display
            if( isset( $get_royal_option_settings['group_attr_color_display'] ) ) {
                $group_attr_color_display = $get_royal_option_settings['group_attr_color_display'];
            }else {
                $group_attr_color_display = 'circle_text';
            }

            // Check ISSET group_attr_image_display
            if( isset( $get_royal_option_settings['group_attr_image_display'] ) ) {
                $group_attr_image_display = $get_royal_option_settings['group_attr_image_display'];
            }else {
                $group_attr_image_display = 'img_text';
            }

            if( IPL_CLIENT_UPDATE_THEME::update() ) {

                ?>
                <div class="royal-tab-content">
                    <table class="form-table no-border ">
    
                        <tr class="iravada-bottom-border">
                            <th scope="row">
                                <lable><?php _e( 'Active/Deactive Group Attribute' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Disabling this option disables Group Attribute in Royal, if you dont need Group Attribute, disable them.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[group_attributes_status]" id="iravada_group_attributes_status" value="no" <?php checked( 'no' , $group_attributes_status ); ?> >
                                    <label for="iravada_group_attributes_status">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting">
                            <th scope="row">
                                <lable for="iravada_group_attributes_select_style"><?php _e( 'Select Style' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Select the style for displaying feature categories on the product page.' , 'royal' ); ?></p>
                                </lable>
                            </th>
        
                            <td> 
                                <div class="option-input-margin-right">
                                    <select id="iravada_group_attributes_select_style" class="iravada_select_style" name="royal_option[group_attributes_select_style]">
                                        <option value="title_side" <?php selected( $group_attributes_select_style, 'title_side' ); ?> ><?php _e('Title On Side', 'royal'); ?></option>
                                        <option value="title_on_top" <?php selected( $group_attributes_select_style, 'title_on_top' ); ?> ><?php _e('Title On Top', 'royal'); ?></option>
                                    </select>
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting">
                            <th scope="row">
                                <lable for="iravada_group_attributes_variable_display_style"><?php _e( 'Variable display style' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Choose how to display features.' , 'royal' ); ?></p>
                                </lable>
                            </th>
        
                            <td> 
                                <div class="option-input-margin-right">
                                    <div class="radio-group">
    
                                        <input type="radio" id="under" name="royal_display_attribute_type" value="under" <?php checked( 'under' , $group_attributes_variable_display_style ); ?>>
                                        <label style="border-radius: 0px 5px 5px 0px;" for="under"><?php _e('below', 'royal'); ?></label>
    
                                        <input type="radio" id="next" name="royal_display_attribute_type" value="next" <?php checked( 'next' , $group_attributes_variable_display_style ) ?> >
                                        <label style="border-radius: 5px 0px 0px 5px;"  for="next"><?php _e('Side by side', 'royal'); ?></label>
    
                                    </div>
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting">
                            <th scope="row">
                            <lable for="iravada_group_attributes_other_text"><?php _e( 'other text' , 'royal' ); ?>
                                <p class="description"><?php _e( 'Enter your custom word for the title of uncategorized features.' , 'royal' ); ?></p>
                            </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="royal-text-field-style" name="royal_option[group_attributes_other_text]" id="iravada_group_attributes_other_text" placeholder="<?php _e('other attribute', 'royal'); ?>" value="<?= $group_attributes_other_text ? $group_attributes_other_text : 'سایر ویژگی‌ها' ?>" >
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting">
                            <th scope="row">
                                <lable><?php _e( 'Show more/less button' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'The button controls the display more/less.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[group_attributes_more_setting]" id="iravada_group_attributes_more_setting" value="no" <?php checked( 'no' , $group_attributes_more_setting ); ?> >
                                    <label for="iravada_group_attributes_more_setting">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting roup_attributes_more_number">
                            <th scope="row">
                                <lable><?php _e( 'Number of display features' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Enter the desired number to display the initial number of features. By default, 5 features are displayed. Default: 5' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="text" name="royal_option[group_attributes_more_number]" class="royal-text-field-style" id="group_attributes_more_number" value="<?php echo (! empty($get_royal_option_settings['group_attributes_more_number'])) ? $get_royal_option_settings['group_attributes_more_number'] : '5'; ?>">
                                </div>
                            </td>
                        </tr>
        
                        <tr class="iravada-bottom-border royal-group-attribute-setting">
                            <th scope="row">
                                <lable><?php _e( 'Display Product Color Attibute Background' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'By activating this option, You Can Display Color Attribute Circle Background.' , 'royal' ); ?></p>
                                </lable>
                            </th>
        
                            <td> 
                                <div class="option-input-margin-right">
                                    <div class="radio-group">
                                        <input type="radio" id="circle_text" name="royal_attr_color_text" value="circle_text" <?php checked( 'circle_text' , $group_attr_color_display ); ?>>
                                        <label style="border-radius: 0px 5px 5px 0px;" for="circle_text">رنگ و متن</label>
    
                                        <input type="radio" id="color_circle" name="royal_attr_color_text" value="circle" <?php checked( 'circle' , $group_attr_color_display ) ?> >
                                        <label for="color_circle">رنگ</label>
    
                                        <input type="radio" id="color_text" name="royal_attr_color_text" value="text" <?php checked( 'text' , $group_attr_color_display ) ?> >
                                        <label style="border-radius: 5px 0px 0px 5px;" for="color_text">متن</label>
                                    </div>
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting">
                            <th scope="row">
                            <lable><?php _e( 'Display Product Attibute Image' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'By activating this option, You Can Display Image Attribute.' , 'royal' ); ?></p>
                                </lable>
                            </th>
        
                            <td> 
                                <div class="option-input-margin-right">
                                    <div class="radio-group">
                                        <input type="radio" id="img_text" name="royal_attr_img_text" value="img_text" <?php checked( 'img_text' , $group_attr_image_display ); ?>>
                                        <label style="border-radius: 0px 5px 5px 0px;" for="img_text">عکس و متن</label>
    
                                        <input type="radio" id="img" name="royal_attr_img_text" value="img" <?php checked( 'img' , $group_attr_image_display ) ?> >
                                        <label for="img">عکس</label>
    
                                        <input type="radio" id="text" name="royal_attr_img_text" value="text" <?php checked( 'text' , $group_attr_image_display ) ?> >
                                        <label style="border-radius: 5px 0px 0px 5px;" for="text">متن</label>
                                    </div>
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting">
                            <th scope="row">
                                <lable><?php _e( 'display weight' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'display weight in attributes.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[group_attributes_display_weight]" id="iravada_group_attributes_display_weight" value="no" <?php checked( 'no' , $group_attributes_display_weight ); ?> >
                                    <label for="iravada_group_attributes_display_weight">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting">
                            <th scope="row">
                                <lable><?php _e( 'display dimensions' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'display dimensions in attributes.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[group_attributes_display_dimensions]" id="iravada_group_attributes_display_dimensions" value="no" <?php checked( 'no' ,  $group_attributes_display_dimensions ); ?> >
                                    <label for="iravada_group_attributes_display_dimensions">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>
                        </tr>
    
                        <!-- Start Setting Html For Style On Side ====> Start -->
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s1">
                            <th scope="row">
                                <lable for="iravada_group_attr_title_text_color"><?php _e( 'Group Attribute Title Text color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Category title text color. Default color: <strong> #333333 </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#333333" value="<?php echo $royal_group_attr_title_text_color_s_one ?>" id="iravada_group_attr_title_text_color_s_one" name="royal_option[royal_group_attr_title_text_color_s_one]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s1">
                            <th scope="row">
                                <lable><?php _e( 'Group Attribute Title Icon' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Select Icon For Royal Group Attribute Title.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <div id="attribute_icon">
                                    
                                        <!-- رادیو باتن‌های آیکون -->
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_one" value="noIcon" id="noIcon_s_one" <?php checked($group_attribute_title_icon_s_one, 'noIcon'); ?> />
                                        <label for="noIcon_s_one">X</label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_one" value="icon1" id="icon1_s_one" <?php checked($group_attribute_title_icon_s_one, 'icon1'); ?> />
                                        <label for="icon1_s_one"><svg width="100%" viewBox="-2.16 -2.16 28.32 28.32" fill="#1C274C" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="#1C274C"/> </g></svg></label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_one" value="icon2" id="icon2_s_one" <?php checked($group_attribute_title_icon_s_one, 'icon2'); ?> />
                                        <label for="icon2_s_one"><svg width="100%" viewBox="0 0 24 24" fill="#1C274C" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <circle cx="12" cy="12" r="10" fill="#1C274C"/> </g></svg></label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_one" value="icon3" id="icon3_s_one" <?php checked($group_attribute_title_icon_s_one, 'icon3'); ?> />
                                        <label for="icon3_s_one"><svg width="100%" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="#1C274C"/> </g></svg></label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_one" value="icon4" id="icon4_s_one" <?php checked($group_attribute_title_icon_s_one, 'icon4'); ?> />
                                        <label for="icon4_s_one"><svg width="100%" viewBox="-2.16 -2.16 28.32 28.32" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M3.46447 3.46447C2 4.92893 2 7.28595 2 12C2 16.714 2 19.0711 3.46447 20.5355C4.92893 22 7.28595 22 12 22C16.714 22 19.0711 22 20.5355 20.5355C22 19.0711 22 16.714 22 12C22 7.28595 22 4.92893 20.5355 3.46447C19.0711 2 16.714 2 12 2C7.28595 2 4.92893 2 3.46447 3.46447ZM9.17157 15.5784C8.75736 15.5784 8.42157 15.2426 8.42157 14.8284L8.42157 10.5858C8.42157 10.1716 8.75736 9.83579 9.17157 9.83578C9.58579 9.83579 9.92157 10.1716 9.92157 10.5858L9.92157 13.0178L14.2981 8.64124C14.591 8.34835 15.0659 8.34835 15.3588 8.64124C15.6517 8.93414 15.6517 9.40901 15.3588 9.7019L10.9822 14.0784H13.4142C13.8284 14.0784 14.1642 14.4142 14.1642 14.8284C14.1642 15.2426 13.8284 15.5784 13.4142 15.5784L9.17157 15.5784Z" fill="#1C274C"/> </g></svg></label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_one" value="icon5" id="icon5_s_one" <?php checked($group_attribute_title_icon_s_one, 'icon5'); ?> />
                                        <label for="icon5_s_one"><svg width="100%" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(270)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M21 13.5C21 18.4706 16.9706 22.5 12 22.5C7.02944 22.5 3 18.4706 3 13.5C3 10.796 4.40858 8.44449 5.97593 6.65272C7.55461 4.84799 9.3972 3.49253 10.4939 2.76287C11.411 2.15267 12.589 2.15267 13.5061 2.76287C14.6028 3.49253 16.4454 4.84799 18.0241 6.65272C19.5914 8.44449 21 10.796 21 13.5Z" fill="#1C274C"/> </g></svg></label>
    
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s1">
                            <th scope="row">
                                <lable for="iravada_group_attr_title_icon_color"><?php _e( 'Group Attribute Title Icon Color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Category title icon color.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#21d392" value="<?php echo $royal_group_attr_title_icon_color_s_one ?>" id="iravada_group_attr_title_icon_color_s_one" name="royal_option[royal_group_attr_title_icon_color_s_one]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s1">
                            <th scope="row">
                                <lable for="iravada_group_attr_variable_title_text_color_s_one"><?php _e( 'Attribute Title Text Color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Attribute title text color. Default color: <strong> #81858b </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#81858b" value="<?php echo $royal_group_attr_variable_title_text_color_s_one ?>" id="iravada_group_attr_variable_title_text_color_s_one" name="royal_option[royal_group_attr_variable_title_text_color_s_one]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s1">
                            <th scope="row">
                                <lable for="iravada_group_attr_variable_text_color_s_one"><?php _e( 'Variable text color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Variable text color. Default color: <strong> #222222 </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#333333" value="<?php echo $royal_group_attr_variable_text_color_s_one ?>" id="iravada_group_attr_variable_text_color_s_one" name="royal_option[royal_group_attr_variable_text_color_s_one]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s1">
                            <th scope="row">
                                <lable for="royal_group_attr_link_hover_text_color_s_one"><?php _e( 'Variable Link Text Hover color' , 'royal' ); ?>
                                <p class="description"><?php _e( 'Link Text Hover Color Attribute Options. Default Hover color: <strong> #00c095 </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#00c095" value="<?php echo $royal_group_attr_link_hover_text_color_s_one ?>" id="royal_group_attr_link_hover_text_color_s_one" name="royal_option[royal_group_attr_link_hover_text_color_s_one]" />
                                </div>
                            </td>
                        </tr>
                        <!-- Start Setting Html For Style On Side ====> End -->
    
                        <!-- Start Setting Html For Style On Top ====> Start -->
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s2">
                            <th scope="row">
                                <lable for="iravada_group_attr_title_text_color"><?php _e( 'Group Attribute Title Text color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Category title text color. Default color: <strong> #333333 </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#333333" value="<?php echo $royal_group_attr_title_text_color_s_two ?>" id="iravada_group_attr_title_text_color_s_two" name="royal_option[royal_group_attr_title_text_color_s_two]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s2">
                            <th scope="row">
                                <lable><?php _e( 'Group Attribute Title Icon' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Select Icon For Royal Group Attribute Title.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <div id="attribute_icon">
                                    
                                        <!-- رادیو باتن‌های آیکون -->
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_two" value="noIcon" id="noIcon_s_two" <?php checked($group_attribute_title_icon_s_two, 'noIcon'); ?> />
                                        <label for="noIcon_s_two">X</label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_two" value="icon1" id="icon1_s_two" <?php checked($group_attribute_title_icon_s_two, 'icon1'); ?> />
                                        <label for="icon1_s_two"><svg width="100%" viewBox="-2.16 -2.16 28.32 28.32" fill="#1C274C" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="#1C274C"/> </g></svg></label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_two" value="icon2" id="icon2_s_two" <?php checked($group_attribute_title_icon_s_two, 'icon2'); ?> />
                                        <label for="icon2_s_two"><svg width="100%" viewBox="0 0 24 24" fill="#1C274C" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <circle cx="12" cy="12" r="10" fill="#1C274C"/> </g></svg></label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_two" value="icon3" id="icon3_s_two" <?php checked($group_attribute_title_icon_s_two, 'icon3'); ?> />
                                        <label for="icon3_s_two"><svg width="100%" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" fill="#1C274C"/> </g></svg></label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_two" value="icon4" id="icon4_s_two" <?php checked($group_attribute_title_icon_s_two, 'icon4'); ?> />
                                        <label for="icon4_s_two"><svg width="100%" viewBox="-2.16 -2.16 28.32 28.32" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(45)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M3.46447 3.46447C2 4.92893 2 7.28595 2 12C2 16.714 2 19.0711 3.46447 20.5355C4.92893 22 7.28595 22 12 22C16.714 22 19.0711 22 20.5355 20.5355C22 19.0711 22 16.714 22 12C22 7.28595 22 4.92893 20.5355 3.46447C19.0711 2 16.714 2 12 2C7.28595 2 4.92893 2 3.46447 3.46447ZM9.17157 15.5784C8.75736 15.5784 8.42157 15.2426 8.42157 14.8284L8.42157 10.5858C8.42157 10.1716 8.75736 9.83579 9.17157 9.83578C9.58579 9.83579 9.92157 10.1716 9.92157 10.5858L9.92157 13.0178L14.2981 8.64124C14.591 8.34835 15.0659 8.34835 15.3588 8.64124C15.6517 8.93414 15.6517 9.40901 15.3588 9.7019L10.9822 14.0784H13.4142C13.8284 14.0784 14.1642 14.4142 14.1642 14.8284C14.1642 15.2426 13.8284 15.5784 13.4142 15.5784L9.17157 15.5784Z" fill="#1C274C"/> </g></svg></label>
    
                                        <input type="radio" name="royal_group_attribute_selected_icon_s_two" value="icon5" id="icon5_s_two" <?php checked($group_attribute_title_icon_s_two, 'icon5'); ?> />
                                        <label for="icon5_s_two"><svg width="100%" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" transform="rotate(270)"><g id="SVGRepo_bgCarrier" stroke-width="0"/><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"/><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M21 13.5C21 18.4706 16.9706 22.5 12 22.5C7.02944 22.5 3 18.4706 3 13.5C3 10.796 4.40858 8.44449 5.97593 6.65272C7.55461 4.84799 9.3972 3.49253 10.4939 2.76287C11.411 2.15267 12.589 2.15267 13.5061 2.76287C14.6028 3.49253 16.4454 4.84799 18.0241 6.65272C19.5914 8.44449 21 10.796 21 13.5Z" fill="#1C274C"/> </g></svg></label>
    
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s2">
                            <th scope="row">
                                <lable for="iravada_group_attr_title_icon_color_s_two"><?php _e( 'Group Attribute Title Icon Color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Category title icon color.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#21d392" value="<?php echo $royal_group_attr_title_icon_color_s_two ?>" id="iravada_group_attr_title_icon_color_s_two" name="royal_option[royal_group_attr_title_icon_color_s_two]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s2">
                            <th scope="row">
                                <lable for="iravada_group_attr_variable_title_text_color_s_two"><?php _e( 'Attribute Title Text Color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Attribute title text color. Default color: <strong> #333333 </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#333333" value="<?php echo $royal_group_attr_variable_title_text_color_s_two ?>" id="iravada_group_attr_variable_title_text_color_s_two" name="royal_option[royal_group_attr_variable_title_text_color_s_two]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s2">
                            <th scope="row">
                                <lable for="iravada_group_attr_variable_background_color_s_two"><?php _e( 'Attribute Title Background Color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Attribute Title Background Color. Default color: <strong> #fafafa </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#fafafa" value="<?php echo $royal_group_attr_variable_background_color_s_two ?>" id="iravada_group_attr_variable_background_color_s_two" name="royal_option[royal_group_attr_variable_background_color_s_two]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s2">
                            <th scope="row">
                                <lable for="iravada_group_attr_variable_text_color_s_two"><?php _e( 'Variable text color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Variable text color. Default color: <strong> #333333 </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#333333" value="<?php echo $royal_group_attr_variable_text_color_s_two ?>" id="iravada_group_attr_variable_text_color_s_two" name="royal_option[royal_group_attr_variable_text_color_s_two]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s2">
                            <th scope="row">
                                <lable for="iravada_group_attr_variable_text_background_color_s_two"><?php _e( 'Variable text background color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Variable text background color. Default color: <strong> #fafafa </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#fafafa" value="<?php echo $royal_group_attr_variable_text_background_color_s_two ?>" id="iravada_group_attr_variable_text_background_color_s_two" name="royal_option[royal_group_attr_variable_text_background_color_s_two]" />
                                </div>
                            </td>
                        </tr>
    
                        <tr class="iravada-bottom-border royal-group-attribute-setting-s2">
                            <th scope="row">
                                <lable for="royal_group_attr_link_hover_text_color_s_two"><?php _e( 'Variable Link Text Hover color' , 'royal' ); ?>
                                <p class="description"><?php _e( 'Link Text Hover Color Attribute Options. Default Hover color: <strong> #00c095 </strong>' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="iravada_group_attr_color_pick_option" data-default-color="#00c095" value="<?php echo $royal_group_attr_link_hover_text_color_s_two ?>" id="royal_group_attr_link_hover_text_color_s_two" name="royal_option[royal_group_attr_link_hover_text_color_s_two]" />
                                </div>
                            </td>
                        </tr>
    
                        <!-- Start Setting Html For Style On Top ====> End -->
    
                        <?php 
                            if( Proshop_Royal::check_plugin_activated('woocommerce-group-attributes/woocommerce-group-attributes.php') == true ) {
                        ?>
                            <tr class="royal-group-attribute-setting">
                                
                                <th scope="row">
                                    <lable for="import_royal_group_attributes_pwb"><?php _e( 'Import Group Attributes From woocommerce group attributes' , 'royal'); ?>
                                        <p class="description"><?php _e( 'If You Use woocommerce group attributes Plugin. You Can Import All Goup Attributes From Plugin To Royal Group Attributes.' , 'royal' ); ?></p>
                                    </lable>
                                </th>
                                <td> 
                                    <div class="option-input-margin-right">
                                        <button type="submit" name="import_royal_group_attributes_pwb" class="royal-setting-button iravada-royal-group-attributes-import-btn"><?php _e( 'Import Group Attribute' , 'royal' ); ?></button>
                                    </div>
                                </td>
    
                            </tr>
                        <?php
    
                            }
                        ?>
    
    
                    </table>
                </div>
    
                <?php

            }else {
                ?><span style="display: block;width: 100%;padding: 10px 0;text-align: center;background: #d32f2f36;color: #d32f2f;border-radius: 5px;border: 1px solid #d32f2f57;">لطفا برای فعالسازی این بخش لایسنس خود را ثبت/تمدید نمایید</span><?php   
            }

        }

    } new Royal_Group_Attribute_Settings();

}