<?php

if( !class_exists('Royal_MyAccount_Setting') ) {

    class Royal_MyAccount_Setting {

        public function __construct() {

            // Add myaccount Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_myaccount_setting_menu_handle') );

            // Add myaccount Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_myaccount_setting_content_handle') );

        }

        // Add myaccount Tab Menu
        public function royal_myaccount_setting_menu_handle() {

            // Add myaccount Setting Tab Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'Royal MyAccount' , 'royal' ), 
                'dashicons-admin-users', 
                '', 
                '', 
                'royal_myaccount' 
            );

        }

        // Add myaccount Tab Menu Content
        public function royal_myaccount_setting_content_handle() {

            // Add myaccount Setting Tab Menu Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'Royal MyAccount' , 'royal' ),  
                'dashicons-admin-users', 
                'royal_myaccount',
                '', 
                array($this, 'royal_myaccount_setting_content')
            );

        }

        // Handle myaccount Setting Content
        public function royal_myaccount_setting_content() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            $get_royal_myaccount_status         = '';
            $royal_myaccount_mobile_meta_key    = '';

            if( isset( $get_royal_option_settings['royal_myaccount_status'] ) ) {
                $get_royal_myaccount_status = $get_royal_option_settings['royal_myaccount_status'];
            }

            if( isset( $get_royal_option_settings['royal_myaccount_mobile_meta_key'] ) ) {
                $royal_myaccount_mobile_meta_key = $get_royal_option_settings['royal_myaccount_mobile_meta_key'];
            }

            if( IPL_CLIENT_UPDATE_THEME::update() ) {

                ?>
                <div class="royal-tab-content">
                    <table class="form-table no-border">
    
                        <tr class="iravada-bottom-border">
        
                            <th scope="row">
                            <lable for="iravada_royal_myaccount_status"><?php _e( 'Active / Deactive Royal myaccount' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Set Royal MyAccount Status.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[royal_myaccount_status]" id="iravada_royal_myaccount_status" value="no" <?php checked( 'no' , $get_royal_myaccount_status ); ?> >
                                    <label for="iravada_royal_myaccount_status">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>
        
                        </tr>
                        <tr class="iravada-bottom-border">
                            <th scope="row">
                                <lable for="royal_myaccount_mobile_meta_key"><?php _e( 'Select Phone Number Key' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Set Phone Number Key To Display Number On Myaccount.' , 'royal' ); ?></p>
                                </lable>
                            </th>

                            <td> 
                                <div class="option-input-margin-right">
                                    <?php 

                                        global $wpdb;

                                        // دریافت کلیدهای احتمالی شماره موبایل
                                        $meta_keys = $wpdb->get_col("
                                            SELECT DISTINCT meta_key
                                            FROM {$wpdb->usermeta}
                                            WHERE meta_key LIKE '%phone%'
                                            OR meta_key LIKE '%mobile%'
                                            OR meta_key LIKE '%cell%'
											OR meta_key LIKE '%number%'
                                            LIMIT 500
                                        ");

                                        if (empty($meta_keys)) {
										echo '<p>هیچ کلید مرتبط با شماره موبایل پیدا نشد.</p>';
									} else {
										?>
										<select name="royal_myaccount_mobile_meta_key" class="iravada_select_style" id="royal_myaccount_mobile_meta_key">
											<?php
												foreach ($meta_keys as $key) {
													?><option value="<?= esc_attr($key) ?>" <?php selected( $royal_myaccount_mobile_meta_key, $key ); ?>><?= esc_html($key) ?></option><?php
												}
											?>
										</select>
										<?php
									}

                                    ?>
                                </div>
                            </td>
                        </tr>
                        <tr class="iravada-bottom-border">
                            <th scope="row">
                                <lable for="royal_myaccount_menu_text_color"><?php _e( 'Menu Color' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Set MyAccount Menu Text Color.' , 'royal' ); ?></p>
                                </lable>
                            </th>

                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="royal-myaccount-color-picker" data-default-color="#3f4064" value="<?= isset( $get_royal_option_settings['royal_myaccount_menu_text_color'] ) ? $get_royal_option_settings['royal_myaccount_menu_text_color'] : '#3f4064' ?>" id="royal_myaccount_menu_text_color" name="royal_myaccount_menu_text_color" />
                                </div>
                            </td>
                        </tr>
                        <tr class="iravada-bottom-border">
                            <th scope="row">
                                <lable for="royal_myaccount_menu_font_size"><?php _e( 'Menu Font Size' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Set Menu Font Size, Example: 15px' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="royal-text-field-style" class="royal-myaccount-input-option" value="<?= isset( $get_royal_option_settings['royal_myaccount_menu_font_size'] ) ? $get_royal_option_settings['royal_myaccount_menu_font_size'] : '15px' ?>" id="royal_myaccount_menu_font_size" name="royal_myaccount_menu_font_size" />
                                </div>
                            </td>
                        </tr>
                        <tr class="iravada-bottom-border">
                            <th scope="row">
                                <lable for="royal_myaccount_menu_icon_size"><?php _e( 'Menu Icon Size' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Set Menu Icon Size, Example: 15px' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="text" class="royal-text-field-style" class="royal-myaccount-input-option" value="<?= isset( $get_royal_option_settings['royal_myaccount_menu_icon_size'] ) ? $get_royal_option_settings['royal_myaccount_menu_icon_size'] : '22px' ?>" id="royal_myaccount_menu_icon_size" name="royal_myaccount_menu_icon_size" />
                                </div>
                            </td>
                        </tr>
                        <tr class="iravada-bottom-border">
                            <th scope="row">
                                <lable for="royal-export-btn"><?php _e( 'Export' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Export MyAccount All Settings To .json File' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <button id="royal-export-btn" class="royal-setting-button export-royal-myaccount-all-data"><?php _e('export', 'royal') ?></button>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <lable for="royal-import-btn"><?php _e( 'Import' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Import MyAccount All Settings By .json File' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="option-input-margin-right">
                                    <input type="file" name="file" accept=".json" required />
                                    <button class="royal-setting-button import-royal-myaccount-all-data" type="submit"><?php _e('import', 'royal') ?></button>
                                    <div class="royal-go-to-myaccount-edit-page"></div>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
                <?php

            }else {
                ?><span style="display: block;width: 100%;padding: 10px 0;text-align: center;background: #d32f2f36;color: #d32f2f;border-radius: 5px;border: 1px solid #d32f2f57;">لطفا برای فعالسازی این بخش لایسنس خود را ثبت/تمدید نمایید</span><?php   
            }

        }

    }new Royal_MyAccount_Setting();

}