<?php 

if( !class_exists('Royal_Tutorial_Section') ) {

    class Royal_Tutorial_Section {

        public function __construct() {

            // Add Tutorial Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_tutorial_setting_menu_handle') );

            // Add Tutorial Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_tutorial_setting_content_handle') );

        }

        // Add Tutorial Tab Menu
        public function royal_tutorial_setting_menu_handle() {

            // Add Tutorial Tab Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'Proshop Royal Tutorials' , 'royal' ), 
                'dashicons-welcome-learn-more', 
                '', 
                '', 
                'tutorial_theme' 
            );

        }

        // Add Tutorial Tab Menu Content
        public function royal_tutorial_setting_content_handle() {

            // Add Tutorial Setting Tab Menu Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'Proshop Royal Tutorials' , 'royal' ), 
                'dashicons-welcome-learn-more', 
                'tutorial_theme',
                '', 
                array($this, 'royal_tutorial_section_content')
            );

        }

        // Handle Tutorial Content
        public function royal_tutorial_section_content() {

            ?>
            <div class="royal-tab-content">
                <div style="text-align: center;">
                    <p><?php _e( 'See Proshap Royal Tutorials at <a href="https://iranavada.com/proshop-learning-list/" target="_blank" rel="noopener"> Prosop Royal Tutorials List.</a>' , 'royal' ); ?></p>
                </div>
            </div>
            <?php

        }

    }new Royal_Tutorial_Section();

}