<?php

if( !class_exists('Royal_Wishlist_Setting') ) {

    class Royal_Wishlist_Setting {

        public function __construct() {

            // Add wishlist Tab Menu
            add_action( 'royal_options_tab_menu', array($this, 'royal_wishlist_setting_menu_handle') );

            // Add wishlist Tab Menu Content
            add_action( 'royal_options_tab_content', array($this, 'royal_wishlist_setting_content_handle') );

        }

        // Add wishlist Tab Menu
        public function royal_wishlist_setting_menu_handle() {

            // Add wishlist Tab Menu
            Royal_Option_Functions::royal_add_option_menu( 
                __( 'Wishlist' , 'royal' ), 
                'dashicons-heart', 
                '', 
                '', 
                'royal_wishlist' 
            );

        }

        // Add wishlist Tab Menu Content
        public function royal_wishlist_setting_content_handle() {

            // Add wishlist Setting Tab Menu Content
            Royal_Option_Functions::royal_add_option_menu_content( 
                __( 'Wishlist' , 'royal' ), 
                'dashicons-heart', 
                'royal_wishlist',
                '', 
                array($this, 'royal_wishlist_setting_content')
            );

        }

        // Handle Wishlist Setting Content
        public function royal_wishlist_setting_content() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            if( IPL_CLIENT_UPDATE_THEME::update() ) {

                ?>
                <div class="royal-tab-content">
                    <table class="form-table no-border ">
                        <tr class="iravada-bottom-border">
                            <th scope="row">
                                <lable><?php _e( 'Active/Deactive Wishlist' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Disabling this option disables Wishlist in Royal, if you dont need Wishlist, disable them.' , 'royal' ); ?></p>
                                </lable>
                            </th>
                            <td> 
                                <div class="can-toggle option-input-margin-right">
                                    <input type="checkbox" name="royal_option[wishlist_status]" id="iravada_wishlist_status" value="no" <?php checked( 'no' , $get_royal_option_settings['wishlist_status'] ); ?> >
                                    <label for="iravada_wishlist_status">
                                        <div class="can-toggle__switch" data-checked="<?php _e( 'Deactive' , 'royal' ); ?>" data-unchecked="<?php _e( 'Active' , 'royal' ); ?>"></div>
                                    </label>
                                </div>
                            </td>
                        </tr>
                        <tr class="iravada-bottom-border">
                            <th scope="row">
                                <lable for="iravada_wishlist_page"><?php _e( 'Select Wishlist Page' , 'royal' ); ?>
                                    <p class="description"><?php _e( 'Select The Wishlist Page.' , 'royal' ); ?></p>
                                </lable>
                            </th>
        
                            <td> 
                                <div class="option-input-margin-right">
                                    <select id="wishlist_page" class="iravada_select_style" name="royal_option[wishlist_page]">
                                        <option value="NAN" <?php selected( $get_royal_option_settings['wishlist_page'], 'NAN' ); ?>>یک صفحه را انتخاب کنید</option>
                                        <?php // Query for listing all pages in the select box loop
                                            $get_wordpress_pages_query = new WP_Query();
                                            $all_wp_pages = $get_wordpress_pages_query->query( array(
                                                'post_type' => 'page',
                                                'posts_per_page' => -1
                                            ));
        
                                            foreach ($all_wp_pages as $value){
        
                                                $post       = get_page($value);
                                                $title      = $post->post_title;
                                                $id         = $post->ID;
        
                                                ?><option value="<?= $id ?>" <?php selected( $get_royal_option_settings['wishlist_page'], $id ); ?>><?= $title ?></option><?php
        
                                            }; 
                                        ?>
                                    </select>
                                    <p style="font-size: 11px;">برای ویرایش و طراحی صفحه علاقمندی <a href="<?= get_edit_post_link( $get_royal_option_settings['wishlist_page'] ) ?>" class="royal-edit-wishlist-page" style="font-weight: bold;" data-id="<?= $get_royal_option_settings['wishlist_page'] ?>" target="_blank">اینجا</a> کلیک کنید.</p>
                                </div>
                            </td>
                        </tr>
        
                    </table>
                </div>
                <?php

            }else {
                ?><span style="display: block;width: 100%;padding: 10px 0;text-align: center;background: #d32f2f36;color: #d32f2f;border-radius: 5px;border: 1px solid #d32f2f57;">لطفا برای فعالسازی این بخش لایسنس خود را ثبت/تمدید نمایید</span><?php   
            }

        }

    }new Royal_Wishlist_Setting();

}