<?php 

if( !class_exists('ROYAL_STUDIO') ) {

    class ROYAL_STUDIO {
        
        protected $rs_tab_content = '';
        protected $royal_studio_path = '';
        protected $template_include_path = '';


        public function __construct() {

            $this->rs_tab_content           = get_stylesheet_directory() . '/includes/royal-screen/admin-contents/royal-studio/rs-tab-content';
            $this->royal_studio_path        = get_stylesheet_directory() . '/includes/royal-screen/admin-contents/royal-studio';
            $this->template_include_path    = get_template_directory() . '/includes';

            // Add Royal Studio Menu
            add_action( 'admin_menu' , array($this, 'royal_studio_menu'), 40 );
            
            add_action( 'after_setup_theme', array($this, 'load_define_needed'), 99 );

            // Ajax Request Import
            add_action( 'wp_ajax_rs_import_data' , array($this, 'rs_import_data_function') );
            add_action( 'wp_ajax_nopriv_rs_import_data' , array($this, 'rs_import_data_function') );

            // Ajax Request Import
            add_action( 'wp_ajax_iravada_studio_update_data' , array($this, 'iravada_studio_update_data_func') );
            add_action( 'wp_ajax_nopriv_iravada_studio_update_data' , array($this, 'iravada_studio_update_data_func') );

        }
        
        public function load_define_needed() {
            
            defined('ItemUnicIDN');
            defined('PROSHOP_ROYAL_STUDIO');
            
        }

        // Add Menu For Royal Studio
        public function royal_studio_menu() {
            
            add_submenu_page( 
                'iranavada', 
                __('Royal Studio','royal'), 
                __('Royal Studio','royal'),
                'administrator', 
                'royal-studio', 
                array($this, 'royal_studio_handle_content_func')
            );
        }

        // Function For Load All Content For Royal Studio Page
        public function royal_studio_handle_content_func() {

            // Enqueue Scripts Needed
            wp_enqueue_script( 'royal-screen-js' );
                
            if( !get_transient('royal_studio') ) {
         
                // Get Api Response
                $response = wp_remote_get( PROSHOP_ROYAL_STUDIO, array(
                    'timeout'     => 15000,
                ) );
    
                // Get Api Body Of Data
                $retrieve_body = wp_remote_retrieve_body( $response );
                
                $load_studios = json_decode( $retrieve_body );
                $status_transient = null;
                
                foreach( $load_studios as $setTransient ) {

                    if( $setTransient->sutdio_unic_item_key == ItemUnicIDN ) {
                        $status_transient = 'OK';
                    }
                    
                }
             
                if( $status_transient == 'OK' ) {
                 
                    // Set Transient Body Data 
                    set_transient( 'royal_studio', $retrieve_body, 7 * DAY_IN_SECONDS );
                
                }
                
            }

            require_once( $this->royal_studio_path . '/royal-studio-content.php' );
            
        }

        // Render Ajax Request
        public function rs_import_data_function() {

            global $wpdb,
            $data_taxonomy,
            $get_data_type;

            // Get Transient
            $get_royal_studio_transient = get_transient( 'royal_studio' );

            // Check Transient Exists
            if( $get_royal_studio_transient ) {
                $studios = json_decode( $get_royal_studio_transient );
            }

			// Allow Upload Any File Code For Wordpress
			define('ALLOW_UNFILTERED_UPLOADS',true);
			
            // For each post.
            foreach ( $studios as $studio ) {

                if( $_POST['id'] == $studio->id ) {
                    $get_item_content           = $studio->studio_post_content ? $studio->studio_post_content : '';
                    $get_post_title             = $studio->title->rendered .' '. $studio->id ? $studio->title->rendered .' '. $studio->id : '';
                    $get_image_url              = $studio->studio_template_banner ? $studio->studio_template_banner : '';
                    $get_attach_url             = isset($studio->studio_gallery_attach_images->image_url) ? $studio->studio_gallery_attach_images->image_url : '';
                    $get_canvas_status          = isset($studio->studio_template_layout->canvas) ? $studio->studio_template_layout->canvas : '';
                    $get_canvas_option          = $studio->studio_canvas_data_page_option ? $studio->studio_canvas_data_page_option : '';
                    $get_item_public_status     = isset($studio->studio_template_layout->public_layouts) ? $studio->studio_template_layout->public_layouts : '';
                }

                $post_title = $get_post_title;
                $counter = 2;
                
                // بررسی وجود پست
                while (post_exists($post_title)) {
                    $post_title = $get_post_title . ' - ' . $counter;
                    $counter++;
                }

                if( $_POST['id'] == $studio->id && isset($studio->studio_active_menu_items->nav_menus) ) {

                    foreach( $studio->studio_active_menu_items->nav_menus as $nav_menu_item ) {

                        $response = wp_remote_get( "https://royal-studio.ir/wp-json/menus/v1/menus/$nav_menu_item", array(
                            'timeout'     => 10000,
                        ) );
                    
                        // Check for error.
                        if ( is_wp_error( $response ) ) {
                            return false;
                        }
                    
                        // Get Menus Api Body
                        $data = json_decode( wp_remote_retrieve_body( $response ), true );
                    
                        // Create a new menu.
                        $menu_id = wp_create_nav_menu( $data['name'] );

                        foreach ( $data['items'] as $nav_item ) {

                            $menu_item_data = [
                                'menu-item-db-id'           => $nav_item['db_id'],
                                'menu-item-object-id'       => $nav_item['object_id'],
                                'menu-item-object'          => $nav_item['object'],
                                'menu-item-parent-id'       => 0,
                                'menu-item-title'           => $nav_item['post_title'],
                                'menu-item-type'            => $nav_item['type'],
                                'menu-item-url'             => $nav_item['url'],
                                'menu-item-description'     => $nav_item['description'],
                                'menu-item-attr-title'      => $nav_item['attr_title'],
                                'menu-item-target'          => $nav_item['target'],
                                'menu-item-classes'         => $nav_item['classes'],
                                'menu-item-xfn'             => $nav_item['xfn'],
                                'menu-item-status'          => $nav_item['post_status'],
                            ];
                    
                            $nav_item_id = wp_update_nav_menu_item( $menu_id, 0, $menu_item_data );
                    
                            $insert_nav_items_setting = [
                                'style'                                 => $nav_item['fusion_menu_style'],
                                'icon'                                  => $nav_item['fusion_megamenu_icon'],
                                'icononly'                              => $nav_item['fusion_menu_icononly'],
                                'modal'                                 => $nav_item['fusion_megamenu_modal'],
                                'highlight_label'                       => $nav_item['fusion_highlight_label'],
                                'highlight_label_background'            => $nav_item['fusion_highlight_label_background'],
                                'highlight_label_color'                 => $nav_item['fusion_highlight_label_color'],
                                'highlight_label_border_color'          => $nav_item['fusion_highlight_label_border_color'],
                                'special_link'                          => $nav_item['fusion_special_link'],
                                'show_woo_cart_counter'                 => $nav_item['fusion_show_woo_cart_counter'],
                                'show_empty_woo_cart_counter'           => $nav_item['fusion_show_empty_woo_cart_counter'],
                                'show_woo_cart_contents'                => $nav_item['fusion_show_woo_cart_contents'],
                                'searchform_mode'                       => $nav_item['fusion_searchform_mode'],
                                'status'                                => $nav_item['fusion_megamenu_status'],
                                'width'                                 => $nav_item['fusion_megamenu_width'],
                                'columns'                               => $nav_item['fusion_megamenu_columns'],
                                'columnwidth'                           => $nav_item['fusion_megamenu_columnwidth'],
                                'thumbnail'                             => $nav_item['fusion_megamenu_thumbnail'],
                                'background_image'                      => $nav_item['fusion_megamenu_background_image'],
                                'cart_counter_display'                  => $nav_item['fusion_cart_counter_display'],
                                'off_canvas_id'                         => $nav_item['fusion_off_canvas_id'],
                            ];
                    
                            update_post_meta( $nav_item_id, '_menu_item_fusion_megamenu', $insert_nav_items_setting );
                            
                        }
                    
                    }

                }
            }

            $post_args = array(
                'post_title'    => $post_title,
                'post_content'  => $get_item_content,
                'post_type'     => $_POST['post_type'],
                'post_status'   => 'publish',
            );

            if( $get_item_public_status == 'active' ) {
                $post_args['meta_input'] = [
                    '_fusion_is_global' => 'yes',
                ];
            }

            // if( post_exists($get_post_title) ) {
            //     echo 'پست مورد نظر درون ریزی شده است، لطفا بخش مربوطه را چک کنید.';
            // }else {
                $rs_insert_status = wp_insert_post($post_args);

                if( $rs_insert_status == true ) {

                    $data_taxonomy      = $_POST['data_tax'];
                    $get_data_type      = $_POST['data_type'];

                    // Set Post Terms
                    wp_set_object_terms( $rs_insert_status, $get_data_type, $data_taxonomy );

                    $site_url = site_url();
                    $table_name_posts = $wpdb->prefix . 'posts';  // Get Table Name

                    if( $rs_insert_status == true ) {
                        $image_id = '';
                        foreach ( $get_attach_url as $image_url => $replacements ) {
        				// 	$existing_image = $this->find_existing_media( $image_url );
        				// 	if ( $existing_image ) {
        				// 		$image_id = $existing_image;
        				// 	} else {
        
                        // $img_attch_id = attachment_url_to_postid( $image_url );
            
        				// 		// We don't already have it, need to load it.
        				// 		$image_id = media_sideload_image( $image_url, $img_attch_id, null, 'id' ); // phpcs:ignore WordPress.Security
        
        				// 		if ( ! is_wp_error( $image_id ) ) {
        				// 			// Add flag to prevent duplicate imports.
        				// 			$this->add_media_meta( $image_id, $image_url );
        
        				// 			do_action( 'awb_studio_import_action', $image_id );
        				// 		}
        				// 	}
        
        					if ( ! is_wp_error( $image_id ) ) {
        						foreach ( (array) $replacements as $param_name => $old_value ) {
        							// Get ID if its mixed with size.
        							$old_id    = (int) $old_value;
        							$new_value = str_replace( $old_id, $image_id, $old_value );
        
        							// Replace the old image ID with the new one.
        							$post_content = str_replace( $param_name . '="' . $old_value . '"', $param_name . '="' . $new_value . '"', $post_content );
        						}
        						$new_url = wp_get_attachment_url( $image_id );
        					} else {
        						foreach ( (array) $replacements as $param_name => $old_value ) {
        
        							// Replace the old image ID with the empty value.
        							$post_content = str_replace( $param_name . '="' . $old_value . '"', $param_name . '=""', $post_content );
        						}
        
        						$new_url = '';
        					}
        
        					// Replace the URL as well.
        					$post_content = str_replace( $image_url, $new_url, $post_content );
        				}

                    }else {
                        echo 'درون ریزی با مشکل مواجه شد.';
                    }

                    // If For Check Canvas Is Activated Or Not
                    if( $get_canvas_status == 'active' ) {
                        update_post_meta($rs_insert_status, '_fusion', $get_canvas_option);
                    }

                    // Run Query For Update Links
                    $update_link_query_posts = $wpdb->query("UPDATE $table_name_posts SET post_content = replace(post_content, 'https://royal-studio.ir', '$site_url');");
                }
            // }

            exit;
        }

        // Update Studio Data Ajax Function
        public function iravada_studio_update_data_func() {

            // Get Api Response
            $response = wp_remote_get( 'http://royal-studio.ir/wp-json/wp/v2/proshoproyal_studio_rest?per_page=800', array(
                'timeout'     => 10000,
            ) );

            // Get Api Body Of Data
            $retrieve_body_ajax = wp_remote_retrieve_body( $response_ajax );
            
            $update_studios = json_decode( $retrieve_body_ajax );
            $status_transient = null;
            
            foreach( $update_studios as $setTransient ) {
                
                if( $setTransient->sutdio_unic_item_key == ItemUnicIDN ) {
                    $status_transient = 'OK';
                }
                
            }

            // Delete Transient
            $delete_transient = delete_transient('royal_studio');

            if( $status_transient != null && $delete_transient  ) {
             
                // Set Transient Body Data 
                set_transient( 'royal_studio', $retrieve_body_ajax, 7 * DAY_IN_SECONDS );
            
            }

            exit;
        }
    }
    new ROYAL_STUDIO();
}
