<?php
// v3.0
if( !class_exists('Iranavada_Royal_Screen') ) {

    class Iranavada_Royal_Screen {
        
        protected $iranavada_panel_css_url = '';
        protected $iranavada_royal_screen_dir = '';
        protected $css_path = '';
        protected $js_path = '';

        public function __construct() {

            $this->iranavada_panel_css_url    = get_stylesheet_directory_uri() . '/includes/royal-screen/assets/css';
            $this->iranavada_royal_screen_dir = get_stylesheet_directory() . '/includes/royal-screen/';

            $this->css_path    = get_stylesheet_directory_uri() . '/includes/royal-screen/assets/css';
            $this->js_path     = get_stylesheet_directory_uri() . '/includes/royal-screen/assets/js';

            // Admin Enqueue Scripts/Styles
            add_action( 'admin_enqueue_scripts', array($this, 'iranavada_enqueue_admin_scripts') );

            // Run All Required Files Needed
            $this->load_all_sections_needed();
        }

        // Wp Enqueue Admin Styles/Scripts
        public function iranavada_enqueue_admin_scripts() {

            wp_enqueue_style('iranavada-royal-screen-styles', $this->iranavada_panel_css_url . '/iravada-royal-screen-styles.css', '', '5.1' );

            wp_register_script( 'royal-screen-js', $this->js_path . '/rs-scripts.js', '', '5.0', true );

            // Localize Script For Dashboard Script
            wp_localize_script( 'royal-screen-js', 'rs_ajax_url', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
            wp_localize_script( 'royal-screen-js', 'studio_admin_url', array( 'studio_url' => admin_url( 'admin.php?page=royal-studio' ) ) );
            
        }

        // Load Admin Panels php
        public function load_all_sections_needed() {

            // Require Once Studio File
            require_once( $this->iranavada_royal_screen_dir . 'pages/royal-studio.php' );
            
            // Require Once IranAvada Royal Setting Options
            require_once( $this->iranavada_royal_screen_dir . 'pages/royal-setting/royal-setting.php' );

        }

    }new Iranavada_Royal_Screen();
}
