<?php
if (isset($_GET['story_id']) && !empty($_GET['story_id'])) {
    $highlight_id = sanitize_text_field($_GET['story_id']);
    $object = RoyalStoryMnage::get_royal_highlights($highlight_id);
    $highlight_data = reset($object);
    $list_stories = RoyalStoryMnage::get_royal_stories(intval($highlight_id));
} else {
    $highlight_id = 0;
    $highlight_data = ['title' => false];
}

$catlist = get_terms(
    array(
        'taxonomy' => 'product_cat',
        'hide_empty' => true
    )
);

?>
<form action="javascript:;" method="post" name="add_highlight" id="add_highlight"
    class="royal-story-form add-highlight">

    <table class="form-table">
        <tbody>
            <tr class="tr" style="border-bottom: 1px solid #e2e2e2;">
                <th scope="row">
                    <label for="highlightTitle">
                        <?php _e('Highlight title', 'royal'); ?>
                    </label>
                </th>
                <td>
                    <input type="text" id="highlightTitle" name="highlightTitle" class="regular-text" autocomplete="off"
                        placeholder="<?php _e('Highlight title', 'royal'); ?>" value="<?php if (isset($highlight_data->title) && $highlight_data->title != false)
                               echo $highlight_data->title; ?>" placeholder="<?php _e('Highlight title', 'royal'); ?>">
                </td>
            </tr>
            <tr class="tr" style="border-bottom: 1px solid #e2e2e2;">
                <th scope="row">
                    <label for="highlightImage">
                        <?php _e('Highlight image', 'royal'); ?>
                    </label>
                </th>
                <td>
                    <input type="" value="<?php if (isset($highlight_data->image_url) && $highlight_data->image_url)
                        echo $highlight_data->image_url; ?>" class="regular-text process_highlight_images <?php if (isset($highlight_data->image_url) && $highlight_data->image_url)
                              echo ('showInput'); ?>" autocomplete="off" id="process_highlight_images"
                        name="imageFile">
                    <button class="set_highlight_images button">
                        <?php _e('Set Image', 'royal'); ?>
                    </button>
                    <div class="royal-image-thumb <?php if (isset($highlight_data->image_url) && $highlight_data->image_url)
                        echo ('active'); ?>">
                        <div class="royal-delete-thumb <?php if (isset($highlight_data->image_url) && $highlight_data->image_url)
                            echo ('active'); ?>">X</div>
                        <img src="<?php if (isset($highlight_data->image_url) && $highlight_data->image_url)
                            echo $highlight_data->image_url; ?>" onerror="this.style.display='none'" alt="">
                    </div>
                </td>
            </tr>
            <tr class="tr" style="border-bottom: 1px solid #e2e2e2;">
                <th scope="row">
                    <label for="disableHighlight">
                        <?php _e('Highlight Status', 'royal'); ?>
                    </label><br>
                </th>
                <td>
                    <label class="royal-checkbox-wrap">
                        <input type="checkbox" id="disableHighlight" name="disableHighlight" class="checkbox_inp" <?php if (isset($highlight_data->status) && $highlight_data->status == 'deactive')
                            echo 'checked'; ?>>
                        <span class="highligh-status-text disableHighlight">
                            <span class="active-text"><?php _e('Deactive', 'royal'); ?></span>
                            <span class="royal-status-handler"></span>
                            <span class="deactive-text"><?php _e('Active', 'royal'); ?></span>
                        </span>
                    </label>
                    <div id="disableOptions"
                        style="display: <?php echo (isset($highlight_data->status) && $highlight_data->status == 'deactive') ? 'block' : 'none'; ?>;">
                        <table class="form-table">
                            <tbody>
                            <?php 
                            if(isset($highlight_data->deactive_from)){
                                $compare = (strtotime($highlight_data->deactive_from) - strtotime(current_time('mysql'))); 
                                $hours = ceil($compare / 3600); 
                                $disableOption = ($hours < 1) ? 'now' : 'after'; 
                            }else{
                                 $compare = (strtotime(current_time('mysql')) - strtotime(current_time('mysql'))); 
                                $hours = ceil($compare / 3600); 
                                $disableOption = ($hours < 1) ? 'now' : 'after';
                            }
                           
                            ?>
                                <tr class="tr">
                                    <th scope="row">
                                        <label for="disableNow"><input type="radio" id="disableNow" name="disableOption"
                                                value="now" class="regular-text" <?php if($disableOption == 'now'){ echo 'checked'; } ?>>
                                            <?php _e('Deactive Now', 'royal'); ?>
                                        </label><br>
                                    </th>
                                    <td>

                                    </td>
                                </tr>
                                <tr class="tr">
                                    <th scope="row">
                                        <label for="disableLater"><input type="radio" id="disableLater"
                                                name="disableOption" value="later" class="regular-text" <?php if($disableOption == 'after'){ echo 'checked'; } ?>>
                                            <?php _e('Deactive After', 'royal'); ?>
                                        </label>
                                    </th>
                                    <td>
                                        <div class="quantity">
                                            <span class="quantity-title">
                                                <?php _e('Hours', 'royal'); ?>
                                            </span>
                                            <input type="number" id="disableHours" min="1" name="disableHours"
                                                value="<?php if($disableOption == 'after'){ echo $hours; }else{ echo '1'; } ?>">
                                        </div>

                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </td>
            </tr>
            <tr class="tr" style="border-bottom: 1px solid #e2e2e2;">
                <th scope="row">
                    <label for="highlightStoryTime">
                        <?php _e('Stories duration (s)', 'royal'); ?>
                    </label>
                </th>
                <td>
                    <div class="quantity">
                        <input type="number" id="highlightStoryTime" min="1" name="highlightStoryTime"
                            value="<?php echo (isset($highlight_data->show_story_time) && $highlight_data->show_story_time) ? $highlight_data->show_story_time : 8; ?>">
                    </div>

                </td>
            </tr>
            <tr class="tr" style="border-bottom: 1px solid #e2e2e2;">
                <th scope="row">
                    <label for="highlightStoryOpenLink">
                        <?php _e('Open stories in new tab', 'royal'); ?>
                    </label>
                </th>
                <td>

                    <label class="royal-checkbox-wrap">

                        <?php if (isset($_GET['story_id'])): ?>
                            <input type="checkbox" id="highlightStoryOpenLink" name="highlightStoryOpenLink" <?php if (isset($highlight_data->open_links) && $highlight_data->open_links == '_blank')
                                echo 'checked'; ?>>
                        <?php else: ?>
                            <input type="checkbox" id="highlightStoryOpenLink" name="highlightStoryOpenLink" checked>
                        <?php endif; ?>
                        <span class="highligh-status-text royal-status-target">
                            <span class="active-text"><?php _e('Active', 'royal'); ?></span>
                            <span class="royal-status-handler"></span>
                            <span class="deactive-text"><?php _e('Deactive', 'royal'); ?></span>
                        </span>
                    </label>
                </td>
            </tr>
            <tr>
                <th>
                    <label for="highlightStoryDisplaySize">
                        <?php _e('Image display size', 'royal'); ?>
                    </label>
                </th>
                <td>
                    <label class="royal-checkbox-wrap">
                        <?php if (isset($_GET['story_id'])): ?>
                            <input type="checkbox" id="highlightStoryDisplaySize" name="highlightStoryDisplaySize" <?php if (isset($highlight_data->display_size) && $highlight_data->display_size == 'contain')
                                echo 'checked'; ?>>
                        <?php else: ?>
                            <input type="checkbox" id="highlightStoryDisplaySize" name="highlightStoryDisplaySize" checked>
                        <?php endif; ?>
                        <span class="highligh-status-text royal-status-target">
                            <span class="active-text"><?php _e('Contain', 'royal'); ?></span>
                            <span class="royal-status-handler"></span>
                            <span class="deactive-text"><?php _e('Cover', 'royal'); ?></span>
                        </span>
                    </label>
                    <p><?php _e('Cover mode is only used for photos.', 'royal'); ?></p>
                </td>
            </tr>
        </tbody>
    </table>

    <h2 class="stories title">
        <?php _e('Stories', 'royal'); ?>
        <hr>
    </h2>

    <table class="form-table">
        <tbody>
            <tr class="tr">
                <td id="storyContainer">
                    <?php if (isset($list_stories) && !empty($list_stories)):
                        $count = 1;
                        foreach ($list_stories as $story):
                            $story_title = false;
                            if ($story->type == 'simple') {
                                $type = 'btn';
                                $story_title = $story->title;
                                $type_product = false;
                            } elseif ($story->type == 'categorys') {
                                $type = 'products';
                                $type_product = 'categorys';
                                $story_title = __('category', 'royal');
                            } else {
                                $type = 'products';
                                $type_product = 'products';
                                $story_title = __('product', 'royal');
                            }

                            if (!empty($story->products)) {
                                $products = json_decode($story->products);
                            } else {
                                $products = '';
                            }

                            if (!empty($story->categorys)) {
                                $categorys = json_decode($story->categorys);
                            } else {
                                $categorys = '';
                            }
                            ?>
                            <div class="story <?php echo "story{$count}"; ?>" id="<?php echo "story{$count}"; ?>">

                                <div class="royal-accardion-title">
                                    <div class="royal-accardion-arrow">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                            <path
                                                d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z" />
                                        </svg>
                                    </div>
                                    <div class="royal-accardion-title-text">
                                        <h5>
                                            <?php echo (!empty($story_title)) ? $story_title : __('story title', 'royal'); ?>
                                        </h5>
                                    </div>
                                    <div class="roya-accardion-action">
                                        <input type="hidden" id="stories_id_<?php echo "story{$count}"; ?>" name="stories_id"
                                            value="<?php echo $story->id; ?>">
                                        <div class="icon" onclick="removeStory('<?php echo "story{$count}"; ?>')"><svg
                                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                                                <path
                                                    d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z" />
                                            </svg></div>
                                        <div class="icon" onclick="copyStory('<?php echo "story{$count}"; ?>')"><svg
                                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                                                <path
                                                    d="M384 336H192c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16l140.1 0L400 115.9V320c0 8.8-7.2 16-16 16zM192 384H384c35.3 0 64-28.7 64-64V115.9c0-12.7-5.1-24.9-14.1-33.9L366.1 14.1c-9-9-21.2-14.1-33.9-14.1H192c-35.3 0-64 28.7-64 64V320c0 35.3 28.7 64 64 64zM64 128c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64H256c35.3 0 64-28.7 64-64V416H272v32c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V192c0-8.8 7.2-16 16-16H96V128H64z" />
                                            </svg></div>
                                        <div class="icon royal-drag-btn"><svg xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 512 512">
                                                <path
                                                    d="M278.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8h32v96H128V192c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6V288h96v96H192c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8H288V288h96v32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6v32H288V128h32c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-64-64z" />
                                            </svg></div>
                                    </div>
                                </div>

                                <div class="royal-accardion-content">
                                    <?php if ($type == 'btn'): ?>
                                        <input type="hidden" value="btn" name="story-type" class="hidden-input-story-type">
                                        <button class="active" onclick="showTab('<?php echo "story{$count}"; ?>', 1, this)">
                                            <?php _e('Image/Video', 'royal'); ?>
                                        </button>
                                        <button class="" onclick="showTab('<?php echo "story{$count}"; ?>', 2, this)">
                                            <?php _e('Product/Category', 'royal'); ?>
                                        </button>
                                    <?php else: ?>
                                        <input type="hidden" value="product" name="story-type" class="hidden-input-story-type">
                                        <button class="" onclick="showTab('<?php echo "story{$count}"; ?>', 1, this)">
                                            <?php _e('Image/Video', 'royal'); ?>
                                        </button>
                                        <button class="active" onclick="showTab('<?php echo "story{$count}"; ?>', 2, this)">
                                            <?php _e('Product/Category', 'royal'); ?>
                                        </button>
                                    <?php endif; ?>


                                    <div id="<?php echo "story{$count}"; ?>_tab1" class="tabContent" <?php echo ($type == 'btn') ? 'style="display: block;"' : 'style=""'; ?>>
                                        <table class="form-table">
                                            <tbody>
                                                <tr class="tr">
                                                    <th scope="row">
                                                        <label for="<?php echo "story{$count}"; ?>_title">
                                                            <?php _e('Story title', 'royal'); ?>*
                                                        </label>
                                                    </th>
                                                    <td>
                                                        <input type="text" name="stories_title"
                                                            value="<?php echo $story->title; ?>"
                                                            class="regular-text royal-story-title-input"
                                                            id="<?php echo "story{$count}"; ?>_title" autocomplete="off"
                                                            placeholder="<?php _e('Story title', 'royal'); ?>">
                                                    </td>
                                                </tr>

                                                <tr class="tr">
                                                    <th scope="row">
                                                        <label for="<?php echo "story{$count}"; ?>_image">
                                                            <?php _e('Image/Video', 'royal'); ?>*
                                                        </label>
                                                    </th>
                                                    <td>
                                                        <input type="" class="regular-text process_story_images hidden-image-story-inp <?php if ($story->image_url)
                                                            echo ('showInput'); ?>"
                                                            id="<?php echo "story{$count}"; ?>_image" name="stories_image"
                                                            value="<?php echo $story->image_url; ?>">
                                                        <button class="set_story_images button">
                                                            <?php _e('Set', 'royal'); ?>
                                                        </button>
                                                        <div class="royal-image-thumb <?php if ($story->image_url)
                                                            echo ('active'); ?>">
                                                            <div class="royal-delete-thumb <?php if ($story->image_url)
                                                                echo ('active'); ?>">
                                                                X</div>
                                                                
                                                            <?php 
                                                                $path_info = pathinfo($story->image_url);
                                                                    
                                                                $extension = strtolower($path_info['extension']);
                                                                    
                                                                if (in_array($extension, ['mp4', 'avi', 'mkv', 'mov'])){ $image_url = home_url('/wp-includes/images/media/video.png');}else{ $image_url = $story->image_url; } ?>
                                                            <img src="<?php if ($story->image_url)
                                                                echo $image_url; ?>"
                                                                onerror="this.style.display='none'" alt="">

                                                        </div>
                                                        <p class="royal-desc-text">
                                                            <?php _e('Image size 1080x607px (recomended)', 'royal'); ?>
                                                        </p>
                                                    </td>
                                                </tr>

                                                <tr class="tr">
                                                    <th scope="row">
                                                        <label
                                                            for="<?php echo "story{$count}"; ?>_decription"><?php _e('Story description', 'royal'); ?></label>
                                                    </th>
                                                    <td>
                                                        <input type="text" value="<?php echo $story->excerpt; ?>"
                                                            class="regular-text" id="<?php echo "story{$count}"; ?>_decription"
                                                            name="stories_decription"
                                                            placeholder="<?php _e('description in story', 'royal'); ?>">
                                                    </td>
                                                </tr>
                                                <tr class="tr">
                                                    <th scope="row">
                                                        <label for="<?php echo "story{$count}"; ?>_link">
                                                            <?php _e('Story link', 'royal'); ?>
                                                        </label>
                                                    </th>
                                                    <td>
                                                        <input type="text" name="stories_link"
                                                            value="<?php echo $story->link; ?>"
                                                            class="regular-text royal-story-link-inpt"
                                                            id="<?php echo "story{$count}"; ?>_link"
                                                            placeholder="<?php _e('Story link', 'royal'); ?>">
                                                    </td>
                                                </tr>
                                                <tr class="tr">
                                                    <th scope="row">
                                                        <label for="<?php echo "story{$count}"; ?>_btntxt">
                                                            <?php _e('Story link text', 'royal'); ?>
                                                        </label>
                                                    </th>
                                                    <td>
                                                        <input type="text" value="<?php echo $story->button_text_image; ?>"
                                                            id="<?php echo "story{$count}"; ?>_btntxt" name="stories_btntxt"
                                                            class="royal-story-linkbtn-txt" autocomplete="off"
                                                            placeholder="<?php _e('show more', 'royal'); ?>">
                                                    </td>
                                                </tr>

                                                <tr class="tr">
                                                    <th scope="row">
                                                        <label for="<?php echo "story{$count}"; ?>_btnimg">
                                                            <?php _e('Story link image', 'royal'); ?>
                                                        </label>
                                                    </th>
                                                    <td>
                                                        <input type="" value="<?php echo $story->button_image_bg; ?>" class="regular-text process_story_images <?php if ($story->image_url)
                                                               echo ('showInput'); ?>"
                                                            id="<?php echo "story{$count}"; ?>_btnimg" name="stories_btnimg">
                                                        <button class="set_story_images button">
                                                            <?php _e('Set', 'royal'); ?>
                                                        </button>
                                                        <div class="royal-image-thumb <?php if ($story->button_image_bg)
                                                            echo ('active'); ?>">
                                                            <div class="royal-delete-thumb <?php if ($story->button_image_bg)
                                                                echo ('active'); ?>">
                                                                X</div>
                                                            <img src="<?php if ($story->button_image_bg)
                                                                echo $story->button_image_bg; ?>"
                                                                onerror="this.style.display='none'" alt="">
                                                        </div>
                                                    </td>
                                                </tr>



                                            </tbody>
                                        </table>
                                    </div>

                                    <div id="<?php echo "story{$count}"; ?>_tab2" class="tabContent" <?php echo ($type == 'products') ? 'style="display: block;"' : 'style=""'; ?>>
                                        <table class="form-table">
                                            <tr class="tr">
                                                <th scope="row">
                                                    <label for="stories_type_product">
                                                        <?php _e('Select Type Product', 'royal'); ?>
                                                    </label>
                                                </th>
                                                <td>
                                                    <select name="stories_type_product" class="select-story-type"
                                                        id="<?php echo "story{$count}"; ?>_type_product"
                                                        onchange="showDiv(this, '<?php echo "story{$count}"; ?>')">
                                                        <option value="products" <?php if ($type_product == 'products') {
                                                            echo 'selected';
                                                        } ?>>
                                                            <?php _e('Products', 'royal'); ?>
                                                        </option>
                                                        <option value="categorys" <?php if ($type_product == 'categorys') {
                                                            echo 'selected';
                                                        } ?>>
                                                            <?php _e('categorys', 'royal'); ?>
                                                        </option>
                                                    </select>
                                                    <table id="<?php echo "story{$count}"; ?>_section_products"
                                                        class="<?php echo "story{$count}"; ?>-section_products story-section_products"
                                                        style="display: <?php echo ($type_product == 'products') ? 'block' : 'none'; ?>;">
                                                        <tbody>
                                                            <tr class="tr">
                                                                <th scope="row">
                                                                    <label for="stories_select_products">
                                                                        <?php _e('Select Products', 'royal'); ?>
                                                                    </label>
                                                                </th>
                                                                <td>

                                                                    <div class="royal-selected-products-holder-div">
                                                                        <?php if ($story->type == 'simple') {
                                                                            echo '<div class="search_products_holder"></div>';
                                                                        } else if (is_array($products) && !empty($products)) {
                                                                            echo '<div class="search_products_holder active ui-sortable">';
                                                                            foreach ($products as $product_id) {
                                                                                $product_title = get_the_title($product_id);
                                                                                echo '<div class="selected-highlight-item ui-sortable-handle" data-id="' . $product_id . '"><span class="selected-product-title">' . $product_title . '</span> <span class="selected-product-remove">❌</span></div>';
                                                                            }
                                                                            echo '</div>';
                                                                        } else {
                                                                            echo '<div class="search_products_holder"></div>';
                                                                        } ?>


                                                                        <input type="text"
                                                                            id="<?php echo "story{$count}"; ?>_select_products"
                                                                            placeholder="<?php _e('Enter 3 characters...', 'royal'); ?>"
                                                                            name="stories_select_products" autocomplete="off"
                                                                            class="search_products">
                                                                        <input type="hidden" id="stories_product_id"
                                                                            name="stories_product_id"
                                                                            value="<?php echo implode(',', $products); ?>">
                                                                        <div id="results"></div>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>

                                                    <table id="<?php echo "story{$count}"; ?>_section_categorys"
                                                        class="<?php echo "story{$count}"; ?>-section_categorys story-section_categorys"
                                                        style="display: <?php echo ($type_product == 'categorys') ? 'block' : 'none'; ?>;">
                                                        <tbody>

                                                            <tr class="tr">
                                                                <th scope="row">
                                                                    <label for="story2_select_categorys">
                                                                        <?php _e('Select Categories', 'royal'); ?>
                                                                    </label>
                                                                </th>
                                                                <?php
                                                                if (!is_null($categorys) && !empty($categorys)) {
                                                                    $product_cat = get_term($categorys[0], 'product_cat');
                                                                    $p_cat_name = $product_cat->name;
                                                                    $p_cat_id = $product_cat->term_id;
                                                                } else {
                                                                    $p_cat_name = "";
                                                                    $p_cat_id = "";
                                                                }
                                                                ?>
                                                                <td scope="row">
                                                                    <select name="stories_cat_id">
                                                                        <?php
                                                                        if ($catlist) {
                                                                            foreach ($catlist as $category) {
                                                                                if ($p_cat_id == $category->term_id) {
                                                                                    echo '<option value="' . $category->term_id . '" selected>' . $category->name . '</option>';
                                                                                } else {
                                                                                    echo '<option value="' . $category->term_id . '">' . $category->name . '</option>';
                                                                                }
                                                                            }
                                                                        } else {
                                                                            _e('Not Found!', 'royal');
                                                                        }
                                                                        wp_reset_postdata(); ?>
                                                                    </select>
                                                                </td>
                                                            </tr>

                                                            <tr class="tr">
                                                                <th scope="row">
                                                                    <label
                                                                        for="<?php echo "story{$count}"; ?>_select_order_categorys">
                                                                        <?php _e('Sort By', 'royal'); ?>
                                                                    </label>
                                                                </th>
                                                                <td>
                                                                    <select name="stories_product_order_by"
                                                                        id="<?php echo "story{$count}"; ?>_select_order_categorys">
                                                                        <option value="latest" <?php if ($story->sort_category == 'latest') {
                                                                            echo "selected";
                                                                        } ?>>
                                                                            <?php _e('Latest', 'royal'); ?>
                                                                        </option>
                                                                        <option value="rand" <?php if ($story->sort_category == 'rand') {
                                                                            echo "selected";
                                                                        } ?>>
                                                                            <?php _e('Random', 'royal'); ?>
                                                                        </option>
                                                                        <option value="popularity" <?php if ($story->sort_category == 'popularity') {
                                                                            echo "selected";
                                                                        } ?>>
                                                                            <?php _e('Popularity', 'royal'); ?>
                                                                        </option>
                                                                        <option value="price" <?php if ($story->sort_category == 'price') {
                                                                            echo "selected";
                                                                        } ?>>
                                                                            <?php _e('Price', 'royal'); ?>
                                                                        </option>
                                                                        <option value="price-desc" <?php if ($story->sort_category == 'price-desc') {
                                                                            echo "selected";
                                                                        } ?>>
                                                                            <?php _e('Price Desc', 'royal'); ?>
                                                                        </option>
                                                                    </select>
                                                                </td>
                                                            </tr>

                                                            <tr class="tr">
                                                                <th scope="row">
                                                                    <label
                                                                        for="<?php echo "story{$count}"; ?>_show_products_categorys">
                                                                        <?php _e('Products Show Limit', 'royal'); ?>
                                                                    </label>
                                                                </th>
                                                                <td>
                                                                    <div class="quantity">
                                                                        <input type="number" class="product-show-limit"
                                                                            id="<?php echo "story{$count}"; ?>_show_products_categorys"
                                                                            name="stories_limit_product_cat"
                                                                            value="<?php echo $story->limit_product_show; ?>">
                                                                    </div>
                                                                </td>
                                                            </tr>

                                                        </tbody>
                                                    </table>

                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                            </div>
                            <?php $count++;
                        endforeach;
                    else: ?>

                        <div class="story story1" id="story1">

                            <div class="royal-accardion-title clicked">
                                <div class="royal-accardion-arrow">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                        <path
                                            d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z" />
                                    </svg>
                                </div>
                                <div class="royal-accardion-title-text">
                                    <h5>
                                        <?php _e('story title', 'royal'); ?>
                                    </h5>
                                </div>
                                <div class="roya-accardion-action">
                                    <input type="hidden" id="stories_id_story1" name="stories_id" value="0">
                                    <div class="icon" onclick="removeStory('story1')"><svg
                                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                                            <path
                                                d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z" />
                                        </svg></div>
                                    <div class="icon" onclick="copyStory('story1')"><svg xmlns="http://www.w3.org/2000/svg"
                                            viewBox="0 0 448 512">
                                            <path
                                                d="M384 336H192c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16l140.1 0L400 115.9V320c0 8.8-7.2 16-16 16zM192 384H384c35.3 0 64-28.7 64-64V115.9c0-12.7-5.1-24.9-14.1-33.9L366.1 14.1c-9-9-21.2-14.1-33.9-14.1H192c-35.3 0-64 28.7-64 64V320c0 35.3 28.7 64 64 64zM64 128c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64H256c35.3 0 64-28.7 64-64V416H272v32c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V192c0-8.8 7.2-16 16-16H96V128H64z" />
                                        </svg></div>
                                    <div class="icon royal-drag-btn"><svg xmlns="http://www.w3.org/2000/svg"
                                            viewBox="0 0 512 512">
                                            <path
                                                d="M278.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8h32v96H128V192c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6V288h96v96H192c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8H288V288h96v32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6v32H288V128h32c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-64-64z" />
                                        </svg></div>
                                </div>
                            </div>

                            <div class="royal-accardion-content showContent">
                                <input type="hidden" value="btn" name="story-type" class="hidden-input-story-type">
                                <button class="active" onclick="showTab('story1', 1, this)">
                                    <?php _e('Image/Video', 'royal'); ?>
                                </button>
                                <button onclick="showTab('story1', 2, this)">
                                    <?php _e('Product/Category', 'royal'); ?>
                                </button>

                                <div id="story1_tab1" class="tabContent" style="display: block;">
                                    <table class="form-table">
                                        <tbody>
                                            <tr class="tr">
                                                <th scope="row">
                                                    <label for="story1_title">
                                                        <?php _e('Story title', 'royal'); ?>*
                                                    </label>
                                                </th>
                                                <td>
                                                    <input type="text" name="stories_title"
                                                        class="regular-text royal-story-title-input" id="story1_title"
                                                        autocomplete="off"
                                                        placeholder="<?php _e('Story title', 'royal'); ?>">
                                                </td>
                                            </tr>

                                            <tr class="tr">
                                                <th scope="row">
                                                    <label for="story1_image">
                                                        <?php _e('Image/Video', 'royal'); ?>*
                                                    </label>
                                                </th>
                                                <td>
                                                    <input type=""
                                                        class="regular-text process_story_images hidden-image-story-inp"
                                                        id="story1_image" name="stories_image">
                                                    <button class="set_story_images button">
                                                        <?php _e('Set', 'royal'); ?>
                                                    </button>
                                                    <div class="royal-image-thumb">
                                                        <div class="royal-delete-thumb">X</div>
                                                        <img src="" onerror="this.style.display='none'" alt="">
                                                    </div>
                                                    <p class="royal-desc-text">
                                                        <?php _e('Image size 1080x607px (recomended)', 'royal'); ?>
                                                    </p>
                                                </td>
                                            </tr>

                                            <tr class="tr">
                                                <th scope="row">
                                                    <label
                                                        for="story1_decription"><?php _e('Story description', 'royal'); ?></label>
                                                </th>
                                                <td>
                                                    <input type="text" class="regular-text" id="story1_decription"
                                                        name="stories_decription"
                                                        placeholder="<?php _e('description in story', 'royal'); ?>">
                                                </td>
                                            </tr>
                                            <tr class="tr">
                                                <th scope="row">
                                                    <label for="story1_link">
                                                        <?php _e('Story link', 'royal'); ?>
                                                    </label>
                                                </th>
                                                <td>
                                                    <input type="text" name="stories_link"
                                                        class="regular-text royal-story-link-inpt" id="story1_link"
                                                        placeholder="<?php _e('Story link', 'royal'); ?>">
                                                </td>
                                            </tr>
                                            <tr class="tr">
                                                <th scope="row">
                                                    <label for="story1_btntxt">
                                                        <?php _e('Story link text', 'royal'); ?>
                                                    </label>
                                                </th>
                                                <td>
                                                    <input type="text" id="story1_btntxt" name="stories_btntxt"
                                                        class="royal-story-linkbtn-txt" autocomplete="off"
                                                        placeholder="<?php _e('show more', 'royal'); ?>">
                                                </td>
                                            </tr>

                                            <tr class="tr">
                                                <th scope="row">
                                                    <label for="story1_btnimg">
                                                        <?php _e('Story link image', 'royal'); ?>
                                                    </label>
                                                </th>
                                                <td>
                                                    <input type="" class="regular-text process_story_images"
                                                        id="story1_btnimg" name="stories_btnimg">
                                                    <button class="set_story_images button">
                                                        <?php _e('Set', 'royal'); ?>
                                                    </button>
                                                    <div class="royal-image-thumb">
                                                        <div class="royal-delete-thumb">X</div>
                                                        <img src="" onerror="this.style.display='none'" alt="">
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <div id="story1_tab2" class="tabContent">
                                    <table class="form-table">
                                        <tr class="tr">
                                            <th scope="row">
                                                <label for="stories_type_product">
                                                    <?php _e('Select Type Product', 'royal'); ?>
                                                </label>
                                            </th>
                                            <td>
                                                <select name="stories_type_product" class="select-story-type"
                                                    id="story1_type_product" onchange="showDiv(this, 'story1')">
                                                    <option value="products">
                                                        <?php _e('Products', 'royal'); ?>
                                                    </option>
                                                    <option value="categorys">
                                                        <?php _e('categorys', 'royal'); ?>
                                                    </option>
                                                </select>
                                                <table id="story1_section_products"
                                                    class="story1-section_products story-section_products"
                                                    style="display: block;">
                                                    <tbody>
                                                        <tr class="tr">
                                                            <th scope="row">
                                                                <label for="stories_select_products">
                                                                    <?php _e('Select Products', 'royal'); ?>
                                                                </label>
                                                            </th>
                                                            <td>
                                                                <div class="royal-selected-products-holder-div">
                                                                    <div class="search_products_holder"></div>
                                                                    <input type="text" id="story1_select_products"
                                                                        name="stories_select_products" autocomplete="off"
                                                                        placeholder="<?php _e('Enter 3 characters...', 'royal'); ?>"
                                                                        class="search_products">
                                                                    <input type="hidden" id="stories_product_id"
                                                                        name="stories_product_id" value="">
                                                                    <div id="results"></div>

                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>

                                                <table id="story1_section_categorys"
                                                    class="story1-section_categorys story-section_categorys"
                                                    style="display: none;">
                                                    <tbody>

                                                        <tr class="tr">
                                                            <th scope="row">
                                                                <label for="story2_select_categorys">
                                                                <?php _e('Select Categories', 'royal'); ?>
                                                                </label>
                                                            </th>
                                                            <td scope="row">
                                                                <select name="stories_cat_id" id="stories_cat_id">
                                                                    <?php
                                                                    if ($catlist) {
                                                                        foreach ($catlist as $category) {
                                                                            echo '<option value="' . $category->term_id . '">' . $category->name . '</option>';
                                                                        }
                                                                    } else {
                                                                        _e('Not Found!', 'royal');
                                                                    }
                                                                    wp_reset_postdata(); ?>
                                                                </select>
                                                            </td>
                                                        </tr>

                                                        <tr class="tr">
                                                            <th scope="row">
                                                                <label for="story1_select_order_categorys">
                                                                    <?php _e('Sort By', 'royal'); ?>
                                                                </label>
                                                            </th>
                                                            <td>
                                                                <select name="stories_product_order_by"
                                                                    id="story1_select_order_categorys">
                                                                    <option value="latest">
                                                                        <?php _e('Latest', 'royal'); ?>
                                                                    </option>
                                                                    <option value="rand">
                                                                        <?php _e('Random', 'royal'); ?>
                                                                    </option>
                                                                    <option value="popularity">
                                                                        <?php _e('Popularity', 'royal'); ?>
                                                                    </option>
                                                                    <option value="price">
                                                                        <?php _e('Price', 'royal'); ?>
                                                                    </option>
                                                                    <option value="price-desc">
                                                                        <?php _e('Price Desc', 'royal'); ?>
                                                                    </option>
                                                                </select>
                                                            </td>
                                                        </tr>

                                                        <tr class="tr">
                                                            <th scope="row">
                                                                <label for="story1_show_products_categorys">
                                                                    <?php _e('Products Show Limit', 'royal'); ?>
                                                                </label>
                                                            </th>
                                                            <td>
                                                                <div class="quantity">
                                                                    <input type="number" class="product-show-limit"
                                                                        id="story1_show_products_categorys"
                                                                        name="stories_limit_product_cat" value="5">
                                                                </div>
                                                            </td>
                                                        </tr>

                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                        </div>

                    <?php endif; ?>
                </td>
            </tr>
            <tr class="tr">
                <th scope="row">
                    <p class="royal-validate-error"></p>
                    <p class="highlight_submit" id="royal-submit-div">
                        <button name="submit" class="button button-primary" type="submit" id="add_highlight_submit">
                            <?php _e('Save', 'royal'); ?>
                        </button>
                    </p>
                    <button onclick="addStory()" class="btn add-story">
                        + <?php _e('Add Story', 'royal'); ?>
                    </button>
                </th>
                <td>
                </td>
            </tr>
            <input name="highlight_id" id="highlight_id" type="hidden" value="<?php echo $highlight_id; ?>">
        </tbody>
    </table>


</form>
<?php
// Hook the function to admin_footer
add_action('admin_footer', 'royal_add_footer_script', 999);

function royal_add_footer_script() {
    
    ?>
    <script>
	
    document.getElementById("disableHighlight").addEventListener("change", function () {
        var disableOptions = document.getElementById("disableOptions");
        if (this.checked) {
            disableOptions.style.display = "block";
        } else {
            disableOptions.style.display = "none";
        }
    });

    function showDiv(select, id) {
        switch (select.value) {
            case 'button':
                document.getElementById(id + '_section_button').style.display = "block";
                document.getElementById(id + '_section_image').style.display = "none";
                break;
            case 'image':
                document.getElementById(id + '_section_button').style.display = "none";
                document.getElementById(id + '_section_image').style.display = "block";
                break;
            case 'products':
                document.getElementById(id + '_section_products').style.display = "block";
                document.getElementById(id + '_section_categorys').style.display = "none";
                document.querySelector(`#${id} .royal-accardion-title-text h5`).textContent = '<?php _e('product', 'royal'); ?>';
                break;
            case 'categorys':
                document.getElementById(id + '_section_products').style.display = "none";
                document.getElementById(id + '_section_categorys').style.display = "block";
                document.querySelector(`#${id} .royal-accardion-title-text h5`).textContent = '<?php _e('category', 'royal'); ?>';
                break;
        }

    }

    jQuery(document).ready(function ($) {
        // Delegate click event for set_highlight_images buttons
        $(document).on('click', '.set_highlight_images', function (e) {
            e.preventDefault();
            var button = $(this);
            var id = button.prev();
            var parent = id.closest('td');
            openMediaModal(button, id, parent);
            return false;
        });

        // Delegate click event for set_story_images buttons
        $(document).on('click', '.set_story_images', function (e) {
            e.preventDefault();
            var button = $(this);
            var id = button.prev();
            var parent = id.closest('td');
            openMediaModal(button, id, parent);
            return false;
        });

        function openMediaModal(button, id, parent) {
            if (typeof wp !== 'undefined' && wp.media && wp.media.editor) {
                wp.media.editor.send.attachment = function (props, attachment) {
                    if (attachment.type === 'video') {
                        // If the attachment is a video, set the URL to the video placeholder
                        //attachment.url = '';
                        $(parent).find('.royal-image-thumb img').attr('src', '<?php echo home_url("/"); ?>wp-includes/images/media/video.png');
                    } else {
                        $(parent).find('.royal-image-thumb img').attr('src', attachment.url);
                    }
                    id.val(attachment.url);
                    id.addClass('showInput');
                    //image_url_thumbnail_preview
                    //$(parent).find('.royal-image-thumb img').attr('src', attachment.url);
                    $(parent).find('.royal-image-thumb').addClass('active');
                    $(parent).find('.royal-image-thumb img').css('display', 'inline-block');
                    $(parent).find('.royal-image-thumb .royal-delete-thumb').addClass('active');
                };
                wp.media.editor.open(button);
            }
        }

        $(document).on('click', '.royal-delete-thumb', function (e) {
            $(this).removeClass('active');
            $(this).parent().removeClass('active');
            $(this).parent().find('img').attr('src', '');
            $(this).parents().eq(2).find('input').val('');
            $(this).parents().eq(2).find('input').removeClass('showInput');
        });
    });

    function addStory() {
        var storyCount = document.querySelectorAll('.story').length;
        storyCount++;
        var storyContainer = document.getElementById("storyContainer");
        var newStory = document.createElement("div");
        var storyId = "story" + storyCount;
        newStory.id = storyId;
        newStory.className = "story";


        newStory.innerHTML = `<div class="royal-accardion-title clicked">
                            <div class="royal-accardion-arrow">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z"/></svg>
                            </div>
                            <div class="royal-accardion-title-text">
                                <h5> <?php _e('story title', 'royal'); ?></h5>
                            </div>
                            
                            <div class="roya-accardion-action">
                            <input type="hidden" id="stories_id_${storyId}" name="stories_id" value="0">
                                <div class="icon" onclick="removeStory('${storyId}')"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                                        <path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z" />
                                    </svg></div>
                                <div class="icon" onclick="copyStory('${storyId}')"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                                        <path d="M384 336H192c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16l140.1 0L400 115.9V320c0 8.8-7.2 16-16 16zM192 384H384c35.3 0 64-28.7 64-64V115.9c0-12.7-5.1-24.9-14.1-33.9L366.1 14.1c-9-9-21.2-14.1-33.9-14.1H192c-35.3 0-64 28.7-64 64V320c0 35.3 28.7 64 64 64zM64 128c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64H256c35.3 0 64-28.7 64-64V416H272v32c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V192c0-8.8 7.2-16 16-16H96V128H64z" />
                                    </svg></div>
                                <div class="icon royal-drag-btn"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                        <path d="M278.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8h32v96H128V192c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6V288h96v96H192c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8H288V288h96v32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6v32H288V128h32c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-64-64z" />
                                    </svg></div>
                            </div>
                        </div>
                        <div class="royal-accardion-content showContent">
                        <input type="hidden" value="btn" name="story-type" class="hidden-input-story-type">
        <button class="active" onclick="showTab('${storyId}', 1, this)"><?php _e('Image/Video', 'royal'); ?></button>
        <button onclick="showTab('${storyId}', 2, this)"><?php _e('Product/Category', 'royal'); ?></button>
    <div id="${storyId}_tab1" class="tabContent" style="display: block;">
    <table class="form-table">
        <tbody>
            <tr class="tr">
                <th scope="row">
                    <label for="${storyId}_title"><?php _e('Story title', 'royal'); ?>*</label>
                </th>
                <td>
                    <input type="text" name="stories_title" class="regular-text royal-story-title-input" id="${storyId}_title" placeholder="<?php _e('Story title', 'royal'); ?>">
                </td>
            </tr>
            
            <tr class="tr">
                <th scope="row">
                    <label for="${storyId}_imageStory"><?php _e('Image/Video', 'royal'); ?>*</label>
                </th>
                <td>
                    <input type="" class="regular-text process_story_images hidden-image-story-inp" id="${storyId}_imageStory" name="stories_image">
                    <button class="set_story_images button"><?php _e('Set', 'royal'); ?></button>
                    <div class="royal-image-thumb">
                        <div class="royal-delete-thumb">X</div>
                        <img src="" onerror="this.style.display='none'" alt="">
                    </div>
                    <p class='royal-desc-text'><?php _e('Image size 1080x607px (recomended)', 'royal'); ?></p>
                </td>
            </tr>
            <tr class="tr">
                <th scope="row">
                    <label for="${storyId}_DecsStory"><?php _e('Story description', 'royal'); ?></label>
                </th>
                <td>
                    <input type="text" class="regular-text" id="${storyId}_DecsStory" name="stories_decription" placeholder="<?php _e('description in story', 'royal'); ?>">
                </td>
            </tr>
            <tr class="tr">
                <th scope="row">
                    <label for="${storyId}_link"><?php _e('Story link', 'royal'); ?></label>
                </th>
                <td>
                    <input type="text" name="stories_link" class="regular-text royal-story-link-inpt" id="${storyId}_link" placeholder="<?php _e('Story link', 'royal'); ?>">
                </td>
            </tr>
            <tr class="tr">
                <th scope="row">
                    <label for="${storyId}_buttonText"><?php _e('Story link text', 'royal'); ?></label>
                </th>
                <td>
                    <input type="text" id="${storyId}_buttonText" name="stories_btntxt" class="royal-story-linkbtn-txt" placeholder="<?php _e('show more', 'royal'); ?>">
                </td>
            </tr>
            <tr class="tr">
                <th scope="row">
                    <label for="${storyId}_image-button"><?php _e('Story link image', 'royal'); ?></label>
                </th>
                <td>
                    <input type="" class="regular-text process_story_images" id="${storyId}_image-button" name="stories_btnimg">
                    <button class="set_story_images button"><?php _e('Set', 'royal'); ?></button>
                    <div class="royal-image-thumb">
                        <div class="royal-delete-thumb">X</div>
                        <img src="" onerror="this.style.display='none'" alt="">
                    </div>
                </td>
            </tr>
            
        </tbody>
    </table>
    </div>
    <div id="${storyId}_tab2" class="tabContent">
        <table class="form-table">
            <tr class="tr">
                <th scope="row">
                    <label for="stories_type_product"><?php _e('Select Type Product', 'royal'); ?></label>
                </th>
                <td>
                    <select name="stories_type_product" class="select-story-type" id="${storyId}_type_product" onchange="showDiv(this, '${storyId}')">
                        <option value="products"><?php _e('Products', 'royal'); ?></option>
                        <option value="categorys"><?php _e('categorys', 'royal'); ?></option>
                    </select>
                    <table id="${storyId}_section_products" class="${storyId}-section_products story-section_products" style="display: block;">
                        <tbody>
                            <tr class="tr">
                                <th scope="row">
                                    <label for="stories_select_products"><?php _e('Select Products', 'royal'); ?></label>
                                </th>
                                <td>
                                <div class="royal-selected-products-holder-div">
                                    <div class="search_products_holder"></div>
                                    <input type="text" id="${storyId}_select_products" autocomplete="off" name="stories_select_products" class="search_products" placeholder="<?php _e('Enter 3 characters...', 'royal'); ?>">
                                    <input type="hidden" id="stories_product_id" name="stories_product_id" value="">
                                    <div id="results"></div>
                                </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <table id="${storyId}_section_categorys" class="${storyId}-section_categorys story-section_categorys" style="display: none;">
                        <tbody>

                            <tr class="tr">
                                <th scope="row">
                                    <label for="${storyId}_select_categorys"><?php _e('Select Categories', 'royal'); ?></label>
                                </th>
                                <td>
                                    <select name="stories_cat_id" id="stories_cat_id">
                                                                    <?php
                                                                    if ($catlist) {
                                                                        foreach ($catlist as $category) {
                                                                            echo '<option value="' . $category->term_id . '">' . $category->name . '</option>';
                                                                        }
                                                                    } else {
                                                                        _e('Not Found!', 'royal');
                                                                    }
                                                                    wp_reset_postdata(); ?>
                                                                </select>
                                </td>
                            </tr>
                            <tr class="tr">
                                <th scope="row">
                                    <label for="${storyId}_select_order_categorys"><?php _e('Sort By', 'royal'); ?></label>
                                </th>
                                <td>
                                    <select name="stories_product_order_by" id="${storyId}_select_order_categorys">
                                        <option value="latest"><?php _e('Latest', 'royal'); ?></option>
                                        <option value="rand"><?php _e('Random', 'royal'); ?></option>
                                        <option value="popularity"><?php _e('Popularity', 'royal'); ?></option>
                                        <option value="price"><?php _e('Price', 'royal'); ?></option>
                                        <option value="price-desc"><?php _e('Price Desc', 'royal'); ?></option>
                                    </select>
                                </td>
                            </tr>
                            <tr class="tr">
                                <th scope="row">
                                    <label for="${storyId}_show_products_categorys"><?php _e('Products Show Limit', 'royal'); ?></label>
                                </th>
                                <td>
                                    <div class="quantity">
                                        <input name="stories_limit_product_cat" class="product-show-limit" id="${storyId}_show_products_categorys" type="number" value="5">
                                        <div class="quantity-nav"><div class="quantity-button quantity-up">+</div><div class="quantity-button quantity-down">-</div></div>
                                    </div>
                                    
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </table>
    </div>

  </div></div>`;
        storyContainer.appendChild(newStory);
        jQuery(newStory).one('click', '.quantity', handleQuantityChange);
    }

    function showTab(storyId, tabIndex, clickedButton) {

        var tabs = document.querySelectorAll(`#${storyId} .tabContent`);
        var hiddenInput = document.querySelector(`#${storyId} .hidden-input-story-type`);
        var text = clickedButton.innerHTML;
        if (text.trim() === 'Image/Video' || text.trim() === 'عکس/ویدیو') {
            hiddenInput.value = 'btn';
            var inputStoryName = document.querySelector(`#${storyId} .royal-story-title-input`);
            if (inputStoryName.value.trim() === '') {
                document.querySelector(`#${storyId} .royal-accardion-title-text h5`).textContent = '<?php _e('story title', 'royal'); ?>';
            } else {
                document.querySelector(`#${storyId} .royal-accardion-title-text h5`).textContent = inputStoryName.value;
            }
            
        } else if (text.trim() === 'Product/Category'  || text.trim() == 'محصول/دسته‌بندی')  {
            var selectElement = document.querySelector(`#${storyId} .select-story-type`);
            var selectedOption = selectElement.options[selectElement.selectedIndex];
            var selectedValue = selectedOption.value;
            hiddenInput.value = 'product';
            if (selectedValue === 'products') {
                document.querySelector(`#${storyId} .royal-accardion-title-text h5`).textContent = '<?php _e('product', 'royal'); ?>';
            } else {
                document.querySelector(`#${storyId} .royal-accardion-title-text h5`).textContent = '<?php _e('category', 'royal'); ?>';
            }
            
        }
        tabs.forEach(function (tab, index) {
            if (index + 1 === tabIndex) {
                tab.style.display = "block";
            } else {
                tab.style.display = "none";
            }
        });

        // Remove 'active' class from all buttons
        var buttons = document.querySelectorAll(`#${storyId} button`);
        buttons.forEach(function (button) {
            button.classList.remove('active');
        });

        // Add 'active' class to the clicked button
        clickedButton.classList.add('active');
        var selectType = document.querySelector(`#${storyId} .select-story-type`);
        if (selectType) {
            var selectedOption = selectType.options[selectType.selectedIndex].value;
            var section;

            if (selectedOption === 'products') {
                section = document.querySelector(`#${storyId} .story-section_products`);
                
            } else if (selectedOption === 'categorys') {
                section = document.querySelector(`#${storyId} .story-section_categorys`);
                
            }

            // Hide all sections
            var allSections = document.querySelectorAll(`#${storyId} .story-section`);
            allSections.forEach(function (s) {
                s.style.display = 'none';
            });

            // Show the selected section
            if (section) {
                section.style.display = 'block';
            }
        }
    }

    // Make selected-highlight-item sortable
    jQuery(window).on('load', function() {
		jQuery("#storyContainer").sortable({
			axis: "y",
			containment: "#storyContainer",
			tolerance: "pointer",
			cursor: "move",
			handle: ".royal-drag-btn"
		});
	});



    function removeStory(storyId) {
        var storyToRemove = document.getElementById(storyId);
        storyToRemove.parentNode.removeChild(storyToRemove);
    }

    function copyStory(storyId) {
        var originalStory = document.getElementById(storyId);
        var copiedStory = originalStory.cloneNode(true);
        var originalStoryId = copiedStory.id;
        var newId = getNextStoryId(storyId);
        var newStoryNum = parseInt(newId.replace("story", ""));

        // Update ID, class, and onclick attributes
        copiedStory.id = newId;
        copiedStory.classList.remove(originalStoryId);
        copiedStory.classList.add(newId);
        updateOnclickAttributes(copiedStory, storyId, newId);

        // Update IDs, 'for', 'name', and 'onchange' attributes of elements inside copiedStory
        updateElementAttributes(copiedStory, storyId, newId);

        var storyContainer = document.getElementById("storyContainer");
        storyContainer.appendChild(copiedStory);
        document.getElementById('stories_id_' + newId).value = '0';
    }

    function getNextStoryId(storyId) {
        var lastStoryNum = 0;
        // Find the last story number in the page
        document.querySelectorAll('.story').forEach(function (element) {
            var storyNum = parseInt(element.id.replace("story", ""));
            if (storyNum > lastStoryNum) {
                lastStoryNum = storyNum;
            }
        });
        return "story" + (lastStoryNum + 1);
    }

    function updateOnclickAttributes(element, oldId, newId) {
        element.querySelectorAll('[onclick]').forEach(function (el) {
            var onclickValue = el.getAttribute('onclick');
            var updatedOnclick = onclickValue.replace(oldId, newId);
            el.setAttribute('onclick', updatedOnclick);
        });
    }

    function updateElementAttributes(parentElement, oldId, newId) {
        parentElement.querySelectorAll('[id],[for],[onchange]').forEach(function (el) {
            // Update 'id' attributes
            if (el.hasAttribute('id')) {
                var originalId = el.id;
                var newElementId = originalId.replace(oldId, newId);
                el.id = newElementId;
            }
            // Update 'for' attributes
            if (el.hasAttribute('for')) {
                var originalFor = el.getAttribute('for');
                var newFor = originalFor.replace(oldId, newId);
                el.setAttribute('for', newFor);
            }
            // Update 'name' attributes

            // Update 'onchange' attributes
            if (el.hasAttribute('onchange')) {
                var originalOnChange = el.getAttribute('onchange');
                var newOnChange = originalOnChange.replace(oldId, newId);
                el.setAttribute('onchange', newOnChange);
            }
        });
    }

    // Function to handle quantity changes
    function handleQuantityChange() {
        var spinner = jQuery(this),
            input = spinner.find('input[type="number"]'),
            btnUp = spinner.find('.quantity-up'),
            btnDown = spinner.find('.quantity-down'),
            min = input.attr('min'),
            max = input.attr('max');

        btnUp.click(function () {
            var oldValue = parseFloat(input.val());
            if (oldValue >= max) {
                var newVal = oldValue;
            } else {
                var newVal = oldValue + 1;
            }
            spinner.find("input").val(newVal);
            spinner.find("input").trigger("change");
        });

        btnDown.click(function () {
            var oldValue = parseFloat(input.val());
            if (oldValue <= min) {
                var newVal = oldValue;
            } else {
                var newVal = oldValue - 1;
            }
            spinner.find("input").val(newVal);
            spinner.find("input").trigger("change");
        });
    }

    // Initial setup for existing .quantity elements
    jQuery(document).ready(function () {
        jQuery('<div class="quantity-nav"><div class="quantity-button quantity-up">+</div><div class="quantity-button quantity-down">-</div></div>').insertAfter('.quantity input');
        jQuery('.quantity').each(handleQuantityChange);
    });

    //search product start
    jQuery(document).ready(function ($) {
        // please wait text
        function showLoading(ElementId = "#results") {
            $(ElementId).empty();
            $(ElementId).html("<div id='search_loading'><?php _e('Please Wait!', 'royal'); ?></div>");
        }

        function hideLoading() {
            $("#search_loading").remove();
        }

        $("#storyContainer").on("input", ".search_products", function () {
            var $this = $(this);
            var results = $this.closest(".story-section_products").find("#results");
            var searchText = $this.val().trim();
            var searchText = $this.val();

            clearTimeout(searchTimer);
            searchTimer = setTimeout(function () {
                if (searchText.length >= 3) {
                    showLoading();
                    results.addClass('active');
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'royal_story_search_products',
                            search_text: searchText
                        },
                        success: function (response) {
                            hideLoading();
                            // Display the search results in the designated area
                            results.html(response);
                            var selectedValues = $this.next('input[type="hidden"]').val().split(',');
                            // Add selected-div class to nodes with matching data-id
                            results.find('[data-id]').each(function () {
                                var $node = $(this);
                                if (selectedValues.includes($node.data('id').toString())) {
                                    $node.addClass('selected-div');
                                }
                            });
                            $this.closest(".story-section_products").find(".search_products").val(searchText);
                        },
                        error: function (xhr, status, error) {
                            hideLoading();
                            // Log errors to console if there's any issue with the AJAX request
                            console.error(status + ': ' + error);
                        }
                    });
                } else if (searchText.length == 0) {
                    results.removeClass('active').html('');
                    return;
                }
            }, 1000);
            $(document).click(function (event) {
                var clickedElement = $(event.target);
                var isInput = clickedElement.closest('.search_products').length > 0;
                var isResult = clickedElement.closest('#results').length > 0;
                if (!isInput && !isResult) {
                    // Clear results and empty input value
                    $($this).val('');
                    $(results).removeClass('active').html('');
                }
            });
        });

        var searchTimer; // Variable to store the timer


        // Submit btn save Start
        $('#add_highlight_submit').on('click', function () {
            var isValid = true;

            $(".story").each(function () {
                var $input = $(this).find('input[name="story-type"]');
                var story = $(this);

                if ($input.val() === "btn") {
                    if (!validateForm(story)) {
                        isValid = false;
                        return false; // Exit the loop if validation fails
                    }
                } else {
                    if (!validateInputProd(story)) {
                        isValid = false;
                        return false; // Exit the loop if validation fails
                    }
                }
            });

            if (isValid) {
                disableButton("add_highlight_submit");
                var formData = $("#add_highlight").serializeArray();
                $('.royal-validate-error').hide().text('');

                // Send AJAX request to add_highlight action
                $.ajax({
                    url: ajaxurl, // URL of admin-ajax.php
                    type: 'POST',
                    data: {
                        action: 'add_royal_highlight', // Action name
                        nonce: '<?php echo wp_create_nonce('add-highlight-story-nonce'); ?>',
                        form: formData
                    },
                    success: function (response) {
                        // Successfully received response from the function
                        if (response['hid'] != false && response['hid'] > 0) {
                            $("#highlight_id").val(response['hid']);

                            $.each(response['sid'], function (index, value) {
                                index++;
                                $(`#stories_id_story${index}`).val(value);
                            });

                            displayMessage(response['status'], response['message']);
                            updateQueryParam(response['hid']);
                        } else {
                            displayMessage(response['status'], response['message']);
                        }
                        enableButton("add_highlight_submit");
                    },
                    error: function (xhr, status, error) {
                        // Error in receiving response from the function
                        displayMessage('error', error);
                        enableButton("add_highlight_submit");
                    }
                });
            }
        });

        function updateQueryParam(value) {
        
            var baseUrl = window.location.href.split('?')[0];
            var paramName = 'story_id';
            var url = baseUrl + '?';
            var existingParams = window.location.href.split('?')[1];
        
            if (existingParams) {
                var params = existingParams.split('&');
                params.forEach(function(param) {
                    if (param.split('=')[0] !== paramName) {
                        url += param + '&';
                    }
                });
            }
        
            url += paramName + '=' + encodeURIComponent(value);
        
            window.history.pushState({ path: url }, '', url);
        }

        function validateForm(story) {
            $('.royal-validate-error').text('').hide();
            var isValid = true;

            // Validate title and images
            story.find('.royal-story-title-input').each(function () {
                var title = $(this).val();
                if (!title || !title.trim()) {
                    $('.royal-validate-error').text('<?php _e('Story title is empty', 'royal'); ?>').show();
                    isValid = false;
                }
            });

            story.find('.process_story_images[name=stories_image]').each(function () {
                var images = $(this).val();
                if (!images || !images.trim()) {
                    $('.royal-validate-error').text('<?php _e('Story image/video is empty', 'royal'); ?>').show();
                    isValid = false;
                }
            });

            // Validate link input and button text
            story.find('.royal-story-link-inpt').each(function () {
                var linkInput = $(this).val();
                var linkBtnTxt = $(this).closest('tr').next().find('.royal-story-linkbtn-txt').val();
                if (linkInput && !linkBtnTxt) {
                    $('.royal-validate-error').text('<?php _e('Story link text is empty', 'royal'); ?>').show();
                    isValid = false;
                }
            });

            return isValid;
        }

        function validateInputProd(story) {
            var selectedOpt = story.find('select[name="stories_type_product"]').val();
            var prodInput = story.find('#stories_product_id');

            $('.royal-validate-error').text('').hide();
            if (selectedOpt === 'products') {
                if (prodInput.val() === null || prodInput.val() === '') {
                    $('.royal-validate-error').text('<?php _e('Products not selected!', 'royal'); ?>').show();
                    return false;
                }
            }

            return true;
        }

        // Disabling a button
        function disableButton(buttonId) {
            var button = document.getElementById(buttonId);
            if (button) {
                button.disabled = true;
                button.style.cursor = 'not-allowed';
            }
        }

        // Enabling a button
        function enableButton(buttonId) {
            var button = document.getElementById(buttonId);
            if (button) {
                button.disabled = false;
                button.style.cursor = 'pointer';
            }
        }

        function displayMessage(status, message) {
            var messageBox = document.createElement('div');
            messageBox.classList.add('royal-ssb-message-box');

            if (status === 'success') {
                messageBox.classList.add('royal-ssb-success');
            } else {
                messageBox.classList.add('royal-ssb-error');
            }
            messageBox.textContent = message;
            var closeButton = document.createElement('span');
            closeButton.innerHTML = '&times;';
            closeButton.classList.add('royal-ssb-close-button');
            messageBox.appendChild(closeButton);
            var parentDiv = document.getElementById('royal-submit-div');
            parentDiv.appendChild(messageBox);
            closeButton.onclick = function () {
                parentDiv.removeChild(messageBox);
            };
            setTimeout(function () {
                parentDiv.removeChild(messageBox);
            }, 4000);
            messageBox.classList.add('royal-ssb-bubble-box');
        }
    });



    jQuery(document).ready(function () {
        jQuery("#storyContainer").on('click', '.royal-accardion-title', function (event) {
            if (jQuery(event.target).closest('.roya-accardion-action').length) {
                return;
            }
            jQuery(this).toggleClass('clicked');
            var accardion_content = jQuery(this).parent().find('.royal-accardion-content');
            jQuery(accardion_content).toggleClass('showContent');


        });
    });

    jQuery(document).ready(function () {
        jQuery(document).on("change", ".royal-story-title-input", function () {
            var inputValue = jQuery(this).val();
            var inputId = jQuery(this).attr('id');
            var number = inputId.replace(/\D/g, '');
            var $story = jQuery('#story' + number);

            if ($story.length) {
                if (inputValue != '') {
                    $story.find('.royal-accardion-title-text h5').text(inputValue);
                } else {
                    $story.find('.royal-accardion-title-text h5').text('Story Title');
                }
            }
        });
    });

    jQuery(document).ready(function () {
        jQuery(document).on("click", "#cresults div", function () {
            var dataId = jQuery(this).data("id");
            var $searchCategories = jQuery(this).closest(".story-section_categorys").find(".search_categories");
            var clickedText = jQuery(this).text().trim();
            $searchCategories.val(clickedText);
            var $storiesCatIdInput = $searchCategories.closest(".story-section_categorys").find("#stories_cat_id");
            $storiesCatIdInput.val(dataId);
            jQuery(this).parent().removeClass('active').html('');
        });
    });

    jQuery(document).on("click", "#results div", function () {
        jQuery(this).addClass('selected-div');
        var productId = jQuery(this).data("id");
        var parent = jQuery(this).parents().eq(2);
        var searchProducts = jQuery(this).closest(".story-section_products").find(".search_products");
        var hiddenInput = jQuery(parent).find('#stories_product_id');
        var productTitle = jQuery(this).text();

        if (jQuery(parent).find(".selected-highlight-item[data-id='" + productId + "']").length > 0) {
            return;
        }
        jQuery(hiddenInput).val("");
        var selectedProduct = jQuery("<div class='selected-highlight-item' data-id='" + productId + "'>").html("<span class='selected-product-title'>" + productTitle + "</span> <span class='selected-product-remove'>❌</span>");
        selectedProduct.data("id", productId);
        jQuery(parent).find(".search_products_holder").append(selectedProduct);
        jQuery(parent).find(".search_products_holder").addClass('active');
        var newOrder = [];
        jQuery(parent).find(".selected-highlight-item").each(function () {
            newOrder.push(jQuery(this).data("id"));
        });
        jQuery(hiddenInput).val(newOrder.join(","));
        jQuery(parent).find(".search_products_holder").sortable({
            axis: "xy",
            containment: jQuery(parent).find(".search_products_holder"),
            tolerance: "pointer",
            cursor: "move",
            update: function (event, ui) {
                var newOrder = [];
                jQuery(parent).find(".selected-highlight-item").each(function () {
                    newOrder.push(jQuery(this).data("id"));
                });
                jQuery(hiddenInput).val(newOrder.join(","));
            }
        });
    });

    jQuery(document).on("click", ".selected-product-remove", function () {
        var productId = jQuery(this).closest(".selected-highlight-item").data("id");
        var parent = jQuery(this).parents().eq(4);
        var hiddenInput = jQuery(parent).find('#stories_product_id');
        var currentVal = jQuery(hiddenInput).val();
        var newVal = currentVal.replace(productId + ",", "");
        jQuery(hiddenInput).val(newVal);

        jQuery(this).closest(".selected-highlight-item").remove();

        var newOrder = [];
        jQuery(parent).find(".selected-highlight-item").each(function () {
            newOrder.push(jQuery(this).data("id"));
        });
        jQuery(hiddenInput).val(newOrder.join(","));
        if (jQuery(parent).find(".selected-highlight-item").length == 0) {
            jQuery(parent).find(".search_products_holder").removeClass('active');
        }

    });
</script>
    <?php
}
?>
