<?php
if (isset($_GET['paged']) && !empty($_GET['paged']) && $_GET['paged'] > 1) {
    $highlights = RoyalStoryMnage::get_royal_highlights(null, 10, $_GET['paged']);
} else {
    $highlights = RoyalStoryMnage::get_royal_highlights(null, PHP_INT_MAX);
}

$pages_count = ceil(count(RoyalStoryMnage::get_royal_highlights(null, PHP_INT_MAX)) / 10);
if ($pages_count > 1){
    $current_page = (isset($_GET['paged']))? $_GET['paged']: 1;
    if($current_page == 1){
        $prev_page = intval($current_page);
        $next_page = (intval($current_page) >= $pages_count) ? $pages_count : intval($current_page) + 1;
    }elseif($current_page == $pages_count){
        $prev_page = intval($current_page) - 1;
        $next_page = intval($current_page);
    }else{
        $prev_page = intval($current_page) - 1;
        $next_page = (intval($current_page) >= $pages_count) ? $pages_count : intval($current_page) + 1;
    }
}
?>
<div class="tablenav top">
    <div class="alignleft actions">
        <label for="cb-select-all-1" class="screen-reader-text"><?php _e('Select All', 'royal'); ?></label>
        <select name="action2" id="bulk-action-selector">
            <option value="-1"><?php _e('Bulk Select', 'royal'); ?></option>
            <option value="delete"><?php _e('Delete', 'royal'); ?></option>
            <option value="disable"><?php _e('Enabel/Disable', 'royal'); ?></option>
        </select>
        <input type="submit" id="doaction2" class="button action" value="<?php _e('Run', 'royal'); ?>">
    </div>
    <?php if ($pages_count > 1) : ?>
        <div class="tablenav-pages">
            <span class="displaying-num"><?php echo $pages_count . ' ';
                                            _e('count', 'royal'); ?></span>
            <span class="pagination-links">
                <a class="first-page" href="<?php echo esc_url(add_query_arg(array('page' => 'royal-story', 'action' => 'list_shortcode', 'paged' => '1'), admin_url('admin.php?page=royal-story'))); ?>">«</a>
                <a class="prev-page" href="<?php echo esc_url(add_query_arg(array('page' => 'royal-story', 'action' => 'list_shortcode', 'paged' => $prev_page), admin_url('admin.php?page=royal-story'))); ?>">‹</a>
                <span class="paging-input">
                    <input class="current-page" id="current-page-selector" type="text" name="paged" value="1" size="1" aria-describedby="table-paging">
                    <span class="tablenav-paging-text">از <span class="total-pages"><?php echo $pages_count; ?></span></span>
                </span>
                <a class="next-page" href="<?php echo esc_url(add_query_arg(array('page' => 'royal-story', 'action' => 'list_shortcode', 'paged' => $next_page), admin_url('admin.php?page=royal-story'))); ?>">›</a>
                <a class="last-page" href="<?php echo esc_url(add_query_arg(array('page' => 'royal-story', 'action' => 'list_shortcode', 'paged' => $pages_count), admin_url('admin.php?page=royal-story'))); ?>">»</a>
            </span>
        </div>
    <?php else : ?>
        <div class="tablenav-pages">
            <span class="displaying-num"><?php echo $pages_count . ' ';
                                            _e('paged', 'royal'); ?></span>
            <span class="pagination-links">
                <span class="paging-input">
                    <input class="current-page" id="current-page-selector" type="text" name="paged" value="1" size="1" aria-describedby="table-paging">
                    <span class="tablenav-paging-text">از <span class="total-pages"><?php echo $pages_count; ?></span></span>
                </span>
            </span>
        </div>
    <?php endif; ?>
</div>
<table class="wp-list-table widefat fixed striped">
    <thead>
        <tr>
            <th> <input type="checkbox" id="cb-select-all" onclick="toggleCheckboxes(this)"> <?php _e('Title', 'royal'); ?> </th>
            <th><?php _e('Date', 'royal'); ?></th>
            <th><?php _e('status', 'royal'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($highlights as $highlight) :
            $status = ($highlight->status == 'deactive' && RoyalStoryMnage::now_to_date_active($highlight->deactive_from) == false) ? 'active' : 'deactive'; ?>
            <tr id="<?php echo sprintf('row-%s', $highlight->id); ?>" class="tr-row <?php echo $status; ?>">
                <td>
                    <input type="checkbox" name="item-bulk[]" value="<?php echo $highlight->id; ?>">
                    <a href="<?php echo esc_url(add_query_arg(array('action' => 'add_story', 'story_id' => $highlight->id), admin_url('admin.php?page=royal-story'))); ?>">
                        <?php echo $highlight->title; ?>
                    </a>
                    <div class="row-actions">
                        <span class="edit"><a href="<?php echo esc_url(add_query_arg(array('action' => 'add_story', 'story_id' => $highlight->id), admin_url('admin.php?page=royal-story'))); ?>"><?php _e('Edit', 'royal'); ?></a> | </span>
                        <span class="trash"><a href="javascript:;" class="delete delete-<?php echo $highlight->id; ?>" name="<?php echo $highlight->id; ?>"><?php _e('Delete', 'royal'); ?></a> | </span>
                        <span class="edit"><a href="javascript:;" class="duplicate-highlight duplicate-<?php echo $highlight->id; ?>" name="<?php echo $highlight->id; ?>"><?php _e('clone', 'royal'); ?></a></span>
                    </div>
                </td>
                <td><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($highlight->publish_date));
                    ?></td>
                <td>
                    <label class="royal-checkbox-wrap en-di-label-list" id="en-di-label-<?php echo $highlight->id; ?>">
                        <input type="checkbox" id="disableHighlight-<?php echo $highlight->id; ?>" name="disableHighlight" data-id-value="<?php echo $highlight->id; ?>" class="disableHighlight checkbox_inp" <?php if($status == 'deactive'){ echo 'checked'; } ?>>
                        <span class="highligh-status-text story-list-page royal-status-target">
                            <span class="active-text"><?php _e('Active', 'royal'); ?></span>
                            <span class="royal-status-handler"></span>
                            <span class="deactive-text"><?php _e('Deactive', 'royal'); ?></span>
                        </span>
                    </label><span id="status-txt-<?php echo $highlight->id; ?>" class="status-txt-list"></span>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<p class="add_new_story">
    <a href="<?php echo esc_url(add_query_arg(array('action' => 'add_story'), admin_url('admin.php?page=royal-story'))); ?>" target="_self">
        <?php _e('add new story', 'royal'); ?>
    </a>
</p>
<script>
    function toggleCheckboxes(masterCheckbox) {
        var checkboxes = document.querySelectorAll('tbody input[type="checkbox"][name="item-bulk[]"]');
        checkboxes.forEach(function(checkbox) {
            checkbox.checked = masterCheckbox.checked;
        });
    }

    jQuery(document).ready(function($) {
        <?php $bulk_highlight_nonce = wp_create_nonce('highlight-bulk-nonce'); ?>

        // Delete/Disable Items Start
        $("#doaction2").click(function() {
            var checkedItems = [];
            var Action2Value = $("#bulk-action-selector").val();
            // delete
            if (Action2Value == 'delete') {
                if (confirm('<?php _e('Are you sure to deletes?', 'royal'); ?>')) {
                    $("input[name='item-bulk[]']").each(function(index, obj) {
                        if ($(obj).is(":checked")) {
                            checkedItems.push($(obj).val());
                        }
                    });
                    
                    // Send AJAX request to setting_highlight action
                    $.ajax({
                        url: ajaxurl, // URL of admin-ajax.php
                        type: 'POST',
                        data: {
                            action: 'higlight_delete', // Action name
                            nonce: '<?php echo $bulk_highlight_nonce; ?>',
                            id: checkedItems
                        },
                        success: function(response) {
                            // Successfully received response from the function
                            $("input[name='item-bulk[]']").each(function(index, obj) {
                                if ($(obj).is(":checked")) {
                                    $("#row-" + $(obj).val()).remove();
                                }
                            });

                        },
                        error: function(xhr, status, error) {
                            // Error in receiving response from the function
                            console.log('error', error);
                        }
                    });
                }
            }else if(Action2Value == 'disable'){
                if (confirm('<?php _e('Are you sure to changes?', 'royal'); ?>')) {
                    $("input[name='item-bulk[]']").each(function(index, obj) {
                        if ($(obj).is(":checked")) {
                            checkedItems.push($(obj).val());
                        }
                    });
                    
                    // Send AJAX request to setting_highlight action
                    $.ajax({
                        url: ajaxurl, // URL of admin-ajax.php
                        type: 'POST',
                        data: {
                            action: 'higlight_fast_disable', // Action name
                            nonce: '<?php echo $bulk_highlight_nonce; ?>',
                            id: checkedItems
                        },
                        success: function(response) {
                            // Successfully received response from the function
                            $("input[name='item-bulk[]']").each(function(index, obj) {
                                if ($(obj).is(":checked")) {
                                    if ($("#disableHighlight-" + $(obj).val()).is(":checked")){
                                        document.getElementById("disableHighlight-" + $(obj).val()).checked = false;
                                    }else{
                                        document.getElementById("disableHighlight-" + $(obj).val()).checked = true;
                                    }
                                }
                            });
                        },
                        error: function(xhr, status, error) {
                            // Error in receiving response from the function
                            console.log('error', error);
                        }
                    });
                }
            }
            // delete
        });
        // Delete/Disable Items End

        // Delete Item Start
        $(".delete").click(function() {
            if (confirm('<?php _e('Are you sure to delete?', 'royal'); ?>')) {
                var ItemId = $(this).attr('name');
                // Send AJAX request to setting_highlight action
                $.ajax({
                    url: ajaxurl, // URL of admin-ajax.php
                    type: 'POST',
                    data: {
                        action: 'higlight_delete', // Action name
                        nonce: '<?php echo $bulk_highlight_nonce; ?>',
                        id: ItemId
                    },
                    success: function(response) {
                        // Successfully received response from the function
                        $("#row-" + ItemId).remove();
                    },
                    error: function(xhr, status, error) {
                        // Error in receiving response from the function
                        console.log('error', error);
                    }
                });
            }
        });
        // Delete Item End
        
        // Enable/Disable Item Start
        $(".disableHighlight").click(function() {
            var ItemId = $(this).attr('data-id-value');
           document.getElementById("en-di-label-"+ItemId).classList.add('loading');
           document.getElementById("status-txt-" + ItemId).innerText = '';
            // Send AJAX request to setting_highlight action
            $.ajax({
                url: ajaxurl, // URL of admin-ajax.php
                type: 'POST',
                data: {
                    action: 'higlight_fast_disable', // Action name
                    nonce: '<?php echo $bulk_highlight_nonce; ?>',
                    id: ItemId
                },
                success: function(response) {
                    // Successfully received response from the function
                    if ($("#disableHighlight-" + ItemId).is(":checked")){
                        document.getElementById("status-txt-" + ItemId).classList.add('show');
                        document.getElementById("status-txt-" + ItemId).innerText = '<?php _e('Highlight enabled', 'royal'); ?>';
                    }else{
                        document.getElementById("status-txt-" + ItemId).classList.add('show');
                        document.getElementById("status-txt-" + ItemId).innerText = '<?php _e('Highlight disabled', 'royal'); ?>';
                    }
                    
                    setTimeout(() => {
                      document.getElementById("status-txt-" + ItemId).classList.remove('show');
                    }, 3000);

                    document.getElementById("en-di-label-"+ItemId).classList.remove('loading');
                },
                error: function(xhr, status, error) {
                    // Error in receiving response from the function
                    if ($("#disableHighlight-" + ItemId).is(":checked")){
                        document.getElementById("status-txt-" + ItemId).checked = false;
                        document.getElementById("status-txt-" + ItemId).innerText = error;
                    }else{
                        document.getElementById("status-txt-" + ItemId).checked = true;
                        document.getElementById("status-txt-" + ItemId).innerText = error;
                    }
                    
                    setTimeout(() => {
                      document.getElementById("status-txt-" + ItemId).classList.remove('show');
                    }, 3000);


                    document.getElementById("en-di-label-"+ItemId).classList.remove('loading');
                }
                
            });
        });
        // Enable/Disable Item End
        
        // clone Item Start
        $(".duplicate-highlight").click(function() {
            if (confirm('<?php _e('Are you sure to clone?', 'royal'); ?>')) {
                $(this).css("pointer-events", "none");
                var ItemId = $(this).attr('name');
                // Send AJAX request to setting_highlight action
                $.ajax({
                    url: ajaxurl, // URL of admin-ajax.php
                    type: 'POST',
                    data: {
                        action: 'higlight_clone', // Action name
                        nonce: '<?php echo $bulk_highlight_nonce; ?>',
                        id: ItemId
                    },
                    success: function(response) {
                        // Successfully received response from the function
                        window.location.reload();
                    },
                    error: function(xhr, status, error) {
                        // Error in receiving response from the function
                        console.log('error', error);
                        $(this).css("pointer-events", "auto");
                    }
                });
            }
        });
        // Delete Item End
        
    });
</script>