document.addEventListener("DOMContentLoaded", function() {
    var modalWrapper = document.querySelector('.royal-story-modal-wrapper');
    var footer = document.querySelector('.fusion-footer');

    // Check if both elements exist
    if (modalWrapper && footer) {
        // Move modalWrapper before footer
        footer.parentNode.insertBefore(modalWrapper, footer);
    }
});

jQuery(document).ready(function ($) {
    //function showHighlightHtml() {
    var activeHighlight;
    var activeStory;
    var highlight;
    var numStories;
    var hightlightStory;
    var remainingTime;
    var storyMedia;
    var storyTimer;
    var currentTimer;
    var slideDuration;
    var currentIndex;
    var storyDuration;
    var startX = 0;
    var endX = 0;
    var startY = 0;
    var endY = 0;
    var linksTarget;
    var displaySize;
    function isImage(url) {
        return /\.(jpeg|jpg|gif|png|webp)$/i.test(url);
    }

    function isVideo(url) {
        return /\.(mp4|webm|ogg)$/i.test(url);
    }
    // Function to initialize the swiper slider with highlights
    function initializeSlider() {
        $.each(highlights, function (key, value) {
            var highlightHTML = `
        <div class="swiper-slide royal-story-card" data-highlight="${key}">
        <div class="royal-story-pic" style="
            padding: ${highlightSettings.borderRadius};
            background: linear-gradient(${highlightSettings.gradientAngle}, ${highlightSettings.gradientColors.start}, ${highlightSettings.gradientColors.end});
        ">
            <div class="story-border">
                <img src="${value.highlightPic}" alt="">
            </div>
        </div>
        <div class="royal-story-cap">
            <div style="font-size: ${highlightSettings.fontSize}; color: ${highlightSettings.titleColors.before}">${value.highlightTitle}</div>
        </div>
        </div>`;

            $(".royal-story-wrapper .royal-story.swiper .swiper-wrapper").append(highlightHTML);
        });

        $(".royal-skeleton-wrapper").hide();
        $(".royal-story-wrapper").css({
            'opacity': '1',
            'visibility': 'visible'
        });
        $(".royal-story ").css({
            'min-height': '150px'
        });
        $(".royal-story .swiper-button-prev, .royal-story .swiper-button-next").show();

        // Initialize swiper
        const swiper = new Swiper('.royal-story', {
            slidesPerGroup: 1,
            spaceBetween: 24,
            slidesOffsetAfter: 0,
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            breakpoints: {
                320: {
                    slidesPerView: 3.5
                },
                480: {
                    slidesPerView: 3.5
                },
                768: {
                    slidesPerView: 6.5
                },
                1200: {
                    slidesPerView: 10.5
                },
                1300: {
                    slidesPerView: 12.5
                }
            }
        });
    }
    // Initialization
    initializeSlider();

    function stopAllStories() {
        $('.royal-story-time').each(function () {
            $(this).removeClass('passed');
        });
        $('.royal-modal-main-video').each(function () {
            if (!this.paused) {
                this.pause();
            }
        });
    }

    function getNextHighlightKey(activeHighlight) {
        var highlightKeys = Object.keys(highlights);
        var currentIndex = highlightKeys.indexOf(activeHighlight);

        var nextIndex = (currentIndex + 1);

        var nextHighlightKey = highlightKeys[nextIndex];

        return nextHighlightKey;
    }

    function getPrevHighlightKey(activeHighlight) {
        var highlightKeys = Object.keys(highlights);
        var currentIndex = highlightKeys.indexOf(activeHighlight);
        var prevIndex = (currentIndex - 1);

        var prevHighlightKey = highlightKeys[prevIndex];

        return prevHighlightKey;
    }
    // Function to show the next highlight
    function showNextHighlight(currentHighlight) {
        resetModalContents();
        var nextHighlightKey = getNextHighlightKey(currentHighlight);
        if (!getNextHighlightKey(currentHighlight)) {
            $('.royal-story-modal-overlay').hide();
            resetModalContents();
            return;
        }
        var nextHighlight = highlights[nextHighlightKey];
        activeHighlight = nextHighlightKey;
        numStories = nextHighlight.stories.length;
        hightlightStory = nextHighlight.stories;
        storyDuration = nextHighlight.time;
        updateHighlightInfo(nextHighlight);
        resetStoryTimer();
        stopAllStories();
        $(".royal-modal-main-photo").attr('src', '');
        $(".royal-modal-main-video").attr('src', '');
        showStory(hightlightStory, 0);
        updateThumbnails(activeHighlight);
        $('.royal-modal-main').fadeIn(500);
    }
    // Function to show the previous highlight
    function showPrevHighlight(currentHighlight) {
        resetModalContents();
        var prevHighlightKey = getPrevHighlightKey(currentHighlight);
        if (!prevHighlightKey) return;

        var prevHighlight = highlights[prevHighlightKey];
        activeHighlight = prevHighlightKey;
        numStories = prevHighlight.stories.length;
        hightlightStory = prevHighlight.stories;
        storyDuration = prevHighlight.time;
        updateHighlightInfo(prevHighlight);
        resetStoryTimer();
        stopAllStories();
        $(".royal-modal-main-photo").attr('src', '');
        $(".royal-modal-main-video").attr('src', '');
        showStory(hightlightStory, 0);
        updateThumbnails(activeHighlight);
        $('.royal-modal-main').fadeIn(500);

    }
    // Function to reset the story timer
    function resetStoryTimer() {
        $('.royal-story-time').css({
            width: '0',
            animation: 'none'
        });
    }
    // Function to update highlight information in UI
    function updateHighlightInfo(highlight) {
        $('.royal-story-time-holder').html('');
        var highlightImg = highlight.highlightPic;
        var highlightTitle = highlight.highlightTitle;
        $(".royal-modal-header-title").text(highlightTitle);
        $('.royal-modal-header-profile').attr('src', highlightImg);
        linksTarget = highlight.target;
        $('.royal-story-time-holder').html(generateStoryTimeHTML(numStories));
        displaySize = highlight.display_size;
    }

    // Function to generate HTML for story time indicators
    function generateStoryTimeHTML(numStories) {
        var royalStoryTimeHTML = '';
        for (var i = 0; i < numStories; i++) {
            royalStoryTimeHTML += '<div class="royal-story-time-wrapper" style="width: calc((100% / ' + numStories + ') - 2px)"><div class="royal-story-time time-' + i + '" style="animation: auto ease 0s 1 normal none running none; width: 0px;"></div></div>';
        }
        return royalStoryTimeHTML;
    }
    // Function to handle next button actions
    function handleNextButtonClick() {
        var currentHighlight = activeHighlight;
        $('.royal-modal-pause-btn').show();
        $('.royal-modal-play-btn').hide();
        var currentStoryIndex = activeStory;
        if (currentStoryIndex < numStories - 1) {
            $(".royal-modal-main-photo").attr('src', '');
            $(".royal-modal-main-video").attr('src', '');
            showStory(hightlightStory, currentStoryIndex + 1);
            // Reset only the timer of the current story
            var timer = $('.time-' + currentStoryIndex);
            timer.stop().width('100%');
            timer.addClass('passed');
            var currentStory = hightlightStory[currentStoryIndex];
            if (currentStory && isVideo(currentStory.img)) {
                $('.royal-modal-main-video')[0].pause();
            }
        } else {
            if (!getNextHighlightKey(currentHighlight)) {
                $('.royal-story-modal-overlay').hide();
                resetModalContents();
            } else {
                $('.royal-modal-main').fadeOut(500, function () {
                    showNextHighlight(currentHighlight);
                });
            }
        }
    }

    // Function to handle previous button actions
    function handlePrevButtonClick() {
        $('.royal-modal-pause-btn').show();
        $('.royal-modal-play-btn').hide();
        var currentHighlight = activeHighlight;
        var currentStoryIndex = activeStory;
        if (currentStoryIndex > 0) {
            $(".royal-modal-main-photo").attr('src', '');
            $(".royal-modal-main-video").attr('src', '');
            showStory(hightlightStory, currentStoryIndex - 1);
            var timer = $('.time-' + currentStoryIndex);
            timer.stop().width(0);
            timer.removeClass('passed');
            var currentStory = hightlightStory[currentStoryIndex];
            if (currentStory && isVideo(currentStory.img)) {
                $('.royal-modal-main-video')[0].pause();
            }
        } else {
            if (!getPrevHighlightKey(currentHighlight)) {
                $('.royal-story-modal-overlay').hide(); // Hide overlay for the first highlight
                resetModalContents();
            } else {
                $('.royal-modal-main').fadeOut(500, function () {
                    showPrevHighlight(currentHighlight);
                });
            }
        }
    }

    // Touch event handlers for next button
    $(".royal-story-modal-content").on("touchstart", ".royal-modal-nxt-btn", function (e) {
        e.preventDefault();
        var touchStartTime = new Date().getTime();
        $(this).data('touchStartTime', touchStartTime);
        pauseStoryTimer(currentTimer, currentIndex);
        $(".royal-modal-main-header, .royal-modal-main-footer").animate({
            opacity: 0
        }, 200);
        $('.royal-modal-pause-btn').hide();
        $('.royal-modal-play-btn').show();

    }).on("touchend mouseup", ".royal-modal-nxt-btn", function (e) {
        var touchStartTime = $(this).data('touchStartTime');
        var touchEndTime = new Date().getTime();
        var touchDuration = touchEndTime - touchStartTime;
        if (touchDuration >= 500) {
            resumeStoryTimer(currentTimer, currentIndex);
            $(".royal-modal-main-header, .royal-modal-main-footer").animate({
                opacity: 1
            }, 200);

            $('.royal-modal-pause-btn').show();
            $('.royal-modal-play-btn').hide();

        } else {
            $(".royal-modal-main-header, .royal-modal-main-footer").animate({
                opacity: 1
            }, 200);

            $('.royal-modal-pause-btn').show();
            $('.royal-modal-play-btn').hide();
            handleNextButtonClick();
        }
    });

    // Touch event handlers for previous button
    $(".royal-story-modal-content").on("touchstart", ".royal-modal-prev-btn", function (e) {
        e.preventDefault();
        var touchStartTime = new Date().getTime();
        $(this).data('touchStartTime', touchStartTime);
        pauseStoryTimer(currentTimer, currentIndex);
        $(".royal-modal-main-header, .royal-modal-main-footer").animate({
            opacity: 0
        }, 200);
        $('.royal-modal-pause-btn').hide();
        $('.royal-modal-play-btn').show();
    }).on("touchend mouseup", ".royal-modal-prev-btn", function (e) {
        var touchStartTime = $(this).data('touchStartTime');
        var touchEndTime = new Date().getTime();
        var touchDuration = touchEndTime - touchStartTime;
        if (touchDuration >= 500) {

            resumeStoryTimer(currentTimer, currentIndex);
            $(".royal-modal-main-header, .royal-modal-main-footer").animate({
                opacity: 1
            }, 200);

            $('.royal-modal-pause-btn').show();
            $('.royal-modal-play-btn').hide();
        } else {
            $(".royal-modal-main-header, .royal-modal-main-footer").animate({
                opacity: 1
            }, 200);

            $('.royal-modal-pause-btn').show();
            $('.royal-modal-play-btn').hide();
            handlePrevButtonClick();
        }
    });



    // Function to handle click on story card
    $('.royal-story-card').click(function () {
        $(this).addClass('royal-story-active');
        var highlightKey = $(this).data('highlight');
        activeHighlight = highlightKey;
        var highlight = highlights[highlightKey];
        numStories = highlight.stories.length;
        hightlightStory = highlight.stories;
        storyDuration = highlight.time;
        $(".royal-modal-main").fadeIn(200);
        updateHighlightInfo(highlight);
        $(".royal-modal-main-photo").attr('src', '');
        $(".royal-modal-main-video").attr('src', '');
        showStory(hightlightStory, 0);
        updateThumbnails(activeHighlight);
    });


    function showProdModal() {
        pauseStoryTimer(currentTimer, currentIndex);
        $(".royal-story-product-modal-overlay").show(500);
        $('.royal-story-product-modal').show();
        var btn = $(".royal-story-product-btn.active");
        var image = $(btn).attr('data-image');
        var link = $(btn).attr('data-link');
        var title = $(btn).text();
        var price = $(btn).attr('data-price');
        var curr = $(btn).attr('data-currency');
        var cartLink = $(btn).attr('data-cart');
        var target = $(btn).attr('data-target');

        $(".royal-story-product-modal-content img").attr('src', image);
        $(".royal-story-product-modal-content h3").text(title);
        $(".royal-story-product-modal-content a").attr('href', link);
        $(".royal-story-product-modal-content a").attr('target', target);
        var formattedPrice = price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $(".royal-story-product-modal-footer span").text(formattedPrice);
        $(".royal-story-modal-add-to-cart").attr('href', cartLink);
        $(".royal-story-modal-add-to-cart").attr('target', target);
        if (curr == 'IRT') {
            var currencySign = $('<div class="royal-story-currencySign">تومان</div>');
            $('.royal-story-product-modal-footer span').append(currencySign);
        } else if (curr == 'IRR') {
            var currencySign = $('<div class="royal-story-currencySign">ریال</div>');
            $('.royal-story-product-modal-footer span').append(currencySign);
        }

    }
    // Function to show a story
    function showStory(stories, index) {

        if (index === numStories) {
            $('.royal-modal-main').fadeOut(500, function () {
                showNextHighlight(activeHighlight);
                return;
            });

        }
        var currentStoryLoader = $('.royal-story-time').eq(index);
        currentStoryLoader.removeClass('passed');
        activeStory = index;
        var singleStory = stories[index];
        if (singleStory) {

            var title = singleStory.title;
            var desc = singleStory.description;
            var btnTitle = singleStory.btnTitle;
            var img = singleStory.img;
            var link = singleStory.link;
            var type = singleStory.type;
            var prodImg = singleStory.prodImg;
            var price = singleStory.price;
            storyTimer = $(".time-" + index);
            var btnImage = singleStory.btnImg;
            var prodCurrency = singleStory.currency;
            var cartLink = singleStory.cart_link;
            var storyLinksTarget = linksTarget;
            
        }
        if (isImage(img)) {
            storyMedia = 'image';
            $(".royal-modal-main-photo").show().attr('src', img);
            $('.royal-modal-main-video').hide();
            if(displaySize == 'contain') {
                $(".royal-modal-main-photo").css({
                    height: 'auto',
                    objectFit: 'unset'
                });
            } else {
                $(".royal-modal-main-photo").css({
                    height: '100%',
                    objectFit: 'cover'
                });
            }
            slideDuration = storyDuration;
            animateStoryTimer(storyTimer, index, slideDuration);
        } else if (isVideo(img)) {
            storyMedia = 'video';
            $(".royal-story-loader-elm").addClass('active');
            $('.royal-modal-main-video').attr('src', img).show();
            $(".royal-modal-main-photo").hide();
            var video = $('.royal-modal-main-video');
            $(video).on('loadedmetadata', function () {
                var storyDuration = this.duration + 1;
                var durationInMilliseconds = storyDuration * 1000;
                slideDuration = durationInMilliseconds;
            });
            
            var loadedCount = 0;
            video.on('loadeddata', function() {
                loadedCount++;
                if (loadedCount === video.length) {
                    $(".royal-story-loader-elm").removeClass('active');
                    animateStoryTimer(storyTimer, index, slideDuration);
                }
            });

            

        }

        
        $('.royal-modal-story-title').text(title);
        $('.royal-modal-story-caption').text(desc);
        if (type == 'btn') {
            if( link) {
                $(".royal-modal-story-btn").empty();
                $(".royal-modal-story-btn").removeClass('royal-story-product-btn active');
                $('.royal-modal-story-btn').removeClass('hidden-btn');
                $(".royal-modal-story-btn").removeAttr("data-link");
                $(".royal-modal-story-btn").removeAttr("data-image");
                $(".royal-modal-story-btn").removeAttr("data-price");
                $(".royal-modal-story-btn").removeAttr("onclick").off("click");
                $(".royal-modal-story-btn").attr('href', link);
                $(".royal-modal-story-btn").attr('target', storyLinksTarget);
                $(".royal-modal-main-center").css('height', 'calc(100% - 76px)');
            } else {
                $('.royal-modal-story-btn').addClass('hidden-btn');
                $(".royal-modal-main-center").css('height', '100%');
            }
            var span = $('<span>').text(btnTitle);
            $(".royal-modal-story-btn").append(span);
            if (prodImg) {
                var img = $('<img class="royal-story-product-btn-img" src="' + prodImg + '">');
                $(".royal-modal-story-btn").prepend(img);
                $(".royal-modal-story-btn").css({
                    justifyContent: 'unset'
                });
                $(".royal-modal-story-btn span").css({
                    width: '200px',
                    textAlign: 'right'
                });
            } else {
                $(".royal-modal-story-btn").css('justify-content', 'center');
                $(".royal-modal-story-btn span").css({
                    width: '100%',
                    textAlign: 'center'
                });
            }


        } else if (type == 'product') {
            $(".royal-modal-story-btn").empty();
            $(".royal-modal-story-btn").addClass('royal-story-product-btn active');
            $('.royal-modal-story-btn').removeClass('hidden-btn');
            $(".royal-modal-story-btn").removeAttr('target');
            $(".royal-modal-story-btn").attr({
                "href": 'javascript:void(0)',
                "data-link": link,
                "data-image": prodImg,
                "data-price": price,
                "data-currency": prodCurrency,
                "data-cart": cartLink,
                "data-target": storyLinksTarget,

            }).click(showProdModal);
            var span = $('<span>').text(btnTitle);
            var img = $('<img>').attr('src', btnImage).addClass('royal-story-product-btn-img');
            $(".royal-modal-story-btn").prepend(img);
            $(".royal-modal-story-btn").append(span);
            $(".royal-modal-story-btn").css({
                justifyContent: 'unset'
            });
            $(".royal-modal-story-btn span").css({
                width: '200px',
                textAlign: 'right'
            });
        }

    }
    $('.royal-story-product-modal-overlay').on('click', function (event) {
        if ($(event.target).hasClass('royal-story-product-modal-overlay')) {
            $('.royal-story-product-modal').hide();
            $(this).hide();
            resumeStoryTimer(currentTimer, currentIndex);
            $(".royal-story-product-modal-content img").attr('src', '');
            $(".royal-story-product-modal-content h3").text('');
            $(".royal-story-product-modal-content a").attr('href', '');
            $(".royal-story-product-modal-footer span").text('');
        }

    });
    $('.royal-story-product-modal-close-btn').on('click', function (event) {
        $('.royal-story-product-modal').hide();
        $('.royal-story-product-modal-overlay').hide();
        resumeStoryTimer(currentTimer, currentIndex);
        $(".royal-story-product-modal-content img").attr('src', '');
        $(".royal-story-product-modal-content h3").text('');
        $(".royal-story-product-modal-content a").attr('href', '');
        $(".royal-story-product-modal-footer span").text('');
        $(".royal-story-modal-add-to-cart").attr('href', '');
        $(".royal-story-currencySign").text('');
    });
    // Function to pause the animation of the story timer
    function pauseStoryTimer(timer, index) {
        $(timer).stop();

        // Calculate remaining time based on the type of media
        if (storyMedia === 'image') {
            remainingTime = slideDuration - ($(timer).width() / $(timer).parent().width() * slideDuration);
        } else if (storyMedia === 'video') {
            remainingTime = slideDuration - ($(timer).width() / $(timer).parent().width() * slideDuration);
            $('.royal-modal-main-video')[0].pause(); // Pause the video
        }

    }


    // Function to resume the animation of the story timer
    function resumeStoryTimer(timer, index) {
        var remainingDuration = remainingTime;
        $(timer).animate({
            width: '100%'
        }, remainingDuration, function () {
            $(this).addClass('passed');
            $(".royal-modal-main-photo").attr('src', '');
            $(".royal-modal-main-video").attr('src', '');
            showStory(hightlightStory, index + 1);
        });
        if (storyMedia === 'video') {
                $('.royal-modal-main-video')[0].play();
        }
    }
    // Function to animate story timer
    function animateStoryTimer(timer, index, duration) {
        currentTimer = timer; // Store the current timer
        currentIndex = index;
        if (storyMedia === 'video') {
            $('.royal-modal-main-video')[0].play();
        } else {
            $(".royal-story-loader-elm").removeClass('active');
        }
        $(timer).width(0).animate({
            width: '100%'
        }, duration, function () {
            $(this).addClass('passed');
            $(".royal-modal-main-photo").attr('src', '');
            $(".royal-modal-main-video").attr('src', '');
            showStory(hightlightStory, index + 1);
        });
    }
    // Event binding for pause button
    $(".royal-modal-pause-btn").click(function () {
        $(".royal-modal-play-btn").show();
        $(this).hide();
        pauseStoryTimer(currentTimer, currentIndex);
    });

    // Event binding for play button
    $(".royal-modal-play-btn").click(function () {
        $(".royal-modal-pause-btn").show();
        $(this).hide();
        resumeStoryTimer(currentTimer, currentIndex);
    });


    // Click event for each slide
    $('.royal-story .swiper-slide').on('click', function () {
        $('.royal-story-modal-overlay').addClass('showed');
        $('.royal-story-modal-overlay').fadeTo(500, 1);
        $('.royal-story-modal-overlay').css("visibility", "visible");
    });

    $(".royal-story-modal-mute-btn").click(function () {
        $(this).hide();
        $(".royal-story-modal-unmute-btn").show();
        $(".royal-modal-main-video").prop('muted', true);
    });
    $(".royal-story-modal-unmute-btn").click(function () {
        $(this).hide();
        $(".royal-story-modal-mute-btn").show();
        $(".royal-modal-main-video").prop('muted', false);
    });
    // Click event for closing modal
    $('.royal-modal-close-btn').on('click', function () {
        pauseStoryTimer(currentTimer, currentIndex);
        resetModalContents();
        $('.royal-story-modal-overlay').fadeOut();
    });

    function resetModalContents() {

        $('.royal-modal-pause-btn').show();
        $('.royal-modal-play-btn').hide();
        $('.royal-modal-header-title').text('');
        $('.royal-modal-story-caption').text('');
        $('.royal-modal-story-title').text('');
        $('.royal-modal-main-photo').attr('src', '');
        $('.royal-modal-main-video').attr('src', '');
        $('.royal-modal-story-btn').attr('href', '');
        $('.royal-modal-header-profile').attr('src', '');
        $(".royal-story-time").stop().animate();
        $('.royal-story-time').css('width', '0px');
        resetStoryTimer();
        stopAllStories();
    }
    $(document).on('click', '.royal-story-modal-overlay', function (event) {
        var target = $(event.target);
        // Check if the clicked element is outside of the specified elements
        if (!target.closest('.royal-story-prev-thumb, .royal-modal-navigation, .royal-modal-main, .royal-modal-navigation, .royal-story-nxt-thumb').length) {
            resetModalContents();
            $('.royal-story-modal-overlay').fadeOut();
        }
    });

    // Function to update thumbnails and assign click functions
    function updateThumbnails(currentHighlight) {
        var prevHighlightKey = getPrevHighlightKey(currentHighlight);
        var nextHighlightKey = getNextHighlightKey(currentHighlight);


        // Update previous thumbnail
        if (prevHighlightKey) {
            var prevHighlight = highlights[prevHighlightKey];
            var prevProfileSrc = prevHighlight.highlightPic;
            var prevHighliteTitle = prevHighlight.highlightTitle;
            var prevThumb = $('<div class="royal-story-pic"><img src="' + prevProfileSrc + '" alt=""></div></div><span>' + prevHighliteTitle + '</span>');
            $('.royal-story-prev-thumb-profile').empty().append(prevThumb);
            $('.royal-story-prev-thumb').removeClass('hiddenThumb');
            $('.royal-story-prev-thumb').off('click').on('click', function () {
                $('.royal-modal-main').fadeOut(500, function () {
                    showPrevHighlight(currentHighlight);
                });

            });
        } else {
            $('.royal-story-prev-thumb').addClass('hiddenThumb');
        }

        // Update next thumbnail
        if (nextHighlightKey) {
            var nextHighlight = highlights[nextHighlightKey];
            var nextProfileSrc = nextHighlight.highlightPic;
            var nextHighliteTitle = nextHighlight.highlightTitle;
            var nextThumb = $('<div class="royal-story-pic"><img src="' + nextProfileSrc + '" alt=""></div><span>' + nextHighliteTitle + '</span>');
            $('.royal-story-nxt-thumb-profile').empty().append(nextThumb);
            $('.royal-story-nxt-thumb').removeClass('hiddenThumb');
            $('.royal-story-nxt-thumb').off('click').on('click', function () {
                $('.royal-modal-main').fadeOut(500, function () {
                    showNextHighlight(currentHighlight);
                });

            });
        } else {
            $('.royal-story-nxt-thumb').addClass('hiddenThumb');
        }
    }
    $(".royal-story-modal-content").on("touchstart mousedown", ".royal-modal-main-center", function (e) {
        e.preventDefault();
        $(".royal-modal-main-header, .royal-modal-main-footer").animate({
            opacity: 0
        }, 200);
        pauseStoryTimer(currentTimer, currentIndex);
        $('.royal-modal-pause-btn').hide();
        $('.royal-modal-play-btn').show();
    });
    $(".royal-story-modal-content").on("touchend mouseup", ".royal-modal-main-center", function (e) {
        $(".royal-modal-main-header, .royal-modal-main-footer").animate({
            opacity: 1
        }, 200);
        resumeStoryTimer(currentTimer, currentIndex);
        $('.royal-modal-pause-btn').show();
        $('.royal-modal-play-btn').hide();
    });
    $(".royal-story-modal-content").on("touchstart mousedown", ".royal-modal-main-footer", function (e) {
        e.preventDefault();
        $(".royal-modal-main-header, .royal-modal-main-footer").animate({
            opacity: 0
        }, 200);
        pauseStoryTimer(currentTimer, currentIndex);
        $('.royal-modal-pause-btn').hide();
        $('.royal-modal-play-btn').show();
    });
    $(".royal-story-modal-content").on("touchend mouseup", ".royal-modal-main-footer", function (e) {
        $(".royal-modal-main-header, .royal-modal-main-footer").animate({
            opacity: 1
        }, 200);
        resumeStoryTimer(currentTimer, currentIndex);
        $('.royal-modal-pause-btn').show();
        $('.royal-modal-play-btn').hide();
    });

    // Event listener for touchstart/mousedown
    $(".royal-story-modal-content").on("touchstart", ".royal-modal-main-center", function (e) {
        e.preventDefault();
        startX = e.pageX || e.originalEvent.touches[0].pageX;
        startY = e.pageY || e.originalEvent.touches[0].pageY;
        //pauseStoryTimer(currentTimer, currentIndex);
        $('.royal-modal-pause-btn').hide();
        $('.royal-modal-play-btn').show();
    });

    // Event listener for touchend/mouseup
    $(".royal-story-modal-content").on("touchend", ".royal-modal-main-center", function (e) {
        endX = e.pageX || e.originalEvent.changedTouches[0].pageX;
        endY = e.pageY || e.originalEvent.changedTouches[0].pageY;
        var deltaX = endX - startX;
        var deltaY = endY - startY;
        var direction;
        if (Math.abs(deltaX) > Math.abs(deltaY)) {
            direction = deltaX > 0 ? 'right' : 'left';
        } else {
            direction = deltaY > 0 ? 'down' : 'up';
        }
        handleSwipe(direction, Math.abs(deltaX), Math.abs(deltaY));
        $('.royal-modal-pause-btn').show();
        $('.royal-modal-play-btn').hide();
    });

    // Function to handle swipe
    function handleSwipe(direction, deltaX, deltaY) {
        if (direction === 'down' && deltaY > 50) {
            $('.royal-story-modal-content').addClass('swipeDown');
            resetModalContents();
            $('.royal-story-modal-overlay').fadeOut();
            $('.royal-story-modal-content').removeClass('swipeDown');
        } else if (deltaX > 80) {
            if (direction === 'left') {
                if (!getPrevHighlightKey(activeHighlight)) {
                    $('.royal-story-modal-overlay').hide();
                    resetModalContents();
                } else {
                    showPrevHighlight(activeHighlight);
                }
            } else if (direction === 'right') {
                if (!getNextHighlightKey(activeHighlight)) {
                    $('.royal-story-modal-overlay').hide();
                    resetModalContents();
                } else {
                    showNextHighlight(activeHighlight);
                }
            }
        }
    }
    // }


});