<?php
// v5.0
if (!class_exists('RoyalStoryMnage')) {

    class RoyalStoryMnage extends RoyalStory
    {
        public static function get_product_cat_thumbnail_url($term_id)
        {
            $thumbnail_id = get_term_meta($term_id, 'thumbnail_id', true);
            $image = wp_get_attachment_image_url($thumbnail_id, 'thumbnail');
            if ($image == false) {
                $placeholder_image = wp_get_attachment_image_src(get_option('woocommerce_placeholder_image', 0));
                $image = $placeholder_image[0];;
            }

            return $image;
        }
        // Use element in front functions start

        public static function royal_all_highlight_story()
        {
            // check call
            if (is_admin()) return;

            $highlights = self::get_royal_highlights(null, PHP_INT_MAX, $page = 1);

            $highlights_data = [];
            $count = 0;
            foreach ($highlights as $highlight) { 
                if ($highlight->status == 'deactive' && ! self::now_to_date_active($highlight->deactive_from)) continue;

                $highlights_data['highlight' . $count] = array(
                    'highlightTitle' => $highlight->title,
                    'highlightPic' => $highlight->image_url,
                    'time' => $highlight->show_story_time * 1000,
                    'target' => $highlight->open_links,
                    'display_size' => $highlight->display_size
                );

                $stories_data = [];
                $stories = self::get_royal_stories($highlight->id, PHP_INT_MAX);
                foreach ($stories as $story) {
                    if ($story->type == 'products') {
                        $products = json_decode($story->products);
                        if (empty($products)) continue;

                        foreach ($products as $product_id) {
                            $stories_data[] = self::get_product_info($product_id);
                        }
                    } elseif ($story->type == 'categorys') {
                        $categorys = json_decode($story->categorys);
                        if (empty($categorys)) continue;

                        foreach ($categorys as $category_id) {
                            $products_by_cat = self::get_products_by_category_id($category_id, $story->limit_product_show, $story->sort_category);
                            foreach ($products_by_cat as $product_info) {
                                $stories_data[] = $product_info;
                            }
                        }
                    } elseif ($story->type == 'simple') {
                        // Combine information into an array
                        $stories_data[] = array(
                            'title' => $story->title,
                            'description' => $story->excerpt,
                            'img' => $story->image_url,
                            'type' => 'btn',
                            'btnTitle' => $story->button_text_image,
                            'prodImg' => $story->button_image_bg,
                            'link'    => $story->link
                        );
                    } else {
                        continue;
                    }
                }
                $highlights_data['highlight' . $count]['stories'] = $stories_data;
                $count++;
            }

            return $highlights_data;
        }

        public static function royal_highlight_selective_story($select_id)
        {
            
            $highlights_ids = explode(',', $select_id);

            $highlights = [];
            $count = 0;
            foreach ($highlights_ids as $highlight_id) {
                if (empty($highlight_id)) continue;

                $hilghlight = reset(self::get_royal_highlights($highlight_id));
                
                if ($hilghlight->status == 'deactive' && !self::now_to_date_active($hilghlight->deactive_from)) continue;
                
                $highlights['highlight' . $count] = array(
                    'highlightTitle' => $hilghlight->title,
                    'highlightPic' => $hilghlight->image_url,
                    'time' => $hilghlight->show_story_time * 1000,
                    'target' => $hilghlight->open_links,
                    'display_size' => $highlight->display_size
                );

                $stories_data = [];
                $stories = self::get_royal_stories($highlight_id, PHP_INT_MAX);
                foreach ($stories as $story) {
                    if ($story->type == 'products') {
                        $products = json_decode($story->products);
                        if (empty($products)) continue;

                        foreach ($products as $product_id) {
                            $stories_data[] = self::get_product_info($product_id);
                        }
                    } elseif ($story->type == 'categorys') {
                        $categorys = json_decode($story->categorys);
                        if (empty($categorys)) continue;

                        foreach ($categorys as $category_id) {
                            $products_by_cat = self::get_products_by_category_id($category_id, $story->limit_product_show, $story->sort_category);
                            foreach ($products_by_cat as $product_info) {
                                $stories_data[] = $product_info;
                            }
                        }
                    } elseif ($story->type == 'simple') {
                        $stories_data[] = array(
                            'title' => $story->title,
                            'description' => $story->excerpt,
                            'img' => $story->image_url,
                            //'gallery_images' => $gallery_image_urls,
                            //'price' => $product_price,
                            //'currency' => get_woocommerce_currency(),
                            'type' => 'btn',
                            'btnTitle' => $story->button_text_image,
                            'prodImg' => $story->button_image_bg,
                            'link'    => $story->link
                            //'cart_link' => esc_url($product->get_permalink() . "?add-to-cart=$product_id")
                        );
                    } else {
                        continue;
                    }
                }
                $highlights['highlight' . $count]['stories'] = $stories_data;

                $count++;
            }

            return $highlights;
        }

        public static function royal_dynamic_product_category($time_story = 8, $target = '_blank', $limit_highlight = 5, $order = 'rand', $limit_story = 5, $display_size = 'contain')
        {
            
            if (is_admin() || !is_tax('product_cat')) return;
            
            global $wp;

            $product_cats = explode(",", $wp->query_vars['product_cat']);
            
            $count = 0;
            
            foreach($product_cats as $product_cat){
                $term = get_term_by('slug', $product_cat, 'product_cat');
                
                $time_story = intval($time_story * 1000);
    
                $product_cat_id = ($term)? $term->term_id: 0;
    
                // check in product_cat
                if ($product_cat_id == 0 || $term->count < 1 || !is_tax('product_cat')) return;
    
                // HighLight Image Url $image
                $image = self::get_product_cat_thumbnail_url($product_cat_id);
                $products = self::get_products_by_category_id($product_cat_id, $limit_story, $order);
    
                $highlights['highlight' . $count] = array(
                    'highlightTitle' => $term->name,
                    'highlightPic' => $image,
                    'time' => $time_story,
                    'target' => $target,
                    'display_size' => $display_size,
                    'stories' => $products
                );
    
    
                $childs = get_term_children($product_cat_id, 'product_cat');
    
                // check childs
                if (!empty($childs)) {
                    $count++;
                    foreach ($childs as $child) {
                        if ($limit_highlight != 0 && $limit_highlight < $count) break;
                        $term = get_term_by('id', $child, 'product_cat');
                        $image = self::get_product_cat_thumbnail_url($child);
                        $products = self::get_products_by_category_id($child, $limit_story, $order);
    
                        $highlights['highlight' . $count] = array(
                            'highlightTitle' => $term->name,
                            'highlightPic' => $image,
                            'time' => $time_story,
                            'target' => $target,
                            'display_size' => $display_size,
                            'stories' => $products
                        );
                        $count++;
                    }
                }
            
            }
            return $highlights;
        }
        // Use element in front functions end
        
        // use in element
        public static function royal_element_story($atts)
        {
            if (is_admin() || empty($atts)) return;

        	// get dynamic stories
            if (isset($atts['story_element_type']) && $atts['story_element_type'] == 'dynamic') {
                $highlights = wp_cache_get('royal-highlights-dynamic', 'iranavada');
                if ($highlights == false) {
                    $highlights = self::royal_dynamic_product_category($atts['dynamic_highlight_story_time'], $atts['dynamic_highlight_open_links'], $atts['dynamic_highlight_limit'], $atts['dynamic_highlight_order'], $atts['dynamic_highlight_story_limit'], $atts['dynamic_highlight_display_size']);
                    wp_cache_set('royal-highlights-dynamic', $highlights, 'iranavada', 10 * MINUTE_IN_SECONDS);
                }
            }

            // get all stories
            if (isset($atts['story_element_type']) && $atts['story_element_type'] == 'all') {
                $cache_key = 'royal-highlights-all';
                $highlights = wp_cache_get($cache_key, 'iranavada');
                if ($highlights == false) {
                    $highlights = self::royal_all_highlight_story();
                    wp_cache_set($cache_key, $highlights, 'iranavada', 10 * MINUTE_IN_SECONDS);
                }
            }

            // get all selctive stories
            if (isset($atts['story_element_type']) && $atts['story_element_type'] == 'selective') {
                $cache_key = 'royal-highlights-id-' . $atts['stories_selected'];
                $highlights = wp_cache_get($cache_key, 'iranavada');
                if ($highlights == false) {
                    $highlights = self::royal_highlight_selective_story($atts['stories_selected']);
                    wp_cache_set($cache_key, $highlights, 'iranavada', 10 * MINUTE_IN_SECONDS);
                }
            }

            if (!$highlights || empty($highlights)) return;

            // General All HighLights Setting
            $general_setting = self::get_royal_story_setting_element($atts);
            
            require_once(get_stylesheet_directory() . '/includes/royal-story/royal-story-front-shcema.php');
            
            add_action("wp_footer", function(){ echo sprintf('<script src="%s"></script>', get_stylesheet_directory_uri() . '/includes/royal-story/assets/js/royal-story-script.js');}, 99);
            
            echo sprintf(
                "<script>%s</script>
                <script class='royal-story-script' >generateSkeletonCards(%s); var highlights = %s</script>",
                $general_setting,
                count($highlights),
                json_encode($highlights, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES)
            );
            return;
        }
        
        public static function get_royal_story_setting_element($design = array())
        {
            $highlightSettings = [
                'gradientColors' => [
                    'start' => $design["border_gradiant_from"],
                    'end'   => $design["border_gradiant_to"]
                ],
                'gradientAngle' => $design["border_gradiant_angle"].'deg',
                'titleColors' => [
                    'before'  => $design["title_color_before_click"],
                    'after'   => $design["title_color_after_click"]
                ],
                'fontSize'     => $design['title_size'].'px',
                'borderRadius' => $design['border_weight'].'px'
            ];

            $settings = "const highlightSettings = " . json_encode($highlightSettings, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT) . ";";
            
            return $settings;
           
        }
        // use in element

        public static function get_products_by_category_id($category_id, $limit_story = 5, $orderby = 'Latest')
        {
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => $limit_story,
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_cat',
                        'field'    => 'term_id',
                        'terms'    => $category_id,
                        'include_children' => false
                    ),
                )
            );
            
            if($orderby == 'rand'){
                $orderby = $orderby;
                $order = 'DESC';
            }elseif($orderby == 'Popularity'){
                $orderby = 'meta_value_num';
                $order = 'DESC';
                $args['meta_key'] = 'total_sales';
            }elseif($orderby == 'price'){
                $orderby = 'meta_value_num';
                $order = 'ASC';
                $args['meta_key'] = '_price';
            }elseif($orderby == 'price-desc'){
                $orderby = 'meta_value_num';
                $order = 'DESC';
                $args['meta_key'] = '_price';
            }else{
                $orderby = 'date';
                $order = 'DESC';
            }
            
            $args['orderby'] = $orderby;
            $args['order'] = $order;
            
            $products_query = new WP_Query($args);
            $products = array();

            if ($products_query->have_posts()) {
                while ($products_query->have_posts()) {
                    $products_query->the_post();
                    $products[] = self::get_product_info(get_the_ID());
                }
            }
            wp_reset_postdata();
            return $products;
        }
        
        /*
        public static function get_product_info($product_id)
        {
            // Check if product with the given ID exists
            $product = wc_get_product($product_id);

            if (!$product) return false;

            // Retrieve product information
            $product_price = $product->get_price();
            $type = 'simple';

            // If product has variable price, return the lowest option
            if ($product->is_type('variable')) {
                $product_variations = $product->get_available_variations();
                $min_price = null;

                foreach ($product_variations as $variation) {
                    $variation_price = $variation['display_price'];
                    if ($min_price === null || $variation_price < $min_price) {
                        $min_price = $variation_price;
                        $product_id = $variation['variation_id'];
                        $type = 'variable';
                    }
                }
                $product_price = $min_price;
            }

            // Combine information into an array
            $product_info = array(
                'title' => $product->get_title(),
                'description' => wp_trim_words($product->get_short_description(), 25, '...'),
                'img' => get_the_post_thumbnail_url($product_id, 'full'),
                'price' => $product_price,
                'currency' => get_woocommerce_currency(),
                'type' => 'product',
                'btnTitle' => $product->get_title(),
                'prodImg' => get_the_post_thumbnail_url($product_id, 'medium'),
                'btnImg' => get_the_post_thumbnail_url($product_id, 'thumbnail'),
                'link'    => esc_url($product->get_permalink()),
                'cart_link' => esc_url($product->get_permalink() . "?add-to-cart=$product_id")
            );

            return $product_info;
        }
        */
        
        // اصلاح گرفتن عکس محصول متغییر بجای عکس شاخص اصلی خود محصول
        // اگر محصول متغییر عکسی نداشته باشد، عکس استوری نمایش داده نمیشد که اینجا اصلاح شد
        public static function get_product_info($product_id)
        {
            // Check if product with the given ID exists
            $product = wc_get_product($product_id);
        
            if (!$product) return false;
        
            // ID محصول اصلی (والد) را برای استفاده در تصاویر ذخیره می‌کنیم
            $parent_product_id = $product->get_id();
            // ID محصول برای لینک سبد خرید را به صورت پیش‌فرض برابر با محصول اصلی قرار می‌دهیم
            $cart_product_id = $parent_product_id;
        
            // Retrieve product information
            $product_price = $product->get_price();
        
            // If product has variable price, find the lowest price and correct cart link
            if ($product->is_type('variable')) {
                $product_variations = $product->get_available_variations();
                $min_price = null;
        
                foreach ($product_variations as $variation) {
                    // اطمینان حاصل کنید که متغیر قیمت دارد
                    if (isset($variation['display_price'])) {
                        $variation_price = $variation['display_price'];
                        if ($min_price === null || $variation_price < $min_price) {
                            $min_price = $variation_price;
                            // فقط ID مربوط به سبد خرید را به‌روزرسانی می‌کنیم، نه ID اصلی
                            $cart_product_id = $variation['variation_id'];
                        }
                    }
                }
                // اگر قیمت کمینه پیدا شد، آن را جایگزین قیمت اصلی می‌کنیم
                if ($min_price !== null) {
                    $product_price = $min_price;
                }
            }
        
            // از ID محصول اصلی (والد) برای گرفتن تمام تصاویر استفاده می‌کنیم
            $image_url = get_the_post_thumbnail_url($parent_product_id, 'full');
            // اگر محصول اصلی عکس نداشت، از placeholder ووکامرس استفاده کن
            if (empty($image_url)) {
                $image_url = wc_placeholder_img_src('full');
            }
        
            // Combine information into an array
            $product_info = array(
                'title' => $product->get_title(),
                'description' => wp_trim_words($product->get_short_description(), 25, '...'),
                'img' => $image_url,
                'price' => $product_price,
                'currency' => get_woocommerce_currency(),
                'type' => 'product',
                'btnTitle' => $product->get_title(),
                'prodImg' => get_the_post_thumbnail_url($parent_product_id, 'medium'),
                'btnImg' => get_the_post_thumbnail_url($parent_product_id, 'thumbnail'),
                'link'    => esc_url($product->get_permalink()),
                // از ID متغیر (یا اصلی) برای لینک افزودن به سبد خرید استفاده می‌کنیم
                'cart_link' => esc_url(add_query_arg('add-to-cart', $cart_product_id, $product->get_permalink()))
            );

            return $product_info;
        }

        public static function get_royal_stories($highlight_id, $perPage = 10, $page = 1, $id = null)
        {
            global $wpdb;
            $table_name = $wpdb->prefix . self::get_table_stories();

            // Build WHERE clause based on $id if provided
            $where_clause = '';
            if (!is_null($id)) {
                $where_clause = $wpdb->prepare(" WHERE id = %d", $id);
            }

            // Calculate offset for the current page
            $offset = ($page - 1) * $perPage;

            if (!is_null($highlight_id) && !is_null($id)) {
                $where_clause = $wpdb->prepare(" AND WHERE highlight_id = %d", $highlight_id);
                $perPage = PHP_INT_MAX;
                $offset = 0;
            } elseif (!is_null($highlight_id) && is_null($id)) {
                $where_clause = $wpdb->prepare(" WHERE highlight_id = %d", $highlight_id);
                $perPage = PHP_INT_MAX;
                $offset = 0;
            }

            // Build query to retrieve records
            $query = "SELECT * FROM $table_name" . $where_clause . " ORDER BY `num_order` ASC LIMIT $perPage OFFSET $offset";

            return $wpdb->get_results($query);
        }

        public static function get_royal_highlights($id = null, $perPage = 40, $page = 1)
        {
            global $wpdb;
            $table_name = $wpdb->prefix . self::get_table_highlights();

            // Build WHERE clause based on $id if provided
            $where_clause = '';
            if (!is_null($id)) {
                $where_clause = $wpdb->prepare(" WHERE id = %d", $id);
            }

            // Calculate offset for the current page
            $offset = ($page - 1) * $perPage;

            // Build query to retrieve records
            $query = "SELECT * FROM $table_name" . $where_clause . " LIMIT $perPage OFFSET $offset";

            return $wpdb->get_results($query);
        }

        public static function copy_highlight($highlight_id) {
            
            $highlight = reset(self::get_royal_highlights($highlight_id));
            
            // data in db higlight
            $new_data_highlight = array(
                'title'           => $highlight->title.' '.__('(copy)', 'royal'),
                'image_url'       => $highlight->image_url,
                'status'          => $highlight->status,
                'deactive_from'   => $highlight->deactive_from,
                'show_story_time' => $highlight->show_story_time,
                'open_links'      => $highlight->open_links,
                'display_size'    => $highlight->display_size,
                'publish_date'    => current_time('mysql')
            );
            
            $new_highlight_id = self::insert_content(self::get_table_highlights(), $new_data_highlight);
            
            if($new_highlight_id > 0){
                $stories = self::get_royal_stories($highlight_id, PHP_INT_MAX);
                foreach($stories as $story){
                    
                    $new_data_story = array(
                        'highlight_id'       => $new_highlight_id,
                        'type'               => $story->type,
                        'title'              => $story->title,
                        'excerpt'            => $story->excerpt,
                        'image_url'          => $story->image_url,
                        'link'               => $story->link,
                        'button_type'        => $story->button_type,
                        'button_color_text'  => $story->button_color_text,
                        'button_color_bg'    => $story->button_color_bg,
                        'button_text_image'  => $story->button_text_image,
                        'button_image_bg'    => $story->button_image_bg,
                        'sort_category'      => $story->sort_category,
                        'limit_product_show' => $story->limit_product_show,
                        'status'             => $story->status,
                        'deactive_from'      => $story->deactive_from,
                        'publish_date'       => current_time('mysql'),
                        'num_order'          => $story->num_order
                    );
                    
                    if ($story->type == 'categorys') {
                        $new_data_story['products'] = json_encode(array());
                        $new_data_story['categorys'] = $story->categorys;
                    } elseif($story->type == 'products') {
                        $new_data_story['products'] = $story->products;
                        $new_data_story['categorys'] = json_encode(array());
                    }else {
                        $new_data_story['products'] = json_encode(array());
                        $new_data_story['categorys'] = json_encode(array());
                    }
                    
                    $story_id[] = self::insert_content(self::get_table_stories(), $new_data_story);
                }
                return true;
            }else{
                return false;
            }
        }

        /**
         * Delete royal highlights record(s).
         *
         * @param int|array $id       The ID of the record(s) to delete. If an array is passed, delete all records with these IDs.
         * @return int                The number of affected rows (deleted records).
         */
        public static function delete_royal_highlights($id)
        {
            global $wpdb;
            $table_name = $wpdb->prefix . self::get_table_highlights();
            // Build WHERE clause based on $id
            $where_clause = '';
            if (is_array($id)) {
                $ids = implode(', ', array_map('intval', $id));
                $where_clause = " WHERE id IN ($ids)";
            } else {
                $where_clause = $wpdb->prepare(" WHERE id = %d", $id);
            }

            // Build query to delete records
            $query = "DELETE FROM $table_name" . $where_clause;

            return $wpdb->query($query);
        }

        /**
         * Delete royal highlights record(s).
         *
         * @param int|array $id       The ID of the record(s) to delete. If an array is passed, delete all records with these IDs.
         * @return int                The number of affected rows (deleted records).
         */
        public static function delete_royal_stories($id)
        {
            global $wpdb;
            $table_name = $wpdb->prefix . self::get_table_stories();
            // Build WHERE clause based on $id
            $where_clause = '';
            if (is_array($id)) {
                $ids = implode(', ', array_map('intval', $id));
                $where_clause = " WHERE id IN ($ids)";
            } else {
                $where_clause = $wpdb->prepare(" WHERE id = %d", $id);
            }

            // Build query to delete records
            $query = "DELETE FROM $table_name" . $where_clause;

            return $wpdb->query($query);
        }

        /**
         * Delete royal highlights record(s).
         *
         * @param int|array $id       The ID of the record(s) to delete. If an array is passed, delete all records with these IDs.
         * @return int                The number of affected rows (deleted records).
         */
        public static function ajax_delete_royal_highlights()
        {

            if (!wp_verify_nonce(sanitize_text_field($_POST['nonce']), 'highlight-bulk-nonce')) {
                $response = array(
                    'status' => 'error',
                    'message' => __('Nonce value cannot be verified.', 'royal')
                );
                wp_send_json($response);
            }
            if (is_array($_POST['id'])) {
                foreach ($_POST['id'] as $hid) {
                    $old_stories = self::get_royal_stories($hid, PHP_INT_MAX);
                    foreach ($old_stories as $old_story) {
                        self::delete_royal_stories($old_story->id);
                    }
                }
            } else {
                $old_stories = self::get_royal_stories($_POST['id'], PHP_INT_MAX);
                foreach ($old_stories as $old_story) {
                    self::delete_royal_stories($old_story->id);
                }
            }

            return self::delete_royal_highlights($_POST['id']);
        }
        
        /**
         * fast_disable_royal_highlights.
         *
         * @param int|array $id       The ID of the record(s) to delete. If an array is passed, delete all records with these IDs.
         * @return int                The number of affected rows (deleted records).
         */
        public static function ajax_fast_disable_royal_highlights()
        {

            if (!wp_verify_nonce(sanitize_text_field($_POST['nonce']), 'highlight-bulk-nonce')) {
                $response = array(
                    'status' => 'error',
                    'message' => __('Nonce value cannot be verified.', 'royal')
                );
                wp_send_json($response);
            }
            
            $return = [];
            $count = 0;
            if (is_array($_POST['id'])) {
                foreach ($_POST['id'] as $hid) {
                    $highlights = self::get_royal_highlights($hid, PHP_INT_MAX);
                    foreach ($highlights as $highlight) {
                        $status = ($highlight->status == 'deactive')? 'active': 'deactive';
                        // data in db higlight
                        $data_highlight = array(
                            'status' => $status,
                            'deactive_from' => current_time('mysql')
                        );
                        self::update_content(self::get_table_highlights(), $data_highlight, array('id' => $highlight->id));
                        $return[$count] = array(
                            'id' => $highlight->id,
                            'status' => $status
                            );
                        $count++;
                    }
                }
            } else {
                $highlights = self::get_royal_highlights($_POST['id'], PHP_INT_MAX);
                foreach ($highlights as $highlight) {
                    $status = ($highlight->status == 'deactive')? 'active': 'deactive';
                    // data in db higlight
                    $data_highlight = array(
                        'status' => $status,
                        'deactive_from' => current_time('mysql')
                    );
                    self::update_content(self::get_table_highlights(), $data_highlight, array('id' => $highlight->id));
                    $return[] = array(
                            'id' => $highlight->id,
                            'status' => $status
                            );
                }
            }

            return $return;
        }
        
        /**
         * fast_disable_royal_highlights.
         *
         * @param int|array $id       The ID of the record(s) to delete. If an array is passed, delete all records with these IDs.
         * @return int                The number of affected rows (deleted records).
         */
        public static function ajax_higlight_clone()
        {

            if (!wp_verify_nonce(sanitize_text_field($_POST['nonce']), 'highlight-bulk-nonce')) {
                $response = array(
                    'status' => 'error',
                    'message' => __('Nonce value cannot be verified.', 'royal')
                );
                wp_send_json($response);
            }
            
            if (is_array($_POST['id'])) {
                foreach ($_POST['id'] as $hid) {
                    $response = RoyalStoryMnage::copy_highlight($hid);
                }
            } else {
                $response = RoyalStoryMnage::copy_highlight($_POST['id']);
            }

            return $response;
        }

    }
}