<?php
if( !class_exists('Iranavada_Royal_Story') ) {

    class Iranavada_Royal_Story {
        
        public $royal_story_path;
        public $iranavada_panel_css_url;
        public $iranavada_royal_story_dir;
        public $css_path;
        public $js_path;

        public function __construct() {
            
            $this->royal_story_path           = get_stylesheet_directory() . '/includes/royal-story/admin-contents/royal-story';

            $this->iranavada_panel_css_url    = get_stylesheet_directory_uri() . '/includes/royal-story/assets/css';
            $this->iranavada_royal_story_dir  = get_stylesheet_directory() . '/includes/royal-story/';

            $this->css_path                   = get_stylesheet_directory_uri() . '/includes/royal-story/assets/css';
            $this->js_path                    = get_stylesheet_directory_uri() . '/includes/royal-story/assets/js';

            // Admin Enqueue Scripts/Styles
            add_action( 'admin_enqueue_scripts', array($this, 'iranavada_enqueue_admin_scripts') );

            // Run All Required Files Needed
            $this->load_all_sections_needed();

            // Add Royal story Menu
            add_action( 'admin_menu' , array($this, 'royal_story_menu'), 30 );
            
            add_action('after_setup_theme', ['RoyalStory', 'create_royal_story_tables']);
            
            // add/edit functions AJAX
            add_action('wp_ajax_add_royal_highlight', ['RoyalStory', 'add_edit_highlight_story']);
            
            // search functions AJAX
            add_action('wp_ajax_royal_story_search_products', ['RoyalStory', 'search_products']);
            add_action('wp_ajax_royal_story_search_categories', ['RoyalStory', 'search_categories']);
            
            // delete functions AJAX
            add_action('wp_ajax_higlight_clone', ['RoyalStoryMnage', 'ajax_higlight_clone']);
            add_action('wp_ajax_higlight_delete', ['RoyalStoryMnage', 'ajax_delete_royal_highlights']);
            
            // higlight fast disable AJAX
            add_action('wp_ajax_higlight_fast_disable', ['RoyalStoryMnage', 'ajax_fast_disable_royal_highlights']);

        }

        // Wp Enqueue Admin Styles/Scripts
        public function iranavada_enqueue_admin_scripts() {
            wp_enqueue_media();
            wp_enqueue_style('admin-royal-story-styles', $this->iranavada_panel_css_url . '/admin-royal-story-styles.css', '', '5.1' );
        }

        // Load Admin Panels php
        public function load_all_sections_needed() {
            
            // Require Once Story File
            require_once( $this->iranavada_royal_story_dir . 'includes/class-royal-story.php' );
            require_once( $this->iranavada_royal_story_dir . 'class-royal-story-manage.php' );
            
        }
        
        // Add Menu For Royal story
        public function royal_story_menu() {

            add_submenu_page(
                'iranavada', 
                __('Royal story','royal'), 
                __('Royal story','royal'),
                'administrator', 
                'royal-story', 
                array($this, 'royal_story_handle_content_func')
            );
        }
        
        // Function For Load All Content For Royal story Page
        public function royal_story_handle_content_func() {

            // Enqueue Scripts Needed
            wp_enqueue_script( 'royal-story-js' );

            require_once(__DIR__ . '/royal-story-admin-content.php');
        }

    }new Iranavada_Royal_Story();
}