<div class="royal-skeleton-wrapper fusion-fullwidth">
    <script>
        function generateSkeletonCards(count) {
            var existingSkeletonCards = document.querySelectorAll('.royal-skeleton-card');
            existingSkeletonCards.forEach(function (card) {
                card.remove();
            });
            var parentElement = document.querySelector('.royal-skeleton-wrapper');
            var screenWidth = window.innerWidth;
            if (screenWidth >= 320 && screenWidth < 480 && count > 3) {
                count = 3.5;
            } else if (screenWidth >= 480 && screenWidth < 768 && count > 6) {
                count = 6.5;
            } else if (screenWidth >= 768 && screenWidth < 1200 && count > 10) {
                count = 10.5;
            } else if (screenWidth >= 1300 && count > 12) {
                count = 12.5;
            }

            for (var i = 0; i < count; i++) {
                var skeletonCard = document.createElement('div');
                skeletonCard.className = 'royal-skeleton-card';
                skeletonCard.innerHTML = '<div class="royal-skeleton-img"></div><div class="royal-skeleton-title"></div>';
                parentElement.appendChild(skeletonCard);
                var lastChild = document.querySelector('.royal-skeleton-wrapper .royal-skeleton-card:last-child');
                if (lastChild) {
                    lastChild.style.marginLeft = '-45px';
                }
            }


            if (count < 12) {
                parentElement.style.justifyContent = 'initial';
                var skeletonCards = document.querySelectorAll('.royal-skeleton-card');
                skeletonCards.forEach(function (card) {
                    card.style.marginLeft = '24px';
                });
            }
        }
    </script>
</div>

<div class="royal-story-wrapper fusion-fullwidth">
    <div class="royal-story swiper">
        <div class="swiper-wrapper">
        </div>
        <!-- If we need navigation buttons -->
        <div class="swiper-button-prev"></div>
        <div class="swiper-button-next"></div>
    </div>
</div>

<div class="royal-story-modal-wrapper">
    <div class="royal-story-modal-overlay">
        <div class="royal-story-modal-content">
            <div class="royal-story-prev-thumb">
                <div class="royal-story-prev-thumb-profile">
                </div>
            </div>
            <div class="royal-modal-navigation">
                <div class="royal-modal-prev-btn">
                    <i class="fa fa-angle-right" aria-hidden="true"></i>
                </div>
            </div>
            <div class="royal-modal-main">
                <div class="royal-modal-main-header">
                    <div class="royal-modal-header-overlay"></div>
                    <div class="royal-story-time-holder">

                    </div>

                    <div class="royal-modal-header-content">
                        <img class="royal-modal-header-profile" src="" alt="">
                        <h3 class="royal-modal-header-title"></h3>
                        <div class="royal-story-modal-mute">
                            <svg class="royal-story-modal-mute-btn" xmlns="http://www.w3.org/2000/svg" height="24px"
                                viewBox="0 0 24 24" width="24px" fill="#000000">
                                <path
                                    d="M3 10v4c0 .55.45 1 1 1h3l3.29 3.29c.63.63 1.71.18 1.71-.71V6.41c0-.89-1.08-1.34-1.71-.71L7 9H4c-.55 0-1 .45-1 1zm13.5 2c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 4.45v.2c0 .38.25.71.6.85C17.18 6.53 19 9.06 19 12s-1.82 5.47-4.4 6.5c-.36.14-.6.47-.6.85v.2c0 .63.63 1.07 1.21.85C18.6 19.11 21 15.84 21 12s-2.4-7.11-5.79-8.4c-.58-.23-1.21.22-1.21.85z">
                                </path>
                            </svg>
                            <svg class="royal-story-modal-unmute-btn" xmlns="http://www.w3.org/2000/svg" height="24px"
                                viewBox="0 0 24 24" width="24px" fill="#000000">
                                <path
                                    d="M3.63 3.63c-.39.39-.39 1.02 0 1.41L7.29 8.7 7 9H4c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h3l3.29 3.29c.63.63 1.71.18 1.71-.71v-4.17l4.18 4.18c-.49.37-1.02.68-1.6.91-.36.15-.58.53-.58.92 0 .72.73 1.18 1.39.91.8-.33 1.55-.77 2.22-1.31l1.34 1.34c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L5.05 3.63c-.39-.39-1.02-.39-1.42 0zM19 12c0 .82-.15 1.61-.41 2.34l1.53 1.53c.56-1.17.88-2.48.88-3.87 0-3.83-2.4-7.11-5.78-8.4-.59-.23-1.22.23-1.22.86v.19c0 .38.25.71.61.85C17.18 6.54 19 9.06 19 12zm-8.71-6.29l-.17.17L12 7.76V6.41c0-.89-1.08-1.33-1.71-.7zM16.5 12c0-1.77-1.02-3.29-2.5-4.03v1.79l2.48 2.48c.01-.08.02-.16.02-.24z">
                                </path>
                            </svg>
                        </div>
                        <div class="royal-story-modal-pause">
                            <svg class="royal-modal-pause-btn" xmlns="http://www.w3.org/2000/svg" height="24px"
                                viewBox="0 0 24 24" width="24px" fill="#000000">
                                <path
                                    d="M8 19c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2s-2 .9-2 2v10c0 1.1.9 2 2 2zm6-12v10c0 1.1.9 2 2 2s2-.9 2-2V7c0-1.1-.9-2-2-2s-2 .9-2 2z">
                                </path>
                            </svg>
                            <svg class="royal-modal-play-btn" xmlns="http://www.w3.org/2000/svg" height="24px"
                                viewBox="0 0 24 24" width="24px" fill="#000000">
                                <path
                                    d="M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z">
                                </path>
                            </svg>
                        </div>
                        <div class="royal-story-modal-close">
                            <svg class="royal-modal-close-btn" xmlns="http://www.w3.org/2000/svg" height="24px"
                                viewBox="0 0 24 24" width="24px" fill="#000000">
                                <path d="M0 0h24v24H0V0z" fill="none"></path>
                                <path
                                    d="M18.3 5.71c-.39-.39-1.02-.39-1.41 0L12 10.59 7.11 5.7c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L10.59 12 5.7 16.89c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L12 13.41l4.89 4.89c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L13.41 12l4.89-4.89c.38-.38.38-1.02 0-1.4z">
                                </path>
                            </svg>
                        </div>
                    </div>

                </div>
                <div class="royal-modal-main-center">
                    <div class="royal-modal-main-center-blur"></div>
                    <video class="royal-modal-main-video" preload="auto" autoplay playsinline
                        disablepictureinpicture="true" style="width: 100%; height: 100%;"></video>
                    <img class="royal-modal-main-photo" src="" alt="">
                </div>
                <div class="royal-modal-main-footer">
                    <div class="royal-modal-footer-overlay"></div>
                    <div class="royal-modal-footer-content">
                        <h4 class="royal-modal-story-title"></h4>
                        <p class="royal-modal-story-caption"></p>
                    </div>
                </div>
                <div class="royal-modal-product-place">
                    <a class="royal-modal-story-btn" href="">

                    </a>
                </div>
                <div class="royal-story-loader-elm"></div>
            </div>
            <div class="royal-modal-navigation">
                <div class="royal-modal-nxt-btn">
                    <i class="fa fa-angle-left" aria-hidden="true"></i>
                </div>
            </div>
            <div class="royal-story-nxt-thumb">
                <div class="royal-story-nxt-thumb-profile">

                </div>
            </div>
        </div><!-- end royal-story-modal-content -->
    </div><!-- end royal-story-modal-overlay -->

    <div class="royal-story-product-modal-overlay">
        <div class="royal-story-product-modal">
            <div class="royal-story-product-modal-wrapper">
                <div class="royal-story-product-modal-header">
                    <svg class="royal-story-product-modal-close-btn" xmlns="http://www.w3.org/2000/svg" height="24px"
                        viewBox="0 0 24 24" width="24px" fill="#000000">
                        <path d="M0 0h24v24H0V0z" fill="none"></path>
                        <path
                            d="M18.3 5.71c-.39-.39-1.02-.39-1.41 0L12 10.59 7.11 5.7c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L10.59 12 5.7 16.89c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L12 13.41l4.89 4.89c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L13.41 12l4.89-4.89c.38-.38.38-1.02 0-1.4z">
                        </path>
                    </svg>
                </div>
                <div class="royal-story-product-modal-content">
                    <img src="" alt="">
                    <h3></h3>
                    <a href="#">مشاهده اطلاعات کامل محصول</a>
                </div>
                <div class="royal-story-product-modal-footer">
                    <a href="#" class="royal-story-modal-add-to-cart">افزودن به سبد</a>
                    <span></span>
                </div>
            </div>
        </div>
    </div>

</div><!-- end royal-story-modal-wrapper -->

<style>
    .royal-story-pic {
        width: 90px;
        height: 90px;
        border-radius: 50%;
        margin: 0 auto;
    }

    .story-border {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        background-color: white;
    }

    .royal-story-pic img {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        border: 3px solid #fff;
    }

    .royal-story-card {
        -webkit-tap-highlight-color: transparent;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -khtml-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;

    }

    .royal-story-active .royal-story-cap p {
        color: #666666 !important;
    }

    .royal-story-cap p {
        font-size: 12px;
    }

    .royal-story .swiper-button-prev,
    .royal-story .swiper-button-next {
        display: none;
    }

    .royal-story .swiper-button-next::after,
    .royal-story .swiper-button-prev::after {
        display: none !important;
    }

    .royal-story-wrapper {
        padding-top: 16px;
        max-width: 1600px;
        margin: 0 auto;
        overflow: hidden;
        padding: 0 !important;
    }

    .royal-story-cap {
        text-align: center;
        line-height: 22px;
        overflow: hidden;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        text-overflow: ellipsis;
    }

    .royal-story .swiper-button-next,
    .royal-story .swiper-button-prev {
        position: absolute;
        width: 40px;
        height: 40px;
        background: #fff;
        border: 1px solid #e2e2e2;
        border-radius: 50%;
        top: calc(50% - 20px);
        z-index: 9999;
        text-align: center;
    }

    .royal-story .swiper-button-next {
        left: 20px;
    }

    .royal-story .swiper-button-next::before {
        content: "\f104";
        font-family: "Font Awesome 5 Free";
        font-weight: 900;
        font-size: 20px;
    }

    .royal-story .swiper-button-prev {
        right: 20px;
    }

    .royal-story .swiper-button-prev::before {
        content: "\f105";
        font-family: "Font Awesome 5 Free";
        font-weight: 900;
        font-size: 20px;
    }

    .royal-story .swiper-button-prev.swiper-button-disabled,
    .royal-story .swiper-button-next.swiper-button-disabled {
        display: none !important;
    }

    .royal-story .swiper-slide {
        cursor: pointer;
    }

    .royal-story-modal-overlay {
        position: fixed;
        display: flex;
        justify-content: center;
        background-color: rgba(0, 0, 0, 0.8);
        z-index: 99999;
        width: 100%;
        height: 100%;
        top: 0;
        right: 0;
        opacity: 0;
        visibility: hidden;
    }

    .royal-story-modal-overlay.active {
        display: flex;
    }

    .royal-story-modal-content {
        display: flex;
        align-items: center;
        transition: all 0.8s ease;
        transform: translateY(0);
    }

    .royal-story-modal-content.swipeDown {
        transform: translateY(100%);
        transition: all 0.8 ease;
    }

    .royal-modal-main {
        width: 360px;
        height: 720px;
        margin: 0 50px;
        position: relative;
        display: flex;
        flex-direction: column;
        border-radius: 5px;
        overflow: hidden;
    }

    .royal-modal-navigation {
        display: flex;
        align-items: center;
    }

    .royal-modal-nxt-btn,
    .royal-modal-prev-btn {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background-color: #fff;
        border: 1px solid #e2e2e2;
        text-align: center;
        cursor: pointer;
    }

    .royal-modal-nxt-btn .fa,
    .royal-modal-prev-btn .fa {
        font-size: 20px;
        line-height: 39px;
    }

    .royal-modal-footer-overlay {
        height: 180px;
        background: linear-gradient(to bottom, #0000 0%, #000000e3 100%);
        position: absolute;
        bottom: 0;
        width: 100%;
        right: 0;
    }

    .royal-modal-header-overlay {
        position: absolute;
        top: 0;
        width: 100%;
        right: 0;
        height: 80px;
        background: linear-gradient(to top, #0000 0%, #000000e3 100%);
    }

    .royal-modal-main-footer {
        position: relative;
        width: 100%;
        margin-top: auto;
        padding: 20px 20px 0px 20px;
    }

    .royal-modal-main-header {
        padding: 20px;
        z-index: 999;
    }

    .royal-modal-header-content {
        display: flex;
        position: relative;
        align-items: center;
        margin-top: 15px;
    }

    .royal-modal-header-profile {
        width: 40px;
        height: 40px;
        border-radius: 50%;
    }

    .royal-modal-pause-btn,
    .royal-modal-play-btn,
    .royal-story-modal-unmute-btn,
    .royal-story-modal-mute-btn {
        fill: #fff;
        cursor: pointer;
    }

    .royal-modal-play-btn,
    .royal-story-modal-unmute-btn {
        display: none;
    }

    .royal-story-modal-mute {
        margin-right: auto;
    }

    .royal-story-modal-pause {

        position: relative;
    }

    .royal-story-modal-close,
    .royal-story-modal-pause {
        margin-right: 5px;
    }

    .royal-modal-close-btn {
        fill: #fff;
        font-size: 20px;
        cursor: pointer;
    }

    .royal-modal-header-title {
        color: #fff !important;
        margin-right: 10px;
        width: 165px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;

    }

    .royal-modal-story-title {
        color: #fff !important;
        font-weight: bold !important;
        font-size: 16px !important;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .royal-modal-story-caption {
        color: #fff;
        font-size: 14px;
        margin-top: 5px;
        white-space: normal;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .royal-modal-footer-content {
        position: relative;
    }

    .royal-modal-story-btn {
        width: calc(100% - 20px);
        display: flex;
        text-align: center;
        height: 60px;
        background: #fff;
        border-radius: 5px;
        color: #333;
        align-items: center;
        margin: 8px;
    }

    .royal-story-product-btn-img {
        width: 54px;
        height: 54px;
        object-fit: cover;
        margin-left: 10px;
        margin-right: 3px;
        border-radius: 5px;
    }

    .royal-modal-story-btn span {
        width: 200px;
        display: inline-block;
        line-height: 27px;
        font-weight: bold;
        text-align: right;
        white-space: normal;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .royal-modal-product-place {
        z-index: 99;
        overflow: hidden;
        background: #0c0c0c;
    }

    .royal-modal-main-center {
        height: 100%;
        width: 100%;
        position: absolute;
        top: 0;
        right: 0;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .royal-modal-main-center-blur {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -1;
        background-size: cover;
        background-position: center;
        filter: blur(10px);
        background-color: #0c0c0c;
    }

    .royal-modal-main-photo {
        width: 100%;

    }

    .royal-story-time-holder {
        display: flex;
        justify-content: space-between;
    }

    .royal-story-time-wrapper {
        height: 2px;
        position: relative;
        background: #9a9999;
        border-radius: 5px;
    }

    .royal-story-time {
        position: absolute;
        height: 2px;
        background-color: #f3f3f3;
        /*animation: progressAnimation 5s linear forwards;*/
        border-radius: 5px;
    }

    .royal-story-time.passed {
        width: 100% !important;
    }

    .royal-modal-main-video {
        width: 100%;
    }

    .royal-story-nxt-thumb {
        margin-right: 130px;
    }

    .royal-story-prev-thumb {
        margin-left: 130px;
    }

    .royal-story-nxt-thumb,
    .royal-story-prev-thumb {
        width: 190px;
        height: 330px;
        position: relative;
        display: flex;
        justify-content: center;
        align-items: center;
        background-color: #0c0c0c;
        overflow: hidden;
        border-radius: 5px;
        cursor: pointer;
        text-align: center;
    }

    .royal-story-nxt-thumb.hiddenThumb,
    .royal-story-prev-thumb.hiddenThumb {
        opacity: 0;
        visibility: hidden;
    }


    .royal-story-prev-thumb-profile,
    .royal-story-nxt-thumb-profile {
        z-index: 9;
    }

    .royal-story-prev-thumb-profile .royal-story-pic,
    .royal-story-nxt-thumb-profile .royal-story-pic {
        margin-bottom: 16px;
    }

    .royal-story-prev-thumb-profile span,
    .royal-story-nxt-thumb-profile span {
        color: #fff;
    }

    .royal-story-prev-thumb.hidden,
    .royal-story-nxt-thumb.hidden {
        visibility: hidden;
        opacity: 0;
    }

    .royal-story-product-modal {
        width: 500px;
        height: 500px;
        position: fixed;
        background-color: #fff;
        z-index: 999999;
        top: calc(50% - 250px);
        right: calc(50% - 250px);
        border-radius: 10px;
        display: none;
    }

    .royal-story-product-modal-close-btn {
        fill: #333;
        cursor: pointer;
    }

    .royal-story-product-modal-header {
        padding: 15px;
        border-bottom: 1px solid #cecaca;
        display: flex;
        justify-content: end;
    }

    .royal-story-product-modal-wrapper {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        width: 100%;
        height: 100%;
    }

    .royal-story-product-modal-content img {
        width: auto;
        height: 250px;
    }

    .royal-story-product-modal-footer {
        display: flex;
        justify-content: space-between;
        padding: 15px 20px;
        border-top: 1px solid #cecaca;
        box-shadow: 0 -1px 1px rgba(0, 0, 0, .14), 0 -2px 2px rgba(0, 0, 0, .05);
        height: 80px;
        background: #fff;
        border-bottom-right-radius: 10px;
        border-bottom-left-radius: 10px;
        align-items: center;
    }

    .royal-story-product-modal-footer span {
        font-size: 20px;
        font-weight: 600;
    }

    .royal-story-product-modal-content {
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 16px 20px 16px 20px;
    }

    .royal-story-product-modal-content h3 {
        font-size: 19px;
        color: #000;
        margin-top: 12px;
        text-align: right;
        width: 100%;
    }

    a.royal-story-modal-add-to-cart {
        background: #ef4056;
        padding: 0px 16px;
        text-align: center;
        color: #fff;
        height: 40px;
        line-height: 40px;
        border-radius: 8px;
        font-size: 12px;
    }

    .royal-story-product-modal-content a {
        font-size: 12px;
        color: #ef4056;
        width: 100%;
        border: 1px solid #ef4056;
        display: inline-block;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-radius: 8px;
        font-size: 12px;
    }

    .royal-story-product-modal-content a:hover {
        background-color: #ef4056;
        color: #fff;
    }

    .royal-modal-story-btn.hidden-btn {
        display: none;
    }

    @keyframes progressAnimation {
        0% {
            width: 0;
        }

        100% {
            width: 100%;
        }
    }

    @media screen and (max-width: 600px) {
        .royal-modal-main {
            width: 100%;
            height: 100%;
            margin: 0;
        }

        .royal-story-modal-content {
            width: 100%;
        }

        .royal-modal-nxt-btn {
            position: absolute;
            width: 100px;
            height: 100%;
            left: 0;
            background: none;
            border: none;
            border-radius: unset;
            outline: unset !important;

            -webkit-tap-highlight-color: transparent;
            -webkit-touch-callout: none;
            -webkit-user-select: none;
            -khtml-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }

        .royal-modal-nxt-btn:focus {
            outline: none !important;
            background: transparent;
        }

        .royal-modal-prev-btn {
            position: absolute;
            right: 0;
            width: 100px;
            height: 100%;
            background: none;
            border-radius: unset;
            border: none;
            z-index: 99;
            outline: unset !important;
            -webkit-tap-highlight-color: transparent;
            -webkit-touch-callout: none;
            -webkit-user-select: none;
            -khtml-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }

        .royal-modal-nxt-btn:focus,
        .royal-modal-nxt-btn:focus {
            outline: unset !important;
        }

        .royal-modal-nxt-btn .fa,
        .royal-modal-prev-btn .fa {
            display: none;
        }

        .royal-story-nxt-thumb,
        .royal-story-prev-thumb {
            display: none;
        }

        .royal-story-product-modal {
            width: 95%;
            height: auto;
            right: 2.5%;
        }

        .royal-modal-prev-btn:focus {
            background: linear-gradient(to right, #0000 0%, #00000059 100%);
        }

        .royal-modal-nxt-btn:focus {
            background: linear-gradient(to left, #0000 0%, #00000059 100%);
        }
    }

    .royal-skeleton-wrapper {
        height: 150px;
        width: 100%;
        overflow: hidden;
        display: flex;
        justify-content: space-between;
        max-width: 1600px;
        margin: 0 auto;
        padding: 0px !important;
    }

    .royal-skeleton-title {
        width: 92px;
        height: 20px;
        background: linear-gradient(100deg, rgba(226, 226, 226, 1) 0%, rgba(226, 226, 226, 1) 30%, rgba(255, 255, 255, 1) 50%, rgba(226, 226, 226, 1) 70%, rgba(226, 226, 226, 1) 100%);
        margin-top: 16px;
        border-radius: 15px;
        animation: shine 6s infinite;
    }

    .royal-skeleton-img {
        width: 90px;
        height: 90px;
        background: linear-gradient(100deg, rgba(226, 226, 226, 1) 0%, rgba(226, 226, 226, 1) 30%, rgba(255, 255, 255, 1) 50%, rgba(226, 226, 226, 1) 70%, rgba(226, 226, 226, 1) 100%);
        border-radius: 50%;
        animation: shine 6s infinite;
    }

    .royal-skeleton-card {
        width: 92px;
    }

    .royal-story-product-modal-overlay {
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        right: 0;
        left: 0;
        bottom: 0;
        background: #00000036;
        z-index: 99999;

        display: none;
    }

    .custom-video-duration-line {
        height: 5px;
        width: calc(100% - 40px);
        background: #fff;
        border-radius: 5px;
        position: relative;
    }

    .video-progress-bar {
        width: 18px;
        height: 18px;
        background: #fff;
        position: absolute;
        left: 0;
        top: -7px;
        border-radius: 20px;
    }

    .custom-video-duration-time {
        position: absolute;
        left: -40px;
        font-size: 14px;
        color: #fff;
        top: -10px;
    }

    .royal-story-currencySign {
        font-size: 12px;
        float: left;
        margin-top: 6px;
        margin-right: 7px;
    }

    @keyframes shine {
        0% {
            background-position: -100px;
        }

        50% {
            background-position: 200px;
        }

        100% {
            background-position: 400px;
        }
    }
    .royal-story-loader-elm {
    position: absolute;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #3b3b3b;
    visibility: hidden;
    opacity: 0;
}
.royal-story-loader-elm.active {
    opacity: 1;
    visibility: visible;
}
.royal-story-loader-elm::before {
    content: '';
    border: 3px solid rgb(143 143 143 / 66%);
    border-top: 3px solid #fff;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    animation: spin 1s linear infinite;
    position: absolute;
    z-index: 9999;
}
@keyframes spin {
    0% {
      transform: rotate(0deg);
    }
    100% {
      transform: rotate(360deg);
    }
  }
</style>