<?php

if( !class_exists('Royal_Soon_Product_Show_Reuqest') ) {

	class Royal_Soon_Product_Show_Reuqest {

		public function __construct() {

			// Royal Soon Product Admin Dir
			$this->royal_soon_product_admin_dir = get_stylesheet_directory() . '/includes/soon-product/admin/';

			// Include Functions.php For Soon Product
			require_once( $this->royal_soon_product_admin_dir . 'functions.php' );

			// Run Show Request On Admin Pages
			$this->royal_soon_product_show_list();

		}

		// Html Design Code For Admin Page => Show Request
		public function royal_soon_product_show_list() {

			$soon_product_functions = new Royal_Soon_Product_Functions();

			?>
			<div class="wrap">

				<?php
					if( isset( $_POST['sjsp_avada_delete_emails'] ) ) {

						if ( $soon_product_functions->sjsp_delete_requests( $_POST['sjsp_avada_product_id'] ) != 0 ) {
							echo $soon_product_functions->sjum_show_notice( __( 'Removal request successfully!' , 'royal' ) , "success" );
						}else {
							echo $soon_product_functions->sjum_show_notice( __( 'Removal request failed!' , 'royal' ) , "error" );
						}

					}
				?>
		
				<h2>لیست درخواست های کاربران</h2>
				<table class="widefat">
					<thead>
						<tr>
							<th>شماره</th>
							<th>محصول</th>
							<th>ایمیل درخواست دهندگان</th>
							<th>تعداد درخواست دهندگان</th>
							<th>عملیات</th>
							<th></th>
						</tr>
					</thead>
					<tfoot>
						<tr>
							<th>شماره</th>
							<th>محصول</th>
							<th>ایمیل درخواست دهندگان</th>
							<th>تعداد درخواست دهندگان</th>
							<th>عملیات</th>
							<th></th>

						</tr>
					</tfoot>
					<tbody>

					<?php


						if ( $requests = $soon_product_functions->sjsp_get_requests() ){
							$count = 1;
							foreach( $requests as $request):
						?>
							<tr>
								<td><?php echo $count;?></td>

								<td>
									<a href="<?php echo get_permalink( $request->product_id);?>" target="_blank">
										<?php echo get_the_title( $request->product_id); ?>
									</a>
								</td>

								<td>
									<p id="emails-<?php echo $count;?>">
										<?php
										$emails = explode('|' , $request->users_emails);
										$email_counts=0;

										foreach($emails as $i =>$email) {
											$email_counts++;

											echo $email .'</br>';

										}
									?>
									</p>
								</td>

								<td><?php echo $email_counts; ?></td>
								<td>
									<form method="post" onSubmit="if(!confirm('آیا از حذف لیست درخواست دهندگان محصول مدنظرتان اطمینان دارید؟')){return false;}">
												<input type="hidden" id="sjsp_avada_product_id" name="sjsp_avada_product_id" value="<?php echo $request->product_id ?>">
												<button class="btn button-primary" type="submit" name="sjsp_avada_delete_emails" id="sjsp_avada_delete_emails">
													حذف
												</button>
									</form>
								</td>
							</tr>
						<?php
							$count++;
							endforeach;
						} else {
							echo '<tr><td colspan="4">درخواستی برای نمایش وجود ندارد</td></tr>';
						}
					?>
					</tbody>
				</table>
			</div>
			<?php
			
		}

	}new Royal_Soon_Product_Show_Reuqest();

}